{ --------------------------------------------- }
{  program DTECO3                   10.11.1998  }
{  KIT-Builder                                  }
{                                               }
{  (c) SofCon 1998                              }
{---------------------------------------------- }

{ Program na testovani komunikacniho protokolu TECOM, pro komunikaci
  s PLC TC500. Fyzicky se zpravy prenaseji ze serioveho portu RS485 Term10
  do PLC Tecomat, kde Term10 je Master a PLC Tecomat je Slave.
  Program provadi cyklicke cteni a zapis hodnot do registru dvou Tecomatu
  s naslednym zpracovanim a vizualizaci ctenych hodnot.
  V PLC Tecomatech je nahran program TECO_REG.950, ktery simuluje exponencielni
  P regulator. Term10 posle Tecomatu pozadovanou hodnotu, ktery podle ni
  zpracuje podle funkce New = (MulVal * Old + (100 - MulVal) * PozVal) / 100
  aktualni merenou hodnotu, kterou posle zpet terminalu Term10, ktery
  ji i s prislusnou pozadovanou hodnotou zapise do pole dat, ktere je graficky
  zobrazovano na displeji. Oba dva PLC Tecomaty komunikuji stejne registry.
}
{ V komentarich se vyskytuji zkracene symboly,
  napr: "/4" znamena "delitelno ctyrma",
        "[10ms]" znamena ze udaj je v desitkach milisekund.
}
{ Tendo demostracni program byl napsan pro Kit-Builder V02.C0 23/10/1998
}

options
  ProgVer = 1; { verze programu }

{ nasledujici konstanty a definice je potrebne definovat pred prilinkovanim
  include soubor TECOM_2.PRI definici "#include TECOM_2.PRI" (viz nize) }
#define
  deklar symbol { misto klicoveho slova "symbol" se smi pouzivat tez slovo "deklar" }
    { tato definice je pro rozdeleni deklarace promennych a symbolicke
      pojmenovani jiz deklarovanych promennych : deklar = deklarace,
      symbol = symbolicke nazvy}
constant
 { konstanty nutne pro automat Tecomatu }
  cTC_MaxPLC     = 2;   { pocet obsluhovanych a maximalne pripojenych PLC stanic }
                        { Pozn: musi byt definovan stejny (nebo vetsi) pocet
                          zaznamu pro jednotlive Tecomaty }
  cTC_SndMaxTOut = 50;  { maximalni timeout pri vysilani [10ms] }
  cTC_RecMaxTOut = 100; { maximalni timeout pri prijmu odpovedi [10ms] }
  cTC_TryConnect = 10;  { perioda pro opakovani testu pripojenych PLC [s] zpravou Connect }
  cTC_SizeRead   = 8;   { velikost bufferu pro cteni registru z PLC
                          1. musi byt /4
                          2. musi byt v intervalu 0 az 244 }
  cTC_SizeWrite  = 8;   { velikost bufferu pro zapis registru do PLC
                          1. musi byt /4
                          2. musi byt v intervalu 0 az 244 }
 { retezcova konstanta s parametry pro komunikaci }
  { zvoli se jedna z nasledujicich variant podle pouzite cilove platformy }
  {Term10 - realne prostredi pro KitV40 a Term10 }
   cTC_ParamStr   = "NAM=TECOM MAS=MASTER NOD=100 LSB=200 NAM=COM ADD=$2330 IRQ=4 BD=38400 BIT=8 STO=2 PAR=E LRB=500";
  {PC     - simulace na PC }
{   cTC_ParamStr   = "NAM=TECOM MAS=MASTER NOD=100 LSB=200 NAM=COM COM=3 IRQ=5 BD=9600 BIT=8 STO=2 PAR=E LRB=500";
   { vyznam jednotlivych parametru - viz komunikacni knihovny }

#include TECOM_2.PRI; { prilinkovani obsluhy PLC Tecomatu }

{ symbolicke nazvy registru obou Tecomatu }
{ Jelikoz oba Tecomaty maji stejnou strukturu a vyznam svych registru,
  staci symbolicky definovat pouze registry pro 1.Tecomat. Na symbolicke
  nazvy registru 2.Tecomatu se odkazuje stejne jako na symbolicke nazvy
  registru 1.Tecomatu, ale s jinym offsetem v [] }
symbol
 { symbolicke nazvy ctenych registru z Tecomatu }
  TC_AktVal  = word(TC1_Addr)[cTC_Read_Data + 0];
     { aktualni hodnota prectena z Tecomatu }
  TC_PozVal_ = word(TC1_Addr)[cTC_Read_Data + 2];
     { zpetne prectena pozadovana hodnota }
  TC_MulVal_ = word(TC1_Addr)[cTC_Read_Data + 4];
     { zpetne prectena regulacni konstanta }
  TC_PerVz_  = word(TC1_Addr)[cTC_Read_Data + 6];
     { zpetne prectena perioda vzorkovani [10ms] }
 { symbolicke nazvy zapisovanych registru do Tecomatu }
  TC_PozVal  = word(TC1_Addr)[cTC_Write_Data+ 0];
     { pozadovana hodnota zapisovana do Tecomatu }
  TC_MulVal  = word(TC1_Addr)[cTC_Write_Data+ 2];
     { regulacni konstanta zapisovana do Tecomatu }
  TC_PerVz   = word(TC1_Addr)[cTC_Write_Data+ 4];
     { perioda vzorkovani [10ms] zapisovana do Tecomatu }

{ konstanty pro simulator regulatoru }
constant
  cMaxPozVal = 500; { maximalni pozadovana hodnota }

{ konstanty a promenne pro graficke znazorneni regulatoru }
constant
  GPoints    = 50;        { pocet bodu grafu }
  GDataSize  = 2*GPoints; { velikost pole dat, "2*" protoze kazda polozka
                            je typu word (zabira 2 byty) }
{ promenne pro graficke znazorneni dat z 1. a 2. Tecomatu }
deklar
  GAktData1  = word :GDataSize; { pole pro ulozeni aktualnich hodnot prectenych z PLC }
  GPozData1  = word :GDataSize; { pole pro ulozeni pozadovanych hodnot zpetne ctenych z PLC }
  GCount1    = longint;         { pocitadlo prijmutych zprav pro periodu vzorkovani grafu
                                  (aby se graf aktualizoval v zavislosti na rychlosti cteni registru z PLC) }
  GAktData2  = word :GDataSize; { pole pro ulozeni aktualnich hodnot prectenych z PLC }
  GPozData2  = word :GDataSize; { pole pro ulozeni pozadovanych hodnot zpetne ctenych z PLC }
  GCount2    = longint;         { pocitadlo prijmutych zprav pro periodu vzorkovani grafu
                                  (aby se graf aktualizoval v zavislosti na rychlosti cteni registru z PLC) }
symbol
  GAktData1_ = GAktData1[2];    { symbolicky nazev pro druhou aktualni hodnotu v poli (pro proceduru Move) }
  GPozData1_ = GPozData1[2];    { symbolicky nazev pro druhou pozadovanou hodnotu v poli (pro proceduru Move) }
  GAktData2_ = GAktData2[2];    { symbolicky nazev pro druhou aktualni hodnotu v poli (pro proceduru Move) }
  GPozData2_ = GPozData2[2];    { symbolicky nazev pro druhou pozadovanou hodnotu v poli (pro proceduru Move) }

{ konfigurace terminalu Term10 }
configuration
  HwObj  = TERM10, { nazev HW objektu }
    Name = TERM,   { uzivatelsky nazev pouzivany dale v programu }
    Adr  = $2300,  { adresa terminalu v IO prostoru }
    Var  = Byte;

{ konstanty fontu, bitmap a obrazovek terminalu }
constant
 { konstanty fontu }
  cFnt_8x8c   = 0; { font 8x8_cestina }
  cFnt_6x8c   = 1; { font 6x8_cestina }
  cFnt_16x32c = 2; { font 16x24_cestina }
 { konstanty bitmap }
  cBmp_Logo   = 0; { bitmapa s logem fy.SofCon }
  cBmp_Clear  = 1; { bitmapa prazdne stranky }
 { konstanty obrazovek terminalu }
  cTer_Uvod   = 0; { uvodni obrazovka s logem firmy SofCon }
  cTer_Graph  = 1; { obrazovka s grafickym znazornenim namerenych hodnot z PLC }
  cTer_Edit   = 2; { obrazovka pro editaci pozadovane hodnoty, regulacni konstanty a periody vzorkovani }
  cTer_SysCom = 3; { systemova obrazovka s komunikaci }

{ pomocne konstanty a promenne }
constant
 { konstanty pro urceni editovane promenne }
  cEd_Pozad  = 1;    { editace pozadovane hodnoty }
  cEd_Regul  = 2;    { editace regulacni konstanty }
  cEd_PerVz  = 3;    { editace periody vzorkovani }
deklar
  Pom_SimPoz = word; { pro simulaci zmeny pozadovane hodnoty }
  Pom_SimLed = word; { pro periodu simulace zmeny LED na Term10 }
  Pom_WhatEd = byte; { pro urceni editovane promenne (nabyva hodnot cEd_...) }
  Pom_Edit   = word; { pro editaci zadaneho parametru }
  Pom_I      = byte; { pro FOR cykly }

{ ------------------------------------ }
{ Nasledujici procedura se vykona vzdy po RESETu }
procedure INIT;
begin
 { pocatecni hodnota LED na Term10 }
  TERM_LED:=$AA;

 { inicializace a nastaveni Teco Automatu a jeho promennych
   a implicitni nastaveni zaznamu Tecomatu }
  TecoInit;
 { pocatecni nastaveni pro cteni a zapis registru z/do 1. PLC Tecomat }
  TC_DNode       [TC1_Offs] := 0;        { cislo stanice PLC v siti }
  TC_SWritePerm  [TC1_Offs] := 0;        { nastaveni vysilani zpravy pro zapis registru na priznak TC_FlSWrite }
  TC_FlSWrite    [TC1_Offs] := 1;        { poprve vyslat zpravu pro zapis registru }
  TC_SRead_Typ   [TC1_Offs] := cTC_RegR; { typ ctenych registru }
  TC_SRead_Frst  [TC1_Offs] := 0;        { cislo prvniho cteneho registru }
  TC_SRead_Len   [TC1_Offs] := 8;        { pocet ctenych registru (bytu) z PLC
                                           Nesmi byt vetsi nez konstanta cTC_SizeRead! }
  TC_SWrite_Typ  [TC1_Offs] := cTC_RegR; { typ zapisovanych registru }
  TC_SWrite_Frst [TC1_Offs] := 2;        { cislo prvniho zapisovaneho registru }
  TC_SWrite_Len  [TC1_Offs] := 6;        { pocet zapisovanych registru (bytu) do PLC
                                           Nesmi byt vetsi nez konstanta cTC_SizeWrite! }
  TC_AktVal      [TC1_Offs] := 0;        { pocatecni nastaveni aktualni hodnoty }
  TC_PozVal_     [TC1_Offs] := 0;        { pocatecni nastaveni zpetne ctene pozadovane hodnoty }
  TC_MulVal_     [TC1_Offs] := 0;        { pocatecni nastaveni zpetne ctene regulacni konstanty }
  TC_PerVz_      [TC1_Offs] := 0;        { pocatecni nastaveni zpetne ctene periody vzorkovani }
  TC_PozVal      [TC1_Offs] := 100;      { pocatecni nastaveni pozadovane hodnoty }
  TC_MulVal      [TC1_Offs] := 2;        { nastaveni regulacni konstanty
                                           ([%] pro zahrnuti pozadovane hodnoty do stavajici aktualni) }
  TC_PerVz       [TC1_Offs] := 4;        { nastaveni periody vzorkovani [10ms] }

 { pocatecni nastaveni pro cteni a zapis registru z/do 2. PLC Tecomat }
  TC_DNode       [TC2_Offs] := 1;        { cislo stanice PLC v siti }
  TC_SWritePerm  [TC2_Offs] := 0;        { nastaveni vysilani zpravy pro zapis registru na priznak TC_FlSWrite }
  TC_FlSWrite    [TC2_Offs] := 1;        { poprve vyslat zpravu pro zapis registru }
  TC_SRead_Typ   [TC2_Offs] := cTC_RegR; { typ ctenych registru }
  TC_SRead_Frst  [TC2_Offs] := 0;        { cislo prvniho cteneho registru }
  TC_SRead_Len   [TC2_Offs] := 8;        { pocet ctenych registru (bytu) z PLC
                                           Nesmi byt vetsi nez konstanta cTC_SizeRead! }
  TC_SWrite_Typ  [TC2_Offs] := cTC_RegR; { typ zapisovanych registru }
  TC_SWrite_Frst [TC2_Offs] := 2;        { cislo prvniho zapisovaneho registru }
  TC_SWrite_Len  [TC2_Offs] := 6;        { pocet zapisovanych registru (bytu) do PLC
                                           Nesmi byt vetsi nez konstanta cTC_SizeWrite! }
  TC_AktVal      [TC2_Offs] := 0;        { pocatecni nastaveni aktualni hodnoty }
  TC_PozVal_     [TC2_Offs] := 0;        { pocatecni nastaveni zpetne ctene pozadovane hodnoty }
  TC_MulVal_     [TC2_Offs] := 0;        { pocatecni nastaveni zpetne ctene regulacni konstanty }
  TC_PerVz_      [TC2_Offs] := 0;        { pocatecni nastaveni zpetne ctene periody vzorkovani }
  TC_PozVal      [TC2_Offs] := 200;      { pocatecni nastaveni pozadovane hodnoty }
  TC_MulVal      [TC2_Offs] := 5;        { nastaveni regulacni konstanty
                                           ([%] pro zahrnuti pozadovane hodnoty do stavajici aktualni) }
  TC_PerVz       [TC2_Offs] := 15;       { nastaveni periody vzorkovani [10ms] }
 { uprava nekterych polozek zaznamu Tecomatu podle uzivatelskeho nastaveni }
  TecoReInit;

 { implicitni nastaveni hodnot poli grafu }
  for Pom_I:=0 to GDataSize-1 do
    begin
      GAktData1[Pom_I]:=0;
      GPozData1[Pom_I]:=0;
      GAktData2[Pom_I]:=0;
      GPozData2[Pom_I]:=0;
    end;
  GCount1 := 0;
  GCount2 := 0;

 { nastaveni promennych pro simulaci LED na Term10 }
  TimerOn(Pom_SimLed,Per1s); { spusteni sekundoveho casovace }
  Pom_SimLed:=0;
end;

{ ------------------------------------ }
procedure SimPozVal1;
  { meneni pozadovane hodnoty pro aktivni zmeny skutecnych hodnot pro 1.Tecomat }
begin
  if (TERM_ScrNo           <>cTer_Edit            ) and  { needituje-li se zrovna nektera konstanta ovlivnujici simulaci regulace }
     (TC_AktVal[TC1_Offs]+1>=TC_PozVal[TC1_Offs]  ) and
     (TC_AktVal[TC1_Offs]  <=TC_PozVal[TC1_Offs]+1) then { AktVal je v intervalu <PozVal-1,PozVal+1> - cca je vyregulovano }
    begin
      { nahodne zmenime pozadovanou hodnotu }
       Pom_SimPoz:=Rnd(151.0)+cMaxPozVal/5;
       if TC_PozVal[TC1_Offs]>cMaxPozVal/2 then
            Pom_SimPoz:=TC_PozVal[TC1_Offs]-Pom_SimPoz
       else Pom_SimPoz:=TC_PozVal[TC1_Offs]+Pom_SimPoz;
       TC_PozVal[TC1_Offs]:=Pom_SimPoz;
      { aby se provedl zapis do PLC }
       TC_FlSWrite[TC1_Offs]:=1;
    end;
end;

{ ------------------------------------ }
procedure SimPozVal2;
  { meneni pozadovane hodnoty pro aktivni zmeny skutecnych hodnot pro 2.Tecomat }
begin
  if (TERM_ScrNo           <>cTer_Edit            ) and  { needituje-li se zrovna nektera konstanta ovlivnujici simulaci regulace }
     (TC_AktVal[TC2_Offs]+1>=TC_PozVal[TC2_Offs]  ) and
     (TC_AktVal[TC2_Offs]  <=TC_PozVal[TC2_Offs]+1) then { AktVal je v intervalu <PozVal-1,PozVal+1> - cca je vyregulovano }
    begin
      { nahodne zmenime pozadovanou hodnotu }
       Pom_SimPoz:=Rnd(151.0)+cMaxPozVal/5;
       if TC_PozVal[TC2_Offs]>cMaxPozVal/2 then
            Pom_SimPoz:=TC_PozVal[TC2_Offs]-Pom_SimPoz
       else Pom_SimPoz:=TC_PozVal[TC2_Offs]+Pom_SimPoz;
       TC_PozVal[TC2_Offs]:=Pom_SimPoz;
      { aby se provedl zapis do PLC }
       TC_FlSWrite[TC2_Offs]:=1;
    end;
end;

{ ------------------------------------ }
procedure AddGraph1;
  { prida novy prvek do dat grafu pokud se nacetla nova data z 1.PLC }
begin
  if GCount1<>TC_RReadCt[TC1_Offs] then { nacetla se nova data }
    begin
      { srovnani pocitadel prectenych dat }
       GCount1 := TC_RReadCt[TC1_Offs];
      { posunuti pole aktualnich hodnot grafu doleva }
       Move(GAktData1_,GAktData1,GDataSize-2);
      { prirazeni nove aktualni hodnoty na konec pole }
       GAktData1[GDataSize-2]:=TC_AktVal[TC1_Offs];
      { posunuti pole pozadovanych hodnot grafu doleva }
       Move(GPozData1_,GPozData1,GDataSize-2);
      { prirazeni posledni pozadovane hodnoty na konec pole }
       GPozData1[GDataSize-2]:=TC_PozVal_[TC1_Offs];
    end;
end;

{ ------------------------------------ }
procedure AddGraph2;
  { prida novy prvek do dat grafu pokud se nacetla nova data z 2.PLC }
begin
  if GCount2<>TC_RReadCt[TC2_Offs] then { nacetla se nova data }
    begin
      { srovnani pocitadel prectenych dat }
       GCount2 := TC_RReadCt[TC2_Offs];
      { posunuti pole aktualnich hodnot grafu doleva }
       Move(GAktData2_,GAktData2,GDataSize-2);
      { prirazeni nove aktualni hodnoty na konec pole }
       GAktData2[GDataSize-2]:=TC_AktVal[TC2_Offs];
      { posunuti pole pozadovanych hodnot grafu doleva }
       Move(GPozData2_,GPozData2,GDataSize-2);
      { prirazeni posledni pozadovane hodnoty na konec pole }
       GPozData2[GDataSize-2]:=TC_PozVal_[TC2_Offs];
    end;
end;

{ ------------------------------------ }
procedure SimTermLed;
  { provadi se simulace rosveceni LED na Term10 }
begin
  if Pom_SimLed=1 then { po 1 sekunde zmenit LED }
    begin
      TERM_LED  := not TERM_LED; { zmena LED }
      Pom_SimLed:= 0; { snulovani casovace }
    end;
end;

{ ------------------------------------ }
{ Nasledujici procedura se provadi cyklicky po celou dobu behu programu }
procedure MAIN;
begin
  SimPozVal1;  { simulace zmeny pozadovane hodnoty 1.Tecomatu }
  SimPozVal2;  { simulace zmeny pozadovane hodnoty 2.Tecomatu }
  TecoAutomat; { automat Tecomatu (pro posilani a prijimani zprav a udrovani navazaneho spojeni s PLC) }
  AddGraph1;   { aktualizace hodnot grafu 1.Tecomatu }
  AddGraph2;   { aktualizace hodnot grafu 2.Tecomatu }
  SimTermLed;  { simulace zmeny LED na Term10 }
end;

{ ========================================================================== }
terminal TERM : cTer_Uvod;
   { uvodni obrazovka s logem firmy SofCon }
begin
  BitMap cBmp_Logo;  { bitmapa c.0 - s logem SofCon }
  Wait 1,cTer_Graph; { po jedne sekunde se automaticky prejde na obrazovku c.1 }
  OnKey              { nebo po stisku nektere z klaves se prejde na obrazovku c.1 }
    zESC,zCR,
    zUp, zDn : TERM_ScrNo:=cTer_Graph;
  end;
end;

{ ------------------------------------ }
terminal TERM : cTer_Graph;
   { obrazovka s grafickym zobrazenim namerenych hodnot }
begin
  Bitmap cBmp_Clear; { bitmapa c.1 - bila stranka }
  Font cFnt_8x8c;    { nastaveni fontu na 8x8_cestina }
  Rect 2,2,237,125;  { ramecek okolo cele obrazovky }
  Line 2,20,237,20;  { linka pro oddeleni hlavicky od zbytku obrazovky }
  Position 20,7;     { vypsani hlavicky obrazovky }
   case TC_ViewTeco of
     1:Print "Vizualizace meen 1.TC500";
     2:Print "Vizualizace meen 2.TC500";
   end;


  Font cFnt_6x8c;
  { vypsani, zda je ci neni navazana komunikace s PLC Tecomat }
  Position 50,25;
   case TC_FlConnect[TC_ViewAdr] of
     0:Print "Nekomunikuji";
     1:Print "Komunikuji";
   end;

  { vykresleni os grafu }
   Line rel,15,36+50,150,0;
   Line rel,15,36,0,50;
  { popis os grafu }
   Position 8,37;
    Print "y";
   Position 160,87;
    Print "x";
  { vlastni vykresleni grafu }
   case TC_ViewTeco of
     1:begin
         Graph Line ,Rel,GPoints,GAktData1,0,500,15,35,150,50; { carovy graf merenych hodnot }
         Graph Point,Rel,GPoints,GPozData1,0,500,15,35,150,50; { bodovy graf pozadovanych hodnot }
       end;
     2:begin
         Graph Line ,Rel,GPoints,GAktData2,0,500,15,35,150,50; { carovy graf merenych hodnot }
         Graph Point,Rel,GPoints,GPozData2,0,500,15,35,150,50; { bodovy graf pozadovanych hodnot }
       end;
   end;

  { vykresleni ramecku pro bargrafy a jejich popis }
   Rect rel,185,35,10,50;
   Rect rel,215,35,10,50;
   Position 182,87;
    Print "m";
   Position 212,87;
    Print "po";
  { vlastni vykresleni bargrafu }
   Bar Bottom,Rel,TC_AktVal [TC_ViewAdr],0,500,185,35,10,50; { bargraph merene hodnoty }
   Bar Bottom,Rel,TC_PozVal_[TC_ViewAdr],0,500,215,35,10,50; { bargraph pozadovane hodnoty }
  { vypis aktualnich hodnot nad bargrafy }
   Position 182,27;
    Print TC_AktVal [TC_ViewAdr]:3;
   Position 212,27;
    Print TC_PozVal_[TC_ViewAdr]:3;

  { vypis globalnich velicin mereni v dolni casti obrazovky }
   Position  10, 99;
    Print "Meno : ",TC_AktVal[TC_ViewAdr];            { vypis ctene merene hodnoty z PLC }
   Position  10,111;
    Print "Poadov: ",TC_PozVal_[TC_ViewAdr];           { vypis zpetne ctene pozadovane hodnoty z PLC }
   Position 110, 99;
    Print "Regulan k: ",TC_MulVal_[TC_ViewAdr]," %";  { vypis zpetne ctene regulacni konstanty z PLC }
   Position 110,111;
    Print "Perioda Vz : ",TC_PerVz_[TC_ViewAdr],"0 ms"; { vypis zpetne ctene periody vzorkovani z PLC }

  { nakresleni podtrzitek editacnich pismen }
   Line rel, 10,119,4,0;
   Line rel,110,107,4,0;
   Line rel,158,119,4,0;

  OnKey { pozadovane akce na stisk danych klaves }
    zESC:TERM_ScrNo:=cTer_Graph;
    zDn,
    zUp :TERM_ScrNo:=cTer_Graph;
    'S' :TERM_ScrNo:=cTer_SysCom;
    zRi :
      begin
        Inc(TC_ViewTeco);
        if TC_ViewTeco>cTC_MaxPLC then TC_ViewTeco:=1;
        TC_SetViewTecoAdr;
      end;
    zLe :
      begin
        Dec(TC_ViewTeco);
        if TC_ViewTeco<1 then TC_ViewTeco:=cTC_MaxPLC;
        TC_SetViewTecoAdr;
      end;
    '1' :
      begin
        TC_ViewTeco:=1;
        TC_SetViewTecoAdr;
      end;
    '2' :
      begin
        TC_ViewTeco:=2;
        TC_SetViewTecoAdr;
      end;
    'P' : { jde se na obrazovku editace pro editaci pozadovane hodnoty }
      begin
        Pom_WhatEd:=cEd_Pozad;
        Pom_Edit  :=TC_PozVal[TC_ViewAdr];
        TERM_ScrNo:=cTer_Edit;
      end;
    'R' : { jde se na obrazovku editace pro editaci regulacni konstanty }
      begin
        Pom_WhatEd:=cEd_Regul;
        Pom_Edit  :=TC_MulVal[TC_ViewAdr];
        TERM_ScrNo:=cTer_Edit;
      end;
    'V' : { jde se na obrazovku editace pro editaci periody vzorkovani }
      begin
        Pom_WhatEd:=cEd_PerVz;
        Pom_Edit  :=TC_PerVz[TC_ViewAdr]*10;
        TERM_ScrNo:=cTer_Edit;
      end;
  end;

  Help { definice stranky napovedy }
   Font cFnt_8x8c;
                         {12345678901234567890123456789012345678 - znakove pozice na obrazovce }
   Position 10,10; Print "Npovda";
   Font cFnt_6x8c;
   Position 10,25; Print "<P> - editace poadovan hodnoty";
   Position 10,35; Print "<R> - editace regulan konstanty";
   Position 10,45; Print "<V> - editace periody vzorkovn";
   Position 10,60; Print "V grafu se znzoruj poadovan";
   Position 10,72; Print "(tekovan) a men (rkovan)";
   Position 10,84; Print "hodnoty z PLC Tecomat. Na osu Y se";
   Position 10,96; Print "vyn jednotliv hodnoty a na osu X";
   Position 10,108;Print "prbh ten dat z PLC Tecomat";
end;

{ ------------------------------------ }
terminal TERM : cTer_Edit;
   { obrazovka pro editaci pozadovane hodnoty, regulacni konstanty ci periody vzorkovani }
begin
  Bitmap cBmp_Clear;
  Font cFnt_8x8c;
  Rect 2,2,237,125;
  Line 2,20,237,20;
  Rect rel,85,46,56,28;
  case Pom_WhatEd of { rozdeleni podle editovane promenne }
    cEd_Pozad: { editace pozadovane hodnoty }
      begin
        { vypis hlavicky }
         Position 15,7;
          Print "Editace Poadovan hodnoty";
        { vypis vodiciho textu }
         Font cFnt_6x8c;
         Position 15,95;
          Print "Zadej cel slo v rozsahu 0 a 500";
        { nastaveni forntu a pozice pro editaci }
         Font cFnt_16x32c;
         Position 90,45;
        { vlastni editace }
         Edit Pom_Edit:3,0,cMaxPozVal;
      end;
    cEd_Regul: { editace regulacni konstanty }
      begin
        Position 12,7;
         Print "Editace Regulan konstanty";
        Font cFnt_6x8c;
        Position 15,95;
         Print "Zadej cel slo v rozsahu 1 a 100";
        Rect rel,85,46,56,28;
        Font cFnt_16x32c;
        Position 143,45;
         Print "%";
        Position 90,45;
        Edit Pom_Edit:3,1,100;
      end;
    cEd_PerVz: { editace periody vzorkovani }
      begin
        Position 15,7;
         Print "Editace Periody vzorkovn";
        Font cFnt_6x8c;
        Position 15,95;
         Print "Zadej cel slo v rozsahu 1 a 999";
        Rect rel,85,46,56,28;
        Font cFnt_16x32c;
        Position 143,45;
         Print "ms";
        Position 90,45;
        Edit Pom_Edit:3,1,999;
      end;
  end;

  EditEnter { definice akci pro ukonceni editace klavesou <Enter> }
   case Pom_WhatEd of
     cEd_Pozad:
       begin
         TC_PozVal  [TC_ViewAdr]:=Pom_Edit; { aktualizace zeditovane promenne }
         TC_FlSWrite[TC_ViewAdr]:=1;        { aby se provedl zapis do PLC }
       end;
     cEd_Regul:
       begin
         TC_MulVal  [TC_ViewAdr]:=Pom_Edit;
         TC_FlSWrite[TC_ViewAdr]:=1;
       end;
     cEd_PerVz:
       begin
         TC_PerVz   [TC_ViewAdr]:=Pom_Edit/10;
         TC_FlSWrite[TC_ViewAdr]:=1;
       end;
   end;

  Help
   Font cFnt_8x8c;
   Position 10,10; Print "Npovda";
   Font cFnt_6x8c;
   case Pom_WhatEd of
     cEd_Pozad:
       begin                   {12345678901234567890123456789012345678 - znakove pozice na obrazovce }
         Position 10,25; Print "Poadovan hodnota je daj, kter se";
         Position 10,37; Print "pole PLC Tecomatu. Ten zane podle";
         Position 10,49; Print "tto hodnoty regulovat a bude se sna-";
         Position 10,61; Print "it piblit meenou hodnotu co nej-";
         Position 10,73; Print "vce k poadovan hodnot.";
       end;
     cEd_Regul:
       begin                   {12345678901234567890123456789012345678 - znakove pozice na obrazovce }
         Position 10,25; Print "Regulan konstanta udv procentueln";
         Position 10,37; Print "zastoupen poadovan hodnoty v nov";
         Position 10,49; Print "namen hodnote, piem zbytek se";
         Position 10,61; Print "bere z pvodn namen hodnoty.";
         Position 10,73; Print "Vpoet se provd v PLC Tecomat";
         Position 10,85; Print "podle vzorce:";
         Position 10,97; Print " New=(Regul_K*Old+(100-Regul_K))/100";
       end;
     cEd_PerVz:
       begin                   {12345678901234567890123456789012345678 - znakove pozice na obrazovce }
         Position 10,25; Print "Perioda vzorkovn udv prodlevu";
         Position 10,37; Print "v destkch milisekund mezi jednotli-";
         Position 10,49; Print "vmi vpoty nov namen hodnoty";
         Position 10,61; Print "v PLC Tecomat.";
       end;
   end;
end;

{ ------------------------------------ }
terminal TERM : cTer_SysCom;
   { ladici obrazovka }
begin
  Bitmap cBmp_Clear;
  Font cFnt_8x8c;
  Rect 2,2,237,125;
  Line 2,20,237,20;
  Position 12,7;
   case TC_ViewTeco of
     1:Print "Komunikace s 1.PLC Tecomat";
     2:Print "Komunikace s 2.PLC Tecomat";
   end;

  Font cFnt_6x8c;
  Position 120,25;
   Print "AktPLC: ",TC_ComTeco; { vypis cisla Tecomatu se kterym se prave komunikuje }
  Position 10,25;
   case ComTECO_Ctrl of { vypise aktualni stav automatu komunikacniho kanalu }
     $00 : Print "Kanl Open/Close";
     $01 : Print "Kanl Off";
     $02 : Print "Kanl En";
     $04 : Print "Kanl Err";
     $10 ,
     $12 : Print "Kanl Send";
     $20 ,
     $22 : Print "Kanl SendErr";
     $40 ,
     $42 : Print "Kanl Rec";
     $80 ,
     $82 : Print "Kanl RecErr";
     else  Print "Kanl v jinm stavu ",ComTECO_Ctrl;
   end;
  Position 10,35;
   case TC_A of { vypise aktualni stav automatu Tecomatu }
     cTC_A_None,
     cTC_A_ReadBeg,
     cTC_A_WriteBeg   : Print "Automat  None";
     cTC_A_BegConn    : Print "Automat  Beg Connect";
     cTC_A_ContConn   : Print "Automat  Connecting";
     cTC_A_Read       : Print "Automat  Read  Reg";
     cTC_A_Write      : Print "Automat  Write Reg";
     cTC_A_WasRW      : Print "Automat  To Next PLC";
     else               Print "Automat  v jinm stavu";
   end;
  Position 10,45;
   case TC_RWA of { vypise aktualni stav RW automatu }
     cTC_RW_None      : Print "RW Autom None";
     cTC_RW_Rec       : Print "RW Autom Receiving";
     cTC_RW_WaitSend  : Print "RW Autom Sending";
     cTC_RW_SndConnect: Print "RW Autom Send_Connect";
     cTC_RW_SndReadN  : Print "RW Autom Send_ReadN";
     cTC_RW_SndWriteN : Print "RW Autom Send_WriteN";
     else               Print "RW Autom v jinm stavu";
   end;
  Position 10,55;
   case TC_Result of { vypise aktualni hodnotu vysledku RW automatu }
     cTC_Res_Ok       : Print "Result : Ok";
     cTC_Res_ErrInit  : Print "Result : Chyba pi ComOn";
     cTC_Res_SndTOut  : Print "Result : TimeOut pi vysln";
     cTC_Res_SndErr   : Print "Result : Chyba pi vysln";
     cTC_Res_RecTOut  : Print "Result : TimeOut pi pjmu";
     cTC_Res_RecErr   : Print "Result : Chyba pi pjmu";
     cTC_Res_BadAnsw  : Print "Result : Pila jin odpov";
     else               Print "Result : neznm";
   end;
  Position 10,65;
   Print "TOutCt : ",TC_TOutCt,"0ms"; { citac pro TimeOut pri cteni odpovedi z Teca }
  Position 10,75;
   Print "Ct_SndRead : ",TC_SReadCt[TC_ViewAdr];
  Position 10,85;
   Print "Ct_RecRead : ",TC_RReadCt[TC_ViewAdr];
  Position 130,75;
   Print "Ct_SndWrite : ",TC_SWriteCt[TC_ViewAdr];
  Position 130,85;
   Print "Ct_RecWrite : ",TC_RWriteCt[TC_ViewAdr];

  Position 10,95;
   case TC_FlConnect[TC_ViewAdr] of
     0 : print "PLC Not Connect";
     1 : print "PLC Connect";
   end;

  Position 10,105;
   Print "Readed ",TC_SRead_Len[TC_ViewAdr];
   case TC_SRead_Typ[TC_ViewAdr] of
     cTC_RegR : Print " Reg R ";
     cTC_RegX : Print " Reg X ";
     cTC_RegY : Print " Reg Y ";
     cTC_RegS : Print " Reg S ";
   end;
   Print "from $",hex TC_SRead_RegH[TC_ViewAdr], hex TC_SRead_RegL[TC_ViewAdr];

  Position 10,115;
   Print "Writed ",TC_SWrite_Len[TC_ViewAdr];
   case TC_SWrite_Typ[TC_ViewAdr] of
     cTC_RegR : Print " Reg R ";
     cTC_RegX : Print " Reg X ";
     cTC_RegY : Print " Reg Y ";
     cTC_RegS : Print " Reg S ";
   end;
   Print "to $",hex TC_SWrite_RegH[TC_ViewAdr], hex TC_SWrite_RegL[TC_ViewAdr];

  OnKey
    zESC:TERM_ScrNo:=cTer_Graph;
    zDn,
    zUp :TERM_ScrNo:=cTer_Graph;
  end;

  Help
    Position 20,20; Print "Obr. se zkl. parametry";
    Position 20,35; Print "komunikace s PLC Tecomat";
end;

{ ------------------------------------ }
