{ --------------------------------------------- }
{  KIT-Builder Program                          }
{                                               }
{  (c) SofCon 1998                              }
{ --------------------------------------------- }
{
  Tento program slouzi k demonstraci prace s objekty archive,
  vedle objektu archive se pracuje s prikazy GRAPH, BAR,
  fce SIN, ...
  V programu je provadeno generovani sinusoveho signalu.
  Tento signal je ukladan do rady (pole) registru.
  Obsah teto rady je zobrazovan na displeji ve forme grafu
}

#define pos position         {pomoci define muzeme misto "position" pouzivat jen "pos"}

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
constant
  cNb    =100;               {pocet bodu grafu}

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
SYMBOL
  GData  = Integer:2*cNb;    {registry pro ulozeni grafu}

  Krok   = Byte;             {krok velikosti uhlu pro vypocet noveho prvku}
  PerS   = Byte;             {perioda vypoctu noveho prvku simulatoru}
  PerG   = Byte;             {perioda zaznamu dalsiho prvku do grafu}

  aKrok  = Byte;             {promenne pro potencionalni cteni}
  aPerS  = Byte;             {obsahu archivu primo z programu KB}
  aPerG  = Byte;
  aTime  = DateTime;
  aFce   = Integer;
  Name   = String:10;
  aName  = String:10;

  Fce    = Integer;          {simulovana sinusova funkce}

  TS     = Word;             {promenna pro casovac vypoctu simulatoru}
  TG     = Word;             {promenna pro casovac ukladani do grafu}

  Alfa   = Integer;          {uhel pri vypoctu simulatoru}
  i      = Byte;             {pomocna prommenna pro cykly}
  TypGr  = Byte;             {promenna pro rozliseni typu zobrazovaneho grafu}

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
CONFIGURATION
  HWOBJ=TERM10, LED=$AA, NAME=TERM, ADR=$2300, VAR=Byte; {deklarace terminalu}
  SWOBJ=SAVER, SAVE=[PerS,Krok,PerG];  {nektere promenne je vhodne pri
                                        vypadku napajeni zalohovat}
  swobj=archivelast, name=archivPar, size=20,
        save=[SysPackTime,Krok,PerS,PerG,Name],
        load=[aTime,aKrok,aPerS,aPerG,aName],
        format=["datum      cas     ","%t"," krok","%5d"," PerS","%5d"," PerG","%5d"] ;
  { archiv zalohujici zasahy obsluhy do regulatoru  }

  swobj=archivelast, name=archivHis, size=50, per=2, save=[SysPackTime,Fce], load=[aTime,aFce],
                                      format=["datum      cas     ","%t","   sin","%6d"] ;
  { archiv zalohujici prubech fce sin }

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
procedure INIT;
begin
  {Osetreni zalohovanych promennych, zda jsou ve spravnych mezich}
  if PerS<2  then PerS:=5
             else PerS:=PerS;

  if Krok<1 then Krok:=1
            else Krok:=Krok;

  if PerG<PerS then PerG:=PerS
               else PerG:=PerG;
  {Nastartovani casovacu}
  TimerOn(TG,per10ms);
  TimerOn(TS,per10ms);
end;
{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
procedure FAST10;             {Rychla procedura, vola se kazdych 10ms}
begin
  {Generator sinusovky}
  if TS>=PerS then
  begin
    TS:=TS-PerS;
    if Alfa < 360 then
      Alfa:=(Alfa+Krok)
    else
      Alfa:=0;
    fce:=sin(Alfa);
    if Fce>=0 then  {LED diody na TERM10 sviti podle polarity promenne fce}
      Term_LED:=$F
    else
      Term_LED:=$F0;
  end;

  {Zaznam noveho prvku do grafu na obrazovce}
  if TG>=PerG then
  begin
    TG:=TG-PerG;
    {uloz dalsi vzorek}

    move(gData[2], gData[0], (cNb-1)*2);

    gData[2*(cNb-1)]:=fce;
  end;
end;

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
procedure MAIN;             {V hlavni procedure se nic nevykonava}
begin
end;
{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
terminal TERM:0;
begin
  font 1;                                                  {Nastavime font 1}
  pos  20, 15; print "Ukzka pouit objektu ARCHIVE";       {Na pozici position ... }
  pos  20, 35; print "genertor sinusovky:";               { Vytiskneme text ...}
  pos  20, 45; print "Krok hlu ",Krok:0,", Perioda ",PerS:0,"0ms"; { a promenne}
  pos  20, 60; print "perioda zznamu do Grafu ",PerG:0,"0ms";
  pos  20, 75; print "Bodov graf";
  pos  20, 85; print "Crov graf";
  pos  20, 95; print "Sloupcov graf";
  pos  20,110; print "Npovda - klvesa F1";
  pos 214,  1; print Fce:4;
  rect 227,10,237,125;                        {nakreslime ramecek do ktereho}
  bar bottom, Fce, -100,100, 227,10,237,125;  {umistime bar graph }
  onkey                                       {definujeme reakci na klavesy}
   'K':TERM_scrno:=15;                        {'K' - prejdeme na obrazovku 15}
   'P':TERM_scrno:=16;                        {'P' - prejdeme na obrazovku 16}
   'G':TERM_scrno:=17;
   'C':begin TypGr:=0; TERM_SCRNO:=20; end;
   'B':begin TypGr:=1; TERM_SCRNO:=20; end;
   'S':begin TypGr:=2; TERM_SCRNO:=20; end;
  end;
help                                          {definice obrazovky HELP - aktivni}
  font 1;                                     {pri stisku F1, nastaveni fontu}
  pos 20, 15; print "Npovda";               {Na pozici ... umisti text ...}
  pos 20, 50; print "Zmnu hodnoty parametru nebo ";
  pos 20, 60; print "zobrazen grafu vyvolme stiskem";
  pos 20, 70; print "velk klavesy v pslunm nzvu.";
  pos 20,110; print "Zpt klvesou ESC.";
end;
{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
terminal TERM:15;
begin
  font 1;                                              {Nastavime font 1}
  pos 20, 30; print "Genertor sinusovky - nastaven"; {Na pozici position ... }
  pos 20, 40; print "velikosti kroku hlu <1,90> ";   {Vytiskneme text ...}
  pos 20, 60; print "Alfa=  "; pos 50,60; edit Krok:2,1,90; {a vytvorime okno
                                                        okno pro editaci promenne}
  pos 20,110; print "Npovda - klvesa F1";

  editenter ArchiveSave(ArchivPar);
help                                          {definice obrazovky HELP - aktivni}
  font 1;                                     {pri stisku F1, nastaveni fontu}
  pos 20, 15; print "Npovda";               {Na pozici ... umisti text ...}
  pos 20, 30; print "Nastaven velikosti kroku hlu.";
  pos 20, 40; print "Potvrzen nastaven hodnoty";
  pos 20, 50; print "klvesou ENTER,";
  pos 20, 60; print "Zpt bez nastaven klvesou ESC.";
end;
{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
terminal TERM:16;
begin
  font 1;                                              {Nastavime font 1}
  pos 20, 30; print "Genertor sinusovky - nastaven"; {Na pozici position ... }
  pos 20, 40; print "periody kroku <1,2000> ms";       {Vytiskneme text ...}
  pos 20, 60; print "Perioda=   0ms"; pos 68,60;edit PerS:3,1,200; { a vytvorime
                                                        okno pro editaci promenne}
  pos 20,110; print "Npovda - klvesa F1";

  editenter ArchiveSave(ArchivPar);

help                                          {definice obrazovky HELP - aktivni}
  font 1;                                     {pri stisku F1, nastaveni fontu}
  pos 20, 15; print "Npovda";               {Na pozici ... umisti text ...}
  pos 20, 30; print "Nastaven periody kroku genertoru.";
  pos 20, 40; print "Potvrzen nastaven hodnoty";
  pos 20, 50; print "klvesou ENTER,";
  pos 20, 60; print "Zpt bez nastaven klvesou ESC.";
end;
{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
terminal TERM:17;
begin
  font 1;                                             {Nastavime font 1}
  pos 20, 30; print "Graf - nastaven periody";       {Na pozici position ... }
  pos 20, 40; print "vzorkovn grafu <1,2000> ms";   {Vytiskneme text ...}
  pos 20, 60; print "Perioda=   0ms";pos 68,60;edit PerG:3,1,200;  { a vytvorime
                                                       okno pro editaci promenne}
  pos 20,110; print "Npovda - klvesa F1";
  editenter ArchiveSave(ArchivPar);
help                                          {definice obrazovky HELP - aktivni}
  font 1;                                     {pri stisku F1, nastaveni fontu}
  pos 20, 15; print "Npovda";               {Na pozici ... umisti text ...}
  pos 20 ,30; print "Nastaven periody vzorkovn.";
  pos 20 ,40; print "Potvrzen nastaven hodnoty";
  pos 20 ,50; print "klvesou ENTER,";
  pos 20 ,60; print "Zpt bez nastaven klvesou ESC.";
end;
{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
terminal TERM:20;
begin
  font 1;                                              {Nastavime font 1}
  case TypGr of                         {Podle nastveneho grafu vytisknu}
    0: graph line  ,rel,cNb,gData,-100,100,10,15,200,100; {carovy graf}
    1: graph point ,rel,cNb,gData,-100,100,10,15,200,100; {bodovy graf}
    2: graph bar   ,rel,cNb,gData,-100,100,10,15,200,100; {sloupcovy graf}
  end;
  rect rel,213,13,25,104;                  {nakreslime ramecek do ktereho}
  bar bottom, fce, -100,100, 215,15,215+21,15+100;   {umistime bar graph }
  pos 214,1; print Fce:4;
  onkey                                    {definujeme reakci na klavesy}
   'C':TypGr:=0;                           {'C' - nastav carovy graf}
   'B':TypGr:=1;                           {'B' - nastav bodovy graf}
   'S':TypGr:=2;                           {'S' - nastav sloupcovy graf}
  end;
help                                          {definice obrazovky HELP - aktivni}
  font 1;                                     {pri stisku F1, nastaveni fontu}
  pos 20, 15; print "Npovda";               {Na pozici ... umisti text ...}
  pos 20, 15; print "Npovda";
  pos 20, 40; print "Zmna typu grafu:";
  pos 20, 50; print "B - Bodov";
  pos 20, 60; print "C - rov";
  pos 20, 70; print "S - Sloupcov";
  pos 20,110; print "Zpt klvesou ESC.";
end;
