{ --------------------------------------------- }
{  KIT-Builder Program                          }
{                                               }
{  (c) SofCon 1998                              }
{---------------------------------------------- }

{
 Program demonstruje jednoduchou komunikaci pod protokolem PRT.
 Fyzicky se zpravy prenaseji z jednoho Comu do druheho.
 Nad jednim Comem sedi Master protokolu a nad druhym
 sedi Slave. Na strane Master je mozno editovat vysilanou zpravu
 a na stisk klavesy ENTER ji odvysilat. Slave prijatou zpravu
 zobrazi a posle zpet. Program dale umoznuje nastavovat DNode na
 strane Master i Slave a tak zkouset, co se stane pri jeho
 spatnem nastaveni.
}

configuration
  hwobj=TERM10, name=TERM, adr=$2300, var=Byte;
          { Pro zobrazovani dat a komunikaci s uzivatelem budeme
            pouzivat terminal TERM10 - definujeme tedy jeho parametry}

  hwobj=COM, name=MASTER,  var=Byte,
        PAR= "NAM=PRT NOD=1 DNO=2 LSB=100 NAM=COM COM=3 ADD=$3E8 IRQ=5 BD=9600 BIT=8 STO=1 PAR=E LRB=100";
   {dale definujeme vlastni komunikacni kanal MASTER vcetne parametru}

  hwobj=COM, name=SLAVE, var=Byte,
        PAR= "NAM=PRT NOD=2 DNO=1 LSB=100 NAM=COM COM=4 ADD=$3E0 IRQ=2 BD=9600 BIT=8 STO=1 PAR=E LRB=100";
   {dale definujeme vlastni komunikacni kanal SLAVE vcetne parametru}

symbol
  MasterS   =String:21;  {provedeme v pameti rezervaci mista pro}
  MasterR   =String:21;  {prijimaci a vysilaci buffery, Slave ma pouze}
  SlaveB    =String:21;  {jeden buffer do ktereho prijima a ihned ho i
                         vysila}

procedure INIT;          {procedura INIT se vykona vzdy po RESETu}
begin                    { - slouzi k pocatecnimu nastaveni promennych}
  MASTER_DNODE :=2;              {Nastevni DNode Master a Slave}
  SLAVE_DNODE  :=1;
  MasterS:="Dobry den, Konec.";  {nastavime pocatecni text vysilane zpravy}
  ComOn(SLAVE);                  {Zapneme komunikacni automat kanalu Slave}
  ComOn(MASTER);                 {Zapneme komunikacni automat kanalu Master}
end;

{ Nasledujici procedura se provadi cyklicky po celou dobu behu automatu }
procedure MAIN;
begin
  {Otestujeme, zda Slave obdrzel nejakou zpravu a vse je vporadku}
  if SLAVE_ON and SLAVE_REC and not SLAVE_RECERR then
  begin             {pokud ano, presuneme danou zpravu do Bufferu SlaveB}
    ComReceive(SLAVE,SlaveB,20); {maximalni povolena delka prijate zpravy je 20 znaku}
    if Slave_ON and not Slave_SEND then
    begin
      ComSend(SLAVE,SlaveB);     {prijatou zpravu posleme zpet}
    end;
  end;
  {Otestujeme, zda Master obdrzel nejakou zpravu a vse je vporadku}
  if MASTER_ON and MASTER_REC and not MASTER_RECERR then
  begin               {pokud ano, presuneme danou zpravu do Bufferu MasterR}
    ComReceive(MASTER,MASTERR,20); {maximalni povolena delka prijate zpravy je 20 znaku}
  end;
end;

{ ------------------------------------ }
{ Popis obrazovky c.0 terminalu TERM10 }
terminal TERM:0;
begin
  font 1;                                                {Nastavime font 1}
  position 10,10; print "Test komunikace";               {Na pozici position ...
                                                          Vytiskneme text ...}
  position 10,30; print "Mastr Ctrl: ",bin MASTER_CTRL,  {Na pozici position ...}
                        " Node=1 DNode=",MASTER_DNODE:0; {Vytiskneme text a obsah
                                                          promennych}
  position 10,50; print "Slave Ctrl: ",bin SLAVE_CTRL,   {Na pozici position ...}
                        " Node=2 DNode=",SLAVE_DNODE:0;  {Vytiskneme text a obsah
                                                          promennych}
  rect rel,8,67,224,12;                                  {nakreslime ramecek do ktereho}
  position 10,70; print "M Odesilam: ",MasterS;          {na pozici position ...}
                                                         {vytiskneme text a obsah
                                                          promennych}
  rect rel,8,87,224,12;                                  {nakreslime ramecek do ktereho}
  position 10,90; print "M Prijimam: ",MasterR;          {na pozici position ...}
                                                         {vytiskneme text a obsah
                                                          promennych}
  rect rel,8,107,224,12;                                 {nakreslime ramecek do ktereho}
  position 10,110; print "S Prijimam: ",SlaveB;          {na pozici position ...}
                                                         {vytiskneme text a obsah
                                                          promennych}
  onkey                                                  {definujeme reakci na klavesy}
    'O':TERM_ScrNo:=1;                                   {'O' - prejdeme na obrazovku 1}
    zCr:begin                                            {ENTER -}
          if MASTER_ON and not MASTER_SEND then          {pokud je vse pripraveno,}
          begin
            ComSend(MASTER,MasterS);                     {Master odesle zpravu}
          end;
        end;
    'D':begin                                            {'D'}
          SlaveB:="";                                    {Smaze buffery obsahujici }
          MasterR:="";                                   {prijate zpravy}
        end;
    'M':TERM_ScrNo:=2;                                   {'M' - prejdeme na obrazovku 2}
    'S':TERM_ScrNo:=3;                                   {'S' - prejdeme na obrazovku 3}
  end;

  help                                                   {definice obrazovky HELP - aktivni}
    font 1;                                              {pri stisku F1, nastaveni fontu}
    position 10,10; print "Npovda:";                   {Na pozici ... umisti text ...}
    position 10,35; print "Stisk klavesy:";
    position 20,45; print "D     - smazani prijate zpravy";
    position 20,55; print "O     - nastaveni vysilane zpravy";
    position 20,65; print "Enter - vyslani nastavene zpravy";
    position 20,75; print "M     - dnode vyslane zpravy Master";
    position 20,85; print "S     - dnode vyslane zpravy Slave";
end;

{ Popis obrazovky c.1 terminalu TERM10 }

terminal TERM:1;
begin
  font 1;                                                {pri stisku F1, nastaveni fontu}
  position 20,30; print "Editace vysilaneho stringu";    {Na pozici ... umisti text ...}
  position 20,50; print "S=";                            {Na pozici ... umisti text ...}
  position 38,50; edit MasterS:20;                       {Na pozici ... umisti editacni
                                                          okno promenne MasterS}
  help                                                   {definice obrazovky HELP - aktivni}
   font 1;                                               {pri stisku F1, nastaveni fontu}
   position 10 ,10; print "Npovda";                    {Na pozici ... umisti text ...}
   position 10 ,30; print "Editace vysilaneho stringu";
end;

terminal TERM:2;                                         {obdoba TERM:1}
begin
  font 1;
  position 20,30; print "Editace DNode MASTER";
  position 20,50; print "S="; position 38,50;
  edit MASTER_DNode:2,1,100;
  help
   font 1;
   position 10 ,10; print "Npovda";
   position 10 ,30; print "Editace DNode";
end;
terminal TERM:3;                                         {obdoba TERM:1}
begin
  font 1;
  position 20,30; print "Editace DNode SLAVE";
  position 20,50; print "S="; position 38,50;
  edit SLAVE_DNode:2,1,100;
  help
   font 1;
   position 10 ,10; print "Npovda";
   position 10 ,30; print "Editace DNode";
end;
