{ --------------------------------------------- }
{  include TECOM_1                  10.11.1998  }
{  KIT-Builder                                  }
{                                               }
{  (c) SofCon 1998                              }
{---------------------------------------------- }

{ Include soubor pro obsluhu jednoho PLC Tecomat.
  Zajistuje udrzovani komunikace s PLC, cteni a zapis pozadovanych registru
  podle nastavenych promennych zaznamu Tecomatu.
  Pozn: V komentarich se vyskytuji zkracene symboly,
        napr "/4" znamena "delitelno ctyrma".
}
{ Pokud uzivatel bude chtit upravit tento include soubor pro komunikaci
  s vice PLC Tecomaty staci provest prislusne upravy na radcich, kde se
  vyskytuje "!Pro vice Tecomatu!".
}

{ Pred prilinkovanim tohoto include souboru do aplikace prikazem
  "#include TECOM_1.PRI;" je treba definovat tyto konstanty a definice:
  #define
    deklar symbol  = misto klicoveho slova "symbol" se smi pouzivat tez slovo "deklar"
                     tato definice je pro rozdeleni deklarace promennych a symbolicke
                     pojmenovani jiz deklarovanych promennych : deklar = deklarace,
                     symbol = symbolicke nazvy
  constant
    cTC_MaxPLC     = pocet obsluhovanych a maximalne pripojenych PLC stanic
                     Pozn: pro include soubor TECOM_1.PRI = 1,
                           pro include soubor TECOM_2.PRI = 2 apod.
    cTC_ParamStr   = retezec s parametry komunikace (viz manualy komunikacnich
                     knihoven ChnXxx nebo manual Kit-Builder,Jak na to?)
    cTC_SndMaxTOut = maximalni timeout pri vysilani zprav [10ms]
    cTC_RecMaxTOut = maximalni timeout pri prijmu odpovedi [10ms]
    cTC_TryConnect = perioda [s] pro opakovani testu pripojenych PLC Tecomatu
                     zpravou Connect
    cTC_SizeRead   = velikost bufferu pro cteni registru z PLC
                     1. musi byt /4
                     2. musi byt v intervalu 0 az 244
                     3. pokud je vice Tecomatu, musi byt rovna velikosti
                        toho nejvetsiho bufferu
    cTC_SizeWrite  = velikost bufferu pro zapis registru do PLC
                     1. musi byt /4
                     2. musi byt v intervalu 0 az 244
                     3. pokud je vice Tecomatu, musi byt rovna velikosti
                        toho nejvetsiho bufferu
}

{----------------------------------------------------------}
{ konstanty definovane protokolem Tecomat }
constant
 { tMessType - typ zpravy }
  cTC_tpSACK          = 0;   { kratke potvrzeni }
  cTC_tpShortM        = 1;   { kratka zprava bez dat }
  cTC_tpLongM         = 2;   { dloha zprava s daty }

 { typy registru }
  cTC_RegX            = 0;   { registry X (vstupu) }
  cTC_RegY            = 1;   { registry Y (vystupu) }
  cTC_RegS            = 2;   { registry S (systemove) }
  cTC_RegR            = 3;   { registry R (uzivatelske) }
  cTC_DBox0           = $80; { oblast pridavne pameti DataBox adresy $00000 - $0FFFF }
  cTC_DBox1           = $81; { oblast pridavne pameti DataBox adresy $10000 - $1FFFF }
  cTC_DBox2           = $82; { oblast pridavne pameti DataBox adresy $20000 - $2FFFF }
  cTC_DBox3           = $83; { oblast pridavne pameti DataBox adresy $30000 - $3FFFF }
  cTC_DBox4           = $84; { oblast pridavne pameti DataBox adresy $40000 - $4FFFF }
  cTC_DBox5           = $85; { oblast pridavne pameti DataBox adresy $50000 - $5FFFF }
  cTC_DBox6           = $86; { oblast pridavne pameti DataBox adresy $60000 - $6FFFF }
  cTC_DBox7           = $87; { oblast pridavne pameti DataBox adresy $70000 - $7FFFF }

 { Frame Control (Command) }
  { od Master stanice }
  cTC_FCM_Connect     = $69; { FC pro zpravu Connect }
  cTC_FCM_Ident       = $6E; { FC pro zpravu Ident }
  cTC_FCM_Write       = $63; { FC pro zapis dat od Master stanice }
  cTC_FCM_Read        = $6C; { FC pro cteni dat od Master stanice }
  { od Slave stanice }
  cTC_FCS_ConnectRep  = $00; { FC pro odpoved na Connect }
  cTC_FCS_IdentRep    = $00; { FC pro dlouhou pozitivni odpoved na Ident }
  cTC_FCS_Reply       = $08; { FC pro dlouhou pozitivni odpoved na obecnou zpravu }
  cTC_FCS_UnknownMes  = $02; { FC pro kratkou negativni odpoved Neznama komunikacni sluzba }
  cTC_FCS_DataNotReady= $09; { FC pro kratkou negativni odpoved Data zatim nedostupna (ale brzy treba budou) }
  cTC_FCS_BadMesParam = $0C; { FC pro dlouhou negativni odpoved Chybne parametry komunikacni sluzby }

 { Second Frame Control (SubCommand) }
  cTC_FC2_SetTID      = $08; { SubFC pro nastaveni casu od Master stanice }
  cTC_FC2_SetCW       = $09; { SubFC pro nastaveni ridiciho slova od Master stanice }
  cTC_FC2_GetSW       = $0A; { SubFC pro cteni stavoveho slova od Master stanice }
  cTC_FC2_GetErr      = $0E; { SubFC pro cteni chyboveho zasobniku od Master stanice }
  cTC_FC2_MaskCW      = $11; { SubFC pro nastaveni jednotlivych bitu ridiciho slova od Master stanice }
  cTC_FC2_ReadN       = $0B; { SubFC pro cteni registru ze Slave stanice }
  cTC_FC2_WriteN      = $0C; { SubFC pro zapis registru do Slave stanice }
  cTC_FC2_WandrN      = $0D; { SubFC pro cteni i zapis registru }
  cTC_FC2_ReadB       = $0F; { SubFC pro cteni bitu registru }
  cTC_FC2_WriteB      = $10; { SubFC pro zapis bitu registru }
  cTC_FC2_ReadBD      = $90; { SubFC pro destruktivni cteni bitu registru }
  cTC_FC2_ReadND      = $91; { SubFC pro destruktivni cteni registru }
  cTC_FC2_WandrND     = $93; { SubFC pro destruktivni cteni registru a zapis registru }

{ konstanty automatu }
constant
{ konstanty stavu RW automatu }
 { konstanty stabilnich stavu automatu }
  cTC_RW_None         = $0 ; { nic se neprovadi }
  cTC_RW_Rec          = $10; { ceka se na prijem }
 { konstanty nestabilnich stavu automatu }
  cTC_RW_WaitSend     = $20; { ceka se do odvysilani zpravy }
  cTC_RW_SndConnect   = $21; { pocatek vyslani zpravy Connect od Mastra }
  cTC_RW_SndReadN     = $23; { pocatek vyslani zpravy ReadN od Mastra }
  cTC_RW_SndWriteN    = $24; { pocatek vyslani zpravy WriteN od Mastra }

{ konstanty stavu globalniho automatu }
  cTC_A_None          = $0 ; { }
  cTC_A_BegConn       = $10; { pocatek testovani pripojenych PLC }
  cTC_A_ContConn      = $15; { testovani pripojenych PLC }
  cTC_A_ReadBeg       = $20; { pocatek cteni registru }
  cTC_A_Read          = $21; { probiha cteni registru }
  cTC_A_WriteBeg      = $30; { pocatek zapisu registru }
  cTC_A_Write         = $31; { probiha zapis registru }
  cTC_A_WasRW         = $40; { prechod na dalsi PLC }

 { konstanty vysledku operaci }
  cTC_Res_Ok          = 0;   { vsechno je OK }
  cTC_Res_ErrInit     = 1;   { chyba pri initu kanalu }
  cTC_Res_SndTOut     = 2;   { TimeOut pri vysilani }
  cTC_Res_SndErr      = 3;   { vysilani skoncilo chybou }
  cTC_Res_RecTOut     = 4;   { TimeOut pri prijmu odpovedi }
  cTC_Res_RecErr      = 5;   { prijmuta zprava byla chybna }
  cTC_Res_BadAnsw     = 6;   { prijata zprava byla jina nez se ocekava }

{ promenne pro automaty }
symbol
 { citace }
  TC_TOutCt     = word;    { citac pro TimeOut }
  TC_ConnCt     = word;    { citac pro test pripojenych PLC }
 { promenne pro automat kanalu }
  TC_ComTeco    = byte;    { cislo aktualniho PLC s nimz se komunikuje }
  TC_ViewTeco   = byte;    { cislo aktualniho PLC, jehoz registry jsou zobrazovany }
  TC_ComAdr     = word;    { adresa pro pristup k zaznamum Tecomatu,
                             se kterym se prave komunikuje }
  TC_ViewAdr    = word;    { adresa pro pristup k zaznamum Tecomatu,
                             jehoz hodnoty jsou zobrazovany }
  TC_RWA        = byte;    { aktualni stav RW automatu }
  TC_WaitFor    = byte;    { urcuje pri prijmu jaka zprava je ocekavana }
  TC_Result     = byte;    { vysledek operace }
  TC_A          = byte;    { aktualni stav globalniho automatu }
 { pomocne "vnitrni" promenne }
  TC_I          = byte;    { pro vnejsi FOR cykly }
  TC_J          = byte;    { pro vnitrni FOR cykly }
  TC_PomTeco    = byte;    { cislo PLC pro pomocny pristup k polozkam zaznamu }
  TC_PomAdr     = word;    { adresa pro pomocny pristup k polozkam zaznamu }

{----------------------------------------------------------}
{ symbolicke konstanty offsetu pro definovani polohy polozek v zaznamu
  Tecomatu => jednotna struktura zaznamu vsech Tecomatu }
constant
                { velikost (typ) dane polozky }
 { konstanty obecnych polozek }
  cTC_DNode       = 0; { byte }
     { offset adresy stanice PLC Tecomat v siti }
  cTC_FlConnect   = 1; { byte }
     { offset priznaku pripojeni PLC Tecomatu }
  cTC_SWritePerm  = 2; { byte }
     { offset priznaku permanentniho vysilani zpravy WriteN }
  cTC_FlSWrite    = 3; { byte }
     { offset priznaku jednorazoveho vyslani zpravy WriteN }
  cTC_SReadCt     = 4; { longint }
     { offset citace vyslanych zprav ReadN }
  cTC_RReadCt     = 8; { longint }
     { offset citace prijmutych odpovedi na zpravu ReadN }
  cTC_SWriteCt    = 12; { longint }
     { offset citace vyslanych zprav WriteN }
  cTC_RWriteCt    = 16; { longint }
     { offset citace prijmutych odpovedi na zpravu WriteN }
 { konstanty polozek zpravy Connect - test pripojeni PLC Tecomat }
  cTC_SConn       = 20; { byte }
     { offset zacatku a zaroven delky vysilane zpravy Connect }
  cTC_SConn_FC    = 21; { byte }
     { offset FC vysilane zpravy Connect }
  cTC_RConn       = 22; { byte }
     { offset zacatku a zaroven delky odpovedi na zpravu Connect }
  cTC_RConn_MsTp  = 23; { byte }
     { offset MessType prijate odpovedi na zpravu Connect }
  cTC_RConn_FC    = 24; { byte }
     { offset FC prijate odpovedi na zpravu Connect }
 { konstanty polozek zpravy ReadN - cteni registru }
  { 1. cTC_SRead_FC musi byt na offsetu /4
    2. konstanty cTC_SRead az cTC_sRead_Len musi byt spojite za sebou }
  cTC_SRead       = 25; { byte }
     { offset zacatku a zaroven delky vysilane zpravy ReadN }
  cTC_SRead_FC    = 26; { byte }
     { offset FC vysilane zpravy ReadN }
  cTC_SRead_FC2   = 27; { byte }
     { offset FC2 vysilane zpravy ReadN }
  cTC_SRead_Dummy = 28; { word }
     { offset vynechaneho mista pro zarovnani na adresu /4 }
  cTC_SRead_Typ   = 30; { byte }
     { offset typu ctenych registru }
  cTC_SRead_RegL  = 31; { byte }
     { offset adresy prvniho cteneho registru - nizsi byte }
  cTC_SRead_RegH  = 32; { byte }
     { offset adresy prvniho cteneho registru - vyssi byte }
  cTC_SRead_Len   = 33; { byte }
     { offset poctu ctenych registru }
  cTC_SRead_Frst  = 34; { word }
     { offset adresy prvniho cteneho registru }
  { 1. cTC_RRead_MsTp musi byt na offsetu /4
    2. konstanty cTC_RRead az cTC_Read_Data musi byt spojite za sebou }
  cTC_RRead       = 39; { byte }
     { offset zacatku a zaroven delky odpovedi na zpravu ReadN }
  cTC_RRead_MsTp  = 40; { byte }
     { offset MessType odpovedi na zpravu ReadN }
  cTC_RRead_FC    = 41; { byte }
     { offset FC odpovedi zpravu ReadN }
  cTC_RRead_Dummy = 42; { word }
     { offset vynechaneho mista pro zarovnani na adresu /4 }
  cTC_Read_Data   = 44; { cTC_SizeRead bytu }
     { offset pole pro ulozeni prectenych hodnot registru }
 { konstanty polozek zpravy WriteN - zapis registru }
  { 1. cTC_SWrite_FC musi byt na offsetu /4
    2. konstanty cTC_SWrite az cTC_Write_Data musi byt spojite za sebou }
  cTC_SWrite      = 47+cTC_SizeRead; { byte }
     { offset zacatku a zaroven delky vysilane zpravy WriteN }
  cTC_SWrite_FC   = 48+cTC_SizeRead; { byte }
     { offset FC vysilane zpravy WriteN }
  cTC_SWrite_FC2  = 49+cTC_SizeRead; { byte }
     { offset FC2 vysilane zpravy WriteN }
  cTC_SWrite_Dummy= 50+cTC_SizeRead; { word }
     { offset vynechaneho mista pro zarovnani na adresu /4 }
  cTC_SWrite_Typ  = 52+cTC_SizeRead; { byte }
     { offset typu zapisovanych registru }
  cTC_SWrite_RegL = 53+cTC_SizeRead; { byte }
     { offset adresy prvniho zapisovaneho registru - (nizsi byte) }
  cTC_SWrite_RegH = 54+cTC_SizeRead; { byte }
     { offset adresy prvniho zapisovaneho registru - (vyssi byte) }
  cTC_SWrite_Len  = 55+cTC_SizeRead; { byte }
     { offset poctu zapisovanych registru }
  cTC_Write_Data  = 56+cTC_SizeRead; { cTC_SizeWrite bytu }
     { offset pole pro nacteni zapisovanych hodnot }
  cTC_SWrite_Frst = 56+cTC_SizeRead+cTC_SizeWrite; { word }
     { offset adresy prvniho zapisovaneho registru }
  cTC_RWrite      = 58+cTC_SizeRead+cTC_SizeWrite; { byte }
     { offset zacatku a zaroven delky odpovedi na zpravu WriteN }
  cTC_RWrite_MsTp = 59+cTC_SizeRead+cTC_SizeWrite; { byte }
     { offset MessType odpovedi na zpravu WriteN }
 { nasledujici konstanta urcuje velikost zaznamu jednoho Tecomatu
   1. musi byt /4 }
  cTC_SizeTCRec   = 60+cTC_SizeRead+cTC_SizeWrite;

symbol
{ zaznam promennych Tecomatu }
 {=== Tecomat1 ===}
  TC1_Addr      = longint : cTC_SizeTCRec;
    { vyhrazeni prostoru pro zaznam 1.Tecomatu
      a zaroven definovani ukazatele na zaznam 1.Tecomatu }

 {=== Tecomat2 ===}
  {TC2_Addr      = longint : cTC_SizeTCRec;}
    { vyhrazeni prostoru pro zaznam 2.Tecomatu
      a zaroven definovani ukazatele na zaznam 2.Tecomatu }
 {!Pro vice Tecomatu! - stejnym zpusobem se definuji zaznamy (pole longintu)
                        pro obsluhu dalsich PLC Tecomatu }

deklar
{ symbolicke nazvy jednotlivych polozek zaznamu Tecomatu }
 { obecne polozky }
  TC_DNode       = byte    (TC1_Addr) [cTC_DNode      ];
                    { adresa stanice PLC v siti }
  TC_FlConnect   = byte    (TC1_Addr) [cTC_Flconnect  ];
                    { priznak pripojeni PLC Tecomatu }
  TC_SWritePerm  = byte    (TC1_Addr) [cTC_SWritePerm ];
                    { priznak permanentniho vysilani zpravy WriteN }
                    { 0 - vysilat zpravu WriteN pouze pri nastavenem TC_FlSWrite;
                      1 - vysilat zpravu WriteN neustale }
  TC_FlSWrite    = byte    (TC1_Addr) [cTC_FlSWrite   ];
                    { pri TC_SWritePerm=1 bit TC_FlSWrite nema vyznam
                      0 - nevysilat zpravu WriteN
                      1 - vysilat zpravu WriteN a po jejim vyslani snulovat TC_FlSWrite }
  TC_SReadCt     = longint (TC1_Addr) [cTC_SReadCt    ];
                    { citac vyslanych zprav ReadN }
  TC_RReadCt     = longint (TC1_Addr) [cTC_RReadCt    ];
                    { citac prijmutych odpovedi na zpravu ReadN }
  TC_SWriteCt    = longint (TC1_Addr) [cTC_SWriteCt   ];
                    { citac vyslanych zprav WriteN }
  TC_RWriteCt    = longint (TC1_Addr) [cTC_RWriteCt   ];
                    { citac prijmutych odpovedi na zpravu WriteN }
 { polozky vysilaciho bufferu pro test Connect }
  TC_SConn       = byte    (TC1_Addr) [cTC_SConn      ];
                    { zacatek a zaroven delka vysilane zpravy Connect }
  TC_SConn_FC    = byte    (TC1_Addr) [cTC_SConn_FC   ];
                    { FC pro vysilanou zpravu Connect }
 { polozky prijimaciho buffer pro test Connect }
  TC_RConn       = byte    (TC1_Addr) [cTC_RConn      ];
                    { zacatek a zaroven delka odpovedi na zpravu Connect }
  TC_RConn_MsTp  = byte    (TC1_Addr) [ctC_RConn_MsTp ];
                    { MessType pro prijatou odpoved na zpravu Connect }
  TC_RConn_FC    = byte    (TC1_Addr) [ctC_RConn_FC   ];
                    { FC pro prijatou odpoved na zpravu Connect }
 { polozky vysilaciho bufferu pro cteni registru }
  TC_SRead       = byte    (TC1_Addr) [cTC_SRead      ];
                    { zacatek a zaroven delka vysilane zpravy ReadN }
  TC_SRead_FC    = byte    (TC1_Addr) [cTC_SRead_FC   ];
                    { FC pro vysilanou zpravu ReadN }
  TC_SRead_FC2   = byte    (TC1_Addr) [cTC_SRead_FC2  ];
                    { FC2 pro vysilanou zpravu ReadN }
  TC_SRead_Typ   = byte    (TC1_Addr) [cTC_SRead_Typ  ];
                    { typ ctenych registru pro vysilanou zpravu ReadN }
  TC_SRead_RegL  = byte    (TC1_Addr) [cTC_SRead_RegL ];
                    { adresa prvniho cteneho registru - (nizsi byte) pro vysilanou zpravu ReadN }
  TC_SRead_RegH  = byte    (TC1_Addr) [cTC_SRead_RegH ];
                    { adresa prvniho cteneho registru - (vyssi byte) pro vysilanou zpravu ReadN }
  TC_SRead_Len   = byte    (TC1_Addr) [cTC_SRead_Len  ];
                    { pocet ctenych registru pro vysilanou zpravu ReadN }
  TC_SRead_Frst  = word    (TC1_Addr) [cTC_SRead_Frst ];
                    { adresa prvniho cteneho registru }
 { polozky prijimaciho bufferu pro cteni registru }
  TC_RRead       = byte    (TC1_Addr) [cTC_RRead      ];
                    { zacatek a zaroven delka odpovedi na zpravu ReadN }
  TC_RRead_MsTp  = byte    (TC1_Addr) [cTC_RRead_MsTp ];
                    { MessType pro prijatou odpoved (data) na zpravu ReadN }
  TC_RRead_FC    = byte    (TC1_Addr) [cTC_RRead_FC   ];
                    { FC pro prijatou odpoved na zpravu ReadN }
  TC_RRead_Data  = byte    (TC1_Addr) [cTC_Read_Data  ];
                    { pole pro ulozeni prectenych hodnot }
 { polozky vysilaciho bufferu pro zapis registru }
  TC_SWrite      = byte    (TC1_Addr) [cTC_SWrite     ];
                    { zacatek a zaroven delka vysilane zpravy WriteN }
  TC_SWrite_FC   = byte    (TC1_Addr) [cTC_SWrite_FC  ];
                    { FC pro vysilanou zpravu WriteN }
  TC_SWrite_FC2  = byte    (TC1_Addr) [cTC_SWrite_FC2 ];
                    { FC2 pro vysilanou zpravu WriteN }
  TC_SWrite_Typ  = byte    (TC1_Addr) [cTC_SWrite_Typ ];
                    { typ zapisovanych registru }
  TC_SWrite_RegL = byte    (TC1_Addr) [cTC_SWrite_RegL];
                    { adresa prvniho zapisovaneho registru - (nizsi byte) }
  TC_SWrite_RegH = byte    (TC1_Addr) [cTC_SWrite_RegH];
                    { adresa prvniho zapisovaneho registru - (vyssi byte) }
  TC_SWrite_Len  = byte    (TC1_Addr) [cTC_SWrite_Len ];
                    { pocet zapisovanych registru }
  TC_SWrite_Data = byte    (TC1_Addr) [cTC_Write_Data ];
                    { pole pro nacteni zapisovanych hodnot }
  TC_SWrite_Frst = word    (TC1_Addr) [cTC_SWrite_Frst];
                    { adresa prvniho zapisovaneho registru }
 { polozky prijimaciho bufferu pro zapis registru }
  TC_RWrite      = byte    (TC1_Addr) [cTC_RWrite     ];
                    { zacatek a zaroven delka odpovedi na zpravu WriteN }
  TC_RWrite_MsTp = byte    (TC1_Addr) [cTC_RWrite_MsTp];
                    { MessType pro prijatou odpoved na zpravu WriteN }

 { na jednotlive polozky se odkazuje napr: TC_SWrite_Typ[TC_ViewAdr]:=...,
   kde TC_ViewAdr je aktualni adresa zaznamu daneho Tecomatu,
   jehoz hodnoty jsou prave zobrazovany }

deklar
  TC_Base        = byte (TC1_Addr);
    { baze ukazatele na pocatek zaznamu vsech Tecomatu
      (je shodna s ukazatelem na zaznam 1.Tecomatu) }

symbol
 { offsety pro odkazovani na polozky jednotlivych Tecomatu
   s jejich pomoci lze pristupovat primo k polozkam daneho Tecomatu napr:
   TC_SWrite_Typ[TC1_Offs]:=... }
  TC1_Offs       = word; { offset 1.Tecomatu }
  {TC2_Offs       = word; { offset 2.Tecomatu }
 {!Pro vice Tecomatu! - stejnym zpusobem se definuji offsety
                        pro obsluhu dalsich PLC Tecomatu }

{----------------------------------------------------------}
{ konfigurace serioveho kanalu }
configuration
  HwObj  = COM,          { nazev HW objektu }
    Name = ComTECO,      { uzivatelsky nazev pouzivany dale v programu }
    Var  = Byte,
    Par  = cTC_ParamStr; { retezec s parametry komunikace }

{----------------------------------------------------------}
procedure TC_SetComTecoAdr;
  { privatni procedura - nevolat v aplikaci }
  { do promenne TC_ComAdr vlozi adresu pocatku zaznamu aktualniho Tecomatu,
    se kterym se prave komunikuje a nastavi DNODE na danou stanici }
begin
  case TC_ComTeco of
    1 : TC_ComAdr   := TC1_Offs;
    {2 : TC_ComAdr   := TC2_Offs;}
    {!Pro vice Tecomatu! - stejnym zpusobem se definuje adresa pro komunikaci
                           pro obsluhu dalsich PLC Tecomatu }
  end;
  if ComTECO_ON then ComTECO_DNODE:=TC_DNode[TC_ComAdr];
end;

{---------------------}
procedure TC_SetViewTecoAdr;
  { verejna procedura - mozno volat v aplikaci }
  { do promenne TC_ViewAdr vlozi adresu pocatku zaznamu aktualniho Tecomatu,
    jehoz hodnoty jsou zobrazovany }
begin
  case TC_ViewTeco of
    1 : TC_ViewAdr   := TC1_Offs;
    {2 : TC_ViewAdr   := TC2_Offs;}
    {!Pro vice Tecomatu! - stejnym zpusobem se definuje adresa pro zobrazovani
                           pro obsluhu dalsich PLC Tecomatu }
  end;
end;

{---------------------}
procedure TC_SetPomTecoAdr;
  { verejna procedura - mozno volat v aplikaci }
  { do promenne TC_PomAdr vlozi adresu pocatku zaznamu Tecomatu s cislem v TC_PomTeco }
begin
  case TC_PomTeco of
    1 : TC_PomAdr   := TC1_Offs;
    {2 : TC_PomAdr   := TC2_Offs;}
    {!Pro vice Tecomatu! - stejnym zpusobem se definuje adresa pro zobrazovani
                           pro obsluhu dalsich PLC Tecomatu }
  end;
end;

{---------------------}
procedure TecoReInit;
  { verejna procedura - mozno volat v aplikaci v procedure INIT po TecoInit
                        nebo po zmene nekterych polozek zaznamu }
  { reinicializace nekterych polozek vsech zaznamu Tecomatu }
begin
  for TC_I:=1 to cTC_MaxPLC do
  begin
    TC_PomTeco:=TC_I;
    TC_SetPomTecoAdr;
    TC_SWrite     [TC_PomAdr] := 8+TC_SWrite_Len [TC_PomAdr];
    TC_SWrite_RegL[TC_PomAdr] :=   TC_SWrite_Frst[TC_PomAdr] and $00FF;
    TC_SWrite_RegH[TC_PomAdr] :=  (TC_SWrite_Frst[TC_PomAdr] and $FF00) shr 8;
    TC_SRead_RegL [TC_PomAdr] :=   TC_SRead_Frst [TC_PomAdr] and $00FF;
    TC_SRead_RegH [TC_PomAdr] :=  (TC_SRead_Frst [TC_PomAdr] and $FF00) shr 8;
  end;
end;

{---------------------}
procedure TecoInit;
  { verejna procedura - mozno volat v aplikaci v procedure INIT }
  { inicializace promennych pro automat TECO }
begin
 { inicializace komunikace }
  ComOn(ComTECO);

 { spusteni uzivatelskych casovacu }
  TimerOn(TC_TOutCt,Per10ms); { casovac pro TimeOuty vysilani a prijmu }
  TimerOn(TC_ConnCt,Per1s);   { casovac pro test pripojenych PLC }

 { vunulovani priznaku chyby a nastaveni stavu automatu }
  TC_Result := cTC_Res_Ok;
  TC_RWA    := cTC_RW_None;
  TC_A      := cTC_A_BegConn;
  { nastaveni cekani na odpoved na danou zpravu }
  TC_WaitFor:= TC_RWA;

 { nastaveni offsetu Tecomatu }
  TC1_Offs  := Addr(TC1_Addr)-Addr(TC_Base);
  {TC2_Offs  := Addr(TC2_Addr)-Addr(TC_Base);}
 {!Pro vice Tecomatu! - stejnym zpusobem se nastavuji offsety
                        pro obsluhu dalsich PLC Tecomatu }

 { implicitni nastaveni zaznamu vsech Tecomatu }
  for TC_I:=1 to cTC_MaxPLC do
  begin
    TC_PomTeco:=TC_I;
    TC_SetPomTecoAdr;
    (*
     {X} = nesmi se (nemelo by se) menit
     { } = uzavatel smi menit podle potreby v aplikaci v procedure INIT
           po zavolani teto procedury TecoInit }
    *)
    { } TC_DNode       [TC_PomAdr]   := 0;
    {X} TC_FlConnect   [TC_PomAdr]   := 0;
    { } TC_SWritePerm  [TC_PomAdr]   := 1;
    { } TC_FlSWrite    [TC_PomAdr]   := 0;
    {X} TC_SReadCt     [TC_PomAdr]   := 0;
    {X} TC_RReadCt     [TC_PomAdr]   := 0;
    {X} TC_SWriteCt    [TC_PomAdr]   := 0;
    {X} TC_RWriteCt    [TC_PomAdr]   := 0;
    {X} TC_SConn       [TC_PomAdr]   := 2;
    {X} TC_SConn_FC    [TC_PomAdr]   := cTC_FCM_Connect;
    {X} TC_RConn       [TC_PomAdr]   := 0;
    {X} TC_RConn_MsTp  [TC_PomAdr]   := cTC_tpShortM;
    {X} TC_RConn_FC    [TC_PomAdr]   := cTC_FCS_ConnectRep;
    {X} TC_SRead       [TC_PomAdr]   := 8;
    {X} TC_SRead_FC    [TC_PomAdr]   := cTC_FCM_Read;
    {X} TC_SRead_FC2   [TC_PomAdr]   := cTC_FC2_ReadN;
    { } TC_SRead_Typ   [TC_PomAdr]   := cTC_RegR;
    { } TC_SRead_RegL  [TC_PomAdr]   := 0;
    { } TC_SRead_RegH  [TC_PomAdr]   := 0;
    { } TC_SRead_Len   [TC_PomAdr]   := 0;
    {X} TC_RRead       [TC_PomAdr]   := 0;
    {X} TC_RRead_MsTp  [TC_PomAdr]   := cTC_tpLongM;
    {X} TC_RRead_FC    [TC_PomAdr]   := cTC_FCS_Reply;
    {X} for TC_J:=0 to cTC_SizeRead-1 do
         TC_RRead_Data [TC_PomAdr+TC_J] := $00;
    {X} TC_SWrite_FC   [TC_PomAdr]   := cTC_FCM_Write;
    {X} TC_SWrite_FC2  [TC_PomAdr]   := cTC_FC2_WriteN;
    { } TC_SWrite_Typ  [TC_PomAdr]   := cTC_RegR;
    { } TC_SWrite_RegL [TC_PomAdr]   := 0;
    { } TC_SWrite_RegH [TC_PomAdr]   := 0;
    { } TC_SWrite_Len  [TC_PomAdr]   := 0;
    {X} TC_SWrite      [TC_PomAdr]   := 8+TC_SWrite_Len[TC_PomAdr];
    {X} TC_RWrite      [TC_PomAdr]   := 0;
    {X} TC_RWrite_MsTp [TC_PomAdr]   := cTC_tpSACK;
  end;
 { uprava nekterych polozek zaznamu Tecomatu podle implicitniho nastaveni }
  TecoReInit;

 { nastaveni ukazovatek a adres na 1.Tecomat }
  TC_ComTeco :=1;
  TC_ViewTeco:=1;
  TC_SetComTecoAdr;
  TC_SetViewTecoAdr;
end;

{---------------------}
procedure TC_RecConnBuffFlush;
  { privatni procedura - nevolat v aplikaci }
  { vycisti prijimaci buffer pro odpoved na zpravu Connect }
begin
  TC_RConn[TC_ComAdr]:=0;
end;

{---------------------}
procedure TC_RecWriteBuffFlush;
  { privatni procedura - nevolat v aplikaci }
  { vycisti prijimaci buffer pro odpoved na zpravu WriteN }
begin
  TC_RWrite[TC_ComAdr]:=0;
end;

{---------------------}
procedure TC_RecReadBuffFlush;
  { privatni procedura - nevolat v aplikaci }
  { vycisti prijimaci buffer pro odpoved na zpravu ReadN }
begin
  TC_RRead[TC_ComAdr]:=0;
end;

{---------------------}
procedure TC_RWAutomat;
  { privatni procedura - nevolat v aplikaci }
  { automat pro odesilani a prijimani zprav do/z daneho PLC }
  { podle registru Tecom protokolu sestavi zpravu, odesle ji a pocka
    na prijem odpovedi, podle vysledku a odpovedi nastavuje TecomResult }
begin
 { test na pripravenost serioveho kanalu COMu }
  if (not ComTECO_ON)or(ComTECO_Err) then
    begin
      TC_RWA:=cTC_RW_None;
    end;

 { vlastni automat }
  case TC_RWA of
    cTC_RW_None: { nic se nedeje }
     L_TC_None:
      begin
        TC_WaitFor:=TC_RWA;
      end;

    cTC_RW_Rec: { prijem }
      begin
        if (ComTECO_Rec)and(not ComTECO_RecErr) then { prisla-li bezchybna odpoved }
          begin
            case TC_WaitFor of { na kterou zpravu se ceka odpoved }
              cTC_RW_SndConnect: { ocekava se odpoved na zpravu Connect }
                begin
                  ComReceive(ComTECO,TC_RConn[TC_ComAdr],2); { vlastni prijem }
                  if (TC_RConn     [TC_ComAdr] = 2)                  and
                     (TC_RConn_MsTp[TC_ComAdr] = cTC_tpShortM)       and
                     (TC_RConn_FC  [TC_ComAdr] = cTC_FCS_ConnectRep) then
                    begin { je-li to opravdu odpoved na zpravu Connect }
                      TC_FlConnect[TC_ComAdr]:=1;
                      TC_Result:=cTC_Res_Ok;
                    end
                  else
                    begin { prisla-li jina odpoved }
                      TC_FlConnect[TC_ComAdr]:=0;
                      TC_Result:=cTC_Res_BadAnsw;
                    end;
                end;
              cTC_RW_SndReadN: { ocekava se odpoved na zpravu ReadN }
                begin
                  ComReceive(ComTECO,TC_RRead[TC_ComAdr],cTC_SizeRead+4);
                  if (TC_RRead     [TC_ComAdr] = 4+(TC_SRead_Len[TC_ComAdr]))and
                     (TC_RRead_MsTp[TC_ComAdr] = cTC_tpLongM)   and
                     (TC_RRead_FC  [TC_ComAdr] = cTC_FCS_Reply) then
                    begin
                      if TC_RReadCt[TC_ComAdr]<$7FFFFFFF then { zvetseni pocitadla }
                           TC_RReadCt[TC_ComAdr]:=TC_RReadCt[TC_ComAdr]+1
                      else TC_RReadCt[TC_ComAdr]:=0;
                      TC_Result:=cTC_Res_Ok;
                    end
                  else
                    begin
                      TC_Result:=cTC_Res_BadAnsw;
                    end;
                end;
              ctC_RW_SndWriteN: { ocekava se odpoved na zpravu WriteN }
                begin
                  ComReceive(ComTECO,TC_RWrite[TC_ComAdr],1);
                  if (TC_RWrite     [TC_ComAdr] = 1)          and
                     (TC_RWrite_MsTp[TC_ComAdr] = cTC_tpSACK) then
                    begin
                      if TC_RWriteCt[TC_ComAdr]<$7FFFFFFF then { zvetseni pocitadla }
                           TC_RWriteCt[TC_ComAdr]:=TC_RWriteCt[TC_ComAdr]+1
                      else TC_RWriteCt[TC_ComAdr]:=0;
                      TC_FlSWrite[TC_ComAdr]:=0;
                      TC_Result:=cTC_Res_Ok;
                    end
                  else
                    begin
                      TC_Result:=cTC_Res_BadAnsw;
                    end;
                end;
            end;
            TC_TOutCt:=0; { snulovani citace TimeOutu }
            TC_RWA:=cTC_RW_None;
            goto L_TC_None;
          end;
        if (ComTECO_RecErr)or               { nastala-li pri prijmu chyba nebo }
           (TC_TOutCt>=cTC_RecMaxTOut) then { vyprsel-li TimeOut }
          begin
            if ComTECO_RecErr then
                 TC_Result:=cTC_Res_RecErr
            else TC_Result:=cTC_Res_RecTOut;
            ComTECO_RecErr:=0;
            ComTECO_Rec   :=0;
            TC_TOutCt  :=0;
            TC_FlConnect[TC_ComAdr]:=0; { nastavi se FlConnect na False }
            if TC_WaitFor<>cTC_RW_SndConnect then { pokud se necekalo na odpoved na zpravu Connect }
              TC_ConnCt:=cTC_TryConnect;          { ma se provest test zpravou Connect co nejdrive }
            TC_RWA:=cTC_RW_None;
            goto L_TC_None;
          end;
      end;

    cTC_RW_WaitSend: { vysilani }
      if (not ComTECO_Send)or(ComTECO_SendErr)or(TC_TOutCt>=cTC_SndMaxTOut) then
      begin
        if ComTECO_SendErr then
          TC_Result:=cTC_Res_SndErr
        else
          if not ComTECO_Send then
            TC_Result:=cTC_Res_Ok
          else
            TC_Result:=cTC_Res_SndTOut;
        if not ComTECO_Send then
          TC_RWA:=cTC_RW_Rec
        else
          begin
            TC_RWA:=cTC_RW_None;
            TC_FlSWrite[TC_ComAdr]:=0;
          end;
        if TC_Result<>cTC_Res_Ok then ComSendFlush(ComTECO);
      end;

    cTC_RW_SndConnect: { pocatek vyslani zpravy Connect }
      if not ComTECO_Send then
      begin
        TC_WaitFor:=TC_RWA;
       { vynulovani prijimace a chyb }
        ComRecFlush(ComTECO);
        TC_RecConnBuffFlush;
        TC_TOutCt:=0;
       { spusteni vysilace }
        ComSend(ComTECO,TC_SConn[TC_ComAdr]);
       { prechod do dalsiho stavu }
        TC_RWA:=cTC_RW_WaitSend;
      end;

    cTC_RW_SndReadN: { pocatek vyslani zpravy ReadN }
      if not ComTECO_Send then
      begin
        if TC_SRead_Len[TC_ComAdr]=0 then
          begin
            TC_RWA:=cTC_RW_None;
            goto L_TC_None;
          end;
        TC_WaitFor:=TC_RWA;
        if TC_SReadCt[TC_ComAdr]<$7FFFFFFF then
             TC_SReadCt[TC_ComAdr]:=TC_SReadCt[TC_ComAdr]+1
        else TC_SReadCt[TC_ComAdr]:=0;
       { vynulovani prijimace a chyb }
        ComRecFlush(ComTECO);
        TC_RecReadBuffFlush;
        TC_TOutCt   :=0;
       { spusteni vysilace }
        ComSend(ComTECO,TC_SRead[TC_ComAdr]);
       { prechod do dalsiho stavu }
        TC_RWA:=cTC_RW_WaitSend;
      end;

    cTC_RW_SndWriteN: { pocatek vyslani zpravy WriteN }
      if not ComTECO_Send then
      begin
        if TC_SWrite_Len[TC_ComAdr]=0 then
          begin
            TC_RWA:=cTC_RW_None;
            goto L_TC_None;
          end;
        TC_WaitFor :=TC_RWA;
        if TC_SWriteCt[TC_ComAdr]<$7FFFFFFF then
             TC_SWriteCt[TC_ComAdr]:=TC_SWriteCt[TC_ComAdr]+1
        else TC_SWriteCt[TC_ComAdr]:=0;
       { vynulovani prijimace a chyb }
        ComRecFlush(ComTECO);
        TC_RecWriteBuffFlush;
        TC_TOutCt   :=0;
       { spusteni vysilace }
        ComSend(ComTECO,TC_SWrite[TC_ComAdr]);
       { prechod do dalsiho stavu }
        TC_RWA:=cTC_RW_WaitSend;
      end;
  end;
end;

{---------------------}
procedure TecoAutomat;
  { verejna procedura - mozno volat v aplikaci v procedure MAIN }
  { automat pro spravovani vsech pripojenych PLC stanic }
begin
  TC_RWAutomat;

  if (TC_RWA=cTC_RW_None)and(ComTECO_ON) then { ceka se do dokonceni RW automatu }
  begin
    if (TC_ConnCt>=cTC_TryConnect)and { je cas na zacatek testovani? }
       (TC_ComTeco=1)and              { tak, aby se zacalo s testem 1.Tecomatu }
       (TC_A<>cTC_A_ContConn)and
       (TC_A<>cTC_A_BegConn) then     { a dosud se netestuje }
      TC_A:=cTC_A_BegConn;

    case TC_A of
      cTC_A_None    :
       L_TC_ANone:
        begin
          if TC_FlConnect[TC_ComAdr]=0 then { neni connect }
            begin
              TC_A:=cTC_A_WasRW;   { prechod na dalsi Tecomat }
              goto L_TC_WasRW;
            end
          else                           { je connect }
            begin
              TC_A:=cTC_A_ReadBeg; { zacina se obsluhovat tento Tecomat }
              goto L_TC_ReadBeg;
            end;
        end;
      cTC_A_ReadBeg:
       L_TC_ReadBeg:
        begin
          if TC_SRead_Len[TC_ComAdr]<>0 then { je-li neco k precteni }
            begin
              TC_RWA:=cTC_RW_SndReadN; { podnet k vyslani zpravy ReadN }
              TC_A:=cTC_A_Read;
            end
          else                            { neni-li nic k precteni }
            begin
              TC_A:=cTC_A_WriteBeg;    { jde se na zapis }
              goto L_TC_WriteBeg;
            end;
        end;
      cTC_A_Read : { vysila se zprava ReadN }
       L_TC_Read:
        begin
          TC_A:=cTC_A_WriteBeg; { jde se na zapis }
          goto L_TC_WriteBeg;
        end;
      cTC_A_WriteBeg:
       L_TC_WriteBeg:
        begin
          if (TC_SWrite_Len [TC_ComAdr]<>0)and { je-li neco k zapsani }
             ((TC_SWritePerm[TC_ComAdr]=1) or
              (TC_SWritePerm[TC_ComAdr]=0) and
              (TC_FlSWrite  [TC_ComAdr]=1)) then
            begin
              TC_RWA:=cTC_RW_SndWriteN; { podnet k vyslani zpravy WriteN }
              TC_A:=cTC_A_Write;
            end
          else                              { neni-li nic k zapsani }
            begin
              TC_A:=cTC_A_WasRW; { prechod na dalsi Tecomat }
              goto L_TC_WasRW;
            end;
        end;
      cTC_A_Write   : { vysila se zprava WriteN }
        begin
          TC_A:=cTC_A_WasRW; { prechod na dalsi Tecomat }
          goto L_TC_WasRW;
        end;
      cTC_A_WasRW   : { prechod na dalsi PLC Tecomat }
       L_TC_WasRW:
        begin
          if cTC_MaxPLC=1 then { je-li jen jeden Tecomat }
            begin
              TC_A:=cTC_A_None;
            end
          else                 { je-li vice Tecomatu }
            begin
             { inkrementace na dalsi PLC }
              TC_ComTeco:=TC_ComTeco+1;
              if TC_ComTeco>cTC_MaxPLC then TC_ComTeco:=1;
              TC_SetComTecoAdr;
             { zpet na zacatek }
              TC_A:=cTC_A_None;
              if TC_ComTeco<>1 then goto L_TC_ANone;
                { - toto ma za nasledek ze behem jednoho kolecka automatu
                  se v nejlepsim pripade obslouzi vsechny Tecomaty;
                  - pokud by tento radek nebyl vybec naprogramovan, obslouzil
                  by se v jednom kole automatu v nejlepsim pripade pouze
                  jeden Tecomat;
                  - podminka je nutna pro opusteni automatu a umozneni tak
                  ostatnich akci v procedure MAIN v hlavnim programu }
            end;
        end;

      cTC_A_BegConn : { pocatek testovani pripojenych PLC (nutno zajistit, aby TC_ComTeco=1) }
        begin
          ComTECO_DNode:=TC_DNode[TC_ComAdr];
          TC_ConnCt:=0;
          TC_RWA:=cTC_RW_SndConnect; { podnet k vyslani zpravy Connect }
          TC_A:=cTC_A_ContConn;
        end;
      cTC_A_ContConn: { prechod na testovani dalsiho PLC }
        begin
          TC_ComTeco:=TC_ComTeco+1; { inkrementace na dalsi PLC }
          if TC_ComTeco>cTC_MaxPLC then { otestovali jsme vsechny PLC? }
            begin { ano - zacne cteni registru z 1.Tecomatu }
              TC_ComTeco:=1;
              TC_SetComTecoAdr;
              TC_A:=cTC_A_None;
            end
          else
            begin { ne - pokracuje se v testovani }
              TC_SetComTecoAdr;
              TC_RWA:=cTC_RW_SndConnect; { podnet k vyslani zpravy Connect }
            end;
        end;
    end;
  end;
end;
