{ --------------------------------------------- }
{  KIT-Builder Program                          }
{                                               }
{  (c) SofCon 1998                              }
{---------------------------------------------- }
{
  program demonstruje obsluhu V/V portu na desce
  terminalu TERM10, demonstrace se provadi za pomoci desky
  PIND01 obsahujici 8 tlacitek a 8 LED diod.
}

#define pos position           {pomoci define muzeme misto "position" pouzivat jen "pos"}

configuration
  hwobj=TERM10, name=TERM, adr=$2300, var=Byte;
          { Pro zobrazovani dat a komunikaci s uzivatelem budeme
            pouzivat terminal TERM10 - definujeme tedy jeho parametry}

  hwobj=IOTERM10, name=IO, adr=$2300, var=Byte, main=[IN,OUT];
          { vlastni definice ovladace HW portu typu DIOTERM10}

symbol
  Tlacitka = IO_IN;   { prejmenovani standardnich nazvu na jina jmena}
  Led      = IO_OUT;

{ Nasledujici procedura se provadi cyklicky po celou dobu behu automatu }
procedure MAIN;
begin
  TERM_LED:=Tlacitka xor Led;  {Na LED diody na terminalu zobraz
                                xor promennych Tlacitka a LED}
end;

{ ------------------------------------ }
{ Popis obrazovky c.0 terminalu TERM10 }
terminal TERM:0;
begin
  font 1;                                {Nastavime font 0}
  pos 20, 15; print "Ukazka pouziti objektu DIOTERM10"; {Na pozici position ...}
  pos 20, 40; print "IN  ",bin Tlacitka; {vytiskneme text}
  pos 20, 50; print "OUT ",bin Led;      {a promenne ve formatu bin}
  pos 20, 70; print "Na LED terminlu je IN XOR OUT";
  pos 20,110; print "Npovda - klvesa F1";
  OnKey                                  {definujeme reakci na klavesy}
    'N':TERM_ScrNo:=1;                   {'N' - prejdeme na obrazovku 1}
  end;
help                                     {definice obrazovky HELP - aktivni}
  font 1;                                {pri stisku F1, nastaveni fontu}
  pos 20, 15; print "Npovda:";         {Na pozici ... umisti text ...}
  pos 20, 30; print "Nastaven vstupu - klvesa N";
  pos 20, 40; print "Na port IN pipojte tlatka,";
  pos 20, 50; print "Na port OUT pipojte LED diody.";
  pos 20,110; print "Zpt klvesou ESC.";
end;

{ Popis obrazovky c.1 terminalu TERM10 }
terminal TERM:1;
begin
  font 1;                                {Nastavime font 1}
  pos 20, 30; print "Nastaven vstupu"; {Na pozici position ...}
  pos 20, 50; print "Out=";font 0;pos 44,50;edit bin Led:9,0,$FF; {Vytiskneme text
                                          a vyhradime misto pro editaci
                                          promenne LED v binarnim tvaru}
  font 1;                                {Protoze editaci provdime jinym
                                          fontem, nastavime opet font 1}
  pos 20,110; print "Npovda - klvesa F1";
help                                     {definice obrazovky HELP - aktivni}
  font 1;                                {pri stisku F1, nastaveni fontu}
  pos 20, 15; print "Npovda:";         {Na pozici ... umisti text ...}
  pos 20, 30; print "Nastaven vstupu.";
  pos 20, 40; print "Potvrzen nastaven hodnoty";
  pos 20, 50; print "klvesou ENTER,";
  pos 20, 60; print "Zpt bez nastaven klvesou ESC.";
end;
