{ --------------------------------------------- }
{  KIT-Builder Program                          }
{  (c) SofCon 1998                              }
{---------------------------------------------- }
{
  Tento program slouzi k demonstraci prikazu GRAPHXY,
  vedle toho se zde pracuje s fcemi SIN, COS, ...
  V programu jsou za pomoci funkce sin a cos vygenerovany souradnice
  spiraly, ktera je nasledne vykreslena prikazem GRAPHXY.
  Potrebny HW: TERM10 resp. jeho DOS-simulator
}
options gonio=dec;        {argument fce sin a cos je ve stupnich}

#define pos position         {pomoci define muzeme misto "position" pouzivat jen "pos"}

CONSTANT
  PocetBodu=50;             {pocet bodu grafu spiraly}

SYMBOL
  PoleX:Integer:PocetBodu*2; { pole x-souradnic bodu v grafu }
                             { delku pole integer musime uvadet v poctu bytu! }
  PoleY:Integer:PocetBodu*2; { pole y-souradnic bodu v grafu }

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
CONFIGURATION
  HWOBJ=TERM10, LED=$AA, NAME=TERM, ADR=$2300, VAR=Byte; {deklarace terminalu}

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}

SYMBOL
  i:Byte;          {pomocna prommenna pro cykly}
  u:LongInt;       {pomocna promenna pro generovani souradnic spiraly}
  r:Real;          {pomocna promenna pro generovani  souradnic spiraly}
  TypGr:Byte;      {pomocna promenna urcuje typ zobrazeni grafu}
{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
procedure INIT;    {procedura se spousti pouze po resetu sytemu a provede
                    vlastni generovani souradnic bodu spiraly}
begin
  for i:=0 to PocetBodu-1 do
  begin                  {Pro vsechny body postupne spocti souradnice}
    r:=i;
    r:=1-r/PocetBodu;    {urceni polomeru, dana konstrukce je nutna z duvodu
                          preteceni promennych}
    u:=1*360;
    u:=u*i/PocetBodu;    {urceni uhlu, dana konstrukce je nutna z duvodu
                          preteceni promennych}

    PoleY[i*2]:=r*sin(u);{vyplni se y-souradnice bodu v grafu }
                         {index v KIT-Basicu = offset v poctu bytu od
                          zacatku pole}
    PoleX[i*2]:=r*cos(u);{vyplni se x-souradnice bodu v grafu }
  end;
end;

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
procedure MAIN;  { povinna hlavni procedura, zde nic nedela }
begin
end;

{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
terminal TERM:0;  { definice zakladni obrazovky c.0 }
begin
  font 1;                                                  {Nastavime font 1}
  pos  20, 15; print "Ukzka pouit prikazu GRAPHXY";     {Na pozici position ... }
  pos  20, 35; print "Spirla:";                           { Vytiskneme text ...}
  pos  20,110; print "Npovda - klvesa F1";

  case TypGr of
    0:graphxy line,PocetBodu,PoleX,PoleY,-100,100,-100,100, 10, 20,210,120;
             { typ,poc.polozek,data,      rozsahX, rozsahY, x1, y1, x2, y2}
    1:graphxy point,PocetBodu,PoleX,PoleY,-100,100,-100,100, 10, 20,210,120;
    2:graphxy bar,PocetBodu,PoleX,PoleY,-100,100,-100,100, 10, 20,210,120;
  end;
  onkey                         {definujeme reakci na klavesy}
   'C':TypGr:=0;                {'C' - nastavime typ grafu Cara}
   'B':TypGr:=1;                {'B' - nastavime typ grafu Body}
   'S':TypGr:=2;                {'S' - nastavime typ grafu Sloupce}
  end;
help                                          {definice obrazovky HELP - aktivni}
  font 1;                                     {pri stisku F1, nastaveni fontu}
  pos 20, 15; print "Npovda";               {Na pozici ... umisti text ...}
  pos 20, 30; print "Zmnu typu grafu stiskem";
  pos 20, 40; print "velk klavesy v pslunm nzvu:";
  pos 20, 55; print "Bodov graf";
  pos 20, 65; print "Crov graf";
  pos 20, 75; print "Sloupcov graf";

  pos 20,110; print "Zpt klvesou ESC.";

end;
{-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}

