{ ------------------------------------ }
{  KIT-Builder Program                 }
{                                      }
{  (c) SofCon 1998                     }
{------------------------------------- }

{
 Program slouzi k demonstraci obsluhy komunikacniho kanalu
 typu COM - znakovy prenos. Jednoduse si muzeme vyzkouset
 proti terminalu ve WIN. V programu se otevre okno, muzeme napsat
 text, ktery se na stisk klavesy ENTER odesle, znaky prijate po
 komunikaci se objevuji v okne prichozich znaku.
}

constant
  cPrijemSLen = 20;                 {definujeme velikost prijimaciho
                                     a vysilaciho bufferu}

symbol
  PrijemS  =String:cPrijemSLen+1;   {Buffer pro prijata data}

  RecBuff   =String:2;              {Buffer pro prijaty znak}
  RecBuffZn =Byte(RecBuff)+1;       {Vlastni prijaty znak je na 1 miste v bufferu}

  OdesilS=String:21;                {Buffer odesilane zpravy}

configuration
  hwobj=TERM10, name=TERM, adr=$2300, var=Byte;
          { Pro zobrazovani dat a komunikaci s uzivatelem budeme
            pouzivat terminal TERM10 - definujeme tedy jeho parametry}

  hwobj=COM, name=C, var=Byte,
        PAR= "NAM=COM COM=2    IRQ=3 BD=9600 BIT=8 STO=1 PAR=N LRB=10001"   {PC}
            {"NAM=COM ADD=2320 IRQ=3 BD=9600 BIT=8 STO=2 PAR=N LRB=10001"}; {MC}
   {dale definujeme vlastni komunikacni kanal vcetne parametru, PC pro pocitac, MC pro KITa}


{ Nasledujici procedura se vykona vzdy po RESETu }
procedure INIT;
begin
  PrijemS:="                    ";
  TERM_LED:=$aa;   { pocatecni hodnota  LED }
  ComOn(C);
  C_DNode:=0;  {nevisilam s protokolem, neni potreba nastavovat}
end;

{ Nasledujici procedura se provadi cyklicky po celou dobu behu automatu }
procedure MAIN;
begin
  {prijem zpravy}
  if C_ON and C_REC and not C_RECERR then
  begin
    ComReceive(C,RecBuff,1);           {Zavolanim funkce se priznaky schodi}
    move(PrijemS[2],PrijemS[1],cPrijemSLen); {Posun stara data}
    PrijemS[cPrijemSLen]:=RecBuffZn;   {Dopln novy prvek}
    C_RecErr:=0;
    C_Rec:=0;
  end;
end;

{ ------------------------------------ }
{ Popis obrazovky c.0 terminalu TERM10 }
terminal TERM:0;
begin
  font 1;                                                {Nastavime font 1}
  position 10,10; print "Ukazka komunikace - COM";       {Na pozici position ...
                                                          Vytiskneme text ...}
  position 10,60; print "Ridici byte: ",bin C_CTRL;      {Na pozici position ...}
                                                         {Vytiskneme text a obsah
                                                          promennych}
  rect rel,8,77,224,12;                                  {nakreslime ramecek do ktereho}
  position 10,80;print   "Prijimam: ",PrijemS;           {na pozici position ...}
                                                         {vytiskneme text a obsah
                                                          promennych}
  rect rel,8,97,224,12;                                  {nakreslime ramecek do ktereho}
  position 10,100; print "Odesilam: ",OdesilS;           {na pozici position ...}
                                                         {vytiskneme text a obsah
                                                          promennych}

  onkey                                                  {definujeme reakci na klavesy}
    'N':TERM_ScrNo:=1;                                   {'N' - prejdeme na obrazovku 1}
    zCr:begin                                            {ENTER:}
          if C_ON and not C_SEND then
          begin
            ComSend(C,OdesilS);                          {Odesleme zpravu}
          end;
        end;
    'S':PrijemS:="                    ";                 {'S' - vymazeme prijimaci buffer}
  end;

  help                                                   {definice obrazovky HELP - aktivni}
    font 1;                                              {pri stisku F1, nastaveni fontu}
    position 10,10; print "Npovda:";                   {Na pozici ... umisti text ...}
    position 10,35; print "Stisk klavesy:";
    position 10,45; print "S      smazani prijate zpravy";
    position 10,55; print "N      nastaveni vysilane zpravy";
    position 10,65; print "ENTER  vyslani nastavene zpravy";
end;

{ Popis obrazovky c.1 terminalu TERM10 }

terminal TERM:1;
begin
  font 1;                                                {pri stisku F1, nastaveni fontu}
  position 20,30; print "Editace vysilaneho stringu";    {Na pozici ... umisti text ...}
  position 20,50; print "S=";                            {Na pozici ... umisti text ...}
  position 35,50; edit OdesilS:20;                       {Na pozici ... umisti editacni
                                                          okno promenne MasterS}
  rect rel, 17, 47, 139, 12;                              {editacni okno oramuj}
  help                                                   {definice obrazovky HELP - aktivni}
   font 1;                                               {pri stisku F1, nastaveni fontu}
   position 10 ,10; print "Npovda";                    {Na pozici ... umisti text ...}
   position 10 ,30; print "Editace vysilaneho stringu";
end;






