{ --------------------------------------------- }
{  program DTECO1                   10.11.1998  }
{  KIT-Builder                                  }
{                                               }
{  (c) SofCon 1998                              }
{---------------------------------------------- }

{ Program na testovani komunikacniho protokolu TECOM, pro komunikaci
  s PLC TC500. Fyzicky se zpravy prenaseji ze serioveho portu RS485 Term10
  do PLC Tecomat, kde Term10 je Master a PLC Tecomat je Slave.
  Program provadi cyklicke cteni a zapis hodnot do registru Tecomatu
  s naslednym zpracovanim a vizualizaci ctenych hodnot.
  V PLC Tecomat je nahran program TECO_REG.950, ktery simuluje exponencielni
  P regulator. Term10 posle Tecomatu pozadovanou hodnotu, ktery podle ni
  zpracuje podle funkce New = (MulVal * Old + (100 - MulVal) * PozVal) / 100
  aktualni merenou hodnotu, kterou pote i s prislusnou pozadovanou hodnotou
  zapise do pole dat, ktere posle zpet terminalu Term10.
}
{ V komentarich se vyskytuji zkracene symboly,
  napr: "/4" znamena "delitelno ctyrma",
        "[10ms]" znamena, ze udaj je v desitkach milisekund.
}
{ Tendo demostracni program byl napsan pro Kit-Builder V02.C0 23/10/1998
}

options
  ProgVer = 1; { verze programu }

{ konstanty a promenne pro graficke znazorneni }
constant
  GPoints   = 50;  { pocet bodu grafu
                     (musi byt shodna s konstantou cDataLen/2 v TECO_REG.950) }
  GDataSize = 2*GPoints;

{ nasledujici konstanty a definice je potrebne definovat pred prilinkovanim
  include soubor TECOM1.PRI definici "#include TECOM1.PRI" (viz nize) }
#define
  deklar symbol { misto klicoveho slova "symbol" se smi pouzivat tez slovo "deklar" }
    { tato definice je pro rozdeleni deklarace promennych a symbolicke
      pojmenovani jiz deklarovanych promennych : deklar = deklarace,
      symbol = symbolicke nazvy}
constant
 { konstanty nutne pro automat Tecomatu }
  cTC_MaxPLC     = 1;   { pocet obsluhovanych a maximalne pripojenych PLC stanic }
                        { Pozn: musi byt definovan stejny (nebo vetsi) pocet
                          zaznamu pro jednotlive Tecomaty }
  cTC_SndMaxTOut = 50;  { maximalni timeout pri vysilani [10ms] }
  cTC_RecMaxTOut = 100; { maximalni timeout pri prijmu odpovedi [10ms] }
  cTC_TryConnect = 10;  { perioda pro opakovani testu pripojenych PLC [s] zpravou Connect }
  cTC_SizeRead   = 10+2*GDataSize+2; { koncove +2 je pro /4 }
                        { velikost bufferu pro cteni registru z PLC
                          1. musi byt /4
                          2. musi byt v intervalu 0 az 244 }
  cTC_SizeWrite  = 8;   { velikost bufferu pro zapis registru do PLC
                          1. musi byt /4
                          2. musi byt v intervalu 0 az 244 }
 { retezcova konstanta s parametry pro komunikaci }
  { zvoli se jedna z nasledujicich variant podle pouzite cilove platformy }
  {Term10 - realne prostredi pro KitV40 a Term10 }
   cTC_ParamStr   = "NAM=TECOM MAS=MASTER NOD=100 LSB=200 NAM=COM ADD=$2320 IRQ=3 BD=19200 BIT=8 STO=2 PAR=E LRB=1000";
  {PC     - simulace na PC }
{   cTC_ParamStr   = "NAM=TECOM MAS=MASTER NOD=100 LSB=200 NAM=COM COM=3 IRQ=5 BD=9600 BIT=8 STO=2 PAR=E LRB=1000";
   { vyznam jednotlivych parametru - viz komunikacni knihovny }

#include TECOM_1.PRI; { prilinkovani obsluhy PLC Tecomatu }

{ symbolicke nazvy registru PLC Tecomatu }
symbol
 { symbolicke nazvy ctenych registru z Tecomatu }
  TC_AktVal  = word(TC1_Addr)[cTC_Read_Data + 0];
     { aktualni hodnota prectena z Tecomatu }
  TC_PozVal_ = word(TC1_Addr)[cTC_Read_Data + 2];
     { zpetne prectena pozadovana hodnota }
  TC_MulVal_ = word(TC1_Addr)[cTC_Read_Data + 4];
     { zpetne prectena regulacni konstanta }
  TC_PerVz_  = word(TC1_Addr)[cTC_Read_Data + 6];
     { zpetne prectena perioda vzorkovani [10ms] }
  TC_AktData = word(TC1_Addr)[cTC_Read_Data +10];
     { pole merenych hodnot prectenych z Tecomatu }
  TC_PozData = word(TC1_Addr)[cTC_Read_Data +10+GDataSize];
     { pole zpetne ctenych pozadovanych hodnot }
 { symbolicke nazvy zapisovanych registru do Tecomatu }
  TC_PozVal  = word(TC1_Addr)[cTC_Write_Data+ 0];
     { pozadovana hodnota zapisovana do Tecomatu }
  TC_MulVal  = word(TC1_Addr)[cTC_Write_Data+ 2];
     { regulacni konstanta zapisovana do Tecomatu }
  TC_PerVz   = word(TC1_Addr)[cTC_Write_Data+ 4];
     { perioda vzorkovani [10ms] zapisovana do Tecomatu }

{ konstanty pro simulator regulatoru }
constant
  cMaxPozVal = 500; { maximalni pozadovana hodnota }

{ konfigurace terminalu Term10 }
configuration
  HwObj  = TERM10, { nazev HW objektu }
    Name = TERM,   { uzivatelske jmeno pouzivane dale v programu }
    Adr  = $2300,  { adresa terminalu v IO prostoru }
    Var  = Byte;

{ konstanty fontu, bitmap a obrazovek terminalu }
constant
 { konstanty fontu }
  cFnt_8x8c   = 0; { font 8x8_cestina }
  cFnt_6x8c   = 1; { font 6x8_cestina }
  cFnt_16x32c = 2; { font 16x24_cestina }
 { konstanty bitmap }
  cBmp_Logo   = 0; { bitmapa s logem fy.SofCon }
  cBmp_Clear  = 1; { bitmapa prazdne stranky }
 { konstanty obrazovek terminalu }
  cTer_Uvod   = 0; { uvodni obrazovka s logem firmy SofCon }
  cTer_Graph  = 1; { obrazovka s grafickym znazornenim namerenych hodnot z PLC }
  cTer_Ed_Poz = 2; { obrazovka pro editaci pozadovane hodnoty }
  cTer_Ed_ReK = 3; { obrazovka pro editaci regulacni konstanty }
  cTer_Ed_PVz = 4; { obrazovka pro editaci periody vzorkovani }
  cTer_SysCom = 5; { systemova obrazovka s komunikaci }

{ pomocne promenne }
deklar
  Pom_SimPoz = word; { pro simulaci zmeny pozadovane hodnoty }
  Pom_Edit   = word; { pro editaci zadaneho parametru }

{ ------------------------------------ }
{ Nasledujici procedura se vykona vzdy po RESETu }
procedure INIT;
begin
 { inicializace a nastaveni Teco Automatu a jeho promennych
   a implicitni nastaveni zaznamu Tecomatu }
  TecoInit;
 { pocatecni nastaveni pro cteni a zapis registru z/do PLC Tecomat }
  TC_DNode       [TC1_Offs] := 0;        { cislo stanice PLC v siti }
  TC_SWritePerm  [TC1_Offs] := 0;        { nastaveni vysilani zpravy pro zapis registru na priznak }
  TC_FlSWrite    [TC1_Offs] := 1;        { poprve vyslat zpravu pro zapis registru }
  TC_SRead_Typ   [TC1_Offs] := cTC_RegR; { typ ctenych registru }
  TC_SRead_Frst  [TC1_Offs] := 10;       { cislo prvniho cteneho registru }
  TC_SRead_Len   [TC1_Offs] := 10+2*GDataSize;
                                         { pocet ctenych registru (bytu) z PLC
                                           (10 + blok merenych dat + blok pozadovanych dat) }
  TC_SWrite_Typ  [TC1_Offs] := cTC_RegR; { typ zapisovanych registru }
  TC_SWrite_Frst [TC1_Offs] := 12;       { cislo prvniho zapisovaneho registru }
  TC_SWrite_Len  [TC1_Offs] := 6;        { pocet zapisovanych registru (bytu) do PLC
                                           Nesmi byt vetsi nez konstanta cTC_SizeWrite! }
  TC_AktVal                 := 0;        { pocatecni nastaveni aktualni hodnoty }
  TC_PozVal_                := 0;        { pocatecni nastaveni zpetne ctene pozadovane hodnoty }
  TC_MulVal_                := 0;        { pocatecni nastaveni zpetne ctene regulacni konstanty }
  TC_PerVz_                 := 0;        { pocatecni nastaveni zpetne ctene periody vzorkovani }
  TC_PozVal                 := 100;      { pocatecni nastaveni pozadovane hodnoty }
  TC_MulVal                 := 25;       { nastaveni regulacni konstanty
                                           ([%] pro zahrnuti pozadovane hodnoty do stavajici aktualni) }
  TC_PerVz                  := 15;       { nastaveni periody vzorkovani [10ms] }
 { uprava nekterych polozek zaznamu Tecomatu podle uzivatelskeho nastaveni }
  TecoReInit;
end;

{ ------------------------------------ }
procedure SimPozVal;
  { meneni pozadovane hodnoty pro aktivni zmeny skutecnych hodnot }
begin
  if (TERM_ScrNo <>cTer_Ed_Poz) and  { nedituje-li se zrovna konstanta pozadovane hodnoty }
     (TC_AktVal+1>=TC_PozVal  ) and
     (TC_AktVal  <=TC_PozVal+1) then { AktVal je v intervalu <PozVal-1,PozVal+1> - cca je vyregulovano }
    begin
      { nahodne zmenime pozadovanou hodnotu }
       Pom_SimPoz:=Rnd(151.0)+cMaxPozVal/5;
       if TC_PozVal>cMaxPozVal/2 then
            Pom_SimPoz:=TC_PozVal-Pom_SimPoz
       else Pom_SimPoz:=TC_PozVal+Pom_SimPoz;
       TC_PozVal:=Pom_SimPoz;
      { aby se provedl zapis do PLC }
       TC_FlSWrite[TC_ComAdr]:=1;
    end;
end;

{ ------------------------------------ }
{ Nasledujici procedura se provadi cyklicky po celou dobu behu automatu }
procedure MAIN;
begin
  SimPozVal;   { simulace zmeny pozadovane hodnoty }
  TecoAutomat; { automat Tecomatu }
end;

{ ========================================================================== }
terminal TERM : cTer_Uvod;
   { uvodni obrazovka s logem firmy SofCon }
begin
  BitMap cBmp_Logo;  { bitmapa c.0 - s logem SofCon }
  Wait 1,cTer_Graph; { po jedne sekunde se automaticky prejde na obrazovku c.1 }
  OnKey              { nebo po stisku nektere z klaves se prejde na obrazovku c.1 }
    zESC,zCR,
    zUp, zDn : TERM_ScrNo:=cTer_Graph;
  end;
end;

{ ------------------------------------ }
terminal TERM : cTer_Graph;
   { obrazovka s grafickym zobrazenim namerenych hodnot }
begin
  Bitmap cBmp_Clear;
  Font cFnt_8x8c;
  Rect 2,2,237,125;
  Line 2,20,237,20;
  Position 25,7;
   Print "Vizualizace meen TC500";

  Font cFnt_6x8c;
  { vypsani, zda je ci neni navazana komunikace s PLC Tecomat }
  Position 50,25;
   case TC_FlConnect[TC_ViewAdr] of
     0:Print "Nekomunikuji";
     1:Print "Komunikuji";
   end;

  { vykresleni os grafu }
   Line rel,15,36+50,150,0;
   Line rel,15,36,0,50;
  { popis os grafu }
   Position 8,37;
    Print "y";
   Position 160,87;
    Print "x";

  { vlastni vykresleni grafu }
   Graph Line ,Rel,GPoints,TC_AktData,0,500,15,35,150,50; { carovy graf merenych hodnot }
   Graph Point,Rel,GPoints,TC_PozData,0,500,15,35,150,50; { bodovy graf pozadovanych hodnot }

  { vykresleni ramecku pro bargrafy a jejich popis }
   Rect rel,185,35,10,50;
   Rect rel,215,35,10,50;
   Position 182,87;
    Print "m";
   Position 212,87;
    Print "po";
  { vlastni vykresleni bargrafu }
   Bar Bottom,Rel,TC_AktVal ,0,500,185,35,10,50;
   Bar Bottom,Rel,TC_PozVal_,0,500,215,35,10,50;
  { popis aktualnich hodnot nad bargrafy }
   Position 182,27;
    Print TC_AktVal :3;
   Position 212,27;
    Print TC_PozVal_:3;

  { vypis globalnich velicin mereni v dolni casti obrazovky }
   Position  10, 99;
    Print "Meno : ",TC_AktVal;            { vypis ctene merene hodnoty z PLC }
   Position  10,111;
    Print "Poadov: ",TC_PozVal_;           { vypis zpetne ctene pozadovane hodnoty z PLC }
   Position 110, 99;
    Print "Regulan k: ",TC_MulVal_," %";  { vypis zpetne ctene regulacni konstanty z PLC }
   Position 110,111;
    Print "Perioda Vz : ",TC_PerVz_,"0 ms"; { vypis zpetne ctene periody vzorkovani z PLC }

  { nakresleni podtrzitek editacnich pismen }
   Line rel, 10,119,4,0;
   Line rel,110,107,4,0;
   Line rel,158,119,4,0;

  OnKey { pozadovane akce na stisk danych klaves }
    zESC:TERM_ScrNo:=cTer_Graph;
    zUp,
    zDn :TERM_ScrNo:=cTer_Graph;
    'S' :TERM_ScrNo:=cTer_SysCom;
    'P' : { jde se na obrazovku editace pro editaci pozadovane hodnoty }
      begin
        Pom_Edit  :=TC_PozVal;
        TERM_ScrNo:=cTer_Ed_Poz;
      end;
    'R' : { jde se na obrazovku editace pro editaci regulacni konstanty }
      begin
        Pom_Edit  :=TC_MulVal;
        TERM_ScrNo:=cTer_Ed_ReK;
      end;
    'V' : { jde se na obrazovku editace pro editaci periody vzorkovani }
      begin
        Pom_Edit  :=TC_PerVz*10;
        TERM_ScrNo:=cTer_Ed_PVz;
      end;
  end;

  Help { definice stranky napovedy }
   Font cFnt_8x8c;
                         {12345678901234567890123456789012345678 - znakove pozice na obrazovce }
   Position 10,10; Print "Npovda";
   Font cFnt_6x8c;
   Position 10,25; Print "<P> - editace poadovan hodnoty";
   Position 10,35; Print "<R> - editace regulan konstanty";
   Position 10,45; Print "<V> - editace periody vzorkovn";
   Position 10,60; Print "V grafu se znzoruj poadovan";
   Position 10,72; Print "(tekovan) a men (rkovan)";
   Position 10,84; Print "hodnoty z PLC Tecomat. Na osu Y se";
   Position 10,96; Print "vyn jednotliv hodnoty a na osu X";
   Position 10,108;Print "prbh ten dat z PLC Tecomat";
end;

{ ------------------------------------ }
terminal TERM : cTer_Ed_Poz;
   { obrazovka pro editaci pozadovane hodnoty }
begin
  Bitmap cBmp_Clear;
  Font cFnt_8x8c;
  Rect 2,2,237,125;
  Line 2,20,237,20;
  Rect rel,85,46,56,28;
  Position 15,7;
   Print "Editace Poadovan hodnoty";
  Font cFnt_6x8c;
  Position 15,95;
   Print "Zadej cel slo v rozsahu 0 a 500";
  Font cFnt_16x32c;
  Position 90,45;
  Edit Pom_Edit:3,0,cMaxPozVal;

  EditEnter
  begin
   TC_PozVal:=Pom_Edit;
   TC_FlSWrite[TC_ViewAdr]:=1;
  end;

  Help
   Font cFnt_8x8c;
   Position 10,10; Print "Npovda";
   Font cFnt_6x8c;
                         {12345678901234567890123456789012345678 - znakove pozice na obrazovce }
   Position 10,25; Print "Poadovan hodnota je daj, kter se";
   Position 10,37; Print "pole PLC Tecomatu. Ten zane podle";
   Position 10,49; Print "tto hodnoty regulovat a bude se sna-";
   Position 10,61; Print "it piblit meenou hodnotu co nej-";
   Position 10,73; Print "vce k poadovan hodnot.";
end;

{ ------------------------------------ }
terminal TERM : cTer_Ed_ReK;
   { obrazovka pro editaci regulacni konstanty }
begin
  Bitmap cBmp_Clear;
  Font cFnt_8x8c;
  Rect 2,2,237,125;
  Line 2,20,237,20;
  Rect rel,85,46,56,28;
  Position 12,7;
   Print "Editace Regulan konstanty";
  Font cFnt_6x8c;
  Position 15,95;
   Print "Zadej cel slo v rozsahu 1 a 100";
  Font cFnt_16x32c;
  Position 143,45;
   Print "%";
  Position 90,45;
  Edit Pom_Edit:3,1,100;

  EditEnter
  begin
   TC_MulVal:=Pom_Edit;
   TC_FlSWrite[TC_ViewAdr]:=1;
  end;

  Help
   Font cFnt_8x8c;
   Position 10,10; Print "Npovda";
   Font cFnt_6x8c;
                         {12345678901234567890123456789012345678 - znakove pozice na obrazovce }
   Position 10,25; Print "Regulan konstanta udv procentueln";
   Position 10,37; Print "zastoupen poadovan hodnoty v nov";
   Position 10,49; Print "namen hodnote, piem zbytek se";
   Position 10,61; Print "bere z pvodn namen hodnoty.";
   Position 10,73; Print "Vpoet se provd v PLC Tecomat";
   Position 10,85; Print "podle vzorce:";
   Position 10,97; Print " New=(Regul_K*Old+(100-Regul_K))/100";
end;

{ ------------------------------------ }
terminal TERM : cTer_Ed_PVz;
   { obrazovka pro editaci periody vzorkovani }
begin
  Bitmap cBmp_Clear;
  Font cFnt_8x8c;
  Rect 2,2,237,125;
  Line 2,20,237,20;
  Rect rel,85,46,56,28;
  Position 15,7;
   Print "Editace Periody vzorkovn";
  Font cFnt_6x8c;
  Position 10,95;
   Print "Zadej cel slo v rozsahu 1 a 1000";
  Font cFnt_16x32c;
  Position 143,45;
   Print "ms";
  Position 90,45;
  Edit Pom_Edit:3,1,1000;

  EditEnter
  begin
   TC_PerVz:=Pom_Edit/10;
   TC_FlSWrite[TC_ViewAdr]:=1;
  end;

  Help
   Font cFnt_8x8c;
   Position 10,10; Print "Npovda";
   Font cFnt_6x8c;
                         {12345678901234567890123456789012345678 - znakove pozice na obrazovce }
   Position 10,25; Print "Perioda vzorkovn udv prodlevu";
   Position 10,37; Print "v destkch milisekund mezi jednotli-";
   Position 10,49; Print "vmi vpoty nov namen hodnoty";
   Position 10,61; Print "v PLC Tecomat.";
end;

{ ------------------------------------ }
terminal TERM : cTer_SysCom;
   { ladici obrazovka }
begin
  Bitmap cBmp_Clear;
  Font cFnt_8x8c;
  Rect 2,2,237,125;
  Line 2,20,237,20;
  Position 20,7;
   Print "Komunikace s PLC Teco";

  Font cFnt_6x8c;
  Position 120,25;
   Print "AktPLC: ",TC_ComTeco; { vypis cisla Tecomatu se kterym se prave komunikuje }
  Position 10,25;
   case ComTECO_Ctrl of { vypise aktualni stav automatu komunikacniho kanalu }
     $00 : Print "Kanl Open/Close";
     $01 : Print "Kanl Off";
     $02 : Print "Kanl En";
     $04 : Print "Kanl Err";
     $10 ,
     $12 : Print "Kanl Send";
     $20 ,
     $22 : Print "Kanl SendErr";
     $40 ,
     $42 : Print "Kanl Rec";
     $80 ,
     $82 : Print "Kanl RecErr";
     else  Print "Kanl v jinm stavu ",ComTECO_Ctrl;
   end;
  Position 10,35;
   case TC_A of { vypise aktualni stav automatu Tecomatu }
     cTC_A_None,
     cTC_A_ReadBeg,
     cTC_A_WriteBeg   : Print "Automat  None";
     cTC_A_BegConn    : Print "Automat  Beg Connect";
     cTC_A_ContConn   : Print "Automat  Connecting";
     cTC_A_Read       : Print "Automat  Read  Reg";
     cTC_A_Write      : Print "Automat  Write Reg";
     cTC_A_WasRW      : Print "Automat  To Next PLC";
     else               Print "Automat  v jinm stavu";
   end;
  Position 10,45;
   case TC_RWA of { vypise aktualni stav RW automatu }
     cTC_RW_None      : Print "RW Autom None";
     cTC_RW_Rec       : Print "RW Autom Receiving";
     cTC_RW_WaitSend  : Print "RW Autom Sending";
     cTC_RW_SndConnect: Print "RW Autom Send_Connect";
     cTC_RW_SndReadN  : Print "RW Autom Send_ReadN";
     cTC_RW_SndWriteN : Print "RW Autom Send_WriteN";
     else               Print "RW Autom v jinm stavu";
   end;
  Position 10,55;
   case TC_Result of { vypise aktualni hodnotu vysledku RW automatu }
     cTC_Res_Ok       : Print "Result : Ok";
     cTC_Res_ErrInit  : Print "Result : Chyba pi ComOn";
     cTC_Res_SndTOut  : Print "Result : TimeOut pi vysln";
     cTC_Res_SndErr   : Print "Result : Chyba pi vysln";
     cTC_Res_RecTOut  : Print "Result : TimeOut pi pjmu";
     cTC_Res_RecErr   : Print "Result : Chyba pi pjmu";
     cTC_Res_BadAnsw  : Print "Result : Pila jin odpov";
     else               Print "Result : neznm";
   end;
  Position 10,65;
   Print "TOutCt : ",TC_TOutCt,"0ms"; { citac pro TimeOut pri cteni odpovedi z Teca }
  Position 10,75;
   Print "Ct_SndRead : ",TC_SReadCt[TC_ViewAdr];
  Position 10,85;
   Print "Ct_RecRead : ",TC_RReadCt[TC_ViewAdr];
  Position 130,75;
   Print "Ct_SndWrite : ",TC_SWriteCt[TC_ViewAdr];
  Position 130,85;
   Print "Ct_RecWrite : ",TC_RWriteCt[TC_ViewAdr];

  Position 10,95;
   case TC_FlConnect[TC_ViewAdr] of
     0 : print "PLC Not Connect";
     1 : print "PLC Connect";
   end;

  Position 10,105;
   Print "Readed ",TC_SRead_Len[TC_ViewAdr];
   case TC_SRead_Typ[TC_ViewAdr] of
     cTC_RegR : Print " Reg R ";
     cTC_RegX : Print " Reg X ";
     cTC_RegY : Print " Reg Y ";
     cTC_RegS : Print " Reg S ";
   end;
   Print "from $",hex TC_SRead_RegH[TC_ViewAdr], hex TC_SRead_RegL[TC_ViewAdr];

  Position 10,115;
   Print "Writed ",TC_SWrite_Len[TC_ViewAdr];
   case TC_SWrite_Typ[TC_ViewAdr] of
     cTC_RegR : Print " Reg R ";
     cTC_RegX : Print " Reg X ";
     cTC_RegY : Print " Reg Y ";
     cTC_RegS : Print " Reg S ";
   end;
   Print "to $",hex TC_SWrite_RegH[TC_ViewAdr], hex TC_SWrite_RegL[TC_ViewAdr];

  OnKey
    zESC:TERM_ScrNo:=cTer_Graph;
    zDn,
    zUp :TERM_ScrNo:=cTer_Graph;
  end;

  Help
    Position 20,20; Print "Obr. se zkl. parametry";
    Position 20,35; Print "komunikace s PLC Tecomat";
end;

{ ------------------------------------ }
