unit F_TestMain;

    {============================================================}
    {                                                            }
    {   TestLnkSofMA - Delphi 32           V1.00  09.11.1999     }
    {                                                            }
    {   Testovaci aplikace pro knihovnu LnkSofMA.DLL             }
    {                                                            }
    {   (C) 1999, SofCon s.r.o., R.Bukovsky                      }
    {                                                            }
    {============================================================}

{$I DEFINE.INC}

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
     Dialogs, Menus , ExtCtrls, StdCtrls
     {$ifdef DEBUGSYSF}
     ,uSysfDlf
     {$endif}
     ,Cf_Debug
     ,Cf_DlgMg
     ,Cf_SysWr
     ,Cf_StrNu
     ,Cf_PRME
     {--------------}
     ,Ext_LnkSofMA
     ,Lnk_KbdProcMess
     ,F_SysWr0
     ,D_GetParV
     ,D_PutParV;

const wm_SofMANotif = 1; { user message }

type
  TClassForm = class of TForm;
  TAppMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File_Menu: TMenuItem;
    Exit_MenuItem: TMenuItem;
    Debug_Menu: TMenuItem;
    SetDM_MenuItem: TMenuItem;
    SofMA_Menu: TMenuItem;
    SofMA_Create_MenuItem: TMenuItem;
    SofMA_Destroy_MenuItem: TMenuItem;
    SofMA_GetParamVal0Repeat_MenuItem: TMenuItem;
    LnkSofMASetDM_MenuItem: TMenuItem;
    Help_Menu: TMenuItem;
    AboutKbdLink_MenuItem: TMenuItem;
    SofMA_PutParamVal0Repeat_MenuItem: TMenuItem;
    OpenSysWr_MenuItem: TMenuItem;
    CloseSysWr_MenuItem: TMenuItem;
    N1: TMenuItem;
    DlgGetParamVal0_MenuItem: TMenuItem;
    DLGPutParamVal0_MenuItem: TMenuItem;
    DlgGetParamVal1_MenuItem: TMenuItem;
    SofMA_GetParamVal1Repeat_MenuItem: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    DLGPutParamVal1_MenuItem: TMenuItem;
    SofMA_PutParamVal1Repeat_MenuItem: TMenuItem;
    ConnectRq_MenuItem: TMenuItem;
    DisConnectRq_MenuItem: TMenuItem;
    N4: TMenuItem;
    Panel1: TPanel;
    SL1Counters_Edit: TEdit;
    Timer1: TTimer;
    SofMABasedState_Edit: TEdit;
    GetFromOutFIFO_MenuItem: TMenuItem;
    N5: TMenuItem;
    RealsTest_MenuItem: TMenuItem;
    TestQuietWait_MenuItem: TMenuItem;
    OpenModemOVL_MenuItem: TMenuItem;
    TestUserTimer_MenuItem: TMenuItem;
    procedure Exit_MenuItemClick(Sender: TObject);
    procedure SetDM_MenuItemClick(Sender: TObject);
    procedure SofMA_Create_MenuItemClick(Sender: TObject);
    procedure SofMA_Destroy_MenuItemClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SofMA_GetParamVal0Repeat_MenuItemClick(Sender: TObject);
    procedure LnkSofMASetDM_MenuItemClick(Sender: TObject);
    procedure AboutKbdLink_MenuItemClick(Sender: TObject);
    procedure SofMA_PutParamVal0Repeat_MenuItemClick(Sender: TObject);
    procedure OpenSysWr_MenuItemClick(Sender: TObject);
    procedure CloseSysWr_MenuItemClick(Sender: TObject);
    procedure DlgGetParamVal0_MenuItemClick(Sender: TObject);
    procedure DLGPutParamVal0_MenuItemClick(Sender: TObject);
    procedure DlgGetParamVal1_MenuItemClick(Sender: TObject);
    procedure SofMA_GetParamVal1Repeat_MenuItemClick(Sender: TObject);
    procedure DLGPutParamVal1_MenuItemClick(Sender: TObject);
    procedure SofMA_PutParamVal1Repeat_MenuItemClick(Sender: TObject);
    procedure ConnectRq_MenuItemClick(Sender: TObject);
    procedure DisConnectRq_MenuItemClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure GetFromOutFIFO_MenuItemClick(Sender: TObject);
    procedure RealsTest_MenuItemClick(Sender: TObject);
    procedure TestQuietWait_MenuItemClick(Sender: TObject);
    procedure OpenModemOVL_MenuItemClick(Sender: TObject);
    procedure TestUserTimer_MenuItemClick(Sender: TObject);
  private
    { Private declarations }
    procedure MyIdle(Sender: TObject; var Done: Boolean);
    function FindMDIChildForm(CType:TClassForm):TForm;
    procedure CreateSofMAChannel;
    procedure TxDGlbKbd_GetParamVal(AIx:byte);
    procedure TxDGlbKbd_PutParamVal(AIx:byte);
    procedure QGetFromOutFIFO;
  public
    UserTimerOn :Boolean;
    { Public declarations }
    procedure WMSofMANotif(var Msg:TMessage);           message wm_User+wm_SofMANotif;
  end;

var
  AppMainForm: TAppMainForm;

{#######################################################################################}
implementation

{$R *.DFM}

uses D_TstSysf;

type  TMyCreateType =(crtype_CallBack,
                      crtype_UserMess,
                      crtype_OutFIFO);
const MyCreateType :TMyCreateType=crtype_OutFIFO;

{ Globalni promenne pouzivane pro Dialogem zadavane parametry zpravy na Kit-Builder }
var GlbKbd_GetParamVal :array[0..1] of TKbd_GetParamVal;
    GlbKbd_PutParamVal :array[0..1] of TKbd_PutParamValue;

procedure UserTimerTickCallBack;stdcall;
begin
  MessageBeep(0);
end;

{ CallBackProcedure pro LnkSofMA.DLL }
procedure LnkSofMA_MessRxD(XTYP:word;lpMessBuff:pointer;wMessLen:Word);stdcall;
var WrkProcMess :TKbdPAR_M_ProcMess;
begin
  case XTYP of
   CBTYPE_Connect:
     if Assigned(lpMessBuff) and (wMessLen>=SizeOf(byte){Node}) then
     begin
       writelnsys(0,'Connect    NODE='+ByteStrDec(byte(lpMessBuff^),0));
     end;
   CBTYPE_DisConnect:
     if Assigned(lpMessBuff) and (wMessLen>=SizeOf(byte){Node}) then
     begin
       writelnsys(0,'DisConnect NODE='+ByteStrDec(byte(lpMessBuff^),0));
     end;
   CBTYPE_Mess:
     if Assigned(lpMessBuff) and (wMessLen>=SizeOf(word){BuffSize}) then
     begin
       WrkProcMess:=TKbdPAR_M_ProcMess.CreateFromBufL(lpMessBuff);
       try
         writelnsys(0,'RxD<-'+WrkProcMess.ViewSymbProcMess);
       finally
         WrkProcMess.Free;
       end;
     end;
   else writelnsys(0,'CallBack RxD XTYP='+WordStrDec(XTYP,0));
  end;
end;

procedure TAppMainForm.WMSofMANotif(var Msg:TMessage);
var WrkProcMess :TKbdPAR_M_ProcMess;
begin
  case Msg.wParam of
   CBTYPE_Connect: { SofMA oznamuje navazani komunikace }
     if pointer(Msg.lParam)<>nil then
     begin
       writelnsys(0,'wmConnect    NODE='+ByteStrDec(byte(pointer(Msg.lParam)^),0));
     end;
   CBTYPE_DisConnect: { SofMA oznamuje ztratu/zruseni komunikace }
     if pointer(Msg.lParam)<>nil then
     begin
       writelnsys(0,'wmDisConnect NODE='+ByteStrDec(byte(pointer(Msg.lParam)^),0));
     end;
   CBTYPE_Mess: { SofMA posila prijatou zpravu }
     if pointer(Msg.lParam)<>nil then
     begin
       WrkProcMess:=TKbdPAR_M_ProcMess.CreateFromBufL(pointer(Msg.lParam));
       try
         { Zobrazeni Mess do okenka Console }
         writelnsys(0,'RxD<-'+WrkProcMess.ViewSymbProcMess);
       finally
         WrkProcMess.Free;
       end;
     end;
   else writelnsys(0,'Msg RxD XTYP='+LongintStrDec(Msg.wParam,0));
  end;
end;

procedure TAppMainForm.QGetFromOutFIFO;
var QXTYP       :word;
    MyMessBuff  :array[0..1000] of byte;
    MessLen     :word;
    WrkProcMess :TKbdPAR_M_ProcMess;
begin
  if LnkSofMA_QOutFIFOEmpty=0 then
  begin
    MessLen:=LnkSofMA_GetFromOutFIFO(QXTYP,Addr(MyMessBuff),SizeOf(MyMessBuff));
    case QXTYP of
     CBTYPE_Connect:
       if (MessLen>=SizeOf(byte){Node}) then
       begin
         writelnsys(0,'FIFO Connect    NODE='+ByteStrDec(MyMessBuff[0],0));
       end;
     CBTYPE_DisConnect:
       if (MessLen>=SizeOf(byte){Node}) then
       begin
         writelnsys(0,'FIFO DisConnect NODE='+ByteStrDec(MyMessBuff[0],0));
       end;
     CBTYPE_Mess:
       if (MessLen>=SizeOf(word){BuffSize}) then
       begin
         WrkProcMess:=TKbdPAR_M_ProcMess.CreateFromBufL(Addr(MyMessBuff));
         try
           writelnsys(0,'RxD<-'+WrkProcMess.ViewSymbProcMess);
         finally
           WrkProcMess.Free;
         end;
       end;
     else writelnsys(0,'CallBack RxD XTYP='+WordStrDec(QXTYP,0));
    end;
  end;
end;

procedure TAppMainForm.CreateSofMAChannel;
begin
  {============= V O L A N I   L n k S o f M A . D L L ===============================}
  case MyCreateType of
   crtype_CallBack: LnkSofMA_ChannelCreate(LnkSofMA_MessRxD,0,0); { Zadat adresu CallBackProc }
   crtype_UserMess: LnkSofMA_ChannelCreate(nil,Handle,wm_User+wm_SofMANotif); { Zadat Handle okna a user Mess }
   crtype_OutFIFO : LnkSofMA_ChannelCreate(nil,0,0); {nezadat nic}
  end;
end;

procedure TAppMainForm.Exit_MenuItemClick(Sender: TObject);
begin
  Close;
end;

function TAppMainForm.FindMDIChildForm(CType:TClassForm):TForm;
var i        :integer;
    CrNewFlg :Boolean;
begin
  CrNewFlg:=true;
  Result:=nil;
  for i:=0 to MDIChildCount-1 do
  begin
    CrNewFlg:=CrNewFlg and not(MDIChildren[i] is CType);
    if not CrNewFlg then
    begin
      Result:=MDIChildren[i];
      Break;
    end;
  end;
end;

procedure TAppMainForm.SetDM_MenuItemClick(Sender: TObject);
var DebugDM_TrRec  :TDebugDM_TrRec;
begin
  DebugDM_TrRec.DebugDM_Value:=DTM_DM;
  DebugDM_TrRec.SysfFl_Value :=SysfFl;
  try
    if TrValDlgExecute(Self,'TDebugDM_Dlg',DebugDM_TrRec)=mrOK
    then begin
           DTM_DM:=DebugDM_TrRec.DebugDM_Value;
           SysfFl:=DebugDM_TrRec.SysfFl_Value;
         end;
  finally
    { pripadny uklid DebugDM_TrRec }
  end;
end;

procedure TAppMainForm.LnkSofMASetDM_MenuItemClick(Sender: TObject);
begin
  {============= V O L A N I   L n k S o f M A . D L L ===============================}
  LnkSofMA_ExecSetDebugMode;
  {===================================================================================}
end;


procedure MyTestCallBack(XTYP:word); stdcall;
begin
  writelnsys(0,'MyTestCallBack($'+WordStrhex(XTYP)+')');
end;

procedure TAppMainForm.SofMA_Create_MenuItemClick(Sender: TObject);
begin
  CreateSofMAChannel; { Explicitni vytvoreni prikazem menu }
end;

procedure TAppMainForm.SofMA_Destroy_MenuItemClick(Sender: TObject);
begin
  {============= V O L A N I   L n k S o f M A . D L L ===============================}
  LnkSofMA_ChannelDestroy;
  {===================================================================================}
end;

procedure TAppMainForm.FormDestroy(Sender: TObject);
begin
  { Pro jistotu, aby byl zrusen thread }
  { Zde je to NUTNO volat, jinak DLL neni dobre ukoncena a zustane "viset" v systemu !}
  Application.OnIdle:=nil;
  {============= V O L A N I   L n k S o f M A . D L L ===============================}
  LnkSofMA_ChannelDestroy; {!!!! JE TREBA ZRUSIT PRED UKONCENIM APLIKACE !!!}
  {===================================================================================}
end;

procedure TAppMainForm.FormCreate(Sender: TObject);
begin
  Application.OnIdle:=MyIdle; {tato fce je periodicky volana}
  CreateSofMAChannel; { Vytvoreni pri otevreni okenka }
end;

procedure TAppMainForm.MyIdle(Sender: TObject; var Done: Boolean);
begin
  if MyCreateType=crtype_OutFIFO
  then begin
         QGetFromOutFIFO; { Je nutno se periodicky dotazovat na stav fronty !}
         Done:=false;
       end
  else Done:=true;
end;

procedure TAppMainForm.SofMA_GetParamVal0Repeat_MenuItemClick(Sender: TObject);
begin
  TxDGlbKbd_GetParamVal(0);
end;

procedure TAppMainForm.SofMA_GetParamVal1Repeat_MenuItemClick(Sender: TObject);
begin
  TxDGlbKbd_GetParamVal(1);
end;

procedure TAppMainForm.SofMA_PutParamVal0Repeat_MenuItemClick(Sender: TObject);
begin
  TxDGlbKbd_PutParamVal(0);
end;

procedure TAppMainForm.SofMA_PutParamVal1Repeat_MenuItemClick(Sender: TObject);
begin
  TxDGlbKbd_PutParamVal(1);
end;

procedure TAppMainForm.AboutKbdLink_MenuItemClick(Sender: TObject);
var APom :array[0..127] of char;
    QVer :longint;
begin
  {============= V O L A N I   L n k S o f M A . D L L ===============================}
  QVer:=LnkSofMA_GetVersion(Addr(APom),SizeOf(APom));
  {===================================================================================}
  ShowMessage('Ver=$'+LongintStrHex(QVer)+chCRLF+
              StrPas(APom));
end;

procedure TAppMainForm.OpenSysWr_MenuItemClick(Sender: TObject);
var Child    :TForm;
begin
  Screen.Cursor := crHourglass;                 { Show hourglass cursor }
  try
    Child:=FindMDIChildForm(TMDIChild_SysWr0);
    if not Assigned(Child)
    then Child:=TMDIChild_SysWr0.Create(Self){ create a new MDI child window }
    else begin
           if Child.WindowState=wsMinimized
           then Child.WindowState:=wsNormal;
           Child.Show;{ Activate MDI child window }
         end;
  finally
  Screen.Cursor := crDefault;                  { Always restore to normal }
  end;
end;

procedure TAppMainForm.CloseSysWr_MenuItemClick(Sender: TObject);
var Child    :TForm;
begin
  Child:=FindMDIChildForm(TMDIChild_SysWr0);
  if Assigned(Child) then Child.Close;
end;

procedure TAppMainForm.TxDGlbKbd_GetParamVal(AIx:byte);
type TGetParamValMess = record
                          HED :TProcMessHeader;
                          REC :TKbd_GetParamVal;
                        end;
var ErrCode         :integer;
    GetParamValMess :TGetParamValMess;
    AdrD,AdrS       :TProcAddr;
    WrkProcMess     :TKbdPAR_M_ProcMess;
begin
  { -- Definovani polozek hlavicky zpravy -- zacatek -------------------------------- }
  FillChar(GetParamValMess,SizeOf(GetParamValMess),0); { vynulovani }
  with GetParamValMess.HED do
  begin
    BuffSize:=SizeOf(GetParamValMess);
    with Destin do              {(4) adresa prijemce    [86,01,4001]  }
    begin
      XIdent :=$86;   { identifikator procesu PRT_KBPAR_S   }
      XInst  :=$01;   { cislo instance procesu              }
      XLogA  :=$4001; { logicka adresa procesu              }
    end;
    with Source do              {(4) adresa odesilatele [85,01,2001]  }
    begin
      XIdent :=$85;   { identifikator procesu PRT_KBPAR_M   }
      XInst  :=$01;   { cislo instance procesu              }
      XLogA  :=$2001; { logicka adresa procesu              }
    end;
    MNo     :=0;                {(1) cislo vysilane zpravy          }
    ANo     :=0;                {(1) cislo posledni prijate zpravy  }
    MCode   :=gcmd_GetParamVal; {(1) identifikator zpravy           }
  end;
  GetParamValMess.REC:=GlbKbd_GetParamVal[AIx]; { zadane parametry z Dlg }
  { -- Definovani polozek hlavicky zpravy -- konec ---------------------------------- }
  {============= V O L A N I   L n k S o f M A . D L L ===============================}
  ErrCode:=LnkSofMA_MessTxD(Addr(GetParamValMess),SizeOf(GetParamValMess));
  {===================================================================================}
  if ErrCode=0
  then begin
         WrkProcMess:=TKbdPAR_M_ProcMess.CreateFromBufL(Addr(GetParamValMess));
         try
           writelnsys(0,'TxD->'+WrkProcMess.ViewSymbProcMess);
         finally
           WrkProcMess.Free;
         end;
       end
  else writelnsys(0,'LnkSofMA_MessTxD Err='+IntegerStrDec(ErrCode,0));
end;

procedure TAppMainForm.DlgGetParamVal0_MenuItemClick(Sender: TObject);
begin
  if ExecGetParamVal_Dlg(Self,GlbKbd_GetParamVal[0])=mrOK
  then TxDGlbKbd_GetParamVal(0);
end;

procedure TAppMainForm.DlgGetParamVal1_MenuItemClick(Sender: TObject);
begin
  if ExecGetParamVal_Dlg(Self,GlbKbd_GetParamVal[1])=mrOK
  then TxDGlbKbd_GetParamVal(1);
end;

procedure TAppMainForm.TxDGlbKbd_PutParamVal(AIx:byte);
type TPutParamValMess = record
                          HED :TProcMessHeader;
                          REC :TKbd_PutParamValue;
                        end;
var ErrCode         :integer;
    PutParamValMess :TPutParamValMess;
    AdrD,AdrS       :TProcAddr;
    WrkProcMess     :TKbdPAR_M_ProcMess;
begin
  FillChar(PutParamValMess,SizeOf(PutParamValMess),0);
  with PutParamValMess.HED do
  begin
    BuffSize     :=SizeOf(TProcMessHeader)+SizeOf(TKbd_BlockHeader);
    case GlbKbd_PutParamVal[AIx].BlockHd.TREC of
      DscrMsk_byte:    { parametr = byte    nebo pole bytu     }
        begin
          BuffSize:=BuffSize+SizeOf(byte)*GlbKbd_PutParamVal[AIx].BlockHd.RCNT;
        end;
      DscrMsk_word:    { parametr = word    nebo pole wordu    }
        begin
          BuffSize:=BuffSize+SizeOf(word)*GlbKbd_PutParamVal[AIx].BlockHd.RCNT;
        end;
      DscrMsk_integer: { parametr = integer nebo pole integeru }
        begin
          BuffSize:=BuffSize+SizeOf(SmallInt)*GlbKbd_PutParamVal[AIx].BlockHd.RCNT;
        end;
      DscrMsk_longint: { parametr = longint nebo pole longintu }
        begin
          BuffSize:=BuffSize+SizeOf(longint)*GlbKbd_PutParamVal[AIx].BlockHd.RCNT;
        end;
      DscrMsk_dword:   { parametr = dword   nebo pole dwordu  ~ double word }
        begin
          BuffSize:=BuffSize+SizeOf(longword)*GlbKbd_PutParamVal[AIx].BlockHd.RCNT;
        end;
      DscrMsk_string:  { parametr = pascalsky string }
        begin
          BuffSize:=BuffSize+SizeOf(Char)*GlbKbd_PutParamVal[AIx].BlockHd.RCNT; {??}
        end;
      DscrMsk_real:    { parametr = pascalsky 6-ti byte real  }
        begin
          BuffSize:=BuffSize+6{PascalReal}*GlbKbd_PutParamVal[AIx].BlockHd.RCNT;
        end;
      DscrMsk_DosDaTi: { parametr = longint chapany jako MS-DOS PackTime  }
        begin
          BuffSize:=BuffSize+SizeOf(longint)*GlbKbd_PutParamVal[AIx].BlockHd.RCNT;
        end;
      DscrMsk_Bit:     { parametr = byte chapany po bitech 0..7 }
        begin
          BuffSize:=BuffSize+SizeOf(byte);
        end;
    end;
    with Destin do              {(4) adresa prijemce    [86,01,4001]  }
    begin
      XIdent :=$86;   { identifikator procesu PRT_KBPAR_S   }
      XInst  :=$01;   { cislo instance procesu              }
      XLogA  :=$4001; { logicka adresa procesu              }
    end;
    with Source do              {(4) adresa odesilatele [85,01,2001]  }
    begin
      XIdent :=$85;   { identifikator procesu PRT_KBPAR_M   }
      XInst  :=$01;   { cislo instance procesu              }
      XLogA  :=$2001; { logicka adresa procesu              }
    end;
    MNo          :=0;                  {(1) cislo vysilane zpravy            }
    ANo          :=0;                  {(1) cislo posledni prijate zpravy    }
    MCode        :=gcmd_PutParamVal;   {(1) identifikator zpravy             }
  end;
  PutParamValMess.REC:=GlbKbd_PutParamVal[AIx]; { zadane parametry z Dlg }
  {============= V O L A N I   L n k S o f M A . D L L ===============================}
  ErrCode:=LnkSofMA_MessTxD(Addr(PutParamValMess),SizeOf(PutParamValMess));
  {===================================================================================}
  if ErrCode=0
  then begin
         WrkProcMess:=TKbdPAR_M_ProcMess.CreateFromBufL(Addr(PutParamValMess));
         try
           writelnsys(0,'TxD->'+WrkProcMess.ViewSymbProcMess);
         finally
           WrkProcMess.Free;
         end;
       end
  else writelnsys(0,'LnkSofMA_MessTxD Err='+IntegerStrDec(ErrCode,0));
end;

procedure TAppMainForm.DLGPutParamVal0_MenuItemClick(Sender: TObject);
begin
  if ExecPutParamVal_Dlg(Self,GlbKbd_PutParamVal[0])=mrOK
  then TxDGlbKbd_PutParamVal(0);
end;

procedure TAppMainForm.DLGPutParamVal1_MenuItemClick(Sender: TObject);
begin
  if ExecPutParamVal_Dlg(Self,GlbKbd_PutParamVal[1])=mrOK
  then TxDGlbKbd_PutParamVal(1);
end;


procedure TAppMainForm.ConnectRq_MenuItemClick(Sender: TObject);
begin
  {============= V O L A N I   L n k S o f M A . D L L ===============================}
  LnkSofMA_ConnectRq;
  {===================================================================================}
end;

procedure TAppMainForm.DisConnectRq_MenuItemClick(Sender: TObject);
begin
  {============= V O L A N I   L n k S o f M A . D L L ===============================}
  LnkSofMA_DisConnectRq;
  {===================================================================================}
end;

procedure TAppMainForm.Timer1Timer(Sender: TObject);
var OKCnt,RepCnt :longint;
begin
  {============= V O L A N I   L n k S o f M A . D L L ===============================}
  LnkSofMA_GetSLMessCounters(1{Node},Addr(OKCnt),Addr(RepCnt));
  if LnkSofMA_GetSLConnectFlg(1{Node})<>0
  {===================================================================================}
  then SL1Counters_Edit.Color:=clSilver
  else SL1Counters_Edit.Color:=clRed;
  SL1Counters_Edit.Text:=LongintStrDec(OKCnt,0)+'/'+LongintStrDec(RepCnt,0);
  {============= V O L A N I   L n k S o f M A . D L L ===============================}
  case LnkSofMA_GetMABaseState of
  {===================================================================================}
   BAS_Closed:      SofMABasedState_Edit.Text:='Closed';
   BAS_Opened:      SofMABasedState_Edit.Text:='Opened';
   BAS_Connected:   SofMABasedState_Edit.Text:='Connected';
   BAS_DisConnected:SofMABasedState_Edit.Text:='DisConnected';
   else             SofMABasedState_Edit.Text:='?';
  end;
end;

{#######################################################################################}
procedure TAppMainForm.GetFromOutFIFO_MenuItemClick(Sender: TObject);
begin
  QGetFromOutFIFO;
end;

procedure TAppMainForm.RealsTest_MenuItemClick(Sender: TObject);
var ArrS        :array[0..1] of Single;
    ArrD        :array[0..1] of Double;
    ArrR1,ArrR2 :array[0..1] of Real48;
    i           :integer;
    Err         :Boolean;
begin
  Err     :=false;
  ArrR1[0]:=1;ArrS[0]:=1;
  ArrR2[0]:=ArrS[0];
  if ArrR1[0]<>ArrR2[0]
  then ShowMessage('Dir Single Reals R1<>R2: '+RealStrExp(ArrR1[0],19)+'<>'+RealStrExp(ArrR2[0],19));
  ArrR1[0]:=1e-3;
  ArrR1[1]:=2e+12;
  ArrR2[0]:=0;
  ArrR2[1]:=0;
  LnkSofMA_ConvertReal6To4(Addr(ArrR1),Addr(ArrS) ,2);
  LnkSofMA_ConvertReal6To8(Addr(ArrR1),Addr(ArrD) ,2);
  LnkSofMA_ConvertReal4To6(Addr(ArrS) ,Addr(ArrR2),2);
  for i:=0 to 1 do
  begin
    if ArrR1[i]<>ArrR2[i] then
    begin
      Err:=true;
      ShowMessage('Single Reals R1<>R2: '+RealStrExp(ArrR1[i],19)+'<>'+RealStrExp(ArrR2[i],19))
    end;
  end;
  LnkSofMA_ConvertReal8To6(Addr(ArrD) ,Addr(ArrR2),2);
  for i:=0 to 1 do
  begin
    if ArrR1[i]<>ArrR2[i] then
    begin
      Err:=true;
      ShowMessage('Double Reals R1<>R2: '+RealStrExp(ArrR1[i],19)+'<>'+RealStrExp(ArrR2[i],19));
    end;
  end;
  if not Err then ShowMessage('Test OK');
end;

procedure TAppMainForm.TestQuietWait_MenuItemClick(Sender: TObject);
begin
  LnkSofMA_QuietWaitForFIFO(10000);
  ShowMessage('QuietEnd');
end;

procedure TAppMainForm.OpenModemOVL_MenuItemClick(Sender: TObject);
begin
  if LnkSofMA_ChannelType=chtMA_MODEM
  then LnkSofMA_OpenModemOVLForm
  else ShowMessage('NO MODEM');
end;

procedure TAppMainForm.TestUserTimer_MenuItemClick(Sender: TObject);
begin
  if UserTimerOn
  then begin
         LnkSofMA_UserTimerDestroy;
         UserTimerOn:=false;
       end
  else begin
         LnkSofMA_UserTimerCreate(2000{APeriod},UserTimerTickCallBack,true{Enabled});
         UserTimerOn:=true;
       end;  

end;

Initialization
  FillChar(GlbKbd_GetParamVal,Sizeof(GlbKbd_GetParamVal),0);
  with GlbKbd_GetParamVal[0].RqBlockHd do
  begin
    TREC    :=DscrMsk_byte; { typ KitBulder registru }
    RADDR   :=2048;         { poc adresa bloku registru v KitBuilderu  }
    RCNT    :=32;           { pocet registru v bloku ~ v poli registru }
  end;
  with GlbKbd_GetParamVal[1].RqBlockHd do
  begin
    TREC    :=DscrMsk_real; { typ KitBulder registru }
    RADDR   :=0;            { poc adresa bloku registru v KitBuilderu  }
    RCNT    :=1;           { pocet registru v bloku ~ v poli registru }
  end;
  FillChar(GlbKbd_PutParamVal,Sizeof(GlbKbd_PutParamVal),0);
  with GlbKbd_PutParamVal[0].BlockHd do
  begin
    TREC    :=DscrMsk_byte; { typ KitBulder registru }
    RADDR   :=2048;         { poc adresa bloku registru v KitBuilderu  }
    RCNT    :=1;            { pocet registru v bloku ~ v poli registru }
  end;
  with GlbKbd_PutParamVal[1].BlockHd do
  begin
    TREC    :=DscrMsk_real; { typ KitBulder registru }
    RADDR   :=0;            { poc adresa bloku registru v KitBuilderu  }
    RCNT    :=1;            { pocet registru v bloku ~ v poli registru }
  end;
end.
