//==========================
// header  file LnkSofMA.h
//==========================
#if !defined(LNKSOFMA_H_INCLUDED)
#define LNKSOFMA_H_INCLUDED

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//=======================================================================================}
//           S l e d o v a n i   O n - L i n e   p a r a m e t r u                       }
//=======================================================================================}
// kod prikazu                typ parametru prikazu  Destination <-- Source   popis      }
//---------------------------------------------------------------------------------------}
#define gcmd_None        0x00// { prazdny prikaz }
#define gcmd_Abort       0x01// { prikaz pro uvedeni automatu do klidu z lib. stavu(nerusi jej!) }
#define gcmd_DoneReq     0x02// { prikaz pro zruseni procesu (pred gcmd_Done nemusi
                             //   predchazet gcmd_Abort)  }
#define gcmd_Result      0x03// { TGCmd_Result  Vysledek operace (0=O.K., >0=chyba) }
#define gcmd_Timeout     0x05// { zprava po vycerpani timeoutu }

#define gcmd_GetParamVal 0x40// { T???_GetParamVal SLV <-  MAS zadost o parametr/parametry }

#define gcmd_PutParamVal 0x41// { T???_ParamValue  SLV <-> MAS zapis parametru/parametru   }

//--------------------------------------------------------------------------------------
//       uvodni blok (hlavicka) kazde zpravy prenasene protokolem SofL2                }
//--------------------------------------------------------------------------------------
typedef BYTE TProcIdent;   // typ identifikatoru procesu ve zprave                     }
typedef BYTE TProcInst;    // typ instance procesu ve zprave                           }
typedef WORD TProcLogA;    // typ logicke adresy ve zprave                             }
typedef BYTE TPMCode;      // typ kodu zpravy                                          }

typedef struct {
    TProcIdent XIdent; //(1) identifikator procesu               }
    TProcInst  XInst;  //(1) cislo instance procesu              }
    TProcLogA  XLogA;  //(2) logicka adresa                      }
	} TProcAddr; //-- celkem  (4) byty ------------------------- }
                  

typedef struct {
   WORD      BuffSize;      //(2) delka vcetne nasledujicich Data      }
   BYTE      DDETrans;      //(1) ddet_xxxx (vyuziti pro DDE)          }
   TProcAddr Destin;        //(4) adresa prijemce                      }
   TProcAddr Source;        //(4) adresa odesilatele                   }
   BYTE      MNo;           //(1) cislo vysilane zpravy                }
   BYTE      ANo;           //(1) cislo posledni prijate zpravy        }
   TPMCode   MCode;         //(1) identifikator/kod prikazu zpravy     }
} TProcMessHeader;//-- celkem (14) bytu ------------------------------ }

//---------------------------------------------------------------------------------------}
//            T y p y   d a t o v y c h   z p r a v                                      }
//---------------------------------------------------------------------------------------}
// 1. Obecne }
#define   g_nevimco          1000 // promenna horni mez pro dynamicke pole parametru }
#define   g_ResultSzMaxIndx    64 // max. delka textu chyboveho hlaseni ve zprave    }


//  Typ datove casti potvrzovaci zpravy, kterou SLAVE potvrzuje (ResultCode=0)
//  bezchybne akceptovani, nebo hlasi chybu (ResultCode<>0). V polozce ResultSz
//  muze SLAVE predat text chyboveho hlaseni }

typedef struct {
  WORD  ResultCode;   // 0=OK, ostatni kod chyby }
  char  ResultSz[g_ResultSzMaxIndx]; // null terminated str }
} Tgcmd_Result;      // zprava muze byt promenne delky dle ResultSz }
  
//---------------------------------------------------------------------------------------}
//            T y p y   d a t o v y c h   z p r a v                                      }
//---------------------------------------------------------------------------------------}
// 2. Pro Kit-Builder                                                                    }

//=======================================================================================}
//  D e s c r i p t o r   z a z n a m u   v   a r c h i v u   K i t - B u i l d e r u    }
//=======================================================================================}
//       |DscrMskByte0|DscrMskByte1|...|DscrMskByteN|                                    }
//       descriptor ma stejnou delku jako jim popisovany zaznam                          }
typedef	BYTE  TDscrMsk_Type;

// konstanty pro vytvareni descriptoru zaznamu }
#define  DscrMsk_First    0x10 //  { bit oznacujici 1. byte parametru }
#define  DscrMsk_TypPol   0x0F //  { maska na bity oznacujici typ polozky }
#define  DscrMsk_undef    0x00 //  { dosud nedefinovany byte masky }

#define  DscrMsk_byte     1    //  { parametr = byte    nebo pole bytu     }
#define  DscrMsk_word     2    //  { parametr = word    nebo pole wordu    }
#define  DscrMsk_integer  3    //  { parametr = integer nebo pole integeru }
#define  DscrMsk_longint  4    //  { parametr = longint nebo pole longintu }
#define  DscrMsk_dword    5    //  { parametr = dword   nebo pole dwordu  ~ double word }
#define  DscrMsk_string   6    //  { parametr = pascalsky string }
#define  DscrMsk_real     7    //  { parametr = pascalsky 6-ti byte real  }
#define  DscrMsk_DosDaTi  8    //  { parametr = longint chapany jako MS-DOS PackTime  }
#define  DscrMsk_Bit      9    //  { parametr = byte chapany po bitech 0..7 }

#define  DscrMsk_TypPolMax 9   //  { maximalni pripustna hodnota typu polozky  }


//  {-------------------------------------------------------------------------}
//  {-------- Adresace bloku registru v Kit-Builderu -------------------------}
//  {-------------------------------------------------------------------------}
typedef struct {
    TDscrMsk_Type TREC;  // typ KitBulder registru }
    WORD          RADDR; // poc adresa bloku registru v KitBuilderu  }
    WORD          RCNT;  // pocet registru v bloku ~ v poli registru }
	} TKbd_BlockHeader;// identifikace bloku registru }

// Typ datove casti zpravy }
typedef struct {
  TKbd_BlockHeader  RqBlockHd; // pozadovany blok registru }
  } TKbd_GetParamVal;// pozadavek na poslani bloku registru z KitBuilderu }

// Typ datove casti zpravy }
typedef struct {
   TKbd_BlockHeader BlockHd; // identifikace posilaneho bloku registru }
   BYTE RegBlock[g_nevimco]; // posilany blok registru }
  } TKbd_PutParamVal;        // posilany blok registru do/z KitBuilderu }

// {-------------------------------------------------------------------------}


// Typy procedur a funkci z knihovny LnkSofMA.DLL
typedef void(_stdcall* LNKSOFMA_EXECSETDEBUGMODE)();
typedef long(_stdcall* LNKSOFMA_GETVERSION)(char* szVerbuff,long lVerBuffSize); 
typedef void(_stdcall* LNKSOFMA_SETDEBUGMODE)(long ADM, BOOL ASysfFl);

//  Typ bufferu predavaneho dialogu pro mastaveni DebugMode 
typedef struct {
	long DebugDM_Value; // mnozina bitu pro nastaveni debug vypisu 
    BOOL SysfFl_Value;  // pozadavek zapisovani do *.TXS souboru   
} TDebugDM_TrRec;

typedef int(_stdcall* LNKSOFMA_EXECDLGDEBUGDM)(TDebugDM_TrRec* lpDebugDM_TrRec);

//  CallBack type = hodnoty parametru XTYP:word pro TSofMACallBackProc 
#define CBTYPE_None       0 //{ nedefinovany }
#define CBTYPE_Connect    1 //{ Master Automat oznamuje navazani komunikace, lpMessBuff^=Node }
#define CBTYPE_DisConnect 2 //{ Master Automat oznamuje ztratu   komunikace, lpMessBuff^=Node }
#define CBTYPE_Mess       3 //{ Master Automat predava prijatou zpravu, lpMessBuff^="zprava"  }

// Typ CallBack procedury, kterou LnkSofMA.DLL predava prijatou zpravu 
typedef void(CALLBACK TSOFMACALLBACKPROC)(UINT XTYP,LPVOID lpMessBuff,UINT wMessLen);
typedef void(_stdcall* LNKSOFMA_CHANNELCREATE)(TSOFMACALLBACKPROC ASofMACallBackProc,
											   HWND ASofMANotifWndHandle,
											   DWORD ASofMANotifUserMsg);

typedef void(_stdcall* LNKSOFMA_CHANNELDESTROY)();
typedef INT (_stdcall* LNKSOFMA_MESSTXD) (LPVOID lpMessBuff,WORD wMessLen);
			 


//--------------------------------------------------------------------------
void LoadLib_LnkSofMA();
void FreeLib_LnkSofMA();

void SofMA_ExecSetDebugMode();
long SofMA_GetVersion(char* szVerbuff,long lVerBuffSize);

void SofMA_ChannelCreate(TSOFMACALLBACKPROC ASofMACallBackProc,
	                     HWND ASofMANotifWndHandle,
					     DWORD ASofMANotifUserMsg);
void SofMA_ChannelDestroy();

INT SofMA_MessTxD(LPVOID lpMessBuff,WORD wMessLen);

/////////////////////////////////////////////////////////////////////////////
#endif // !defined(LNKSOFMA_H_INCLUDED)