' =============================================
' modul KB_Protokol
' modul pro komunikaci s RS, pouzivajicim SW Kit-Builder
' Verze V 17/11/99
' (C) 1999 Tesar, SofCon, s.r.o.
' =============================================
Option Explicit
' POZOR!!! tato verze je zatim napsana pro komunikaci pouze s jednim Slave RS s KIT/Builderem

' Public procedury s prefixem LnkSofMA jsou identicke s procedurami z DLL knihovny
' Public procedury s prefixem LnkSofKB jsou upravene pro potreby prenosu zprav s KIT-Builderem
' Public procedury s prefixem KB jsou pomocne procedury pro realizaci spojeni s KIT-Builderem
' Public konstanty s prefixem KB jsou pomocne konstanty pro vyse uvedene procedury
' Public promenne KB_BB a KB_RB jsou pole, do kterych se ukladaji prichozi bloky dat

' DLL pomocne systemove procedury pro ladeni
' ==========================================
Public Declare Function LnkSofMA_GetVersion Lib "LnkSofMA" ( _
  ByVal ReturnedString As String, ByVal MaxLenString As Integer) As Long
Public Declare Sub LnkSofMA_ExecSetDebugMode Lib "LnkSofMA" ()

' DLL procedury pro otevreni a zavreni komunikacniho kanalu s KB
' ==============================================================
' POZOR!!! komunikace probiha na zaklade parametru, zadanych v souboru LnkSofMA.INI !!
Private Declare Sub LnkSofMA_ChannelCreate Lib "LnkSofMA" ( _
  ByVal ASofMACallBackProc As Long, ByVal ASofMANotifWndHandle As Long, ByVal ASofMANotifUserMsg As Long)
Private Declare Sub LnkSofMA_ChannelDestroy Lib "LnkSofMA" ()
Public Declare Sub LnkSofMA_DisConnectRq Lib "LnkSofMA" () ' odpojeni modemu
Public Declare Sub LnkSofMA_ConnectRq Lib "LnkSofMA" () ' opetovne pripojeni modemu

' DLL procedury pro zjisteni stavu komunikace
' ===========================================
' Stav komunikace jako celku
Public Declare Function LnkSofMA_GetMABaseState Lib "LnkSofMA" () As Integer
Const BAS_Closed = 0       ' { Vychozi stav, komunikacni kanal uzavren }
Const BAS_Opened = 1       ' { Komunikacni kanal otevren, tj. inicializovan COM port }
Const BAS_Connected = 2    ' { Spojeni navazano, bezi komunikace, Master Automat udrzuje spojeni }
Const BAS_DisConnected = 3 ' { Spojeni zruseno/ modem zavesen , Master Automat ceka na prikaz }
' Stav komunikace s konkretnim zarizenim na siti
Public Declare Function LnkSofMA_GetSLConnectFlgLib Lib "LnkSofMA" (ByVal ANode As Byte) As Byte
'  Fukcni hodnota       ... 0 = stanice odpojena, nekomunikuje
'                           1 = stanice pripojena, komunikuje
'  ANode       :byte;   ... Node pozadovane Slave stanice na siti
' Stav komunikace s konkretnim zarizenim na siti
Public Declare Sub LnkSofMA_GetSLMessCounters Lib "LnkSofMA" ( _
  ByVal ANode As Byte, ByRef OKCounter As Long, ByRef RepCounter As Long)
'  ANode         :byte;      ... Node pozadovane Slave stanice na siti
'  lpOKCounter   :^longint;  ... ukazatel na promennou typu longint, do ktere bude
'                                zapsana hodnota citace prenesenych zprav
'  lpRepCounter  :^longint;  ... ukazatel na promennou typu longint, do ktere bude
'                                zapsana hodnota citace opakovani prenosu zprav

' DLL procedura pro vyslani zpravy do Slava
' =========================================
Private Declare Function LnkSofMA_MessTxD Lib "LnkSofMA" ( _
  ByRef ProcMess0 As Byte, ByVal LenProcMess As Integer) As Integer

' DLL procedury pro cteni zprav ze Slava
' ======================================
Public Declare Function LnkSofMA_QOutFIFOEmpty Lib "LnkSofMA" () As Byte
'  Fukcni hodnota         0 = fronta obsahuje polozky
'                         1 = fronta je prazdna
Private Declare Function LnkSofMA_GetFromOutFIFO Lib "LnkSofMA" ( _
  ByRef XTYP As Integer, ByRef ProcMess0 As Byte, ByVal MaxStrLen As Integer) As Integer
' Fukcni hodnota = delka prevzate zpravy do bufferu ProcMess0
' povolene hodnoty parametru XTYP pro LnkSofMA_GetFromOutFIFO }
Private Const CBTYPE_None = 0       ' { nedefinovany }
Private Const CBTYPE_Connect = 1    ' { Master Automat oznamuje navazani komunikace, lpMessBuff^=Node }
Private Const CBTYPE_DisConnect = 2 ' { Master Automat oznamuje ztratu   komunikace, lpMessBuff^=Node }
Private Const CBTYPE_Mess = 3       ' { Master Automat predava prijatou zpravu, lpMessBuff^="zprava"  }
  
' DLL pomocne konverzni procedury pro konverzi 6-bytoveho typu real ve zprave
' na 4 resp. 8-bytovy real ve Visual Basicu
Private Declare Sub LnkSofMA_ConvertReal6To4 Lib "LnkSofMA" ( _
  ByRef R6_0 As Byte, ByRef R4_0 As Single, ByVal Cnt As Integer)
Private Declare Sub LnkSofMA_ConvertReal6To8 Lib "LnkSofMA" ( _
  ByRef R6_0 As Byte, ByRef R8_0 As Double, ByVal Cnt As Integer)
Private Declare Sub LnkSofMA_ConvertReal4To6 Lib "LnkSofMA" ( _
  ByRef R4_0 As Single, ByRef R6_0 As Byte, ByVal Cnt As Integer)
Private Declare Sub LnkSofMA_ConvertReal8To6 Lib "LnkSofMA" ( _
  ByRef R8_0 As Double, ByRef R6_0 As Byte, ByVal Cnt As Integer)
  
' DLL pomocne konverzni procedury pro konverzi z KB-typu byte,word,integer,longint,date
Public Declare Function LnkSofMA_WordPtrToDWord Lib "LnkSofMA" (ByRef b0 As Byte) As Long
Public Declare Function LnkSofMA_IntPtrToLInt Lib "LnkSofMA" (ByRef b0 As Byte) As Long
Public Declare Function LnkSofMA_LIntPtrToLInt Lib "LnkSofMA" (ByRef b0 As Byte) As Long
Public Declare Function LnkSofMA_FDatePtrToDate Lib "LnkSofMA" (ByRef b0 As Byte) As Double
Public Declare Sub LnkSofMA_PStrToSzStr Lib "LnkSofMA" (ByRef b0 As Byte, ByVal s As String, MaxSize As Integer)

' DLL pomocne konverzni procedury pro konverzi do KB-typu byte,word,integer,longint,date
Public Declare Sub LnkSofMA_DWordToWordPtr Lib "LnkSofMA" (ByVal w As Long, ByRef b0 As Byte)
Public Declare Sub LnkSofMA_IntToIntPtr Lib "LnkSofMA" (ByVal i As Integer, ByRef b0 As Byte)
Public Declare Sub LnkSofMA_LIntToLIntPtr Lib "LnkSofMA" (ByVal l As Long, ByRef b0 As Byte)
Public Declare Sub LnkSofMA_DateToFDatePtr Lib "LnkSofMA" (ByVal d As Double, ByRef b0 As Byte)
Public Declare Sub LnkSofMA_SzStrToPStr Lib "LnkSofMA" (ByVal s As String, ByRef b0 As Byte, MaxSize As Integer)


' DLL procedura realizujici cekani (jen pokusy)
Private Declare Function LnkSofMA_QuietWaitForFIFO Lib "LnkSofMA" ( _
  ByVal dwTimeOut As Long) As Long

' DLL procedury pro realizaci timeru (jen pokusy)
Private Declare Sub LnkSofMA_UserTimerCreate Lib "LnkSofMA" ( _
 ByVal Period As Long, ByVal UserCallBackProc As Long, ByVal Enabled As Byte)
Private Declare Sub LnkSofMA_UserTimerSetEnabledLib Lib "LnkSofMA" (ByVal Enabled As Byte)
Private Declare Sub LnkSofMA_UserTimerDestroy Lib "LnkSofMA" ()

' { adresa odesilatele nebo prijemce v ProcMess }
Private Type TProcAddr           ' { --- celkem  (4) byty ----------------- }
  XIdent As Byte         ' {(1) identifikator procesu               }
  XInst As Byte          ' {(1) cislo instance procesu              }
  XLogA As Integer       ' {(2) logicka adresa                      }
End Type

' { ============ typ zpravy, posilane z/do KB ============================= }
' Zprava je typu TProcMess.
' record TProcMess of
'   Case byte of
'   0: begin  pro pripad pozadavku na cteni (cehokoliv)
'      PMH:TProcMessHeader;
'      BH: TKB_BlockHeader;
'      end;
'   1: begin  pro pripad zpravy pri zapis/cteni 1 bytu
'      PMH:TProcMessHeader;
'      BH: TKB_BlockHeader;
'      val: byte;
'      end;
'   2: begin  pro pripad zpravy pri zapis/cteni 1 realu
'      PMH:TProcMessHeader;
'      BH: TKB_BlockHeader;
'      val: real;
'      end;
  
' Na pocatku ma casti, ktere jsou typu TProcMessHeader a TKBD_BlockHeader
Private Type TProcMessHeader     '{ --- celkem (14) bytu ------------------ }
  Buffsize As Integer    '{(2) delka vcetne nasledujicich Data      }
  DDETrans As Byte       '{(1) ddet_xxxx (vyuziti pro DDE)          }
  DA As TProcAddr        '{(4) adresa prijemce                      }
  SA As TProcAddr        '{(4) adresa odesilatele                   }
  MNo As Byte            '{(1) cislo vysilane zpravy                }
  ANo As Byte            '{(1) cislo posledni prijate zpravy        }
  MCode As Byte          '{(1) identifikator/kod prikazu zpravy     }
End Type
' { povolene prikazy MCode v TProcMessHeader }
Private Const gcmd_None = &H0        ' { prazdny prikaz }
Private Const gcmd_Abort = &H1       ' { prikaz pro uvedeni automatu do klidu z lib. stavu(nerusi jej!) }
Private Const gcmd_DoneReq = &H2     ' { prikaz pro zruseni procesu (pred gcmd_Done nemusi predchazet gcmd_Abort)  }
Private Const gcmd_Result = &H3      ' { TGCmd_Result  Vysledek operace (0=O.K., >0=chyba) }
Private Const gcmd_Timeout = &H5     ' { zprava po vycerpani timeoutu }
Private Const gcmd_GetParamVal = &H40 ' { T???_GetParamVal SLV <-  MAS zadost o parametr/parametry }
Private Const gcmd_PutParamVal = &H41 ' { T???_ParamValue  SLV <-> MAS zapis parametru/parametru   }

' { typ identifikace bloku registru v KB }
Private Type TKbd_BlockHeader    ' { --- celkem 5 bytu -------------------- }
  Rtype As Byte          ' { typ registru v KB                      }
  Raddr As Integer       ' { poc adresa bloku registru v KitBuilderu}
  Rcnt As Integer        ' { pocet registru v bloku                 }
End Type
' { povolene typy registru pro KB - TREC v TKbd_BlockHeader }
Private Const DscrMsk_byte = 1       ' { parametr = byte    nebo pole bytu     }
Private Const DscrMsk_word = 2       ' { parametr = word    nebo pole wordu    }
Private Const DscrMsk_integer = 3    ' { parametr = integer nebo pole integeru }
Private Const DscrMsk_longint = 4    ' { parametr = longint nebo pole longintu }
Private Const DscrMsk_dword = 5      ' { parametr = dword   nebo pole dwordu  ~ double word }
Private Const DscrMsk_string = 6     ' { parametr = pascalsky string }
Private Const DscrMsk_real = 7       ' { parametr = pascalsky 6-ti byte real  }
Private Const DscrMsk_DosDaTi = 8    ' { parametr = longint chapany jako MS-DOS PackTime  }
Private Const DscrMsk_Bit = 9        ' { parametr = byte chapany po bitech 0..7 }

' Globalni konstanty pro rozliseni vysledku KB_ReadFIFO (viz dale)
Global Const KB_Res_ResultOK = 1
Global Const KB_Res_Connect = 100
Global Const KB_Res_DisConnect = 500
Global Const KB_Res_Error = 1000
Global Const KB_Res_BBReady = 10000
Global Const KB_Res_RBReady = 20000

' Globalni datova struktura, do ktere se prijima cteny blok dat typu byte
Global KB_BB(0 To 999) As Byte
' Globalni datova struktura, do ktere se prijima cteny blok dat typu real, prevedeny na double
Global KB_RB(0 To 255) As Double

' Pomocna ladici funkce pro nacteni verze DLL-knihovny
Private Function GetDLLVersion() As String
  Dim RetStrVal As String, RetBinVal As Integer
  RetStrVal = String$(255, 0)
  RetBinVal = LnkSofMA_GetVersion(RetStrVal, Len(RetStrVal))
  Debug.Print RetBinVal, RetStrVal
  GetDLLVersion = 0
End Function
' Pomocne procedury pro HEX vypisy
Private Function HEXNib(ByVal B As Byte) As String
  HEXNib = Hex(B)  ' (Hex=prevod cisla na string 1-2HEX cifry)
End Function
Private Function HEXB(ByVal B As Byte) As String
  HEXB = HEXNib(B \ 16) & HEXNib(B And &HF)
End Function
Private Function HEXBArr(ByRef B() As Byte, ByVal n As Byte) As String
Dim i As Byte
  HEXBArr = ""
  For i = 0 To n - 1
    HEXBArr = HEXBArr & HEXB(B(i))
  Next i
End Function
' Dalsi pomocne procedury pro HEX vypisy
Private Function LoB(ByVal i As Integer) As Byte
  LoB = i Mod &H100
End Function
Private Function HiB(ByVal i As Integer) As Byte
  HiB = i \ 256
End Function
Private Sub CopyB(ByRef d() As Byte, ByVal Di As Integer, ByRef s() As Byte, ByVal Si As Integer, ByVal n As Integer)
Dim i As Integer
 For i = 0 To n - 1
   d(i + Di) = s(i + Si)
 Next i
End Sub
' Pomocna procedura pro zobrazeni ProcMess
Private Function ViewProcMess(ByRef PM() As Byte) As String
Dim i As Integer, poms As String
  poms = ""
  For i = 0 To 13
    poms = poms & HEXB(PM(i))
  Next i
    poms = poms & "|"
  For i = 14 To 18
    poms = poms & HEXB(PM(i))
  Next i
    poms = poms & "|"
  For i = 19 To PM(0) - 1
    poms = poms & HEXB(PM(i))
  Next i
  ViewProcMess = poms
End Function
' Procedura pro sestaveni ProcMessHeader
Private Sub FillPMH(ByVal Laddr As Integer, ByVal Cmd As Byte, ByRef PMH() As Byte)
Dim SA(0 To 3) As Byte, MA(0 To 3) As Byte
  SA(0) = &H86
  SA(1) = &H1
  SA(2) = &H1
  SA(3) = &H40
  MA(0) = &H85
  MA(1) = &H1
  MA(2) = &H1
  MA(3) = &H20
  PMH(0) = 0 ' prozatim, pozdeji nutno doplnit!
  PMH(1) = 0 ' prozatim, pozdeji nutno doplnit!
  PMH(2) = &H0
  Call CopyB(PMH, 3, SA, 0, 4)
  Call CopyB(PMH, 7, MA, 0, 4)
  PMH(11) = &H0
  PMH(12) = &H0
  PMH(13) = Cmd
End Sub
' Procedura pro sestaveni TKB_BlockHeader
Private Sub FillBH(ByVal Rtype As Byte, ByVal Raddr As Integer, ByVal Rcnt As Integer, ByRef BH() As Byte)
  BH(0) = Rtype
  BH(1) = LoB(Raddr)
  BH(2) = HiB(Raddr)
  BH(3) = LoB(Rcnt)
  BH(4) = HiB(Rcnt)
End Sub
' Procedura pro zapis promenne typu byte do zarizeni s log. adresou Laddr na KB adresu KBaddr
Public Sub LnkSofKB_SendByte(Laddr As Integer, KBaddr As Integer, ByteVal As Byte)
' Laddr - adresa zarizeni KB v siti - standardne &H4001 pro node=1 (viz INI-file LnkSofMA.INI)
' KBAddr - cislo pocatecniho byte registru v poli KB (0 az 2000(dec))
' ByteVal - hodnota zapisovaneho bytu (0/255)
Dim PMH(0 To 14) As Byte, BH(0 To 4) As Byte
Dim ProcMess(0 To 255) As Byte
Dim Buffsize As Integer, result As Integer
Const Cnt = 1 ' tato procedura umi zapsat pouze parametr daneho typu
  Call FillPMH(Laddr, gcmd_PutParamVal, PMH)
  Call FillBH(DscrMsk_byte, KBaddr, Cnt, BH)
  Call CopyB(ProcMess, 0, PMH, 0, 14)
  Call CopyB(ProcMess, 14, BH, 0, 5)
  ProcMess(19) = ByteVal
  Buffsize = 14 + 5 + 1 ' TProcMessHeader & TKbd_BlockHeader & sizeof(byte)
  ProcMess(0) = LoB(Buffsize)
  Debug.Print "**SendProcMess="; ViewProcMess(ProcMess)
  result = LnkSofMA_MessTxD(ProcMess(0), Buffsize)
  Debug.Print "result="; result
End Sub
' Procedura pro zapis promenne typu 2-bytovy word do zarizeni s log. adresou Laddr na KB adresu KBaddr
Public Sub LnkSofKB_SendWord(Laddr As Integer, KBaddr As Integer, DWordVal As Long)
' Laddr - adresa zarizeni KB v siti - standardne &H4001 pro node=1 (viz INI-file LnkSofMA.INI)
' KBAddr - cislo pocatecniho byte registru v poli KB (0 az 2000(dec))
' WordVal - hodnota zapisovaneho wordu (0 az 65535)
Dim PMH(0 To 14) As Byte, BH(0 To 4) As Byte
Dim ProcMess(0 To 255) As Byte
Dim Buffsize As Integer, result As Integer
Const Cnt = 1 ' tato procedura umi zapsat pouze parametr daneho typu
  Call FillPMH(Laddr, gcmd_PutParamVal, PMH)
  Call FillBH(DscrMsk_word, KBaddr, Cnt, BH)
  Call CopyB(ProcMess, 0, PMH, 0, 14)
  Call CopyB(ProcMess, 14, BH, 0, 5)
  Call LnkSofMA_DWordToWordPtr(DWordVal, ProcMess(19))
  Buffsize = 14 + 5 + 2 ' TProcMessHeader & TKbd_BlockHeader & sizeof(KBword)
  ProcMess(0) = LoB(Buffsize)
  Debug.Print "**SendProcMess="; ViewProcMess(ProcMess)
  result = LnkSofMA_MessTxD(ProcMess(0), Buffsize)
  Debug.Print "result="; result
End Sub
' Procedura pro zapis promenne typu 2-bytovy integer do zarizeni s log. adresou Laddr na KB adresu KBaddr
Public Sub LnkSofKB_SendInteger(Laddr As Integer, KBaddr As Integer, IntVal As Integer)
' Laddr - adresa zarizeni KB v siti - standardne &H4001 pro node=1 (viz INI-file LnkSofMA.INI)
' KBAddr - cislo pocatecniho byte registru v poli KB (0 az 2000(dec))
' IntVal - hodnota zapisovaneho integer (-32767 az 32767)
Dim PMH(0 To 14) As Byte, BH(0 To 4) As Byte
Dim ProcMess(0 To 255) As Byte
Dim Buffsize As Integer, result As Integer
Const Cnt = 1 ' tato procedura umi zapsat pouze parametr daneho typu
  Call FillPMH(Laddr, gcmd_PutParamVal, PMH)
  Call FillBH(DscrMsk_integer, KBaddr, Cnt, BH)
  Call CopyB(ProcMess, 0, PMH, 0, 14)
  Call CopyB(ProcMess, 14, BH, 0, 5)
  Call LnkSofMA_IntToIntPtr(IntVal, ProcMess(19))
  Buffsize = 14 + 5 + 2 ' TProcMessHeader & TKbd_BlockHeader & sizeof(KBinteger)
  ProcMess(0) = LoB(Buffsize)
  Debug.Print "**SendProcMess="; ViewProcMess(ProcMess)
  result = LnkSofMA_MessTxD(ProcMess(0), Buffsize)
  Debug.Print "result="; result
End Sub
' Procedura pro zapis promenne typu 4-bytovy integer do zarizeni s log. adresou Laddr na KB adresu KBaddr
Public Sub LnkSofKB_SendLongint(Laddr As Integer, KBaddr As Integer, LongVal As Integer)
' Laddr - adresa zarizeni KB v siti - standardne &H4001 pro node=1 (viz INI-file LnkSofMA.INI)
' KBAddr - cislo pocatecniho byte registru v poli KB (0 az 2000(dec))
' LongVal - hodnota zapisovaneho integer (-2^31 az 2^31)
Dim PMH(0 To 14) As Byte, BH(0 To 4) As Byte
Dim ProcMess(0 To 255) As Byte
Dim Buffsize As Integer, result As Integer
Const Cnt = 1 ' tato procedura umi zapsat pouze parametr daneho typu
  Call FillPMH(Laddr, gcmd_PutParamVal, PMH)
  Call FillBH(DscrMsk_longint, KBaddr, Cnt, BH)
  Call CopyB(ProcMess, 0, PMH, 0, 14)
  Call CopyB(ProcMess, 14, BH, 0, 5)
  Call LnkSofMA_LIntToLIntPtr(LongVal, ProcMess(19))
  Buffsize = 14 + 5 + 4 ' TProcMessHeader & TKbd_BlockHeader & sizeof(KBlongint)
  ProcMess(0) = LoB(Buffsize)
  Debug.Print "**SendProcMess="; ViewProcMess(ProcMess)
  result = LnkSofMA_MessTxD(ProcMess(0), Buffsize)
  Debug.Print "result="; result
End Sub
' Procedura pro zapis promenne typu datum/cas do zarizeni s log. adresou Laddr na KB adresu KBaddr
Public Sub LnkSofKB_SendDateTime(Laddr As Integer, KBaddr As Integer, DT As Date)
' Laddr - adresa zarizeni KB v siti - standardne &H4001 pro node=1 (viz INI-file LnkSofMA.INI)
' KBAddr - cislo pocatecniho byte registru v poli KB (0 az 2000(dec))
' DT - hodnota zapisovaneho datumu a casu (8-byte real)
Dim PMH(0 To 14) As Byte, BH(0 To 4) As Byte
Dim ProcMess(0 To 255) As Byte
Dim Buffsize As Integer, result As Integer
Const Cnt = 1 ' tato procedura umi zapsat pouze parametr daneho typu
  Call FillPMH(Laddr, gcmd_PutParamVal, PMH)
  Call FillBH(DscrMsk_DosDaTi, KBaddr, Cnt, BH)
  Call CopyB(ProcMess, 0, PMH, 0, 14)
  Call CopyB(ProcMess, 14, BH, 0, 5)
  Call LnkSofMA_DateToFDatePtr(DT, ProcMess(19))
  Buffsize = 14 + 5 + 4 ' TProcMessHeader & TKbd_BlockHeader & sizeof(KBdatetime)
  ProcMess(0) = LoB(Buffsize)
  Debug.Print "**SendProcMess="; ViewProcMess(ProcMess)
  result = LnkSofMA_MessTxD(ProcMess(0), Buffsize)
  Debug.Print "result="; result
End Sub
' Procedura pro zapis promenne typu pascalsky string do zarizeni s log. adresou Laddr na KB adresu KBaddr
Public Sub LnkSofKB_SendString(Laddr As Integer, KBaddr As Integer, StrVal As String)
' Laddr - adresa zarizeni KB v siti - standardne &H4001 pro node=1 (viz INI-file LnkSofMA.INI)
' KBAddr - cislo pocatecniho byte registru v poli KB (0 az 2000(dec))
' StrVal - hodnota zapisovaneho stringu (max 255 znaku)
Dim PMH(0 To 14) As Byte, BH(0 To 4) As Byte, PStr(0 To 255) As Byte
Dim ProcMess(0 To 275) As Byte  ' 19+256
Dim Buffsize As Integer, result As Integer
  Call LnkSofMA_SzStrToPStr(StrVal, PStr(0), 256)
  Call FillPMH(Laddr, gcmd_PutParamVal, PMH)
  Call FillBH(DscrMsk_byte, KBaddr, PStr(0) + 1, BH)
  Call CopyB(ProcMess, 0, PMH, 0, 14)
  Call CopyB(ProcMess, 14, BH, 0, 5)
  Call CopyB(ProcMess, 19, PStr, 0, PStr(0) + 1)
  Buffsize = 14 + 5 + PStr(0) + 1 ' TProcMessHeader & TKbd_BlockHeader & len(string)+1
  ProcMess(0) = LoB(Buffsize)
  ProcMess(1) = HiB(Buffsize)
  Debug.Print "**SendProcMess="; ViewProcMess(ProcMess)
  result = LnkSofMA_MessTxD(ProcMess(0), Buffsize)
  Debug.Print "result="; result
End Sub
' Procedura pro zapis promenne typu real6 do zarizeni s log. adresou Laddr na KB adresu KBaddr
Public Sub LnkSofKB_SendReal(Laddr As Integer, KBaddr As Integer, RealVal As Double)
' Laddr - adresa zarizeni KB v siti - standardne &H4001 pro node=1 (viz INI-file LnkSofMA.INI)
' KBAddr - cislo pocatecniho byte registru v poli KB (0 az 2000(dec))
' RealVal - hodnota zapisovaneho real cisla ve formatu real8 = double
Dim PMH(0 To 14) As Byte, BH(0 To 4) As Byte
Dim R6(0 To 5) As Byte ' 6-bytovy real ve formatu KB
Dim ProcMess(0 To 255) As Byte
Dim Buffsize As Integer, result As Integer
Const Cnt = 1 ' tato procedura umi zapsat pouze 1 byte
  Call FillPMH(Laddr, gcmd_PutParamVal, PMH)
  Call FillBH(DscrMsk_real, KBaddr, Cnt, BH)
  Call CopyB(ProcMess, 0, PMH, 0, 14)
  Call CopyB(ProcMess, 14, BH, 0, 5)
  Call LnkSofMA_ConvertReal8To6(RealVal, R6(0), 1) ' konverze 8-byte real na 6-byte real, ulozeny do pole 6 bytu
  Call CopyB(ProcMess, 19, R6, 0, 6)
  Buffsize = 14 + 5 + 6 ' TProcMessHeader & TKbd_BlockHeader & sizeof(real6)
  ProcMess(0) = LoB(Buffsize)
  Debug.Print "**SendProcMess="; ViewProcMess(ProcMess)
  result = LnkSofMA_MessTxD(ProcMess(0), Buffsize)
  Debug.Print "result="; result
End Sub
' Public Procedura pro vyslani pozadavku na precteni promenne typu byte ze zarizeni s log. adresou Laddr z KB adresy KBaddr
Public Sub LnkSofKB_ReqBBlock(ByVal Laddr As Integer, ByVal KBaddr As Integer, ByVal Cnt As Integer)
' Laddr - adresa zarizeni KB v siti - standardne &H4001 pro node=1 (viz INI-file LnkSofMA.INI)
' KBAddr - cislo pocatecniho byte registru v poli KB (0 az 2000(dec))
' Cnt - pocet pozadovanych registru v poli KB (1 az 1000(dec))
Dim PMH(0 To 14) As Byte, BH(0 To 4) As Byte
Dim ProcMess(0 To 255) As Byte
Dim Buffsize As Integer, result As Integer
  Call FillPMH(Laddr, gcmd_GetParamVal, PMH)
  Call FillBH(DscrMsk_byte, KBaddr, Cnt, BH)
  Call CopyB(ProcMess, 0, PMH, 0, 14)
  Call CopyB(ProcMess, 14, BH, 0, 5)
  Buffsize = 14 + 5 ' TProcMessHeader & TKbd_BlockHeader
  ProcMess(0) = LoB(Buffsize)
  Debug.Print "**SendProcMess="; ViewProcMess(ProcMess)
  result = LnkSofMA_MessTxD(ProcMess(0), Buffsize)
  Debug.Print "result="; result
End Sub
' Public Procedura pro vyslani pozadavku na precteni promenne typu real ze zarizeni s log. adresou Laddr z KB adresy KBaddr
Public Sub LnkSofKB_ReqRBlock(ByVal Laddr As Integer, ByVal KBaddr As Integer, ByVal Cnt As Integer)
' Laddr - adresa zarizeni KB v siti - standardne &H4001 pro node=1 (viz INI-file LnkSofMA.INI)
' KBAddr - cislo pocatecniho real registru v poli KB (0 az 255(dec))
' Cnt - pocet pozadovanych registru v poli KB (1 az 255(dec))
Dim PMH(0 To 14) As Byte, BH(0 To 4) As Byte
Dim ProcMess(0 To 255) As Byte
Dim Buffsize As Integer, result As Integer
  Call FillPMH(Laddr, gcmd_GetParamVal, PMH)
  Call FillBH(DscrMsk_real, KBaddr, Cnt, BH)
  Call CopyB(ProcMess, 0, PMH, 0, 14)
  Call CopyB(ProcMess, 14, BH, 0, 5)
  Buffsize = 14 + 5 ' TProcMessHeader & TKbd_BlockHeader
  ProcMess(0) = LoB(Buffsize)
  Debug.Print "**SendProcMess="; ViewProcMess(ProcMess)
  result = LnkSofMA_MessTxD(ProcMess(0), Buffsize)
  Debug.Print "result="; result
End Sub
' Public procedura pro precteni odpovedi na zpravu PC(VB) -> KB
Public Function LnkSofKB_ReadFIFO() As Integer
' Funkce vraci tyto hodnoty:
' = 0 -> zadna zprava ve FIFO
' = 1 -> ve FIFO zprava Result bez chyby
' KB_Res_Connect >= 100 - ve FIFO byla zprava Connect
' KB_Res_DisConnect >= 500 - ve FIFO byla zprava disConnect
' KB_Res_Error >= 1000 - ve FIFO byla zprava Result s chybovym priznakem
' KB_Res_BBReady >= 10000 - ve FIFO byla zprava SendByteData
' KB_Res_RBReady >= 20000 - ve FIFO byla zprava SendRealData
' Sekvence zprav je nasledujici:
' po navazani fyzicke komunikace generuje DLL zpravu s XTYP=CBType_Connect
' po ztrate fyzicke komunikace generuje DLL zpravu s XTYP=CBType_DisConnect
' po vyslani zpravy VB->KB typu SendByte, SendReal
'    odpovida KB->VB zpravou typu Result, DLL posila dal jako XTYP=CBType_Mess
' po vyslani zpravy VB->KB typu ReqByteBlock, ReqRealBlock
'    odpovida KB->VB zpravou typu SendByteBlock, SendRealBlock, DLL posila dal jako XTYP=CBType_Mess
' Cteme-li funkci KB_ReadFIFO a ta nema zadnou zpravu z vyse uvedenych ve svem bufferu,
'    vraci se CBTYPE_None.
Const ofsCmd = 13 ' info o vyznamu zpravy ProcMess
Const ofsRtype = 14 ' gcmd_PutParamVal - info o typu posilanych registru v ProcMess (byte)
Const ofsRaddr = 15 ' gcmd_PutParamVal - info o poc. adrese posilanych registru v ProcMess (integer)
Const ofsRcnt = 17 ' gcmd_PutParamVal - info o poctu posilanych registru v ProcMess (integer)
Const ofsdata = 19 ' gcmd_PutParamVal - pocatek dat v ProcMess
Const ofsResult = 14 ' gcmd_Result - Result (byte) (nemel by byt integer? !!!)
Dim Rtype As Byte, Raddr As Integer, Rcnt As Integer
Dim XTYP As Integer
Dim ProcMess(2000) As Byte ' musi byt vetsi nez 1000+14+5
  Call LnkSofMA_GetFromOutFIFO(XTYP, ProcMess(0), 2000)
  Select Case XTYP
    Case CBTYPE_None
      Debug.Print "**Empty!"
      LnkSofKB_ReadFIFO = 0
    Case CBTYPE_Connect
      Debug.Print "**Connect!, node=" & ProcMess(0)
      LnkSofKB_ReadFIFO = KB_Res_Connect + ProcMess(0)
    Case CBTYPE_DisConnect
      Debug.Print "**Disconnect!"
      LnkSofKB_ReadFIFO = KB_Res_DisConnect + ProcMess(0)
    Case CBTYPE_Mess
      Debug.Print "**RecMessage=" & ViewProcMess(ProcMess)
      If ProcMess(ofsCmd) = gcmd_PutParamVal Then
        If ProcMess(ofsRtype) = DscrMsk_byte Then
          Rcnt = CInt(ProcMess(ofsRcnt)) + CInt(256) * CInt(ProcMess(ofsRcnt + 1))
          Raddr = CInt(ProcMess(ofsRaddr)) + CInt(256) * CInt(ProcMess(ofsRaddr + 1))
          Call CopyB(KB_BB, 0, ProcMess, ofsdata, Rcnt) ' zde uvadime delku, ale sizeof(byte)=1
          LnkSofKB_ReadFIFO = KB_Res_BBReady + Raddr
        ElseIf ProcMess(ofsRtype) = DscrMsk_real Then
          Rcnt = ProcMess(ofsRcnt)
          Raddr = ProcMess(ofsRaddr)
          Call LnkSofMA_ConvertReal6To8(ProcMess(ofsdata), KB_RB(0), Rcnt) ' zde uvadime pocet! ne delku
          LnkSofKB_ReadFIFO = KB_Res_RBReady + Raddr
        End If
      ElseIf ProcMess(ofsCmd) = gcmd_Result Then
        If ProcMess(ofsResult) <> 0 Then  ' Result<>0 -> chyba
          LnkSofKB_ReadFIFO = KB_Res_Error + ProcMess(ofsResult)
        Else
          LnkSofKB_ReadFIFO = KB_Res_ResultOK
        End If
      End If
  End Select
End Function
' Public procedura pro otevereni komunikacniho kanalu
Public Sub LnkSofKB_CHCreate()
' tuto proceduru musime volat jako prvni, nejlepe pri otevreni dokumentu
' po navazani fyzicke komunikace generuje DLL zpravu s XTYP=CBType_Connect
'   kterou je mozno precist z fronty doslych zprav pomoci KB_ReadFIFO
' po ztrate fyzicke komunikace generuje DLL zpravu s XTYP=CBType_DisConnect
'   kterou je mozno precist z fronty doslych zprav pomoci KB_ReadFIFO
  Call LnkSofMA_ChannelCreate(0, 0, 0)
  Debug.Print "**otevirani zapocato"
End Sub
' Public procedura pro zavreni komunikacniho kanalu
Public Sub LnkSofKB_CHDestroy()
' tuto proceduru musime volat jako posledni, nejlepe pri zavirani dokumentu
  Call LnkSofMA_ChannelDestroy
  Debug.Print "**zavirani kanalu zapocato"
End Sub
' Pomocna procedura pro ladeni
Private Sub SendByte()
  Call LnkSofKB_SendByte(&H4001, 300, &HEE)
End Sub
' Pomocna procedura pro ladeni
Private Sub ReqBB()
  Call LnkSofKB_ReqBBlock(&H4001, 300, 5)
End Sub
' Pomocna procedura pro test timeru z DLL
Private Sub Myproc()
  MsgBox ("CallBack funguje !!!")
End Sub
' Pomocna procedura pro test timeru z DLL
Private Sub TestTimer()
' Call LnkSofMA_UserTimerCreate(5000, AddressOf Myproc,1) ' Nejde prelozit v Access VBA!!!!
End Sub
Private Sub TestKBtypes()
Dim B(3) As Byte, l As Long, DAT As Double
B(0) = 255
B(1) = 255
B(2) = 1
B(3) = 0
l = B(0)
Debug.Print l
l = LnkSofMA_WordPtrToDWord(B(0))
Debug.Print l
l = LnkSofMA_IntPtrToLInt(B(0))
Debug.Print l
l = LnkSofMA_LIntPtrToLInt(B(0))
Debug.Print l
B(0) = 98   ' to by mel byt datum 28/03/2001, 10:11:04 ve formatu PackTime (FDate)
B(1) = 81
B(2) = 124
B(3) = 42
DAT = LnkSofMA_FDatePtrToDate(B(0))
Debug.Print Format(DAT, "DD/MM/YYYY, HH:MM:SS")
End Sub



