' =====================================================
' Form_KB_Archivace
' Ukazka vizualizace a archivace hodnot z KIT/Builder prostredi (1 Slave)
' Verze 17/11/99
' (c) 1999 Tesar SofCon, s.r.o.
' =====================================================

Option Compare Database
Option Explicit

Private Sub SetConnect(s As String)
  V_Connect = s
  If V_Connect = "Connected" Then
    V_Connect.BackColor = 65280 ' zelena
  Else
    V_Connect.BackColor = 255 ' cervena
  End If
End Sub
Private Sub Form_Close()
  Call LnkSofKB_CHDestroy
End Sub
Private Sub Form_Open(Cancel As Integer)
  V_Archivuj = False
  Call SetConnect("Disconnected")
  Call LnkSofKB_CHCreate
  Call V_PERIOD_AfterUpdate
End Sub
' Procedura spoustena od ticku timeru kazdych x ms (zadavame v properties formulare)
Private Sub Form_Timer()
Dim SS As String
  Do
    V_RESULT = LnkSofKB_ReadFIFO ' pripadne ignorovani zpravy Result OK
  Loop While V_RESULT = KB_Res_ResultOK
  If V_RESULT > 0 Then
    Select Case V_RESULT
    Case KB_Res_Connect To KB_Res_DisConnect - 1
      Call SetConnect("Connected")
      Call LnkSofKB_ReqBBlock(&H4001, V_BBASE, V_BLEN) ' pozadavek na cteni hodnot z pole byte
      Call LnkSofKB_ReqRBlock(&H4001, V_RBASE, V_RLEN) ' pozadavek na cteni hodnot z pole real
    Case KB_Res_DisConnect To KB_Res_Error - 1
      Call SetConnect("Not Connected")
    Case KB_Res_BBReady To KB_Res_RBReady - 1
      V_B0 = KB_BB(0)
      V_B1 = KB_BB(1)
      V_B2 = KB_BB(2)
      V_B3 = KB_BB(3)
      V_W0 = LnkSofMA_WordPtrToDWord(KB_BB(0))
      V_W2 = LnkSofMA_WordPtrToDWord(KB_BB(2))
      V_I0 = LnkSofMA_IntPtrToLInt(KB_BB(0))
      V_I2 = LnkSofMA_IntPtrToLInt(KB_BB(2))
      V_L0 = LnkSofMA_LIntPtrToLInt(KB_BB(0))
      V_DT0 = LnkSofMA_FDatePtrToDate(KB_BB(0))
      SS = String$(256, 0)
      Call LnkSofMA_PStrToSzStr(KB_BB(0), SS, 256)
      V_S0 = SS
      Call LnkSofKB_ReqBBlock(&H4001, V_BBASE, V_BLEN) ' pozadavek na opetovne cteni hodnot
    Case Is >= KB_Res_RBReady
      V_R0 = KB_RB(0)
      V_R1 = KB_RB(1)
      V_R2 = KB_RB(2)
      V_R3 = KB_RB(3)
      Call LnkSofKB_ReqRBlock(&H4001, V_RBASE, V_RLEN) ' pozadavek na opetovne cteni hodnot
    End Select
    If V_RESULT >= KB_Res_BBReady And V_Archivuj Then
      Call Archivuj(V_B0, V_B1, V_R0, V_R1)
    End If
  End If
End Sub
' Procedura pro archivaci prestenych hodnot do databaze
Sub Archivuj(v1, v2, r1, r2)
Dim result As Integer
Dim MyDB As Database, RS_ARCH As Recordset
Dim mess As String
  Set MyDB = DBEngine.Workspaces(0).Databases(0)
  Set RS_ARCH = MyDB.OpenRecordset("T_ARCHIV", DB_OPEN_DYNASET)
  RS_ARCH.AddNew
  RS_ARCH!v1 = v1
  RS_ARCH!v2 = v2
  RS_ARCH!r1 = r1
  RS_ARCH!r2 = r2
  RS_ARCH!Date = Date
  RS_ARCH!Time = Time
  RS_ARCH.Update
  RS_ARCH.Close
End Sub
Private Sub Pkaz35_Click()
On Error GoTo Err_Pkaz35_Click
    Screen.PreviousControl.SetFocus
    DoCmd.FindNext
Exit_Pkaz35_Click:
    Exit Sub
Err_Pkaz35_Click:
    MsgBox Err.Description
    Resume Exit_Pkaz35_Click
End Sub

Private Sub K_BStoreData_Click()
  If V_BStoreVal < 0 Or V_BStoreVal >= 256 Then
    MsgBox ("Nelze ulozit - hodnota mimo povolene meze")
  Else
    Call LnkSofKB_SendByte(&H4001, V_BStoreAddr, V_BStoreVal)
  End If
End Sub
Private Sub K_WStoreData_Click()
  If V_BStoreVal < 0 Or V_BStoreVal >= 65536 Then
    MsgBox ("Nelze ulozit - hodnota mimo povolene meze")
  Else
    Call LnkSofKB_SendWord(&H4001, V_BStoreAddr, V_BStoreVal)
  End If
End Sub
Private Sub K_IStoreData_Click()
  If V_BStoreVal < -32767 Or V_BStoreVal >= 32767 Then
    MsgBox ("Nelze ulozit - hodnota mimo povolene meze")
  Else
    Call LnkSofKB_SendInteger(&H4001, V_BStoreAddr, V_BStoreVal)
  End If
End Sub
Private Sub K_LStoreData_Click()
  Call LnkSofKB_SendLongint(&H4001, V_BStoreAddr, V_BStoreVal)
End Sub
Private Sub K_DTStoreData_Click()
Dim DT As Date
'MsgBox ("Zatim neimplementovano!")
'Exit Sub
  DT = CDate(V_DTStoreVal)
  Debug.Print "zadane datum=" & DT
  Call LnkSofKB_SendDateTime(&H4001, V_BStoreAddr, DT)
End Sub
Private Sub K_SStoreData_Click()
  Dim SS As String
  If IsNull(V_SStoreVal) Then
    SS = ""
  Else
    SS = CStr(V_SStoreVal)
  End If
  Call LnkSofKB_SendString(&H4001, V_BStoreAddr, SS)
End Sub

Private Sub K_DEBUG_Click()
  Call LnkSofMA_ExecSetDebugMode
End Sub

Private Sub K_RStoreData_Click()
   Call LnkSofKB_SendReal(&H4001, V_RStoreAddr, V_RStoreVal)
End Sub

Private Sub V_PERIOD_AfterUpdate()
 Me.TimerInterval = V_PERIOD
End Sub


Private Sub ppp()
Dim DT As Date
  DT = CDate(V_DTStoreVal)
  Debug.Print DT
End Sub

