unit Ext_LnkSofMA;

    {============================================================}
    {                                                            }
    {   LnkSofMA - Delphi 32              V1.00  17.11.1999      }
    {                                                            }
    {   Deklarace zakladnich typu pro praci s protokolem SofL2   }
    {                                                            }
    {   Interface pro komunikacni DLL LnkSofMA.DLL               }
    {                                                            }
    {   (C) 1999, SofCon s.r.o., Radomir Bukovsky                }
    {                                                            }
    {============================================================}

{$A-} { alignment of fields in record types - zarovnani vypnuto! }

interface

uses Windows; { Vazba na MS Windows }

(*
  Dulezite upozorneni:
  -------------------

  Pro cinnost knihovny "LnkSofMA.DLL" je nezbytny INI-soubor "LnkSofMA.INI".
  Jmeno INI souboru musi byt stejne jako knihovny DLL avsak s priponou INI,
  tj. LnkSofMA.INI. Soubor knihovny DDL a jeji INI soubor musi lezet v adresari,
  ve kterem lezi EXE program, ktery knihovnu LnkSofMA.DLL vola.
  V INI-souboru se nastavuji parametry objektu komunikacniho kanalu.

*)

const
{=======================================================================================}
{           S l e d o v a n i   O n - L i n e   p a r a m e t r u                       }
{=======================================================================================}
{ kod prikazu                typ parametru prikazu  Destination <-- Source   popis      }
{---------------------------------------------------------------------------------------}
gcmd_None       = $00; { prazdny prikaz }
gcmd_Abort      = $01; { prikaz pro uvedeni automatu do klidu z lib. stavu(nerusi jej!) }
gcmd_DoneReq    = $02; { prikaz pro zruseni procesu (pred gcmd_Done nemusi
                         predchazet gcmd_Abort)  }
gcmd_Result     = $03; { TGCmd_Result  Vysledek operace (0=O.K., >0=chyba) }
gcmd_Timeout    = $05; { zprava po vycerpani timeoutu }

gcmd_GetParamVal= $40; { T???_GetParamVal SLV <-  MAS zadost o parametr/parametry }

gcmd_PutParamVal= $41; { T???_ParamValue  SLV <-> MAS zapis parametru/parametru   }

type
{---------------------------------------------------------------------------------------}
{       uvodni blok (hlavicka) kazde zpravy prenasene protokolem SofL2                  }
{---------------------------------------------------------------------------------------}
TProcIdent      = byte;     { typ identifikatoru procesu ve zprave                     }
TProcInst       = byte;     { typ instance procesu ve zprave                           }
TProcLogA       = word;     { typ logicke adresy ve zprave                             }
TPMCode         = byte;     { typ kodu zpravy                                          }

TProcAddr       = record         { --- celkem  (4) byty ------------------------------ }
                    XIdent       :TProcIdent; {(1) identifikator procesu               }
                    XInst        :TProcInst;  {(1) cislo instance procesu              }
                    XLogA        :TProcLogA;  {(2) logicka adresa                      }
                  end;

TProcMessHeader = record         { --- celkem (14) bytu ------------------------------ }
                    BuffSize     :word;      {(2) delka vcetne nasledujicich Data      }
                    DDETrans     :byte;      {(1) ddet_xxxx (vyuziti pro DDE)          }
                    Destin       :TProcAddr; {(4) adresa prijemce                      }
                    Source       :TProcAddr; {(4) adresa odesilatele                   }
                    MNo          :byte;      {(1) cislo vysilane zpravy                }
                    ANo          :byte;      {(1) cislo posledni prijate zpravy        }
                    MCode        :TPMCode;   {(1) identifikator/kod prikazu zpravy     }
                  end;

(*
  Zprava prenasena protokolem SofL2:
  ==================================

                       1      1
                    +======+=====+======================================================+
               DF1  | CODE |MCode| ################### REC ############################ |
 SofCon Level2      +------+-----+------+------+------+-----+-----+-----+---------------+
               DF2  | CODE | LEN | DUMM | DEST | SOUR | MNo | ANo |MCode| #### REC #### |
                    +======+=====+======+======+======+=====+=====+=====+===============+
                       1   |  2     1      4      4      1     1     1  |  LEN-14       |
                           |<--------- TProcMessHeader (14) ----------->|<-Datova cast->|

 vyznam bytu CODE  |7|6|5|4|3|2|1|0| {bity}
 v SofCon Level1   |FRM|DATx |ACKx |

 Byte CODE v sobe nese 3 informace:
  1) format prenasenych dat FRM
       00 - test spojeni (zadna data)
       01 - DF1 = data ve formatu 1  [CODE|CMD]
       10 - DF2 = data ve formatu 2  [CODE|LEN|DUMM|DEST|SOUR|MNo|ANo|Cmd|# REC #]
       11 - nepouzito
  2) cislo packetu CDATA
       000 - DAT0 = neposilana zadna zprava CDATA
       001 -
       ... - DATx (x in [001..110]) posilana zprava CDATA cislo 1 az 6, vyzadovan ACK
       110 -
       111 - DAT7 posilana zprava CDATA cislo 7, NEvyzadovan ACK
  3) cislo potvrzeni ACK
       000 - ACK0 = neposilano zadna potvrzeni
       001 -
       ... - ACKx (x in [001..110]) posilano potvrzeni ACK na doslou zpravu cislo 1 az 6
       110 -
       111 - ACK7 posilano negativni potvrzeni (NAK)

  Datova cast zpravy je poplatna vyuziti v aplikaci, kde je protokol pouzit.

*)

{---------------------------------------------------------------------------------------}
{            T y p y   d a t o v y c h   z p r a v                                      }
{---------------------------------------------------------------------------------------}
{ 1. Obecne }
const
  g_nevimco          = 1000;  { promenna horni mez pro dynamicke pole parametru }
  g_ResultSzMaxIndx  =   64;  { max. delka textu chyboveho hlaseni ve zprave    }

type
  { Typ datove casti potvrzovaci zpravy, kterou SLAVE potvrzuje (ResultCode=0)
    bezchybne akceptovani, nebo hlasi chybu (ResultCode<>0). V polozce ResultSz
    muze SLAVE predat text chyboveho hlaseni }
  Tgcmd_Result  = record    { zprava muze byt promenne delky dle ResultSz }
    ResultCode :word;   { 0=OK, ostatni kod chyby }
    ResultSz   :array[0..g_ResultSzMaxIndx] of char; { null terminated str }
  end;


{---------------------------------------------------------------------------------------}
{            T y p y   d a t o v y c h   z p r a v                                      }
{---------------------------------------------------------------------------------------}
{ 2. Pro Kit-Builder                                                                    }

{=======================================================================================}
{  D e s c r i p t o r   z a z n a m u   v   a r c h i v u   K i t - B u i l d e r u    }
{=======================================================================================}
{       |DscrMskByte0|DscrMskByte1|...|DscrMskByteN|                                    }
{       descriptor ma stejnou delku jako jim popisovany zaznam                          }
type
  TDscrMsk_Type    =byte;
const  { konstanty pro vytvareni descriptoru zaznamu }
  DscrMsk_First    =$10;   { bit oznacujici 1. byte parametru }
  DscrMsk_TypPol   =$0F;   { maska na bity oznacujici typ polozky }
  DscrMsk_undef    =$00;   { dosud nedefinovany byte masky }

  DscrMsk_byte     =1;     { parametr = byte    nebo pole bytu     }
  DscrMsk_word     =2;     { parametr = word    nebo pole wordu    }
  DscrMsk_integer  =3;     { parametr = integer nebo pole integeru }
  DscrMsk_longint  =4;     { parametr = longint nebo pole longintu }
  DscrMsk_dword    =5;     { parametr = dword   nebo pole dwordu  ~ double word }
  DscrMsk_string   =6;     { parametr = pascalsky string }
  DscrMsk_real     =7;     { parametr = pascalsky 6-ti byte real  }
  DscrMsk_DosDaTi  =8;     { parametr = longint chapany jako MS-DOS PackTime  }
  DscrMsk_Bit      =9;     { parametr = byte chapany po bitech 0..7 }

  DscrMsk_TypPolMax=9;     { maximalni pripustna hodnota typu polozky  }

type
  {-------------------------------------------------------------------------}
  {-------- Adresace bloku registru v Kit-Builderu -------------------------}
  {-------------------------------------------------------------------------}
  TKbd_BlockHeader = record  { identifikace bloku registru }
    TREC    :TDscrMsk_Type; { typ KitBulder registru }
    RADDR   :word;          { poc adresa bloku registru v KitBuilderu  }
    RCNT    :word;          { pocet registru v bloku ~ v poli registru }
  end;

  { Typ datove casti zpravy }
  TKbd_GetParamVal  = record { pozadavek na poslani bloku registru z KitBuilderu }
    RqBlockHd  :TKbd_BlockHeader; { pozadovany blok registru }
  end;

  { Typ datove casti zpravy }
  TKbd_PutParamValue= record { posilany blok registru do/z KitBuilderu }
    BlockHd  :TKbd_BlockHeader; { identifikace posilaneho bloku registru }
    RegBlock :array[0..g_nevimco] of byte; { posilany blok registru }
  end;
  {-------------------------------------------------------------------------}

{=======================================================================================}
{  I n t e r f a c e   p r o   k o m u n i k a c n i   D L L   L n k S o f M A . D L L  }
{=======================================================================================}
{ 1. Obecne sluzby knihovny LnkSofMA.DLL }

{-------------------------------------------------------------}
{ Fce preda identifikaci verze software knihovny LnkSofMA.DLL }
function  LnkSofMA_GetVersion(AVerBuff:PChar;AVerBuffSize:word):longint; stdcall; external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  Funkcni hodnota      ... binarni identifikace verze
  AVerBuff    :PChar;  ... Pointer na buffer, do ktereho Fce zapise textovou representaci
                           verze jako null terminated string
  AVerBuffSize:word    ... Velikost bufferu, omezuje delku predaneho stringu
}

{--------------------------------------------}
{ Nastaveni Debug Mode pro knihovnu LnkSofMA }
procedure LnkSofMA_SetDebugMode(ADM:longint;ASysfFl:byte);stdcall; external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  ADM        :longint; ... Mnozina bitu pro nastaveni debug vypisu
  ASysfFl    :byte     ... <>0 == pozadavek na zapisovani do *.TXS souboru
}

type
  { Typ bufferu predavaneho dialogu pro mastaveni DebugMode }
  TDebugDM_TrRec = record
    DebugDM_Value :longint; { mnozina bitu pro nastaveni debug vypisu }
    SysfFl_Value  :Boolean; { pozadavek zapisovani do *.TXS souboru   }
  end;

{-----------------------------------------------------------------------------------------}
{ Editace zaznamu typu TDebugDM_TrRec pomoci dialogu implementovaneho v knihovne LnkSofMA }
function  LnkSofMA_ExecDlgDebugDM(lpDebugDM_TrRec:pointer):integer; stdcall; external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  Funkcni hodnota                   ... 0=Cancel dialogu, <>0 =OK v dialogu
  lpDebugDM_TrRec :^TDebugDM_TrRec; ... Pointer na editovany zaznam.
}

{-------------------------------------------------------}
{ Nastaveni Debug Mode knihovny LnkSofMA pomoci dialogu }
procedure LnkSofMA_ExecSetDebugMode;                    stdcall; external 'LnkSofMA.DLL';

{---------------------------------------------------------------------------------------}
{ 2. Sluzby knihovny LnkSofMA.DLL tykajici se komunikace prostrednictvim Master Automatu
     s protokolem SofL2 }
const
  { CallBack type = hodnoty parametru XTYP:word pro TSofMACallBackProc }
  CBTYPE_None       =0; { nedefinovany }
  CBTYPE_Connect    =1; { Master Automat oznamuje navazani komunikace, lpMessBuff^=Node }
  CBTYPE_DisConnect =2; { Master Automat oznamuje ztratu   komunikace, lpMessBuff^=Node }
  CBTYPE_Mess       =3; { Master Automat predava prijatou zpravu, lpMessBuff^="zprava"  }

type
  {---------------------------------------------------------------------}
  { Typ CallBack procedury, kterou LnkSofMA.DLL predava prijatou zpravu }
  TSofMACallBackProc = procedure (XTYP:word;lpMessBuff:pointer;wMessLen:Word);   stdcall;
  { Vyznam parametru:
    ----------------
    XTYP       :word;    ... Viz CBTYPE_XXX
    lpMessBuff :pointer; ... Pointer na pocatek bufferu
    wMessLen   :Word     ... Delka platnych dat v Bufferu, tj. delka zpravy

    Poznamka:
       Je-li (XTYP=CBTYPE_Connect) nebo (XTYP=CBTYPE_DisConnect) pak parametr
    lpMessBuff ukazuje na promennou z hodnotou NODE Slave stanice na siti,
    se kterou bylo navazano spojeni, resp. se kterou bylo spojeni ztraceno/zruseno.
       Je-li (XTYP=CBTYPE_Mess) pak parametr lpMessBuff ukazuje na buffer s prijatou
    zpravou z komunikacni linky a wMessLen je delkou zpravy. Ukazatel lpMessBuff
    ukazuje na hlavicku zpravy typu :TProcMessHeader. Za hlavickou nasleduje
    datova cast zpravy.

    Telo CallBack procedury pise uzivatel knihovny LnkSofMA.DLL ve sve aplikaci
    a ve svem programovacim jazyce!
  }

{------------------------------------------------------------------------------------}
{ Vytvoreni instance Master Automatu protokolu SofL2 a otevreni komunikacniho kanalu }
procedure LnkSofMA_ChannelCreate(ASofMACallBackProc:TSofMACallBackProc;
                                 ASofMANotifWndHandle:HWND;
                                 ASofMANotifUserMsg  :Cardinal); stdcall; external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  a)
  ASofMACallBackProc  :TSofMACallBackProc; ... Adresa CallBack procedury, kterou
                                               Master Automat komunikace zavola pri:
                                               - navazani komunikace
                                               - zruseni/ztrate komunikace
                                               - prijmu zpravy z komunikacni linky
  b)
  ASofMANotifWndHandle:HWND;               ... Handler okna, pro prijem User_Message
  ASofMANotifUserMsg  :Cardinal;           ... Kod User_Message

  Poznamka:
      Master Automat muze predavat prijatou zpravu z komunikacni linky bud prostrednictvim
  CallBack procedury, nebo prostrednictvim poslani User_Message na definovane okno.
  Pokud je zadana CallBack procedura je pouzivana tato CallBack procedura bez ohledu
  na to zda byl predan Handle okna a User_Message. Ma-li byt pouzivana User_Message,
  je treba zadat ASofMACallBackProc=nil.

  Zasilana User_Message ma definovany polozky wParam a lParam nasledovne:
    Msg.wParam = CBTYPE_XXX ... typ volani, identifikace dat v bufferu
    Msg.lParam = pointer na buffer, viz popis lpMessBuff pro TSofMACallBackProc

  c)
  Neni zadana CallBack procedura ani Handle okna a User_Mess:
   ASofMACallBackProc   =nil;
   ASofMANotifWndHandle = 0;
   ASofMANotifUserMsg   = 0;

     V tomto pripade je treba pouzivat pro prijem zpravy vyber zpravy z OutputFIFO.
   Dotazovani na stav OutputFIFO je treba provadet periodicky volanim funkce
   "LnkSofMA_QOutFIFOEmpty", vyber zpravy z OutputFIFO zavolanim funkce
   "LnkSofMA_GetFromOutFIFO(...)"

   Priklad:
     ...
    var QXTYP       :word;
        MyMessBuff  :array[0..1000] of byte;
        MessLen     :word;
    begin
      if LnkSofMA_QOutFIFOEmpty=ord(false) then
      begin
        MessLen:=LnkSofMA_GetFromOutFIFO(QXTYP,Addr(MyMessBuff),SizeOf(MyMessBuff));
        case QXTYP of
          CBTYPE_Connect:
            begin
              ...
            end;
          CBTYPE_DisConnect:
            begin
              ...
            end;
          CBTYPE_Mess:
            begin
              ...
            end;
        end;
        ....
      end;
    ...
    end;

}

{-----------------------------------------------------}
{ Zruseni instance Master Automatu s protokolem SofL2 }
procedure LnkSofMA_ChannelDestroy;                      stdcall; external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  Dojde u ukonceni komunikace z komunikacni kanal je zrusen. Operace regularniho
  ukonceni muze nejakou dobu trvat, proto je hlidana timeoutem.
}

const chtMA_None  =0;
      chtMA_COM   =1; { Komunikacni kanal inicializovan jako TComChannel      }
      chtMA_MODEM =2; { Komunikacni kanal inicializovan jako TComModemChannel }

{------------------------------------------------------}
{ Funkce vracejici typ pouziteho kanalu viz. chtMA_XXX }
function  LnkSofMA_ChannelType:byte;                    stdcall; external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  Funkcni hodnota      ... chtMA_None  =0;
                           chtMA_COM   =1;
                           chtMA_MODEM =2;

}

{-------------------------------------}
{ Vyslani zpravy na komunikacni kanal }
function  LnkSofMA_MessTxD(lpMessBuff:pointer;wMessLen:word):integer; stdcall; external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  Funkcni hodnota      ... 0=Vyslani OK, <>0 =chyba, kod chyby
  lpMessBuff :pointer; ... Pointer na pocatek bufferu
  wMessLen   :Word     ... Delka platnych dat v Bufferu, tj. delka zpravy

     Parametr lpMessBuff ukazuje na buffer se zpravou urcenou k odbysilani.
  Parametr wMessLen je delkou zpravy. Ukazatel lpMessBuff ukazuje na hlavicku
  zpravy typu :TProcMessHeader. Za hlavickou nasleduje datova cast zpravy.

     Funkce zapise zpravu do fronty zprav urcenych k odvysilani a vrati rizeni
  zpet do aplikace, odkud byla zavolana. Master Automat se postara o vyslani
  zpravy "na pozadi aplikace".
}

{---------------------------------------------------------------------------}
{ Vydani pozadavku na odpojeni komunikace, u modemu prikaz k zaveseni linky }
procedure LnkSofMA_DisConnectRq;                        stdcall; external 'LnkSofMA.DLL';

{----------------------------------------------------------------------------------------}
{ Vydani pozadavku na otevreni komunikace, u modemu prikaz k vytaceni a navazani spojeni }
procedure LnkSofMA_ConnectRq;                           stdcall; external 'LnkSofMA.DLL';

const
  { Identifikace stabilnich stavu Master Automatu }
  BAS_Closed       =0; { Vychozi stav, komunikacni kanal uzavren }
  BAS_Opened       =1; { Komunikacni kanal otevren, tj. inicializovan COM port }
  BAS_Connected    =2; { Spojeni navazano, bezi komunikace, Master Automat udrzuje spojeni }
  BAS_DisConnected =3; { Spojeni zruseno/ modem zavesen , Master Automat ceka na prikaz }

{------------------------------------------------------------}
{ Funkce vraci identifikaci stabilniho stavu Master Automatu }
function  LnkSofMA_GetMABaseState:word;             stdcall; external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  Funkcni hodnota       ... identifikace stavu Master Automatu, viz. popis BAS_XXXX
}

{-------------------------------------------------------------------}
{ Funkce vraci hodnotu flagu pripojeni zadane Slave stanice na siti }
function  LnkSofMA_GetSLConnectFlg(ANode:byte):byte; stdcall; external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  Funkcni hodnota      ... ord(false) =0 = stanice odpojena, nekomunikuje
                           ord(true)  =1 = stanice pripojena, komunikuje
  ANode       :byte;   ... Node pozadovane Slave stanice na siti
}

{----------------------------------------------------------------}
{ Funkce vraci hodnoty citacu zprav zadane Slave stanice na siti }
procedure LnkSofMA_GetSLMessCounters(ANode:byte;
                                     lpOKCounter,lpRepCounter:pointer);stdcall;external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  ANode         :byte;      ... Node pozadovane Slave stanice na siti
  lpOKCounter   :^longint;  ... ukazatel na promennou typu longint, do ktere bude
                                zapsana hodnota citace prenesenych zprav
  lpRepCounter  :^longint;  ... ukazatel na promennou typu longint, do ktere bude
                                zapsana hodnota citace opakovani prenosu zprav
}

{------------------------------------------------------------------------------}
{ Funkce pro vyzvednuti zpravy z fronty Master Automatem prijatych (RxD) zprav }
function LnkSofMA_GetFromOutFIFO(var XTYP:word;
                                 lpOutBuff:pointer;wOutBuffSize:Word):word;stdcall;external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  Funkcni hodnota        ... delka prevzate zpravy do bufferu lpOutBuff^
  XTYP         :word;    ... promenna do ktere bude zapsana hodnota CBTYPE_XXX, identifikujici
                             prevzatou zpravu
  lpOutBuff    :pointer; ... ukazatel na buffer pro prevzeti zpravy
  wOutBuffSize :Word     ... delka bufferu pro prevzeti zpravy

  Funkci je treba predat adresu promenne pro prevzeti CBTYPE_XXX a adresu a velikost
  bufferu pro prevzeti zpravy.
}

{----------------------------------------------------------------------------------}
{ Funkce vracejici informaci o stavu fronty Master Automatem prijatych (RxD) zprav }
function LnkSofMA_QOutFIFOEmpty:byte;                    stdcall;external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  Funkcni hodnota        ... ord(0)=false = fronta obsahuje polozky
                             ord(1)=true  = fronta je prazdna
}

{-------------------------------------------------------------------------------------}
{ Pomocna funkce cekajici v dialogu na prijeti zpravy do fronty prijatych (RxD) zprav }
function LnkSofMA_WaitForFIFO(dwTimeOut:longint):integer;stdcall;external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  Funkcni hodnota        ... 0 = mrNone   ... bez vyznamu
                             1 = mrOK     ... FIFO obsahuje zpravu
                             2 = mrCancel ... uplynuti timeout
                             3 = mrAbort  ... preruseno explicitne operatorem
  dwTimeOut:longint;     ... timeout (casovy limit) v [ms]

  Cinnost funkce:
     Pokud fronta FIFO obsahuje zpravu, fce vrati hodnotu mrOK.
     Pokud fronta FIFO neobsahuje zpravu, je otevren modalni dialog s tlacitkem
  ABORT, ve kterem se ceka na prijeti zpravy do FIFO nebo na uplynuti timeoutu.
  Stisknutim tlacitka ABORT lze cekani ukoncit explicitne.
     Funkce vrati rizeni do volajici aplikace az pro prijmu zpravy do FIFO nebo
  po uplynuti timeoutu.

  Pouziti funkce:
     Smyslem teto funkce je realizovat cekaci smycku na prijem zpravy v systemech,
  ve kterych je implementace takoveto smycky vlastnimi prostredky neresitelna nebo
  velmi obtizna ci neefektivni. Po dobu cekani je treba umoznit cinnost Windows!
     Tuto funkci bychom meli pouzivat pouze pri ladeni, kdy nam poskytuje moznost
  preruseni tlacitkem ABORT. Ve vyslednem kodu je lepe pouzit funci
  "LnkSofMA_QuietWaitForFIFO", ktera realizuje totez bez otevreneho dialogu.
}

{-------------------------------------------------------------------------------------}
{ Pomocna funkce cekajici v dialogu na prijeti zpravy do fronty prijatych (RxD) zprav }
function LnkSofMA_QuietWaitForFIFO(dwTimeOut:longint):integer;  stdcall;external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  viz popis funkce "LnkSofMA_WaitForFIFO"

  Tato funkce po dobu cekani neotvira modalni dialog, ale pouziva specialni
  Message Loop s funkci PeekMessage() (* Application.ProcessMessages; viz. Delphi *).
}


{------------------------------------------------------}
{ Procedura otevre plovouci okenko pro ovladani modemu }
procedure LnkSofMA_OpenModemOVLForm;                     stdcall;external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  Funkce otevre okenko, ve kterem je mozno sledovat cinnost modemu, zadat telefonni
  cislo, vytacet a zavesit modem. Zadana telefonni cisla lze explicitne ulozit
  do INI-souboru "LnkSofMA.INI" do sekce s parametry modemu.
}

{---------------------------------------------------------------------------------------}
{          P o m o c n e    f u n k c e                                                 }
{---------------------------------------------------------------------------------------}
type PRealp  =^Real48; { 6-ti bytovy real pouzivany v PASCALU a v Kit-Buideru }
     PSingle =^Single; { 4-bytovy real standardni }
     PDouble =^Double; { 8-bytovy real standardni }

{---------------------------------------------------------------}
{ Pomocna finta pro pretypovani - vraci hodnotu sveho parametru }
function LnkSofMA_PtrToPChar(APtr:pointer):PChar;        stdcall;external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  Funkcni hodnota        ... APtr as PChar
  APtr :pointer;         ... hodnota ukazatele

  Pouziti funkce:
     Funkce slouzi k "osaleni" typove kontroly.
  V aplikaci, ktera je napsana v jazyku se striktni typovou kontrolou muzeme tuto
  funkci deklarovat s vice hlavickami, a tak uspokojit typovou kontrolu.
     Mapriklad macro jazyk v 602ProSuite\602Text pouziva duslednou typovou
  kontrolu domenovych typu ukazatelu.


  Priklad: (Macro 602Text-zacatek prikladu --------------------------------)
  type
    tString255=string[255];
    pString255=^tString255;

    TGetParamValMess = record
      HED :TProcMessHeader;
      REC :TKbd_GetParamVal;
    end;
    PGetParamValMess=^TGetParamValMess;

    TPutParamValMess=record
      HED :TProcMessHeader;
      REC :TKbd_PutParamVal;
    end;
    PPutParamValMess=^TPutParamValMess;

  (* Finta pro pretypovani na universalni PChar *)
  function  PtrStr255ToPChar(APtr:pString255):PChar;
  external "LnkSofMA.DLL" name "LnkSofMA_PtrToPChar";

  (* Finta pro pretypovani na universalni PChar *)
  function  GetParamValMessToPChar(APtr:PGetParamValMess):PChar;
  external "LnkSofMA.DLL" name "LnkSofMA_PtrToPChar";

  (* Finta pro pretypovani na universalni PChar *)
  function  PutParamValMessToPChar(APtr:PPutParamValMess):PChar;
  external "LnkSofMA.DLL" name "LnkSofMA_PtrToPChar";

  (Macro 602Text-konec prikladu-----------------------------------------)

}

function LnkSofMA_BytePtrToByte(APtr:pointer):byte;                              stdcall;external 'LnkSofMA.DLL';
function LnkSofMA_WordPtrToDWord(APtr:pointer):longword;                         stdcall;external 'LnkSofMA.DLL';
function LnkSofMA_IntPtrToLInt(APtr:pointer):longint;                            stdcall;external 'LnkSofMA.DLL';
function LnkSofMA_LIntPtrToLInt(APtr:pointer):longint;                           stdcall;external 'LnkSofMA.DLL';
function LnkSofMA_FDatePtrToDate(APtr:pointer):TDateTime;{Double}                stdcall;external 'LnkSofMA.DLL';
procedure LnkSofMA_DWordToWordPtr(ADWord:longword;APtr:pointer);{^.word}         stdcall;external 'LnkSofMA.DLL';
procedure LnkSofMA_IntToIntPtr(AInt:Short;APtr:pointer);        {^.short}        stdcall;external 'LnkSofMA.DLL';
procedure LnkSofMA_LIntToLIntPtr(ALInt:longint;APtr:pointer);   {^.longint}      stdcall;external 'LnkSofMA.DLL';
procedure LnkSofMA_DateToFDatePtr(ADateTime:TDateTime;APtr:pointer);{^.FDate}    stdcall;external 'LnkSofMA.DLL';
procedure LnkSofMA_PStrToSzStr(InPStr:pointer;OutSzBuff:PChar;OutSzBuffSize:word);stdcall;external 'LnkSofMA.DLL';
procedure LnkSofMA_SzStrToPStr(InSzStr:PChar;OutPStrBuff:pointer;OutPStrBuffSize:word);stdcall;external 'LnkSofMA.DLL';

{---------------------------------------------------------------------------------}
{ Skupina funkci pro prevod do textoveho retezce - vraci delku vysledneho retezce }
function LnkSofMA_ByteStrHex(B:Byte;OutStr:PChar;MaxLen:word):word;              stdcall;external 'LnkSofMA.DLL';
function LnkSofMA_WordStrHex(W:Word;OutStr:PChar;MaxLen:word):word;              stdcall;external 'LnkSofMA.DLL';
function LnkSofMA_LongIntStrHex(L:LongInt;OutStr:PChar;MaxLen:word):word;        stdcall;external 'LnkSofMA.DLL';
function LnkSofMA_PointerStrHex(P:pointer;OutStr:PChar;MaxLen:word):word;        stdcall;external 'LnkSofMA.DLL';
function LnkSofMA_BufferStrHex(P:pointer;L:word;OutStr:PChar;MaxLen:word):word;  stdcall;external 'LnkSofMA.DLL';
function LnkSofMA_RealStrDec(R:PRealp;Len:Byte;Flt:Byte;OutStr:PChar;MaxLen:word):word;stdcall;external 'LnkSofMA.DLL';
function LnkSofMA_RealStrExp(R:PRealp;Len:Byte;OutStr:PChar;MaxLen:word):word;   stdcall;external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  Funkcni hodnota        ... delka vysledneho null terminated retezce
  XXX         :TXXX;     ... hodnota, ktera bude prevadena na string
  OutStr      :PChar;    ... ukazatel na buffer do ktereho bude zapsan null terminated string
  MaxLen      :word      ... (velikost ciloveho bufferu-1), maximalni mozna delka ciloveho stringu

  Popis funkce:
     Prevede hodnotu na hexadecimalni zobrazeni a vysledek preda do zadaneho
  bufferu pro null terminated string.
}

{-----------------------------------------------------------------------------------------}
{ Procedury pro konverzi real typu - parametry jsou ukazatele na array[0..Cnt-1] of realX }
procedure LnkSofMA_ConvertReal6To4(R:PRealp;S:PSingle;Cnt:word);  stdcall;external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  R   :PRealp;    ... ukazatel na zdrojove pole Pascalskych realu
  S   :PSingle;   ... ukazatel na cilove pole 4-bytovych realu
  Cnt :word       ... pocet hodnot v polich R^ a S^

  Popis funkce:
    Procedura prevede pole Pascalskych realu na cilove pole 4-bytovych realu
}

{--------------------------------------------------------------------------}
{ Procedura prevede pole Pascalskych realu na cilove pole 8-bytovych realu }
procedure LnkSofMA_ConvertReal6To8(R:PRealp;D:PDouble;Cnt:word);  stdcall;external 'LnkSofMA.DLL';

{--------------------------------------------------------------------------}
{ Procedura prevede pole pole 4-bytovych realu na pole Pascalskych realu   }
procedure LnkSofMA_ConvertReal4To6(S:PSingle;R:PRealp;Cnt:word);  stdcall;external 'LnkSofMA.DLL';

{--------------------------------------------------------------------------}
{ Procedura prevede pole pole 8-bytovych realu na pole Pascalskych realu   }
procedure LnkSofMA_ConvertReal8To6(D:PDouble;R:PRealp;Cnt:word);  stdcall;external 'LnkSofMA.DLL';


{---------------------------------------------------------------------------------------}
{ Pomocne funkce realizujici jeden casovac s CallBack Tick procedurou }
type TUserTimerCallBackProc = procedure; stdcall; { Typ uzivatelske CallBackProc }

{ Vytvoreni casovace }
procedure LnkSofMA_UserTimerCreate(APeriod:longword;
                                   AUserCallBackProc:TUserTimerCallBackProc;
                                   AEnabled:Boolean);        stdcall;external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  APeriod          :longword;               ... perioda volani AUserCallBackProc v [ms]
  AUserCallBackProc:TUserTimerCallBackProc; ... volana uzivatelova Tick CallBackProc
  AEnabled         :Boolean                 ... povoleni behu casovace
}

{ Povoleni behu casovace }
procedure LnkSofMA_UserTimerSetEnabled(AEnabled:Boolean);    stdcall;external 'LnkSofMA.DLL';
{ Vyznam parametru:
  ----------------
  AEnabled         :Boolean                 ... povoleni behu casovace On/Off
}

{ Zruseni casovace }
procedure LnkSofMA_UserTimerDestroy;                         stdcall;external 'LnkSofMA.DLL';

implementation

end.
