unit uString;

          {ͻ}
          {                                                        }
          {  unit uString                                          }
          {                                                        }
          {  jednotka pro dekodovn pkazov dky               }
          {                                                        }
          {  (C)1993 SofCon, Steovick 49, 160 00 Praha 6        }
          {          Ing. Vladimr Kastner, Na Vlovce 6, Praha 6  }
          {               Adam Wild, Dejvicka 42, Praha 6          }
          {                                                        }
          {ͼ}

{----------}
interface
{----------}

const
  Ver_uString = '2.34  19.01.1999';
    { verze knihovny }

type
  tCmdString  = String[128]; { stringovy typ pro retezec prikazove radky }
  pCmdString  = ^tCmdString;

  tParamStr   = String;      { stringovy typ pro retezec parametru }
  pParamStr   = ^tParamStr;

  tWordString = String[64];  { stringovy typ pro slovo ctene z retezce parametru a pro prevodni funkce }
  tString12   = String[12];  { stringovy typ pro retezec s 12-ti znaky }

type
  tCmd = class(TObject)
    Delimiters : set of Char; { mnozina oddelovacich znaku }
    CmdS       : tParamStr;   { dekodovany retezec parametru }
    CmdI       : Byte;        { ukazovatko do dekodovaneho retezce parametru }
    procedure InitCmdPar;
                { inicializace objektu tCmd podle prikazove radky z DOSu }
    procedure InitCmd(const S: tParamStr);
                { inicializace objektu tCmdL podle zadaneho retezce S }
    function  ReadRest       : tParamStr;
                { vrati zbytek dekodovaneho stringu CmdS }
    function  ReadWord       : tWordString;
                { precte 1 slovo z dekodovaneho stringu CmdS a vrati ho jako fnc. hodnotu }
    function  ReadWordUpCase : tWordString;
                { to same jako ReadWord + prevod na UpCase }
    function  ReadString     : tCmdString;
                { precte retezec ('...') z dekodovaneho stringu CmdS a vrati ho jako fnc. hodnotu }
    function  ReadElement    : tCmdString;
                { precte obecny element (xxx, '...' nebo "...") z dekodovaneho stringu CmdS }
    function  ReadElement1   : tCmdString;
                { precte obecny element (xxx, '...' vcetne' nebo "..." vcetne") z dekod. stringu CmdS }
    procedure ReadLVal(var V: longint; var ErrFl: Boolean);
                { cteni ciselne hodnoty z dekod. stringu CmdS }
    procedure ReadRVal(var V: real;    var ErrFl: Boolean);
                { cteni ciselne hodnoty z dekod. stringu CmdS }
  end;

function LStr(L : Longint)           : tWordString;
         { prevod Longintu na String
           (totez jako IntToStr(L) }
function RStr(R : Real; A, B : Byte) : tWordString;
         { prevod Realu na String
           (totez jako NumToStr.RealStrExp(R,A,B)) }
function PtrStr(P : Pointer) : tString12;
         { prevod Pointeru na String
           (totez jako NumToStr.PtrToStr(P)) }

function UpCaseStr(const S : String) : String;
         { prevode zadany string na velka pismena - jen pro kompatibilitu, lepe pouzivat
           AnsiUpperCase}

function EquStr(var S, D; L : word) : Boolean;
         { test shodnosti 2 objektu }
         { S - poc.adresa 1. objektu
           D - poc.adresa 2. objektu
           L - jejich delka (<=65535)
           (podobne jako CompareStr(const S1, S2: string): Integer;
                    nebo CompareMem(P1, P2: Pointer; Length: Integer): Boolean; ) }

function NDelim(Slovo: tWordString; const TabDelim: String): Byte;
         { funkce vyhleda string Slovo v tabulce klicovych slov TabDelim
           a vrati jeho poradi v TabDelim (0 = Slovo nenalezeno) }
         { jednotliva klicova slova v TabDelim musi mit stejnou delku
           a musi byt navzajem oddelena znakem '|' }

function AddParamStr(BaseParamStr: tParamStr; const NewParamStr: tParamStr): tParamStr;
         { BaseParamStr - puvodni retezec s parametry (napr: "NAM=COM COM=1 IRQ=4 PAR=N")
           NewParamStr  - retezec s novymi parametry  (napr: "PAR=O STO=1")
           -funkce vrati upraveny retezec parametru BaseParamStr podle NewParamStr,
           zmeni hodnoty jiz existujicich parametru v BaseParamStr
           a prida nove parametry z NewParamStr (napr vrati: "NAM=COM COM=1 IRQ=4 PAR=O STO=1") }
function SubParamStr(BaseParamStr: tParamStr; const NewParamStr: tParamStr): tParamStr;
         { BaseParamStr - puvodni retezec s parametry (napr: "NAM=COM COM=1 IRQ=4 PAR=N")
           NewParamStr  - retezec s novymi parametry  (napr: "PAR")
           -funkce vrati upraveny retezec parametru BaseParamStr podle NewParamStr,
           vymaze v BaseParamStr vsechny parametry i s jejich hodnotami, jejichz
           nazvy parametru se vyskytuji take v retezci NewParamStr
           (napr vrati: "NAM=COM COM=1 IRQ=4") }

{----------}
implementation
{----------}

uses
  SysUtils;

{ --------------------------------------------------- }
function LStr(L: Longint): tWordString;
var
  S : tWordString;
begin
  Str(L,S);
  LStr:=S;
end;

{ --------------------------------------------------- }
function RStr(R: Real; A, B: Byte): tWordString;
var
  S : tWordString;
begin
  Str(R:A:B,S);
  RStr:=S;
end;

{ --------------------------------------------------- }
function PtrStr(P: Pointer): tString12;
begin
{!Ka mozna chyba}
  PtrStr:='$'+IntToHex(Longint(P),8);
end;

{ --------------------------------------------------- }
function UpCaseStr(const S : String) : String;
begin
  UpCaseStr:=AnsiUpperCase(S);
end;

{ --------------------------------------------------- }
function EquStr(var S,D; L:word):Boolean;
type
  TBAS=array[0..65535]of byte;
var
  I:word;
begin
  I:=0;
  while (TBAS(S)[I]=TBAS(D)[I]) and (I<L) do Inc(I);
  EquStr:= I=L;
end;

{ --------------------------------------------------- }
function NDelim(Slovo: tWordString; const TABDelim: String): Byte;
{ funkce pro vyhledani Stringu Slovo v tabulce klicovych slov TABDelim. }
{ TABDelim je String, jednotliva slova jsou oddelena oddelovaci '|'.
  Delka slov v TABDelim je dana delkou 1. slova v TABDelim.
  Vystupem je
    - cislo 0, nebylo-li Slovo v TABDelim nalezeno
    - poradove cislo nalezeneho slova v TABDelim, je-li nalezeno (>0) }
const
  Delim='|';
var
  J,L,Cnt,Pom : Byte;
  PomSl       : tWordString;
begin
  Pom:=0;
  if Slovo<>'' then
  begin
    L:=Pos(Delim,TABDelim)-1;       { zjisteni sledovane delky klic. slova }
    PomSl:=Copy(Slovo,1,L);
    while Length(PomSl)<L do PomSl:=PomSl+' ';
    J:=1;
    Cnt:=1;
    while (Pom=0) and (J<Length(TABDelim)) do
    begin
      if PomSl=Copy(TABDelim,J,L) then Pom:=Cnt
      else
        begin
        Inc(Cnt);
        J:=J+L+1;
        end;
    end;
  end;
  NDelim:=Pom;
end;

{ --------------------------------------------------- }
function AddParamStr(BaseParamStr: tParamStr; const NewParamStr: tParamStr): tParamStr;
var
  CmdLBase,
  CmdLNew  : tCmd;
  PomSBase,
  PomSNew  : tWordString;
label
  L_01;
begin
  CmdLNew :=tCmd.Create;
  CmdLBase:=tCmd.Create;
  with CmdLNew do
  begin
    InitCmd(NewParamStr);
    if not ('=' in Delimiters) then
      Include(Delimiters,'=');
    { precte se prvni parametr z NewParamStr }
    PomSNew:=ReadWordUpCase;
  end;
  while PomSNew<>'' do
    with CmdLBase do
    begin
      InitCmd(BaseParamStr);
      if not ('=' in Delimiters) then
        Include(Delimiters,'=');
      { precte se prvni parametr z BaseParamStr }
      PomSBase:=ReadWordUpCase;

     L_01:
     { cyklus az do najiti stejneho parametru }
      while (PomSBase<>'') and (PomSBase<>PomSNew) do
        { precte se dalsi parametr z BaseParamStr }
        PomSBase:=ReadWordUpCase;

     { byl nalezen stejny parametr ? }
      if PomSBase=PomSNew then { parametr nalezen }
        begin { zmeni se jeho hodnota }
         { test jedna-li se o hodnotu parametru ci o nazev parametru
           pokud se jedna pouze o hodnotu nesmi se nic provest }
          while (CmdI<=Length(CmdS))and(CmdS[CmdI] in Delimiters)and
                (CmdS[CmdI]<>'=') do Inc(CmdI);
          if CmdI>Length(CmdS) then Dec(CmdI);
          if CmdS[CmdI]<>'=' then
            begin { nalezeny parametr neni parametr ale hodnota }
              PomSBase:=ReadWordUpCase;
              goto L_01; { hleda se dale }
            end;
         { vymazani delicich znaku pred hodnotou parametru }
          while (CmdI<=Length(BaseParamStr)) and
                (BaseParamStr[CmdI] in Delimiters) do
            Delete(BaseParamStr,CmdI,1);
         { vymazani hodnoty parametru az do delicich znaku }
          while (CmdI<=Length(BaseParamStr)) and
                (not (BaseParamStr[CmdI] in Delimiters)) do
            Delete(BaseParamStr,CmdI,1);
         { vlozeni nove hodnoty parametru }
          Insert('='+CmdLNew.ReadWordUpCase,BaseParamStr,CmdI);
        end
      else { parametr nenalezen }
        begin
          { neznamy parametr i s hodnotou se prida na konec }
          BaseParamStr:=BaseParamStr+' '+PomSNew+'='+CmdLNew.ReadWordUpCase;
        end;
      { precte se dalsi parametr z NewParamStr }
      PomSNew:=CmdLNew.ReadWordUpCase;
    end;
  CmdLNew .Free;
  CmdLBase.Free;
  AddParamStr:=BaseParamStr;
end;

{ --------------------------------------------------- }
function SubParamStr(BaseParamStr: tParamStr; const NewParamStr: tParamStr): tParamStr;
var
  CmdLBase,
  CmdLNew  : tCmd;
  PomSBase,
  PomSNew  : tWordString;
label
  L_01;
begin
  CmdLNew :=tCmd.Create;
  CmdLBase:=tCmd.Create;
  with CmdLNew do
  begin
    InitCmd(NewParamStr);
    if not ('=' in Delimiters) then
      Include(Delimiters,'=');
    { precte se prvni parametr z NewParamStr }
    PomSNew:=ReadWordUpCase;
  end;
  while PomSNew<>'' do
    with CmdLBase do
    begin
      InitCmd(BaseParamStr);
      if not ('=' in Delimiters) then
        Include(Delimiters,'=');
      { precte se prvni parametr z BaseParamStr }
      PomSBase:=ReadWordUpCase;

     L_01:
     { cyklus az do najiti stejneho parametru }
      while (PomSBase<>'') and (PomSBase<>PomSNew) do
        { precte se dalsi parametr z BaseParamStr }
        PomSBase:=ReadWordUpCase;

     { byl nalezen stejny parametr ? }
      if PomSBase=PomSNew then { parametr nalezen }
        begin { vymaze se i s hodnotou }
         { test jedna-li se o hodnotu parametru ci o nazev parametru
           pokud se jedna pouze o hodnotu nesmi se nic provest }
          while (CmdI<=Length(CmdS))and(CmdS[CmdI] in Delimiters)and
                (CmdS[CmdI]<>'=') do Inc(CmdI);
          if CmdI>Length(CmdS)  then Dec(CmdI);
          if CmdS[CmdI]<>'=' then
            begin { nalezeny parametr neni parametr ale hodnota }
              PomSBase:=ReadWordUpCase;
              goto L_01; { hleda se dale }
            end;
         { vymazani delicich znaku pred hodnotou parametru }
          while (CmdI<=Length(BaseParamStr)) and
                (BaseParamStr[CmdI] in Delimiters) do
            Delete(BaseParamStr,CmdI,1);
         { vymazani hodnoty parametru az do delicich znaku }
          while (CmdI<=Length(BaseParamStr)) and
                (not (BaseParamStr[CmdI] in Delimiters)) do
            Delete(BaseParamStr,CmdI,1);
          if CmdI>0 then Dec(CmdI);
         { vymazani delicich znaku za nazvem parametru }
          while (CmdI>0)and
                (BaseParamStr[CmdI] in Delimiters) do
            begin
              Delete(BaseParamStr,CmdI,1);
              Dec(CmdI);
            end;
         { zpetne vymazani nazvu parametru }
          while (CmdI>0) and
                (not (BaseParamStr[CmdI] in Delimiters)) do
            begin
              Delete(BaseParamStr,CmdI,1);
              Dec(CmdI);
            end;
         { vymazani prebitecneho deliciho znaku }
          if CmdI=0 then CmdI:=1;
          if BaseParamStr[CmdI] in Delimiters then
            Delete(BaseParamStr,CmdI,1);
        end
      else { parametr nenalezen }
        begin
          { nic se nemaze }
        end;
      { precte se dalsi parametr z NewParamStr }
      PomSNew:=CmdLNew.ReadWordUpCase;
    end;
  CmdLNew .Free;
  CmdLBase.Free;
  SubParamStr:=BaseParamStr;
end;

{=============== object tCmd ===============}
procedure tCmd.InitCmdPar;
begin
{!Ka}
  CmdS:='';
  CmdI:=1;                { nastaveni ukazovatka na pocatek prikazove radky }
  Delimiters:=[#00..' ','='];
end;
{-------------------------------------------}
procedure tCmd.InitCmd(const S: tParamStr);
begin
  CmdS:=S;
  CmdI:=1;
  Delimiters:=[#00..' ','='];
end;
{-------------------------------------------}
function tCmd.ReadWord: tWordString;
var
  IB : Byte;
  Fl : Boolean;
begin
  while (CmdI<=Length(CmdS)) and (CmdS[CmdI] in Delimiters) do Inc(CmdI);
  if CmdI>Length(CmdS) then
    ReadWord:=''
  else
  begin
    { Pokud se budete divit, co se to deje se znakem '|',
      nedivte se. Je to z duvodu potreb komunikacnich knihoven.
      Znak '|' se totiz bere zaroven jako oddelovac i jako slovo. }
    IB:=CmdI;
    Fl:='|' in Delimiters;
    Include(Delimiters,'|');
    if CmdS[CmdI]='|' then
      Inc(CmdI)
    else
      while (CmdI<=Length(CmdS)) and (not(CmdS[CmdI] in Delimiters)) do Inc(CmdI);
    ReadWord:=Copy(CmdS,IB,CmdI-IB);
    if not Fl then
      Exclude(Delimiters,'|');
  end;
end;
{-------------------------------------------}
function tCmd.ReadWordUpCase: tWordString;
begin
  ReadWordUpCase:=AnsiUpperCase(ReadWord);
end;
{-------------------------------------------}
function tCmd.ReadString: tCmdString;
label
  L_01;
const
  Apos = '''';
var
  IB:byte;
begin
  while (CmdI<=Length(CmdS)) and (CmdS[CmdI]<>Apos) do Inc(CmdI);
  if CmdI>Length(CmdS) then ReadString:=''
  else
  begin
    Inc(CmdI);
    IB:=CmdI;
  L_01:
    while (CmdI<=Length(CmdS)) and (CmdS[CmdI]<>Apos) do Inc(CmdI);
    if CmdI>Length(CmdS) then ReadString:=''
    else
    begin
      if (CmdI<Length(CmdS)) and (CmdS[CmdI+1]=Apos) then
      begin
        Inc(CmdI);
        Delete(CmdS,CmdI,1);
        goto L_01;
      end;
      ReadString:=Copy(CmdS,IB,CmdI-IB);
      Inc(CmdI);
    end;
  end;
end;
{-------------------------------------------}
function tCmd.ReadElement: tCmdString;
{ cteni obecneho elem. (xxx resp.'...' resp. "...") z glob.Stringu CMDL.S }
{ Elenentem muze byt:
  - identifikator - automaticky prevaden na uppercase
  - retez, uzavreny mezi "" ( bez techto znaku )
  - retez, uzavreny mezi '' ( bez techto znaku )
  mezery a komentare, uzavrene do slozenych zavorek se ignoruji }
label
  L_01;
const
  Apos1  = '"';
  Apos2  = '''';
  ComBeg = '{';
  ComEnd = '}';
var
  IB:byte;
begin
L_01:
  while (CmdI<=Length(CmdS)) and (CmdS[CmdI] in Delimiters) do Inc(CmdI); { ignorovani mezer }
  if CmdI>Length(CmdS) then
  begin
    ReadElement:='';
    Exit;
  end;

  case CmdS[CmdI] of
    ComBeg:           { ignorovani komentare }
      begin
        while (CmdI<=Length(CmdS)) and (CmdS[CmdI]<>ComEnd) do Inc(CmdI);
        if CmdI>Length(CmdS) then
        begin
          ReadElement:='';
          Exit;
        end;
        Inc(CmdI); { preskoceni uzaviraci komentarove zavorky }
        goto L_01;
      end;
    Apos1:            { cteni retezce1 }
      begin
        Inc(CmdI); { preskoceni 1. apostrofu }
        IB:=CmdI;
        while (CmdI<=Length(CmdS)) and (CmdS[CmdI]<>Apos1) do Inc(CmdI);
        if CmdI>Length(CmdS) then
        begin
          ReadElement:='';
          Exit;
        end;
        ReadElement:=Copy(CmdS,IB,CmdI-IB);
        Inc(CmdI); { preskoceni 2. apostrofu }
      end;
    Apos2:            { cteni retezce2 }
      begin
        Inc(CmdI); { preskoceni 1. apostrofu }
        IB:=CmdI;
        while (CmdI<=Length(CmdS)) and (CmdS[CmdI]<>Apos2) do Inc(CmdI);
        if CmdI>Length(CmdS) then
        begin
          ReadElement:='';
          Exit;
        end;
        ReadElement:=Copy(CmdS,IB,CmdI-IB);
        Inc(CmdI); { preskoceni 2. apostrofu }
      end;
    else              { cteni identifikatoru }
      begin
        IB:=CmdI;
        while (CmdI<=Length(CmdS)) and (not(CmdS[CmdI] in Delimiters)) do Inc(CmdI);
        ReadElement:=Copy(CmdS,IB,CmdI-IB);
      end;
  end; { case }
end;
{-------------------------------------------}
function tCmd.ReadElement1: tCmdString;
{ cteni obec.elem. (xxx resp.'...' vc.' resp. "..." vc.") z glob.Stringu CMDL.S }
{ Elenentem muze byt:
  - identifikator - automaticky prevaden na uppercase
  - retez, uzavreny mezi "" , "" ponechany v retezci
  - retez, uzavreny mezi '' , '' ponechany v retezci
  mezery a komentare, uzavrene do slozenych zavorek se ignoruji }
label
  L_01;
const
  Apos1  = '"';
  Apos2  = '''';
  ComBeg = '{';
  ComEnd = '}';
var
  IB:byte;
begin
L_01:
  while (CmdI<=Length(CmdS)) and (CmdS[CmdI] in Delimiters) do Inc(CmdI); { ignorovani mezer }
  if CmdI>Length(CmdS) then
  begin
    ReadElement1:='';
    Exit;
  end;

  case CmdS[CmdI] of
    ComBeg:           { ignorovani komentare }
      begin
        while (CmdI<=Length(CmdS)) and (CmdS[CmdI]<>ComEnd) do Inc(CmdI);
        if CmdI>Length(CmdS) then
        begin
          ReadElement1:='';
          Exit;
        end;
        Inc(CmdI); { preskoceni uzaviraci komentarove zavorky }
        goto L_01;
      end;
    Apos1:            { cteni retezce1 }
      begin
        Inc(CmdI); { preskoceni 1. apostrofu }
        IB:=CmdI;
        while (CmdI<=Length(CmdS)) and (CmdS[CmdI]<>Apos1) do Inc(CmdI);
        if CmdI>Length(CmdS) then
        begin
          ReadElement1:='';
          Exit;
        end;
        ReadElement1:=Apos1+Copy(CmdS,IB,CmdI-IB)+Apos1;
        Inc(CmdI); { preskoceni 2. apostrofu }
      end;
    Apos2:            { cteni retezce2 }
      begin
        Inc(CmdI); { preskoceni 1. apostrofu }
        IB:=CmdI;
        while (CmdI<=Length(CmdS)) and (CmdS[CmdI]<>Apos2) do Inc(CmdI);
        if CmdI>Length(CmdS) then
        begin
          ReadElement1:='';
          Exit;
        end;
        ReadElement1:=Apos2+Copy(CmdS,IB,CmdI-IB)+Apos2;
        Inc(CmdI); { preskoceni 2. apostrofu }
      end;
    else              { cteni identifikatoru }
      begin
        IB:=CmdI;
        while (CmdI<=Length(CmdS)) and (not(CmdS[CmdI] in Delimiters)) do Inc(CmdI);
        ReadElement1:=Copy(CmdS,IB,CmdI-IB);
      end;
  end; { case }
end;
{-------------------------------------------}
function tCmd.ReadRest: tParamStr;
var
  ZAR:byte;
begin
  while (CmdI<=Length(CmdS)) and (CmdS[CmdI] in Delimiters) do Inc(CmdI);
  ZAR:=Length(CmdS)+1;
  ReadRest:=Copy(CmdS,CmdI,ZAR-CmdI);
  CmdI:=ZAR;
end;
{-------------------------------------------}
procedure tCmd.ReadLVal(var V:longint; var ErrFl:Boolean);
var
  Slovo : tWordString;
  Err   : Integer;
begin
  Slovo:=ReadWord;
  if Length(Slovo)=0 then ErrFl:=true
  else
    begin
      Val(Slovo,V,ERR);
      ErrFl:=Err<>0;
    end;
end;
{-------------------------------------------}
procedure tCmd.ReadRVal(var V:real; var ErrFl:Boolean);
var
  Slovo : tWordString;
  Err   : Integer;
begin
  Slovo:=ReadWord;
  if Length(Slovo)=0 then ErrFl:=true
  else
    begin
      Val(Slovo,V,Err);
      ErrFl:=Err<>0;
    end;
end;
{===========================================}

End.

