unit Crc16;

          {ͻ}
          {                                                        }
          {  unit uCrc16 - jednotka pro vpoet Crc16              }
          {                                                        }
          {  (C)1992 Vladimr Kastner, Na Vlovce 6, Praha 6       }
          {                                                        }
          {ͼ}

interface

{ (C) P.Tesar, T.Pecina, LP Praha, December 1989 }
{ Vypocet CRC-16 (IEEE MICRO 83)                 }
{ generacni polynom = x16 + x15 + x2 + 1         }
{ nejnizsi bit B je prvni prijaty nebo zasilany  }

type
  tCrc16 = class(tObject)
    Residue : Word;
    constructor Init;                { vytvoreni objektu }
    destructor  Done;
    procedure SetResidue(Res: Word); { definuje hodnotu zbytku po deleni }
    function  GetResidue: Word;      { navrati hodnotu zbytku po deleni }
    procedure MakeCrc(B: Byte);      { vypoet zbytku a jeho navrcen }
  end;

implementation

constructor tCrc16.Init; { vytvoreni objektu }
begin
  Create;
end;

destructor tCrc16.Done;
begin
  inherited;
end;

procedure tCrc16.SetResidue(Res: Word); { definuje hodnotu zbytku po deleni }
begin
  Residue:=Res;
end;

function tCrc16.GetResidue: Word; { navrati hodnotu zbytku po deleni }
begin
  GetResidue:=Residue;
end;

procedure tCrc16.MakeCrc(B: Byte); { vypoet zbytku a jeho navrcen }
label Nc1,Nc2;
asm
    xor dl,byte ptr [eax].Residue
    mov cl,dl
    add cl,cl
    xor cl,dl
    add dl,dl
    mov ch,2
    jc  Nc1
    mov ch,0
  Nc1:
    or  dl,dl
    jpe Nc2
    xor ch,3
  Nc2:
    mov dl,ch
    rcr dl,1
    add cx,cx
    add cx,cx
    add cx,cx
    add cx,cx
    add cx,cx
    add cx,cx
    or  cl,dl
    xor cl,byte ptr [eax].Residue+1
    mov [eax].Residue,cx
end;

end.

