unit ChnPrt;

          {ͻ}
          {                                                        }
          {  unit ChnPrt                                           }
          {                                                        }
          {  jednotka definujici komunikacni protokol              }
          {                                                        }
          {  (C)1998 SofCon, Steovick 49, 160 00 Praha 6        }
          {          Ing. Vladimr Kastner, Na Vlovce 6, Praha 6  }
          {               Adam Wild, Dejvicka 42, Praha 6          }
          {ͼ}

interface

uses
  ChnVirt,
  uString,
  Crc16;

const
  cName     = 'PRT';
  cVer      = 'v4.2, 01.12.2000';

  { SOH,DNode,SNode,Len,Data,Crc16,ETX }
  {  1 ,  1  ,  1  , 2 ,Len ,  2  , 1  }
  SOH     = $01;
  DLE     = $10;
  ETX     = $03;

  res_ErrCrc   = $20; { chyba kontrolniho souctu CRC16 - prijatou zpravu nelze akceptovat }
  res_ErrSOH   = $21; { chyba - prijat SOH v prubehu zpravy - prijatou zpravu lze akceptovat, ale predchozi se ztratila }
  res_ErrETX   = $22; { chyba - neprijat ETX na konci zpravy  - prijatou zpravu nelze akceptovat }
  res_ErrLen   = $23; { chyba delky zpravy  - prijatou zpravu nelze akceptovat }

type
  TRec = (Znk,CtZnk,SOHZnk,NoZnk,Err);

type
  tChnPrt = class(tChnVirt)
    CH_RTick   : LongBool; { je vykonavana cinnost prijimaciho automatu }
    CH_DLE     : Boolean;  { priznak DLE }
    CH_SBuff   : Pointer;  { vysilaci buffer }
    CH_MSBuff  : Word;     { delka vysilaciho bufferu }
    CH_LRMess  : Word;     { delka prijimane zpravy }
    CH_vLRMess : Word;     { pom var delka prijimane zpravy }
    CH_RCrc    : tCrc16;   { Crc16 prijimace }
    CH_SCrc    : tCrc16;   { Crc16 vysilace }

    { vytvoreni a zruseni instance objektu }
    constructor Init;
                  { vytvoreni objektu }
    constructor ChInitParam(const S: tParamStr);
                  { vytvoreni objektu a nastaveni parametru }
    destructor  Destroy;
                  override;{ zruseni objektu }

    { zadani a zobrazeni zadanych parametru }
   protected
    function  ChSetOneParam(const S: tWordString; var CmdL: tCmd): tChResult;
                override; { nove nastaveni jednoho parametru textove }
   published
    function  ChGetParam   (const S: tParamStr): tParamStr;
                override; { prevod parametru kanalu do stringu }

    { otevreni a zavreni HW kanalu, navazani a zruseni komunikace }
    procedure ChConnect;
                override; { pocatek navazovani spojeni }
    procedure ChDisConnect;
                override; { pocatek ukonceni spojeni }

    { vysilani dat }
    procedure ChSend(Buff: Pointer; Len: Word);
                override; { pocatek vysilani }

    { prijem dat }
    function  ChReceiveReady: TChState;
                override; { vrati aktualni stav automatu prijimace }
    procedure ChReceive(var Len: Word);
                override; { prijem zpravy }
    procedure ChReceiveFlush;
                override; { stav jako po inicializaci }
    procedure ChGetNode(var SNode, DNode: TNode);
                override; { ziskani odesilatele a adresata z prijmute zpravy }

    function  ChResultStr (Sts  : TChResult) : tResultStr;
                override; { vrati retezec s popisem vysledku operace }

    { krok automatu kanalu, vysilace a prijimace }
    procedure ChReceiveTick;
                override; { provedeni kroku prijimace kanalu }

  private
    function  RecB(var Data: Byte): TRec;
    function  Rec(var Data: Byte): TRec;
  end;

type
  tAddChnPrt = class(tAddChnVirt)
    function ChInit: tChnVirt; override; { funkce provadejici zalozeni a inicializaci daneho kanalu }
  end;

const
  MaxTBuf = 32750;  { max. velikost vyslacho bufferu }

implementation
uses
 {$ifdef HardLock}
  HardLock,
 {$endif}
  SysUtils,
  Windows;

const
  CHS_ReceiveBegin      = 2;
  CHS_ReceiveDNode      = 3;
  CHS_ReceiveSNode      = 4;
  CHS_ReceiveLoLen      = 5;
  CHS_ReceiveHiLen      = 6;
  CHS_ReceiveData       = 7;
  CHS_ReceiveLoCrc      = 8;
  CHS_ReceiveHiCrc      = 9;
  CHS_ReceiveETX        = 10;

function tAddChnPrt.ChInit: tChnVirt;
begin
  ChInit:=tChnPrt.Init;
end;

type
  PAByte = ^TAByte;
  TAByte = array[0..65534]of byte;

{ =============================================================== }
constructor tChnPrt.Init;
begin
  inherited;
  CH_Type    := cName;
  CH_Name    := CH_Type;
  CH_NumName := ChNumName(CH_Type);
  CH_RCtrl   := CHS_ReceiveNoReady;
  CH_RTick   := false;
  CH_DLE     := false;
  CH_SBuff   := nil;
  CH_MSBuff  := 0;
  CH_LRMess  := 0;
  CH_vLRMess := 0;
  CH_RCrc    := tCrc16.Init;
  CH_SCrc    := tCrc16.Init;
end;

{ ---------------------------------------- }
constructor tChnPrt.ChInitParam(const S: tParamStr);
begin
  Init;
  ChSetParam(S);
  { CH_Result nastavuje ChSetParam }
end;

{ ---------------------------------------- }
destructor  tChnPrt.Destroy;
begin
  if CH_SBuff<>nil then
  begin
    FreeMem(CH_SBuff,CH_MSBuff);
    CH_SBuff:=nil;
  end;
  CH_RCrc.Done;
  CH_SCrc.Done;
  inherited;
  { CH_Result nastavuje Done }
end;

{ ---------------------------------------- }
function tChnPrt.ChSetOneParam(const S: tWordString; var CmdL: tCmd): tChResult;
          { typicka syntaxe : NAM=PTR LSB=2 NODE=1 DNODE=2 | ... }
type
  tParam = (P_ERR,
            P_LSB,    { velikost vysilaciho bufferu }
            P_NODE,   { node stanice }
            P_DNODE   { node adresata }
            );
const
  StrParam = 'LSB|NOD|DNO|';
var
  PomRes  : tChResult;
  Param   : tParam;
  ErrFl   : boolean;
  PomL    : longint;
begin
  PomRes:=res_Ok;
  if S='|' then
  begin
    ChNextSetParam(CmdL.ReadRest);
    PomRes:=ChResult;
  end
  else
  begin
    Param:=tParam(NDELIM(S,StrParam));
    case Param of
      P_ERR:
        PomRes:=inherited ChSetOneParam(S,CmdL);
      P_LSB:
        begin
          CmdL.ReadLVal(Poml,ErrFl);
          if not ErrFl then
            if (PomL>=17) and (PomL<=MaxTBuf) then
            begin
              if CH_SBuff<>nil then
                FreeMem(CH_SBuff,CH_MSBuff);
              CH_MSBuff:=PomL;
              GetMem(CH_SBuff,CH_MSBuff);
            end
            else
              ErrFl:=true;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_NODE:
        begin
          CmdL.ReadLVal(Poml,ErrFl);
          if not ErrFl then
            if (PomL>=0) and (PomL<=255) then
              CH_Node:=PomL
            else
              ErrFl:=true;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_DNODE:
        begin
          CmdL.ReadLVal(Poml,ErrFl);
          if not ErrFl then
            if (PomL>=0) and (PomL<=255) then
              CH_DNode:=PomL
            else
              ErrFl:=true;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      end; {case}
  end;
  ChSetOneParam:=PomRes;
end;

{ ---------------------------------------- }
function tChnPrt.ChGetParam(const S: tParamStr): tParamStr;
var
  ss : tParamStr;
begin
  ss:='NAM='+CH_Name+
     ' LSB='+LStr(CH_MSBuff)+
     ' NOD='+LStr(CH_Node)+
     ' DNO='+LStr(CH_DNode);
  ChSetResult(res_Ok);
  if CH_Chn<>nil then
  begin
    ss:=ss+' '+CH_Chn.ChGetParam(S);
    ChSetResult(CH_Chn.ChResult);
  end;
  ChGetParam:=ss;
end;

{ ---------------------------------------- }
procedure tChnPrt.ChConnect;
begin
  inherited;
  if CH_Result=res_Ok then
    begin
      CH_RCtrl:=CHS_ReceiveBegin;
      CH_Dle:=false;
    end;
end;

{ ---------------------------------------- }
procedure tChnPrt.ChDisConnect;
begin
  inherited;
  if CH_Result=res_Ok then
    begin
      CH_RCtrl:=CHS_ReceiveNoReady;
      CH_Dle:=false;
    end;
end;

{ ---------------------------------------- }
procedure tChnPrt.ChSend(Buff: Pointer; Len: Word);
  {-----------------}
  procedure MessSend(var LBuf : word; var Sts  : word);
  var
    i : Integer;
    j : Word;
    {--------}
    procedure IncMax(var I: word);
    begin
      if I<CH_MSBuff-1 then
        Inc(I);
    end;
    {--------}
    procedure Send(B: Byte);
    begin
      if B=DLE then
      begin
        PAByte(CH_SBuff)^[j]:=DLE;
        IncMax(j);
        PAByte(CH_SBuff)^[j]:=DLE;
        IncMax(j);
      end
      else
      begin
        PAByte(CH_SBuff)^[j]:=B;
        IncMax(j);
      end;
    end;
    {--------}
    procedure SendC(B: Byte);
    begin
      PAByte(CH_SBuff)^[j]:=DLE;
      IncMax(j);
      PAByte(CH_SBuff)^[j]:=B;
      IncMax(j);
    end;
    {--------}
  begin
    with CH_SCrc do
    begin
      J:=0;
      SetResidue(0);
      SendC(SOH);        { SOH,DNode,SNode,Len,Data,Crc16,ETX }
      MakeCrc(SOH);

      Send(CH_DNode);
      MakeCrc(CH_DNode);

      Send(CH_Node);
      MakeCrc(CH_Node);

      Send(Lo(Len));
      MakeCrc(Lo(Len));

      Send(Hi(Len));
      MakeCrc(Hi(Len));

      for i:=0 to Integer(Len)-1 do
      begin
        Send(PAByte(Buff)^[i]);
        MakeCrc(PAByte(Buff)^[i]);
      end;

      Send(Lo(GetResidue));
      Send(Hi(GetResidue));
      SendC(ETX);
      LBuf:=j;
      if j=CH_MSBuff-1 then
        Sts:=$ffff
      else
        Sts:=0;
    end;
  end;
  {-----------------}
var
  L : Word;
  Sts : Word;
begin
  if CH_Ctrl=CHS_Connect then
  begin
    MessSend(L,Sts);
    if Sts=0 then
    begin
      CH_Chn.ChSend(CH_SBuff,L);
      ChSetSendResult(CH_Chn.ChSendResult);
    end
    else
      ChSetSendResult(CH_NumName or res_Err);
  end
  else
    ChSetSendResult(CH_NumName or res_ErrNoConnect);
end;

{ ---------------------------------------- }
function tChnPrt.RecB(var Data: Byte): TRec;
         { provede dekodovani jednoho prijateho znaku }
begin
  if CH_Chn<>nil then
  begin
    if CH_Chn.ChReceiveReady=CHS_ReceiveReady then
    begin
      Data:=CH_Chn.ChReceiveChar;
      if CH_Chn.ChReceiveResult=res_Ok then
        RecB:=Znk
      else
        RecB:=Err;
    end
    else
      RecB:=NoZnk;
  end
  else
    RecB:=NoZnk;
end;

{ ---------------------------------------- }
function tChnPrt.Rec(var Data: Byte): TRec;
var
  v : TRec;
begin
  if CH_DLE then
  begin
    v:=RecB(Data);
    case v of
      Znk:
        begin
          case Data of
            DLE : Rec:=Znk;
            SOH : Rec:=SOHZnk;
            else  Rec:=CtZnk;
          end;
          CH_DLE:=false;
        end;
      Err:
        begin
          Rec:=Err;
          CH_DLE:=false;
        end;
      else Rec:=v;
    end;
  end
  else
  begin
    v:=RecB(Data);
    case v of
      Znk :
        begin
          if Data=DLE then
          begin
            v:=RecB(Data);
            case v of
              Znk   :
                begin
                  case Data of
                    DLE : Rec:=Znk;
                    SOH : Rec:=SOHZnk;
                    else  Rec:=CtZnk;
                  end;
                end;
              NoZnk :
                begin
                  Rec:=NoZnk;
                  CH_DLE:=true;
                end;
              else Rec:=v;
            end;
          end
          else
            Rec:=Znk;
        end;
      else Rec:=v;
    end;
  end;
end;

{ ---------------------------------------- }
function  tChnPrt.ChResultStr (Sts : tChResult) : tResultStr;
begin
  if Sts and $FF00 = CH_NumName then
  begin
    Result:=inherited ChResultStr(Sts);
    if Result='' then
    case Lo(Sts) of
      res_ErrCrc   : ChResultStr:='CRC Error';
      res_ErrSOH   : ChResultStr:='Error Previous SOH';
      res_ErrETX   : ChResultStr:='Error ETX';
      res_ErrLen   : ChResultStr:='Error Msg Len';
    end;
  end
  else
    ChResultStr:=inherited ChResultStr(Sts);
end;

{ ---------------------------------------- }
procedure tChnPrt.ChReceiveTick;
label
  L_ReceiveReady, L_ReceiveBegin, L_ReceiveDNode, L_ReceiveSNode,
  L_ReceiveLoLen, L_ReceiveHiLen, L_ReceiveData,  L_ReceiveLoCrc,
  L_ReceiveHiCrc, L_ReceiveETX;
var
  Z   : Byte;
  i   : Word;
  l   : Longint;
  v   : TRec;
begin               { SOH,DNode,SNode,Len,Data,Crc16,ETX }
  if not LongBool(InterlockedExchange( integer(CH_RTick), Ord(true) )) then
  begin
    case CH_RCtrl of
      CHS_ReceiveNoReady,
      CHS_ReceiveReady :
        L_ReceiveReady :
         begin
         end;
      CHS_ReceiveBegin:
        L_ReceiveBegin:                    { SOH }
         begin
           repeat
             v:=Rec(Z);
           until (v=SOHZnk)or(v=NoZnk);
           if v=SOHZnk then
           begin
             CH_RCtrl:=CHS_ReceiveDNode;
             goto L_ReceiveDNode;
           end;
         end;

      CHS_ReceiveDNode:
        L_ReceiveDNode:                    { DNode }
         begin
           CH_RDNode:=0;
           case Rec(Z) of
             Znk    :
               begin
                 CH_RDNode:=Z;
                 if (CH_Node=0)or(CH_RDNode=CH_Node)or(CH_RDNode=0) then
                 begin
                   CH_RCtrl:=CHS_ReceiveSNode;
                   goto L_ReceiveSNode;
                 end
                 else
                 begin
                   CH_RCtrl:=CHS_ReceiveBegin;
                   goto L_ReceiveBegin;
                 end;
               end;
             NoZnk  : ;
             SOHZnk :
               begin
                 ChSetReceiveResult(CH_NumName or res_ErrSOH);
               end;
             else
               begin
                 CH_RCtrl:=CHS_ReceiveBegin;
                 goto L_ReceiveBegin;
               end;
           end;
         end;

      CHS_ReceiveSNode:
        L_ReceiveSNode:                    { SNode }
         begin
           CH_RSNode:=0;
           case Rec(Z) of
             Znk    :
               begin
                 CH_RSNode:=Z;
                 CH_RCtrl:=CHS_ReceiveLoLen;
                 goto L_ReceiveLoLen;
               end;
             NoZnk  : ;
             SOHZnk :
               begin
                 ChSetReceiveResult(CH_NumName or res_ErrSOH);
                 CH_RCtrl:=CHS_ReceiveDNode;
                 goto L_ReceiveDNode;
               end;
             else
               begin
                 CH_RCtrl:=CHS_ReceiveBegin;
                 goto L_ReceiveBegin;
               end;
           end;
         end;

      CHS_ReceiveLoLen:
        L_ReceiveLoLen:                    { Lo(Len) }
         begin
           case Rec(Z) of
             Znk    :
               begin
                 CH_LRMess:=Z;
                 CH_RCtrl:=CHS_ReceiveHiLen;
                 goto L_ReceiveHiLen;
               end;
             NoZnk  : ;
             SOHZnk :
               begin
                 ChSetReceiveResult(CH_NumName or res_ErrSOH);
                 CH_RCtrl:=CHS_ReceiveDNode;
                 goto L_ReceiveDNode;
               end;
             else
               begin
                 CH_RCtrl:=CHS_ReceiveBegin;
                 goto L_ReceiveBegin;
               end;
           end;
         end;

      CHS_ReceiveHiLen:
        L_ReceiveHiLen:                    { Hi(Len) }
         begin
           case Rec(Z) of
             Znk    :
               begin
                 l:=Z;
                 l:=CH_LRMess+(l shl 8);
                 if (l<0)or(l>CH_MRMess) then
                 begin
                   ChSetReceiveResult(CH_NumName or res_ErrLen);
                   CH_RCtrl:=CHS_ReceiveBegin;
                 end
                 else
                 begin
                   CH_vLRMess:=0;
                   if l=0 then
                   begin
                     CH_LRMess:=l;
                     CH_RCtrl:=CHS_ReceiveLoCrc;
                     goto L_ReceiveLoCrc;
                   end
                   else
                   begin
                     CH_LRMess:=l-1;
                     CH_RCtrl:=CHS_ReceiveData;
                     goto L_ReceiveData;
                   end;
                 end;
               end;
             NoZnk  : ;
             SOHZnk :
               begin
                 ChSetReceiveResult(CH_NumName or res_ErrSOH);
                 CH_RCtrl:=CHS_ReceiveDNode;
                 goto L_ReceiveDNode;
               end;
             else
               begin
                 CH_RCtrl:=CHS_ReceiveBegin;
                 goto L_ReceiveBegin;
               end;
           end;
         end;

      CHS_ReceiveData:
        L_ReceiveData:                    { Data }
         begin
           case Rec(PAByte(CH_RMess)^[CH_vLRMess]) of
             Znk    :
               begin
                 if CH_vLRMess=CH_LRMess then
                 begin
                   Inc(CH_LRMess);
                   CH_RCtrl:=CHS_ReceiveLoCrc;
                   goto L_ReceiveLoCrc;
                 end
                 else
                 begin
                   if CH_vLRMess<CH_MRMess-1 then
                   begin
                     Inc(CH_vLRMess);
                     goto L_ReceiveData;
                   end
                   else
                   begin
                     ChSetReceiveResult(CH_NumName or res_ErrLen);
                     CH_RCtrl:=CHS_ReceiveBegin;
                     goto L_ReceiveBegin;
                   end;
                 end;
               end;
             NoZnk  : ;
             SOHZnk :
               begin
                 ChSetReceiveResult(CH_NumName or res_ErrSOH);
                 CH_RCtrl:=CHS_ReceiveDNode;
                 goto L_ReceiveDNode;
               end;
             else
               begin
                 CH_RCtrl:=CHS_ReceiveBegin;
                 goto L_ReceiveBegin;
               end;
           end;
         end;

      CHS_ReceiveLoCrc:
        L_ReceiveLoCrc:                   { Lo(Crc16) }
         begin
           case Rec(Z) of
             Znk    :
               with CH_RCrc do
               begin
                 SetResidue(0);
                 MakeCrc(SOH);
                 MakeCrc(CH_RDNode);
                 MakeCrc(CH_RSNode);
                 MakeCrc(Lo(CH_LRMess));
                 MakeCrc(Hi(CH_LRMess));
                 if CH_LRMess<>0 then
                   for i:=0 to CH_LRMess-1 do
                     MakeCrc(PAByte(CH_RMess)^[i]);

                 if Z=Lo(GetResidue) then
                 begin
                   CH_RCtrl:=CHS_ReceiveHiCrc;
                   goto L_ReceiveHiCrc;
                 end
                 else
                 begin
                   ChSetReceiveResult(CH_NumName or res_ErrCrc);
                   CH_RCtrl:=CHS_ReceiveBegin;
                   goto L_ReceiveBegin;
                 end;
               end;
             NoZnk  : ;
             SOHZnk :
               begin
                 ChSetReceiveResult(CH_NumName or res_ErrSOH);
                 CH_RCtrl:=CHS_ReceiveDNode;
                 goto L_ReceiveDNode;
               end;
             else
               begin
                 CH_RCtrl:=CHS_ReceiveBegin;
                 goto L_ReceiveBegin;
               end;
           end;
         end;

      CHS_ReceiveHiCrc:
        L_ReceiveHiCrc:                   { Hi(Crc16) }
         begin
           case Rec(Z) of
             Znk    :
               begin
                 if Z=Hi(CH_RCrc.GetResidue) then
                 begin
                   CH_RCtrl:=CHS_ReceiveETX;
                   goto L_ReceiveETX;
                 end
                 else
                 begin
                   ChSetReceiveResult(CH_NumName or res_ErrCrc);
                   CH_RCtrl:=CHS_ReceiveBegin;
                   goto L_ReceiveBegin;
                 end;
               end;
             NoZnk  : ;
             SOHZnk :
               begin
                 ChSetReceiveResult(CH_NumName or res_ErrSOH);
                 CH_RCtrl:=CHS_ReceiveDNode;
                 goto L_ReceiveDNode;
               end;
             else
               begin
                 CH_RCtrl:=CHS_ReceiveBegin;
                 goto L_ReceiveBegin;
               end;
           end;
         end;

      CHS_ReceiveETX:
        L_ReceiveETX:                     { ETX }
         begin
           case Rec(Z) of
             CtZnk  :
               begin
                 if Z=ETX then
                 begin
                   CH_RCtrl:=CHS_ReceiveReady;
                 end
                 else
                 begin
                   ChSetReceiveResult(CH_NumName or res_ErrETX);
                   CH_RCtrl:=CHS_ReceiveBegin;
                 end
               end;
             NoZnk  : ;
             SOHZnk :
               begin
                 ChSetReceiveResult(CH_NumName or res_ErrSOH);
                 CH_RCtrl:=CHS_ReceiveDNode;
                 goto L_ReceiveDNode;
               end;
             else
               begin
                 CH_RCtrl:=CHS_ReceiveBegin;
                 goto L_ReceiveBegin;
               end;
           end;
         end;

      else
         begin
           CH_RCtrl:=CHS_ReceiveBegin;
           CH_DLE:=false;
           goto L_ReceiveBegin;
         end;
    end;
    CH_RTick:=false;
  end;
end;

{ ---------------------------------------- }
function tChnPrt.ChReceiveReady: TChState;
begin
  ChReceiveTick;
  { nastavuje CH_RResult }
  if CH_Ctrl=CHS_Connect then
    ChReceiveReady:=CH_RCtrl
  else
    ChReceiveReady:=CHS_ReceiveNoReady;
end;

{ ---------------------------------------- }
procedure tChnPrt.ChReceive(var Len: Word);
begin
  Len:=0;
  if CH_Ctrl=CHS_Connect then
    if CH_RCtrl=CHS_ReceiveReady then
    begin
      Len:=CH_LRMess;
      CH_RCtrl:=CHS_ReceiveBegin;
      ChSetReceiveResult(res_Ok);
    end
    else ChSetReceiveResult(CH_NumName or res_ErrNoReceiveReady)
  else ChSetReceiveResult(CH_NumName or res_ErrNoConnect);
end;

{ ---------------------------------------- }
procedure tChnPrt.ChReceiveFlush;
begin
  inherited;
  if CH_RResult=res_Ok then
  begin
    CH_RCtrl:=CHS_ReceiveBegin;
    CH_Dle:=false;
  end;
end;

{ ---------------------------------------- }
procedure tChnPrt.ChGetNode(var SNode, DNode: TNode);
begin
  SNode:=CH_RSNode;
  DNode:=CH_RDNode;
  ChSetReceiveResult(res_Ok);
end;

{ =============================================================== }
Begin
  ChnCollection.Insert(tAddChnPrt.Init(Nil));

  {$ifdef HardLock}
   if not TestHardLock then RunError(99);
  {$endif}
End.
