unit ChnMod2;

         {ͻ}
         {                                                               }
         { unit ChnMod2                                                  }
         {                                                               }
         { jednotka pro obsluhu komunikace pes telefonn modem          }
         { s vyuitm nizsi knihovny pro obsluhu konkretniho hardware    }
         {                                                               }
         { (C)2001 SofCon, Steovick 49, 160 00 Praha 6                }
         {              Adam Wild, Dejvicka 42, Praha 6                  }
         {ͼ}

{ define ChnModDeb} { definice pro ladici vypisy }

{$ifdef ChnModDeb}
  { define Deb_LoRec}
  { define Deb_SendRec}
  {$define Deb_Ctrl}
{$endif}

{----------}
interface
{----------}

{ pouzivane podminky prekladu: }
{ ChnModDeb - zobrazovani ladicich vypisu na monitoru
    Deb_LoRec   - zobrazovani vsech prijimanych znaku od modemu
    Deb_SendRec - zobrazovani celych prijimanych a vysilanych zprav z/do modemu
    Deb_Ctrl    - zobrazovani mezistavu automatu kanalu, prijimace, vysilace }

uses
  WinProcs,WinTypes,Classes,SysUtils, { vazba na Windows }
  ChnTypes,
  ChnVirt,
  uString,
  Timer;

const
  cName     = 'MOD2';
  cVer      = 'v4.5, 15.02.2001';

const
  Res_ErrInitStr1     = $A0; { chyba pri inicializaci 1.retezcem }
  Res_ErrInitStr2     = $A1; { chyba pri inicializaci 2.retezcem }
  Res_ErrInitStr3     = $A2; { chyba pri inicializaci 3.retezcem }
  Res_ErrPhoneNum     = $A3; { schazi telefonni cislo }
  Res_ErrDial         = $A4; { chyba pri vytaceni cisla }
  Res_ErrCDAbsent     = $A5; { neni nebo spadla nosna }
  Res_ErrSWHangUp     = $A6; { chyba pri softwarovem zavesovani - modem muze byt stale pripojen }

const
  { mezistavy pro connect ulozene v promenne CH_Ctrl2 }
  CHS2_HWIni1         = 07;  { inicializace }
  CHS2_HWIni2         = 08;  { inicializace }
  CHS2_HWIni3         = 09;  { inicializace }
  CHS2_InitBeg        = 10;  { pocatek navazovani spojeni - pocatek automatu }
  CHS2_IniRep         = 11;  { pocatek navazovani spojeni - pocatek automatu }
  CHS2_SWIni1         = 12;  { inicialisace modemu, krok 1 }
  CHS2_SWIni2         = 13;  { inicialisace modemu, krok 2 }
  CHS2_SWIni3         = 14;  { inicialisace modemu, krok 3 }
  CHS2_DialAnsw1      = 15;  { vytaceni cisla }
  CHS2_Busy           = 16;  { obsazeno }
  CHS2_DialAnsw2      = 17;  { vytaceni cisla }
  CHS2_DialAnsw3      = 18;  { vytaceni cisla }
  CHS2_DialEnd        = 19;  { ukonceni vytaceni cisla }
  CHS2_WaitForCD      = 20;  { cekani do nastaveni signalu CD }
  { mezistavy pro disconnect ulozene v promenne CH_Ctrl2 }
  CHS2_DisConBeg      = 30;  { pocatek zavesovani }
  CHS2_HWHangUp1      = 31;  { HW zavesovani }
  CHS2_HWHangUp2      = 32;  { HW zavesovani }
  CHS2_SWHangUp1      = 33;  { SW zavesovani }
  CHS2_SWHangUp2      = 34;  { SW zavesovani }
  CHS2_SWHangUp3      = 35;  { SW zavesovani }

type
  tDelays = (  { vyctovy typ ruznych delay }
    ESC,            { DES - Delay pred a po ESC-stringu v SW Hangup procedure }
    HWIni0,         { DIL - Doba pro DTR=0 v HW Init procedure }
    HWIni1,         { DIH - Doba pro DTR=1 v HW Init procedure }
    HWHangUp0,      { DHL - Doba pro DTR=0 v HW HangUp procedure }
    HWHangUp1,      { DHH - Doba pro DTR=1 v HW HangUp procedure }
    AfterI1S,       { DI1 - Delay po vyslani 1. inicialisacniho stringu }
    AfterI2S,       { DI2 - Delay po vyslani 2. inicialisacniho stringu }
    AfterI3S,       { DI3 - Delay po vyslani 3. inicialisacniho stringu }
    Busy            { DBU - Prodleva mezi vytacenim pri BUSY }
    );

  tTimeOuts = ( { vyctovy typ ruznych timeout }
    SendAtCmd,      { QAT - Timeout pro vysilani zpravy do modemu }
    CmdAnsw,        { QCA - Timeout pro odpoved na ostatni prikazy }
    DialAnsw1,      { QD1 - Timeout pro 1. odpoved na PNS [ms] }
    DialAnsw2,      { QD2 - Timeout pro 2. odpoved na PNS [ms] }
    DialAnsw3       { QD3 - Timeout pro 3. odpoved na PNS [ms] }
    );

  tStrAnsw = ( { vyctovy typ pro ruzne odpovedi modemu a ridici stringy }
    Init1S,         { I1S - 1. inicializacni retezec }
    Init2S,         { I2S - 2. inicializacni retezec }
    Init3S,         { I3S - 3. inicializacni retezec }
    DialPNS,        { PNS - vytaceci prikaz }
    DialNum,        { PNN - vytacene cislo }
    AnswOK,         { OKS - retezec pro odpoved "OK" }
    AnswERROR,      { ERS - retezec pro odpoved "ERROR" }
    AnswCONNECT,    { COS - retezec pro odpoved "CONNECT" }
    AnswBUSY,       { BUS - retezec pro odpoved "BUSY" }
    AnswNOCARRY,    { NCS - retezec pro odpoved "NO CARRIER" }
    ESCStr,         { SHS - retezec pro softwarovy prechod do Cmd rezimu }
    ATH             { HUS - retezec pro zaveseni }
    );

  tSMC_Ctrl = (  { stav kroku miniautomatu }
    SMCS_Beg,         { pocatek modem command cyklu }
    SMCS_Delay1,      { prodleva pred vysilanim commandu }
    SMCS_FlowControl, { SW kontrola toku dat }
    SMCS_Send,        { vyslani commandu }
    SMCS_SendDelay,   { test na dokonceni vysilani }
    SMCS_Delay2,      { prodleva po odvysilani }
    SMCS_Rec,         { cteni odpovedi }
    SMCS_RecEnd,      { konec cteni, dekodovani semantiky zpravy }
    SMCS_Ready        { konec modem command cyklu - stabilni stav }
    );

  tStrATCmd      = String[40]; { typ retezce pro standartni AT prikazy }

 { zaznam struktury bufferu pro vysilani prikazu do modemu pomoci metody ChSetBinParam }
  pAtCmdBuff = ^tAtCmdBuff;
  tAtCmdBuff = record
    Mode     : word;     { zadany mode }
    Delay1,              { pauza v ms pred vyslanim AT prikazu }
    Delay2   : longint;  { pauza v ms po vyslani AT prikazu }
    TimeOut  : longint;  { timeout v ms pro cekani na odpoved }
    CmdStr   : string;   { retezec AT prikazu }
    RecStr   : string;   { retezec odpovedi na AT prikaz }
  end;

const
 { konstanty kodu pro metodu ChSetBinParam }
  cmd_SetMCR    = $0101; { prikaz pro nastaveni vsech modemovych signalu (MCR) dle Param }
  cmd_SetDTR    = $0102; { prikaz pro nastaveni modemoveho signalu DTR  dle Param.0 }
  cmd_SetRTS    = $0103; { prikaz pro nastaveni modemoveho signalu RTS  dle Param.0 }
  cmd_SendCmd   = $0201; { poslani prikazu do modemu s doplnenim CR }
  cmd_RecAnsw   = $0202; { prijmuti zpravy z modemu s odstranenim CR }
  cmd_CmdAnsw   = $0203; { poslani prikazu do modemu s cekanim na odpoved }
  cmd_SendData  = $0204; { poslani dat do modemu }
  cmd_RecData   = $0205; { prijeti dat z modemu }
 { konstanty kodu pro metodu ChGetBinParam }
  cmd_GetMSR    = $0101; { prikaz pro vraceni stavu vsech modemovych signalu (MSR) }
  cmd_GetCTS    = $0106; { prikaz pro vraceni stavu modemoveho signalu CTS   v 0.bitu vysledku funkce }
  cmd_GetDSR    = $0107; { prikaz pro vraceni stavu modemoveho signalu DSR   v 0.bitu vysledku funkce }
  cmd_GetRI     = $0108; { prikaz pro vraceni stavu modemoveho signalu RI    v 0.bitu vysledku funkce }
  cmd_GetRLSD   = $0109; { prikaz pro vraceni stavu modemoveho signalu RLSD  v 0.bitu vysledku funkce }
  cmd_GetCD     = cmd_GetRLSD;
  cmd_GetChCtrl2= $0201; { pozadavek na cteni stavu vnitrniho automatu pri navazovani nebo ruseni spojeni }
  cmd_CmdReady  = $0202; { krok automatu vyslani prikazu a aktualni stav automatu }
  cmd_CmdResult = $0203; { vysledek po poslani cmd_SendCmd,RecAnsw,CmdAnsw,SendData,RecData }
{!!!POZOR:!!! Konstanty cmd_SetMCR..cmd_SetRTS a cmd_GetMSR..cmd_GetRLSD musi mit stejnou hodnotu
              jako stejnojmenne konstanty podrizene zretezene vrstvy (v knihovne ChnCom)}

  { status po vyslani zpravy do modemu navraceny metodou ChGetBinParam s kodem cmd_CmdResult }
  ResMod_Ok           =  0;  { bez chyby resp. odezva OK }
  ResMod_Connect      =  1;  { modem hlasi zpravu CONNECT }
  ResMod_Busy         = 10;  { modem hlasi zpravu BUSY }
  ResMod_Error        = 12;  { modem hlasi zpravu ERROR }
  ResMod_NoCarry      = 13;  { modem hlasi zpravu NO CARRIER }
  ResMod_Answer       = 19;  { modem hlasi jinou odpoved }
  ResMod_LongAnswer   = 20;  { modem hlasi prilis dlouhou odpoved }
  ResMod_SHwErr       = 21;  { nizka chyba pri vysilani }
  ResMod_RHwErr       = 22;  { nizka chyba pri prijmu }
  ResMod_RTimeOut     = 23;  { timeout pri prijmu }
  ResMod_STimeOut     = 24;  { timeout pri vysilani }


type
  tAByte  = array[0..65500]   of Byte;   { typ pole byte }
  pAByte  = ^tAByte;                     { typ ukazovtka na pole byte }

type
  tChnMod2 = class(tChnVirt)
    CH_Master   : Boolean;  { master / slave jednotka }
    CH_Tick     : LongBool; { je vykonvna innost kanlovho automatu }
    CH_STick    : LongBool; { je vykonavana cinnost vysilaciho automatu }
    CH_RTick    : LongBool; { je vykonavana cinnost prijimaciho automatu }

    CH_CDShutDown: Boolean; { priznak shozeni CD }
    CH_FlTestCD  : Boolean; { priznak pozadavku na testovani CD }

    CH_ATCmdBuff: pATCmdBuff;{ ukazatel na pomocny buffer pro miniautomat jednotlivych AT prikazu }

    CH_FlHwI    : boolean;  { priznak hardwarove inicializace }
    CH_FlHWH    : boolean;  { priznak hardwaroveho hangupu }

    CH_Delay    : array [tDelays]   of longint;   { pole ruznych delay }
    CH_TimeOut  : array [tTimeOuts] of longint;   { pole ruznych timeout }
    CH_Str      : array [tStrAnsw]  of tStrATCmd; { pole typu odpovedi a ridicich retezcu pro modem }
    CH_Rep      : Byte;     { max. pocet opakovani pri navaz. spojeni }
    CH_Cnt      : Byte;     { zbyvajici pocet opakovani }
    CH_RepAT    : Byte;         { pocet opakovani pri neuspesnem AT prikazu }

    CH_FlowCntrl: byte;     { zpusob rizeni toku dat
                              0 - zadny
                              1 - CTS/RTS
                              2 - DSR/DTR }

    CH_Char_CR  : char;     { znak pro Enter (CR) }
    CH_Char_LF  : char;     { znak pro odradkovani (LF) }
    CH_Char_BS  : char;     { znak pro BackSpace (BS) }

    CH_Ctrl2    : tCHState; { mezistav pri ruznych akcich pro vnitrni automat }
    CH_Ctrl2Save: tCHState; { ulozeni mezistavu pro vnitrni automat }

    { vytvoreni, zruseni objektu }
    constructor Init;
                  { vytvoreni objektu }
    constructor ChInitParam(const S: TParamStr);
                  { vytvoreni objektu a nastaveni parametru }
    destructor  Destroy;
                  override; { zruseni objektu }

    { zadani a zobrazeni zadanych parametru }
    function  ChSetOneParam(const S: tWordString; var CmdL: tCmd): tChResult;
                override; { nove nastaveni jednoho parametru textove }
    function  ChGetParam   (const S: TParamStr): TParamStr;
                override; { prevod parametru kanalu do stringu }

    { nastaveni a cteni nekterych stavu a parametru kanalu }
    procedure ChSetBinParam(NumName: Word; Code: Word; Param: longint);
                override;
    function  ChGetBinParam(NumName: Word; Code: Word): longint;
                override;

    { otevreni a zavreni kanalu, navazani a zruseni komunikace }
    procedure ChOpen;
                override; { otevereni kanalu }
    procedure ChClose;
                override; { zavreni kanalu }
    procedure ChConnect;
                override; { pocatek navazovani spojeni }
    procedure ChDisConnect;
                override; { pocatek ukonceni spojeni }

    function  ChState: TChState;
                override; { krok automatu a vraceni naposledy dosazeneho stabilniho stavu kanalu }
    function  ChReady: TChState;
                override; { krok automatu a vraceni aktualniho stavu kanalu }

    { vysilani dat }
    procedure ChSend(Buff: Pointer; Len:Word);
                override; { pocatek vysilani }
    function  ChSendReady: TCHState;
                override; { krok vysilaciho aut., stav vysilani }
    procedure ChSendFlush;
                override; { preruseni vysilani }

    { prijem dat }
    function  ChReceiveReady: TCHState;
                override; { krok prij. automatu, stav prijmu }
    procedure ChReceive(var Len: Word);
                override; { prijem zpravy }
    function  ChReceiveChar: Byte;
                override; { prijem 1 znaku zpravy }
    procedure ChReceiveFlush;
                override; { stav jako po inicializaci }

    function  ChResultStr (Sts  : TChResult) : tResultStr;
                override; { vrati retezec s popisem vysledku operace }

    { provedeni kroku automatu kanalu, vysilace, prijimace }
    procedure ChTick;
                override; { provedeni kroku kanalu }
    procedure ChSendTick;
                override; { provedeni kroku vysilace }
    procedure ChReceiveTick;
                override; { provedeni kroku prijimace }

   { === private }
  private
    { pomocne promenne pri vysilani }
    CH_PomBuff  : pAByte;            { ulozeny vysilaci buffer }
    CH_PomLen   : Word;              { ulozena delka vysilaciho bufferu }
    { promenne pro miniautomat SMC }
    SMC_Result  : integer;           { vysledek miniautomatu }
    SMC_Ctrl    : tSMC_Ctrl;         { krok algoritmu miniautomatu }
    SMC_ChnTime : tTimer;            { odmerovani casovych intervalu pro miniautomat }

    CH_RepATCt  : byte;              { citac neuspesnych AT prikazu }
    CH_ModSig_CD: boolean;           { priznak nastaveneho signalu CD }

    procedure ChAtCmd(S:string; Mode_:word; Del1,Del2,TimOut:longint);
                { zacatek vyslani prikazu do modemu s pripadnym cekanim na odpoved (pocatek algoritmu SMC) }
    function  ChAtCmdReady: tSMC_Ctrl;
                { krok automatu algoritmu SMC + prubezny vysledek algoritmu SMC }
    procedure ChAtCmdTick;
                { krok automatu algoritmu SMC }
    function  ChAtCmdResult:integer;
                { poskytnuti vysledku algoritmu SMC SMC_Result }

    function  ChReceiveReadyHW: TCHState;
                virtual; { krok prijimaciho automatu, stav prijimaciho bufferu AT }
    function  ChReceiveCharHW: Byte;
                virtual; { prijem 1 znaku zpravy z bufferu AT }
    procedure ChReceiveFlushHW;
                virtual; { vyprazdneni prijimaciho bufferu AT }

    procedure ChSendHW(Buff: Pointer; Len:Word);
                virtual; { fyzicke vyslani dat }
    function  ChSendReadyHW: TCHState;
                virtual; { status odvysilanych dat }
    procedure ChSendFlushHW;
                virtual; { vyprazdni vysilaci buffer }

    procedure ChSetModem(S:byte);
                virtual; { nastavuje vystupni modemove signaly S }
    procedure ChResModem(S:byte);
                virtual; { nuluje vystupni modemove signaly S }
    function  ChGetModem: Byte;
                virtual; { vraci vstupni modemove signaly }
  end;

type
  TAddChnMod2 = class(TAddChnVirt)
    function ChInit: TChnVirt; override; { funkce provadejici zalozeni a inicializaci daneho kanalu }
  end;

const
  CHS_SendBegin     = $03; { pocatek vysilani a cekani do stabilniho stavu Connect }
  CHS_Send          = $04; { probiha vysilani }
  CHS_ReceiveReConn = $04; { probiha nove navazani spojeni }

{-------------}
implementation
{-------------}
{$ifdef HardLock}
uses
  HardLock;
{$endif}

function tAddChnMod2.ChInit: tChnVirt;
begin
  ChInit:=tChnMod2.Init;
end;

{================================================================}
constructor tChnMod2.Init;
begin
  inherited;
  { CH_Result nastavuje Init }
  CH_Type     := cName;
  CH_Name     := CH_Type;
  CH_NumName  := ChNumName(CH_Type);
  CH_FlHWI    := true;
  CH_FlHWH    := true;
  CH_Rep      := 3;
  CH_Cnt      := 0;
  CH_SCtrl    := CHS_SendReady;
  CH_Ctrl2    := CHS_Close;
  CH_Ctrl2Save:= CH_Ctrl2;
  CH_Master   := False;
  CH_Tick     := false;
  CH_STick    := false;
  CH_RTick    := false;
  CH_CDShutDown:=false;
  CH_FlTestCD  :=false;
  CH_Delay[ESC]         := 02000;  { DES - Delay pred a po ESC-stringu v SW Hangup procedure }
  CH_Delay[HWIni0]      := 02000;  { DIL - Doba pro DTR=0 v HW Init procedure }
  CH_Delay[HWIni1]      := 05000;  { DIH - Doba pro DTR=1 v HW Init procedure }
  CH_Delay[HWHangUp0]   := 02000;  { DHL - Doba pro DTR=0 v HW HangUp procedure }
  CH_Delay[HWHangUp1]   := 05000;  { DHH - Doba pro DTR=1 v HW HangUp procedure }
  CH_Delay[AfterI1S]    := 02000;  { DI1 - Pauza po vyslani 1. inicialisacniho stringu }
  CH_Delay[AfterI2S]    := 00500;  { DI2 - Pauza po vyslani 2. inicialisacniho stringu }
  CH_Delay[AfterI3S]    := 00500;  { DI3 - Pauza po vyslani 3. inicialisacniho stringu }
  CH_Delay[Busy]        := 60000;  { DBU - Pauza mezi vytacenimi pri obsazene lince }
  CH_TimeOut[SendAtCmd] := 00500;  { QAT - Timeout pro vysilani zpravy do modemu [ms] }
  CH_TimeOut[CmdAnsw]   := 05000;  { QCA - Timeout pro odpoved na ostatni prikazy [ms] }
  CH_TimeOut[DialAnsw1] := 10000;  { QD1 - Timeout pro 1. odpoved na DIS [ms] }
  CH_TimeOut[DialAnsw2] := 05000;  { QD2 - Timeout pro 2. odpoved na DIS [ms] }
  CH_TimeOut[DialAnsw3] := 05000;  { QD3 - Timeout pro 3. odpoved na DIS [ms] }
  CH_Str[DialPNS]       := 'ATD';
  CH_Str[DialNum]       := '';
  CH_Str[Init1S]        := 'ATZ';
  CH_Str[Init2S]        := '';
  CH_Str[Init3S]        := '';
  CH_Str[AnswOK]        := 'OK';
  CH_Str[AnswERROR]     := 'ERROR';
  CH_Str[AnswCONNECT]   := 'CONNECT';
  CH_Str[AnswBUSY]      := 'BUSY';
  CH_Str[AnswNOCARRY]   := 'NO CARRIER';
  CH_Str[EscStr]        := '+++';
  CH_Str[ATH]           := 'ATH';
  CH_FlowCntrl:= 0;
  CH_Char_CR  := #$0D;
  CH_Char_LF  := #$0A;
  CH_Char_BS  := #$08;
  CH_RepAT    := 1;
  CH_RepATCt  := 0;
  CH_ModSig_CD:= false;
  New(CH_ATCmdBuff);
  with CH_ATCmdBuff^ do
  begin
    CmdStr :='';
    Delay1 :=0;
    Delay2 :=0;
    TimeOut:=0;
    RecStr :='';
  end;
  SMC_ChnTime:=tTimer.Init;
end;

{------------------------------}
constructor tChnMod2.ChInitParam(const S: TParamStr);
begin
  Init;
  ChSetParam(S);
  { CH_Result nastavuje CHInitParam }
end;

{------------------------------}
destructor tChnMod2.Destroy;
begin
  SMC_ChnTime.Done;
  SMC_ChnTime:=nil;
  if Assigned(CH_ATCmdBuff) then
  begin
    Dispose(CH_ATCmdBuff);
    CH_ATCmdBuff:=nil;
  end;
  inherited;
  { CH_Result nastavuje Done }
end;

{------------------------------}
function  tChnMod2.ChSetOneParam(const S: tWordString; var CmdL: tCmd): tChResult;
type
  tParam = (P_ERR,
            P_MASL,   { urceni Master/Slave stanice }
            P_HWI,    { priznak hardwarove inicializace }
            P_HWH,    { priznak hardwaroveho hangupu }
            P_REP,    { repetition count }
            { Init Strings, Dial Number, Glob Strings }
            P_SFC,    { Typ SW Flow Control }
            P_I1S,    { 1.inicializacni command modemu }
            P_I2S,    { 2.inicializacni command modemu }
            P_I3S,    { 3.inicializacni command modemu }
            P_PNS,    { modem phone number command }
            P_PNN,    { phone number }
            P_OKS,    { retezec pro odpoved "OK" }
            P_ERS,    { retezec pro odpoved "ERROR" }
            P_COS,    { retezec pro odpoved "CONNECT" }
            P_BUS,    { retezec pro odpoved "BUSY" }
            P_NCS,    { retezec pro odpoved "NO CARRIER" }
            P_SHS,    { retezec pro softwarovy prechod do Cmd rezimu }
            P_HUS,    { retezec pro zaveseni }
            { Delays }
            P_DES,    { Delay pred a po ESC-stringu v SW Hangup procedure }
            P_DIL,    { Doba pro DTR=0 v HW Init procedure }
            P_DIH,    { Doba pro DTR=1 v HW Init procedure }
            P_DHL,    { Doba pro DTR=0 v HW HangUp procedure }
            P_DHH,    { Doba pro DTR=1 v HW HangUp procedure }
            P_DI1,    { Delay po vyslani 1. inicialisacniho stringu }
            P_DI2,    { Delay po vyslani 2. inicialisacniho stringu }
            P_DI3,    { Delay po vyslani 3. inicialisacniho stringu }
            P_DBU,    { Prodleva mezi vytacenim pri BUSY }
            { TimeOuts }
            P_QAT,    { Timeout pro vysilani zpravy do modemu }
            P_QCA,    { Timeout pro odpoved na ostatni prikazy }
            P_QD1,    { Timeout pro 1. odpoved na PNS [ms] }
            P_QD2,    { Timeout pro 2. odpoved na PNS [ms] }
            P_QD3     { Timeout pro 3. odpoved na PNS [ms] }
            );
const
  StrParam = 'MAS|HWI|HWH|REP|SFC|'+
             'I1S|I2S|I3S|PNS|PNN|OKS|ERS|COS|BUS|NCS|SHS|HUS|'+
             'DES|DIL|DIH|DHL|DHH|DI1|DI2|DI3|DBU|'+
             'QAT|QCA|QD1|QD2|QD3|';
var
  PomS    : tWordString;
  PomRes  : tChResult;
  Param   : tParam;
  ErrFl   : boolean;
  PomL    : longint;
begin
  PomRes:=res_Ok;
  if S='|' then
  begin
    ChNextSetParam(CmdL.ReadRest);
    PomRes:=ChResult;
  end
  else
  begin
    Param:=tParam(NDELIM(S,StrParam));
    case Param of
      P_ERR:
        PomRes:=inherited ChSetOneParam(S,CmdL);
      P_MASL:
        begin
          PomS:=CmdL.ReadWordUpCase;
          if PomS='MASTER' then CH_Master:=true
          else
          if PomS='SLAVE' then CH_Master:=false
          else PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_HWI:
        begin
          PomS:=CmdL.ReadWordUpCase;
          if PomS='ON' then CH_FlHWI:=true
          else
          if PomS='OFF' then CH_FlHWI:=false
          else PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_HWH:
        begin
          PomS:=CmdL.ReadWordUpCase;
          if PomS='ON' then CH_FlHWH:=true
          else
          if PomS='OFF' then CH_FlHWH:=false
          else PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_REP: { pocet opakovani pri BUSY }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Rep:=PomL;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_SFC:
        begin
          PomS:=CmdL.ReadWordUpCase;
          if (PomS[1]='N')or(PomS[1]='0') then CH_FlowCntrl:=0
          else
          if (PomS='CTS')or(PomS[1]='1')  then CH_FlowCntrl:=1
          else
          if (PomS='DSR')or(PomS[1]='2')  then CH_FlowCntrl:=2
          else
            ErrFl:=True;
        end;
      P_I1S:
        begin
          CH_Str[Init1S     ]:=CmdL.ReadString;
        end;
      P_I2S:
        begin
          CH_Str[Init2S     ]:=CmdL.ReadString;
        end;
      P_I3S:
        begin
          CH_Str[Init3S     ]:=CmdL.ReadString;
        end;
      P_PNS:
        begin
          CH_Str[DialPNS    ]:=CmdL.ReadString;
        end;
      P_PNN:
        begin
          CH_Str[DialNum    ]:=CmdL.ReadString;
        end;
      P_OKS:
        begin
          CH_Str[AnswOK     ]:=CmdL.ReadString;
        end;
      P_ERS:
        begin
          CH_Str[AnswERROR  ]:=CmdL.ReadString;
        end;
      P_COS:
        begin
          CH_Str[AnswCONNECT]:=CmdL.ReadString;
        end;
      P_BUS:
        begin
          CH_Str[AnswBUSY   ]:=CmdL.ReadString;
        end;
      P_NCS:
        begin
          CH_Str[AnswNOCARRY]:=CmdL.ReadString;
        end;
      P_SHS:
        begin
          CH_Str[ESCStr     ]:=CmdL.ReadString;
        end;
      P_HUS:
        begin
          CH_Str[ATH        ]:=CmdL.ReadString;
        end;
      P_DES:    { Delay pred a po ESC-stringu v SW Hangup procedure }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Delay[ESC]:=PomL;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_DIL:    { Doba pro DTR=0 v HW Init procedure }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Delay[HWIni0]:=PomL;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_DIH:    { Doba pro DTR=1 v HW Init procedure }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Delay[HWIni1]:=PomL;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_DHL:    { Doba pro DTR=0 v HW HangUp procedure }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Delay[HWHangUp0]:=PomL;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_DHH:    { Doba pro DTR=1 v HW HangUp procedure }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Delay[HWHangUp1]:=PomL;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_DI1:    { Delay po vyslani 1. inicialisacniho stringu }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Delay[AfterI1S]:=PomL;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_DI2:    { Delay po vyslani 2. inicialisacniho stringu }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Delay[AfterI2S]:=PomL;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_DI3:    { Delay po vyslani 3. inicialisacniho stringu }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Delay[AfterI3S]:=PomL;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_DBU:    { Prodleva mezi vytacenim pri BUSY }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Delay[Busy]:=PomL;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_QAT:    { Timeout pri vysilani do modemu }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_TimeOut[SendAtCmd]:=PomL;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_QCA:    { Timeout pro odpoved na ostatni prikazy }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_TimeOut[CmdAnsw]:=PomL;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_QD1:    { Timeout pro 1. odpoved na PNS [ms] }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_TimeOut[DialAnsw1]:=PomL;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_QD2:    { Timeout pro 2. odpoved na PNS [ms] }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_TimeOut[DialAnsw2]:=PomL;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_QD3:    { Timeout pro 3. odpoved na PNS [ms] }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_TimeOut[DialAnsw3]:=PomL;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
    end; {case}
  end;
  ChSetOneParam:=PomRes;
end;

{------------------------------}
function  tChnMod2.ChGetParam(const S: TParamStr): TParamStr;
var
  ss : tParamStr;
begin
  ss:='';
  if (S='')or(S='1') then     { Zakladni parametry }
  begin
    ss := 'NAM=' +CH_Name+
          ' MAS=';
    if CH_Master then
         ss:=ss+'MASTER'
    else ss:=ss+'SLAVE';
    ss:=ss+' HWI=';
    if CH_FlHwI then
         ss:=ss+'ON'
    else ss:=ss+'OFF';
    ss:=ss+' HWH=';
    if CH_FlHwH then
         ss:=ss+'ON'
    else ss:=ss+'OFF';
    ss:=ss+' REP='+LStr(CH_Rep);
    ss:=ss+' SFC=';
    case CH_FlowCntrl of
      1:   ss:=ss+'CTS';
      2:   ss:=ss+'DSR';
      else ss:=ss+'N';
    end;
  end;
  if S='2' then     { retezce }
    ss := ' I1S='''+CH_Str[Init1S     ]+''+
          ' I2S='''+CH_Str[Init2S     ]+''+
          ' I3S='''+CH_Str[Init3S     ]+''+
          ' PNS='''+CH_Str[DialPNS    ]+''+
          ' PNN='''+CH_Str[DialNum    ]+''+
          ' OKS='''+CH_Str[AnswOK     ]+''+
          ' ERS='''+CH_Str[AnswERROR  ]+''+
          ' COS='''+CH_Str[AnswCONNECT]+''+
          ' BUS='''+CH_Str[AnswBUSY   ]+''+
          ' NCS='''+CH_Str[AnswNOCARRY]+''+
          ' SHS='''+CH_Str[ESCStr     ]+''+
          ' HUS='''+CH_Str[ATH        ]+'';
  if S='3' then     { Delays and TimeOuts }
    ss := ' DES='+LStr(CH_Delay[ESC      ])+
          ' DIL='+LStr(CH_Delay[HWIni0   ])+
          ' DIH='+LStr(CH_Delay[HWIni1   ])+
          ' DHL='+LStr(CH_Delay[HWHangUp0])+
          ' DHH='+LStr(CH_Delay[HWHangUp1])+
          ' DI1='+LStr(CH_Delay[AfterI1S ])+
          ' DI2='+LStr(CH_Delay[AfterI2S ])+
          ' DI3='+LStr(CH_Delay[AfterI3S ])+
          ' DBU='+LStr(CH_Delay[Busy     ])+
          ' QAT='+LStr(CH_TimeOut[SendATCmd])+
          ' QCA='+LStr(CH_TimeOut[CmdAnsw  ])+
          ' QD1='+LStr(CH_TimeOut[DialAnsw1])+
          ' QD2='+LStr(CH_TimeOut[DialAnsw2])+
          ' QD3='+LStr(CH_TimeOut[DialAnsw3]);
  ChGetParam:=ss;
  ChSetResult(res_Ok);
end; {ChGetParam}

{------------------------------}
procedure tChnMod2.ChSetBinParam(NumName: Word; Code: Word; Param: longint);
begin
  if NumName=CH_NumName then
  begin
    ChSetResult(res_Ok);
    case Code of
      cmd_SetMCR:
        begin
          if Assigned(CH_Chn) then
          begin
            CH_Chn.ChSetBinParam(CH_Chn.CH_NumName,cmd_SetMCR,Byte(Param));
            ChSetResult(CH_Chn.ChResult);
          end
          else ChSetResult(CH_NumName or res_ErrChannelNoExist);
        end;
      cmd_SetDTR:
        begin
          if Assigned(CH_Chn) then
          begin
            CH_Chn.ChSetBinParam(CH_Chn.CH_NumName,cmd_SetDTR,Param);
            ChSetResult(CH_Chn.ChResult);
          end
          else ChSetResult(CH_NumName or res_ErrChannelNoExist);
        end;
      cmd_SetRTS:
        begin
          if Assigned(CH_Chn) then
          begin
            CH_Chn.ChSetBinParam(CH_Chn.CH_NumName,cmd_SetRTS,Param);
            ChSetResult(CH_Chn.ChResult);
          end
          else ChSetResult(CH_NumName or res_ErrChannelNoExist);
        end;
      cmd_SendCmd,
      cmd_RecAnsw,
      cmd_CmdAnsw,
      cmd_SendData,
      cmd_RecData:
        begin
          with pATCmdBuff(Param)^ do
            ChAtCmd(CmdStr,Code,Delay1,Delay2,TimeOut);
          ChSetResult(res_Ok);
        end;
      else ChSetResult(CH_NumName or res_Err);
    end;
  end
  else
    if Assigned(CH_Chn) then
    begin
      CH_Chn.ChSetBinParam(NumName,Code,Param);
      ChSetResult(CH_Chn.ChResult);
    end
    else
      ChSetResult(CH_NumName or res_ErrChannelNoExist);
end;

{------------------------------}
function  tChnMod2.ChGetBinParam(NumName: Word; Code: Word): longint;
begin
  if NumName=CH_NumName then
  begin
    ChSetResult(res_Ok);
    case Code of
      cmd_GetMSR:
        begin
          ChGetBinParam:=ChGetModem;
        end;
      cmd_GetCTS:
        begin
          if (ChGetModem and Ms_CTS_ON)=0 then
               ChGetBinParam:=0
          else ChGetBinParam:=1;
        end;
      cmd_GetDSR:
        begin
          if (ChGetModem and Ms_DSR_ON)=0 then
               ChGetBinParam:=0
          else ChGetBinParam:=1;
        end;
      cmd_GetRI :
        begin
          if (ChGetModem and Ms_RING_ON)=0 then
               ChGetBinParam:=0
          else ChGetBinParam:=1;
        end;
      cmd_GetCD :
        begin
          if (ChGetModem and Ms_RLSD_ON)=0 then
               ChGetBinParam:=0
          else ChGetBinParam:=1;
        end;
      cmd_GetChCtrl2:
        begin
          ChGetBinParam:=Word(CH_Ctrl2);
        end;
      cmd_CmdReady:
        begin
          ChGetBinParam:=longint(ChAtCmdReady);
          ChSetResult(res_Ok);
        end;
      cmd_CmdResult:
        begin
          ChGetBinParam:=ChAtCmdResult;
          ChSetResult(res_Ok);
        end;
      else
        begin
          ChGetBinParam:=0;
          ChSetResult(CH_NumName or res_Err);
        end;
    end;
  end
  else
    if Assigned(CH_Chn) then
    begin
      ChGetBinParam:=CH_Chn.ChGetBinParam(NumName,Code);
      ChSetResult(CH_Chn.ChResult);
    end
    else
    begin
      ChGetBinParam:=0;
      ChSetResult(CH_NumName or res_ErrChannelNoExist);
    end;
end;

{------------------------------}
procedure tChnMod2.ChATCmd(S:string; Mode_:word; Del1,Del2,TimOut:longint);
{ procedura pro inicialisaci poslani commandu do modemu }
{ S       - pozadovany commnad (string)
  Mode_   - pripustne hodnoty Mode_xx
  Del1    - prodleva pred vyslanim commandu [ms]
  Del2    - prodleva po vyslani commandu    [ms]
  TimOut  - pripustny timeout [ms] )

A. Mode= cmd_SendCmd   - pouze vyslani prikazu S s doplnenim CR
  SMCS_beg
  SMCS_delay1   cekani po dobu Delay1
  SMCS_send     vyprazdneni prijimaciho kanalu, vyslani stringu "s"+cr
  SMCS_delay2   cekani po dobu Delay2
  SMCS_end

B. Mode= cmd_CmdAnsw   - vyslani prikazu S s doplnenim CR
                         a cekani na odpoved s odstranenim CR
  SMCS_beg
  SMCS_delay1   cekani po dobu Delay1
  SMCS_send     vyprazdneni prijimaciho kanalu, vyslani stringu "s"+cr
  SMCS_delay2   cekani po dobu Delay2
  SMCS_rec      prijem odpovedi:
                - ignorovani cr pred zpravou,
                - ignorovani lf vzdy,
                - konec zpravy detekovan pomoci cr resp. uplynutim timeoutu.
                  (cr do answ-stringu nezapisovan!)
                - je-li length(answ)>40 znaku then Result_LongAnsw
                uplyne-li cas TimOut, pak
                - je-li answ='' , pak Result_RTimeout
                - je-li answ<>'' pak prechod na SMCS_recend
  SMCS_recend   - je-li answ=vysilany string, pak jeho ignorovani (jedna se zrejme o echo),
                  prechod zpet na SMCS_rec
                - je-li pocatek answ=IM_OKS (OK-string), pak Result_OK
                - je-li pocatek answ=IM_COS (CONNECT-string), pak Result_Connect
                - je-li pocatek answ=IM_BUS (BUSY-string), pak Result_Busy
                jinak Result_Answ
  SMCS_end

C. Mode= cmd_RecAnsw   - pouze cekani na odpoved bez vyslani prikazu
  SMCS_beg
  SMCS_delay1   cekani po dobu Delay1
  SMCS_send     zadna cinnost
  SMCS_delay2   cekani po dobu Delay2
  SMCS_rec      prijem odpovedi:
                - ignorovani cr pred zpravou,
                - ignorovani lf vzdy,
                - konec zpravy detekovan pomoci cr resp. uplynutim timeoutu.
                  (cr do answ-stringu nezapisovan!)
                - je-li length(answ)>40 znaku then Result_LongAnsw
                uplyne-li cas TimOut, pak
                - je-li answ='' , pak Result_RTimeout
                - je-li answ<>'' pak prechod na SMCS_recend
  SMCS_recend   - je-li answ=vysilany string, pak jeho ignorovani (jedna se zrejme o echo),
                  prechod zpet na SMCS_rec
                - je-li pocatek answ=IM_OKS (OK-string), pak Result_OK
                - je-li pocatek answ=IM_COS (CONNECT-string), pak Result_Connect
                - je-li pocatek answ=IM_BUS (BUSY-string), pak Result_Busy
                jinak Result_Answ
  SMCS_end

D. Mode= cmd_SendData   - vyslani stringu S bez doplneni CR
  SMCS_beg
  SMCS_delay1   cekani po dobu Delay1
  SMCS_send     vyprazdneni prijimaciho kanalu, vyslani stringu "s"
  SMCS_delay2   cekani po dobu Delay2
  SMCS_rec      cekani po dobu TimOut
  SMCS_end

Ve stavu SMCS_end je vracen nektery ze stavu SMC_Result}

begin
  with CH_ATCmdBuff^ do
  begin
    CmdStr :=S;
    Mode   :=Mode_;
    Delay1 :=Del1;
    Delay2 :=Del2;
    TimeOut:=TimOut;
    RecStr :='';
  end;
  SMC_Ctrl  :=SMCS_Beg;
  SMC_Result:=ResMod_Ok;
  SMC_ChnTime.SaveTime;
  ChAtCmdTick;
end;

{------------------------------}
function  tChnMod2.ChAtCmdReady : TSMC_Ctrl;
begin
  ChAtCmdTick;
    { nastavuje SMC_Result }
  ChAtCmdReady:=SMC_Ctrl;
end;

{------------------------------}
procedure tChnMod2.ChAtCmdTick;
label
  L_FlowControl, L_Send, L_SendDelay, L_Delay2, L_Rec, L_RecEnd, L_End, PomL_Za;
var
  ch:char;
begin
  with CH_ATCmdBuff^ do
  case SMC_Ctrl of
    SMCS_Beg,
    SMCS_Delay1:   { prodleva delay1 pred vyslanim commandu }
      begin
        if (Delay1=0)or(SMC_ChnTime.TstTime(Delay1)) then
          begin
            SMC_ChnTime.SaveTime;
            SMC_Ctrl:=SMCS_FlowControl;
            goto L_FlowControl;
          end;
      end;
    SMCS_FlowControl:
       L_FlowControl:
      begin
        case CH_FlowCntrl of
          0:begin
              SMC_Ctrl:=SMCS_Send;
              goto L_Send;
            end;
          1:if (ChGetModem and Ms_CTS_ON)<>0 then
            begin { je-li signal CTS }
              SMC_Ctrl:=SMCS_Send;
              goto L_Send;
            end
            else  { neni-li signal CTS }
            if SMC_ChnTime.TstTime(TimeOut) then
            begin { byl prekrocen Timeout }
              SMC_Ctrl:=SMCS_Ready;
              SMC_Result:=ResMod_STimeOut;
            end;
          2:if (ChGetModem and Ms_DSR_ON)<>0 then
            begin { je-li signal DSR }
              SMC_Ctrl:=SMCS_Send;
              goto L_Send;
            end
            else  { neni-li signal DSR }
            if SMC_ChnTime.TstTime(TimeOut) then
            begin { byl prekrocen Timeout }
              SMC_Ctrl:=SMCS_Ready;
              SMC_Result:=ResMod_STimeOut;
            end;
          else
            begin
              SMC_Ctrl:=SMCS_Send;
              goto L_Send;
            end;
        end;
      end;
    SMCS_Send:
      L_Send:
      begin
        ChSendFlushHW;
        if (Mode=cmd_SendCmd)or(Mode=cmd_CmdAnsw)or(Mode=cmd_SendData) then
        begin
          {$ifdef Deb_SendRec}
            writeln('out(',CH_Ctrl:2,')>',CmdStr,'<');
          {$endif}
          if (Mode=cmd_SendCmd)or(Mode=cmd_CmdAnsw) then
          begin
            { vyprazdneni prijimaciho kanalu }
            ChReceiveFlushHW;
            CmdStr:=CmdStr+CH_Char_CR;
          end;
          ChSendHW(@CmdStr[1],Length(CmdStr));

          if ChSendResult=res_Ok then
          begin
            SMC_Ctrl:=SMCS_SendDelay;
            SMC_ChnTime.SaveTime;
          end
          else
          begin
            SMC_Ctrl:=SMCS_Ready;
            SMC_Result:=ResMod_SHwErr;
          end;
        end
        else           { SMC_mode vyzaduje pouze odpoved }
        begin
          if ChSendReadyHW=CHS_SendReady then {jestli se nahodou jeste nevysila}
          begin
            SMC_Ctrl:=SMCS_Delay2;
            goto L_Delay2;
          end;
          if SMC_ChnTime.TstTime(CH_TimeOut[SendAtCmd]) then
          begin
            SMC_Ctrl:=SMCS_Ready;
            SMC_Result:=ResMod_STimeOut;
            {$ifdef Deb_SendRec}
              writeln('TimeOut while Send');
            {$endif}
          end;
        end;
      end;
    SMCS_SendDelay:
      L_SendDelay:
      begin
        if ChSendReadyHW=CHS_SendReady then
        begin
          SMC_ChnTime.SaveTime;
          SMC_Ctrl:=SMCS_Delay2;
          goto L_Delay2;
        end;
        if SMC_ChnTime.TstTime(CH_TimeOut[SendAtCmd]) then
        begin
          SMC_Ctrl:=SMCS_Ready;
          SMC_Result:=ResMod_STimeOut;
          {$ifdef Deb_SendRec}
            writeln('TimeOut while Send');
          {$endif}
        end;
      end;
    SMCS_Delay2:
      L_Delay2:
      begin
        if (Delay2=0)or(SMC_ChnTime.TstTime(Delay2)) then
        begin
          SMC_ChnTime.SaveTime;
          SMC_Ctrl:=SMCS_Rec;
          goto L_Rec;
        end;
      end;
    SMCS_Rec:
      L_Rec:
      begin
        if (Mode=cmd_SendCmd)or(Mode=cmd_SendData) then  { nema se prijimat }
        begin
          SMC_Result:=ResMod_Ok;
          SMC_Ctrl:=SMCS_Ready;
          goto L_End;
        end
        else  { cekani na prijem }
        begin
          while ChReceiveReadyHW=CHS_ReceiveReady do   { postupne cteni dat z modemu }
          begin
            Ch:=UpCase(chr(ChReceiveCharHW));
            if ChReceiveResult<>res_Ok then
            begin
              SMC_Result:=ResMod_RHwErr;
              SMC_Ctrl:=SMCS_Ready;
              goto L_End;
            end
            else
            begin
              if Ch=CH_Char_CR then
              begin
                {$ifdef Deb_LoRec}
                  write('[CR]');
                {$endif}
                if RecStr<>'' then              { ignorovani cr pred zpravou }
                begin
                  SMC_ChnTime.SaveTime;
                  SMC_Ctrl:=SMCS_RecEnd;
                  goto L_RecEnd;
                end;
              end
              else
              if Ch=CH_Char_LF then
              begin
                {$ifdef Deb_LoRec}
                  write('[LF]');
                {$endif}
                if RecStr<>'' then
                begin
                  SMC_Result:=ResMod_LongAnswer;
                  SMC_Ctrl:=SMCS_Ready;
                  goto L_End;
                end;
              end
              else
              begin
                {$ifdef Deb_LoRec}
                  write(Ch);
                {$endif}
(*                if Length(RecStr)<(SizeOf(RecStr)-1) then*)
                  RecStr:=RecStr+ch            { skladani odpovedi }
(*                else
                begin
                  SMC_Result:=ResMod_LongAnswer;
                  SMC_Ctrl:=SMCS_Ready;
                  goto L_End;
                end;
!Wi - pri pouzivani dlouhych stringu je toto zbytecny
*)
              end;
            end;
          end;
          if SMC_ChnTime.TstTime(TimeOut) then { test na timeout }
          begin
            if RecStr='' then
            begin
              SMC_Result:=ResMod_RTimeOut;
              {$ifdef Deb_SendRec}
               {$ifdef Deb_LoRec}
                writeln;
               {$endif}
                writeln('Result: ',byte(SMC_Result));
              {$endif}
              SMC_Ctrl:=SMCS_Ready;
              goto L_End;
            end
            else
            begin
              SMC_ChnTime.SaveTime;
              SMC_Ctrl:=SMCS_RecEnd;
              goto L_RecEnd;
            end;
          end;
        end;
      end;
    SMCS_RecEnd:
      L_RecEnd:
      begin
        if (Mode=cmd_CmdAnsw) and (RecStr+CH_Char_CR=CmdStr) then
                 { prijem=vysilani -> zapnute echo -> jeho ignorovani }
        begin
          RecStr:='';
          SMC_ChnTime.SaveTime;
          SMC_Ctrl:=SMCS_Rec;
          goto L_Rec;
        end
        else
        begin
          if Copy(RecStr,1,Length(CH_Str[AnswOK]))=CH_Str[AnswOK] then
             begin
               SMC_Result:=ResMod_Ok;
               goto PomL_Za;
             end
          else
          if Copy(RecStr,1,length(CH_Str[AnswCONNECT]))=CH_Str[AnswCONNECT] then
             begin
               SMC_Result:=ResMod_CONNECT;
               goto PomL_Za;
             end
          else
          if Copy(RecStr,1,length(CH_Str[AnswBUSY]))=CH_Str[AnswBUSY] then
             begin
               SMC_Result:=ResMod_BUSY;
               goto PomL_Za;
             end
          else
          if Copy(RecStr,1,length(CH_Str[AnswNOCARRY]))=CH_Str[AnswNOCARRY] then
             begin
               SMC_Result:=ResMod_NoCarry;
               goto PomL_Za;
             end
          else
          if Copy(RecStr,1,length(CH_Str[AnswERROR]))=CH_Str[AnswERROR] then
             begin
               SMC_Result:=ResMod_Error;
               goto PomL_Za;
             end
          else
             begin
               SMC_Result:=ResMod_Answer;    { nejaka jina odpoved }
             end;
        PomL_Za:
          {$ifdef Deb_SendRec}
           {$ifdef Deb_LoRec}
            writeln;
           {$endif}
            writeln('in (',CH_Ctrl:2,')>',RecStr,'<','  Result: ',byte(SMC_Result));
          {$endif}
          SMC_Ctrl:=SMCS_Ready;
          goto L_End;
        end;
      end;
    SMCS_Ready:
      L_End:
      begin
      end;
  end; { case }
end;

{------------------------------}
function  tChnMod2.ChAtCmdResult : integer;
begin
  ChAtCmdResult:=SMC_Result;
  SMC_Result:=ResMod_Ok;
end;

{------------------------------}
function  tChnMod2.ChResultStr (Sts : tChResult) : tResultStr;
begin
  if Sts and $FF00 = CH_NumName then
  begin
    Result:=inherited ChResultStr(Sts);
    if Result='' then
    case Lo(Sts) of
      Res_ErrInitStr1   : ChResultStr:='Error in 1.Init AT Cmd';
      Res_ErrInitStr2   : ChResultStr:='Error in 2.Init AT Cmd';
      Res_ErrInitStr3   : ChResultStr:='Error in 3.Init AT Cmd';
      Res_ErrPhoneNum   : ChResultStr:='Phone Number Absent';
      Res_ErrDial       : ChResultStr:='Dial Number Error';
      Res_ErrCDAbsent   : ChResultStr:='Not CD';
      Res_ErrSWHangUp   : ChResultStr:='SW HangUp Error';
      ResMod_Error      : ChResultStr:='Modem responds ERROR';
      ResMod_NoCarry    : ChResultStr:='Modem responds NO CARRIER';
      ResMod_Answer     : ChResultStr:='Unknown Answer from Modem';
      ResMod_LongAnswer : ChResultStr:='Too Long Answer from Modem';
      ResMod_SHwErr     : ChResultStr:='HW Send Error';
      ResMod_RHwErr     : ChResultStr:='HW Receive Error';
      ResMod_RTimeOut   : ChResultStr:='TimeOut while Receive';
      ResMod_STimeOut   : ChResultStr:='TimeOut while Send';
    end;
  end
  else
    ChResultStr:=inherited ChResultStr(Sts);
end;

{------------------------------}
procedure tChnMod2.ChTick;
label
  L_InitBeg,
  L_HWIni1   , L_HWIni2   , L_HWIni3,
  L_IniRep   , L_SWIni1   , L_SWIni2   , L_SWIni3,
  L_DialAnsw , L_DialEnd  ,
  L_Busy     , L_WaitForCD,
  L_DisConBeg, L_HWHangUp1, L_HWHangUp2, L_SWHangUp1, L_SWHangUp2, L_SWHangUp3;
begin
  if not LongBool(InterlockedExchange( integer(CH_Tick), Ord(true) )) then
  begin
    { vnitrni automat }
    case CH_Ctrl2 of
      CHS_Close,
      CHS_Open
      {CHS_DisConnect}: { stabilni stavy - nedeje se nic }
        begin
        end;
      CHS_Connect:    { stabilni stav - testuje se pouze CD u stanice Master }
        begin
          if (CH_Master)and
             (ChGetModem and Ms_RLSD_ON=0) then { nastal vypadek CD zacina se Disconnect a potom Connect }
          begin
            {$ifdef Deb_Ctrl}
              writeln('Err - CD ShutDown');
            {$endif}
            CH_ModSig_CD:=False;
            CH_CDShutDown:=True;
            ChReceiveFlushHW; if ChReceiveResult<>Res_Ok then ;
            CH_Ctrl2Save:=CHS2_InitBeg;
            CH_Ctrl2:=CHS2_DisConBeg;
            goto L_DisConBeg;
          end;
        end;
      CHS2_InitBeg:         { Pocatek automatu pro navazani spojeni }
        L_InitBeg:
        begin
          CH_Cnt:=CH_Rep;
          if CH_Cnt=0 then CH_Cnt:=1;
          if CH_FlHWI then
          begin
            {$ifdef Deb_Ctrl}
              writeln('HW Init');
            {$endif}
            ChSetModem(SetDTR or SetRTS); { nastaveni DTR signalu }
            SMC_ChnTime.SaveTime;
            CH_Ctrl2:=CHS2_HWIni1;
            goto L_HWIni1;
          end
          else
          begin
            SMC_ChnTime.SaveTime;
            CH_Ctrl2:=CHS2_IniRep;
            goto L_IniRep;
          end;
        end;
      CHS2_HWIni1:          { 1. krok HW init }
        L_HWIni1:
        begin
          if SMC_ChnTime.TstTime(CH_Delay[HWIni1]) then
          begin
            ChResModem(SetDTR or SetRTS);
            SMC_ChnTime.SaveTime;
            CH_Ctrl2:=CHS2_HWIni2;
            goto L_HWIni2;
          end;
        end;
      CHS2_HWIni2:          { 2. krok HW init }
        L_HWIni2:
        begin
          if SMC_ChnTime.TstTime(CH_Delay[HWIni0]) then
          begin
            ChSetModem(SetDTR or SetRTS); { nastaveni DTR signalu }
            SMC_ChnTime.SaveTime;
            CH_Ctrl2:=CHS2_HWIni3;
            goto L_HWIni3;
          end;
        end;
      CHS2_HWIni3:          { 3. krok HW init }
        L_HWIni3:
        begin
          if SMC_ChnTime.TstTime(CH_Delay[HWIni1]) then
          begin
            SMC_ChnTime.SaveTime;
            CH_Ctrl2:=CHS2_IniRep;{ skok na SW init }
            goto L_IniRep;
          end;
        end;
      CHS2_IniRep:   { zacatek SW init }
        L_IniRep:
        begin
          ChReceiveFlushHW; if ChReceiveResult<>Res_Ok then ; {vymazani prijimaciho bufferu}
          {$ifdef Deb_Ctrl}
            writeln('SW Init ',CH_Cnt,' pokus');
          {$endif}
          if CH_Str[Init1S]<>'' then { pocatek vyslani 1.Init retezce }
             ChATCmd(CH_Str[Init1S],cmd_SendCmd,0,CH_Delay[AfterI1S],0)
          else SMC_Ctrl:=SMCS_Ready;
          CH_RepATCt:=0;
          SMC_ChnTime.SaveTime;
          CH_Ctrl2:=CHS2_SWIni1;
          goto L_SWIni1;
        end;
      CHS2_SWIni1:  { pokracovani SW init }
        L_SWIni1:
        if ChAtCmdReady=SMCS_Ready then { ceka se do konce provedeni 1.Init retezce }
        begin
          if (ChATCmdResult in [ResMod_RTimeOut,
                                ResMod_STimeOut,
                                ResMod_SHwErr,
                                ResMod_RHwErr])or
             (CH_Result <>res_Ok)or
             (CH_RResult<>res_Ok)or
             (CH_SResult<>res_Ok)then
             begin { predchozi Init retezec se neprovedl spravne }
               Inc(CH_RepATCt);
               if CH_RepATCt<=CH_RepAT then
               begin
                 CH_Result :=res_Ok;
                 CH_RResult:=res_Ok;
                 CH_SResult:=res_Ok;
                 if CH_Str[Init1S]<>'' then { pocatek vyslani 1.Init retezce }
                    ChATCmd(CH_Str[Init1S],cmd_SendCmd,0,CH_Delay[AfterI1S],0)
                 else SMC_Ctrl:=SMCS_Ready;
                 goto L_SWIni1;
               end
               else
               begin
                 ChSetResult(CH_NumName or Res_ErrInitStr1);
                 SMC_ChnTime.SaveTime;
                 CH_Ctrl2:=CHS2_DisConBeg;
                 CH_Ctrl2Save:=CHS2_InitBeg;
                 goto L_DisConBeg;
               end;
             end;
          if CH_Str[Init2S]<>'' then { pocatek vyslani 2.Init retezce }
             ChATCmd(CH_Str[Init2S],cmd_CmdAnsw,0,CH_Delay[AfterI2S],CH_TimeOut[CmdAnsw])
          else SMC_Ctrl:=SMCS_Ready;
          CH_RepATCt:=0;
          SMC_ChnTime.SaveTime;
          CH_Ctrl2:=CHS2_SWIni2;
          goto L_SWIni2;
        end;
      CHS2_SWIni2:
        L_SWIni2:
        if ChAtCmdReady=SMCS_Ready then { ceka se do konce provedeni 2.Init retezce }
        begin
          if (ChATCmdResult in [ResMod_RTimeOut,
                                ResMod_STimeOut,
                                ResMod_SHwErr,
                                ResMod_RHwErr])or
             (CH_Result <>res_Ok)or
             (CH_RResult<>res_Ok)or
             (CH_SResult<>res_Ok)then
             begin { predchozi Init retezec se neprovedl spravne }
               Inc(CH_RepATCt);
               if CH_RepATCt<=CH_RepAT then
               begin
                 CH_Result :=res_Ok;
                 CH_RResult:=res_Ok;
                 CH_SResult:=res_Ok;
                 if CH_Str[Init2S]<>'' then { pocatek vyslani 2.Init retezce }
                    ChATCmd(CH_Str[Init2S],cmd_CmdAnsw,0,CH_Delay[AfterI2S],CH_TimeOut[CmdAnsw])
                 else SMC_Ctrl:=SMCS_Ready;
                 goto L_SWIni2;
               end
               else
               begin
                 ChSetResult(CH_NumName or Res_ErrInitStr2);
                 SMC_ChnTime.SaveTime;
                 CH_Ctrl2:=CHS2_DisConBeg;
                 CH_Ctrl2Save:=CHS2_InitBeg;
                 goto L_DisConBeg;
               end;
             end;
          if CH_Str[Init3S]<>'' then { vyslani 3.Init retezce }
             ChATCmd(CH_Str[Init3S],cmd_CmdAnsw,0,CH_Delay[AfterI3S],CH_TimeOut[CmdAnsw])
          else SMC_Ctrl:=SMCS_Ready;
          CH_RepATCt:=0;
          SMC_ChnTime.SaveTime;
          CH_Ctrl2:=CHS2_SWIni3;
          goto L_SWIni3;
        end;
      CHS2_SWIni3:
        L_SWIni3:
        if ChAtCmdReady=SMCS_Ready then { ceka se do konce provedeni 3.Init retezce }
        begin
          if (ChATCmdResult in [ResMod_RTimeOut,
                                ResMod_STimeOut,
                                ResMod_SHwErr,
                                ResMod_RHwErr])or
             (CH_Result <>res_Ok)or
             (CH_RResult<>res_Ok)or
             (CH_SResult<>res_Ok) then
             begin { predchozi Init retezec se neprovedl spravne }
               Inc(CH_RepATCt);
               if CH_RepATCt<=CH_RepAT then
               begin
                 CH_Result :=res_Ok;
                 CH_RResult:=res_Ok;
                 CH_SResult:=res_Ok;
                 if CH_Str[Init3S]<>'' then { pocatek vyslani 3.Init retezce }
                    ChATCmd(CH_Str[Init3S],cmd_CmdAnsw,0,CH_Delay[AfterI3S],CH_TimeOut[CmdAnsw])
                 else SMC_Ctrl:=SMCS_Ready;
                 goto L_SWIni3;
               end
               else
               begin
                 ChSetResult(CH_NumName or Res_ErrInitStr3);
                 SMC_ChnTime.SaveTime;
                 CH_Ctrl2:=CHS2_DisConBeg;
                 CH_Ctrl2Save:=CHS2_InitBeg;
                 goto L_DisConBeg;
               end;
             end;
          if CH_Master then { Master vytaci cislo }
            if CH_Str[DialNum]<>'' then
            begin
              ChATCmd(CH_Str[DialPns]+CH_Str[DialNum],cmd_CmdAnsw,0,0,CH_TimeOut[DialAnsw1]);
              CH_RepATCt:=0;
              SMC_ChnTime.SaveTime;
              CH_Ctrl2:=CHS2_DialAnsw1;
              goto L_DialAnsw;
            end
            else
            begin
              ChSetResult(CH_NumName or Res_ErrPhoneNum);
              SMC_ChnTime.SaveTime;
              CH_Ctrl2:=CHS2_DisConBeg;
              goto L_DisConBeg;
            end
          else { pro Slave je Connect dokoncen }
            begin
              ChSendFlush;    if ChSendResult<>res_Ok then ;
              ChReceiveFlush; if ChReceiveResult<>res_Ok then ;
              CH_Ctrl :=CHS_Connect;
              CH_Ctrl2:=CH_Ctrl;
              CH_Ctrl2Save:=CH_Ctrl2;
              CH_State:=CH_Ctrl;
            end;
        end;
      CHS2_DialAnsw1,  { prijem az 3 odpovedi na prikaz pro vytaceni cisla }
      CHS2_DialAnsw2,
      CHS2_DialAnsw3:
        L_DialAnsw:
        if ChAtCmdReady=SMCS_Ready then { ceka se do provedeni prikazu pro vytoceni cisla }
        case ChAtCmdResult of
          ResMod_SHwErr,
          ResMod_RHwErr,
          ResMod_RTimeOut,
          ResMod_STimeOut:
            begin { chyba pri komunikaci }
              Inc(CH_RepATCt);
              if CH_RepATCt<=CH_RepAT then
              begin
                CH_Result :=res_Ok;
                CH_RResult:=res_Ok;
                CH_SResult:=res_Ok;
                ChATCmd(CH_Str[DialPns]+CH_Str[DialNum],cmd_CmdAnsw,0,0,CH_TimeOut[DialAnsw1]);
                goto L_DialAnsw;
              end
              else
              begin
                ChSetResult(CH_NumName or Res_ErrDial);
                SMC_ChnTime.SaveTime;
                CH_Ctrl2:=CHS2_DialEnd;
              end;
            end;
          ResMod_Busy: { "obsazeno" }
            begin
              Dec(CH_Cnt);
              if CH_Cnt>0 then
              begin { zkousi se znovu }
                SMC_ChnTime.SaveTime;
                CH_Ctrl2:=CHS2_Busy;
                goto L_Busy;
              end
              else
              begin
                SMC_ChnTime.SaveTime;
                CH_Ctrl2:=CHS2_DisConBeg;
                CH_Ctrl2Save:=CHS2_InitBeg;
                goto L_DisConBeg;
              end;
            end;
          ResMod_NoCarry: { "nikdo to nezveda" }
            begin
              Dec(CH_Cnt);
              if CH_Cnt>0 then
              begin { zkousi se znovu }
                SMC_ChnTime.SaveTime;
                CH_Ctrl2:=CHS2_Busy;
                goto L_Busy;
              end
              else
              begin
                SMC_ChnTime.SaveTime;
                CH_Ctrl2:=CHS2_DisConBeg;
                CH_Ctrl2Save:=CHS2_InitBeg;
                goto L_DisConBeg;
              end;
            end;
          ResMod_Connect: { spojeni provedeno }
            begin
              SMC_ChnTime.SaveTime;
              CH_Ctrl2:=CHS2_WaitForCD;
              goto L_WaitForCD;
            end;
          ResMod_Answer, { jina odpoved }
          ResMod_Ok:
            case CH_Ctrl2 of
              CHS2_DialAnsw1:
                begin
                  if CH_TimeOut[DialAnsw2]>0 then
                  begin
                    ChATCmd('',cmd_RecAnsw,0,0,CH_TimeOut[DialAnsw2]);
                    SMC_ChnTime.SaveTime;
                    CH_Ctrl2:=CHS2_DialAnsw2;
                    goto L_DialAnsw;
                  end
                  else
                  begin
                    SMC_ChnTime.SaveTime;
                    CH_Ctrl2:=CHS2_DialEnd;
                    goto L_DialEnd;
                  end;
                end;
              CHS2_DialAnsw2:
                begin
                  if CH_TimeOut[DialAnsw3]>0 then
                  begin
                    ChATCmd('',cmd_RecAnsw,0,0,CH_TimeOut[DialAnsw3]);
                    SMC_ChnTime.SaveTime;
                    CH_Ctrl2:=CHS2_DialAnsw3;
                    goto L_DialAnsw;
                  end
                  else
                  begin
                    SMC_ChnTime.SaveTime;
                    CH_Ctrl2:=CHS2_DialEnd;
                    goto L_DialEnd;
                  end;
                end;
              CHS2_DialAnsw3:
                begin
                  SMC_ChnTime.SaveTime;
                  CH_Ctrl2:=CHS2_DialEnd;
                  goto L_DialEnd;
                end;
            end;
          else
            begin
              SMC_ChnTime.SaveTime;
              CH_Ctrl2:=CHS2_DialEnd;
              goto L_DialEnd;
            end;
        end;
      CHS2_WaitForCD:
        L_WaitForCD:
        if (ChGetModem and Ms_RLSD_ON)<>0 then { ceka se do signalu CD }
        begin
          ChReceiveFlushHW; if ChReceiveResult<>Res_Ok then ;
          CH_ModSig_CD :=True;
          CH_CdShutDown:=False;
          CH_FlTestCD  :=True;
          SMC_ChnTime.SaveTime;
          CH_Ctrl2:=CHS_Connect;
          CH_Ctrl2Save:=CHS_Connect;
          CH_Ctrl:=CHS_Connect;
          CH_State:=CH_Ctrl;
        end
        else
          {toto by nemelo nikdy nastat ale kdo vi}
          if SMC_ChnTime.TstTime(1000) then
          begin
            ChSetResult(CH_NumName or Res_ErrCDAbsent);
            SMC_ChnTime.SaveTime;
            CH_Ctrl2:=CHS2_DisConBeg;
            CH_Ctrl2Save:=CHS2_InitBeg;
            goto L_DisConBeg;
          end;
      CHS2_DialEnd:
        L_DialEnd:
        begin
          Dec(CH_Cnt);
          if CH_Cnt>0 then
          begin
            SMC_ChnTime.SaveTime;
            CH_Ctrl2:=CHS2_DisConBeg;
            CH_Ctrl2Save:=CHS2_IniRep;
            goto L_DisConBeg;
          end
          else
          begin
            SMC_ChnTime.SaveTime;
            CH_Ctrl2:=CHS2_DisConBeg;
            CH_Ctrl2Save:=CHS2_InitBeg;
            goto L_DisConBeg;
          end;
        end;
      CHS2_Busy:
        L_Busy:
        begin
          if SMC_ChnTime.TstTime(CH_Delay[Busy]) then
          begin
            SMC_ChnTime.SaveTime;
            CH_Ctrl2:=CHS2_IniRep;
          end;
        end;

      CHS2_DisConBeg:
        L_DisConBeg:
        begin
          CH_CdShutDown:=False;
          if CH_FlHWH then
          begin
            {$ifdef Deb_Ctrl}
              writeln('HW HangUp');
            {$endif}
            ChResModem(SetDTR);
            SMC_ChnTime.SaveTime;
            CH_Ctrl2:=CHS2_HWHangUp1;
            goto L_HWHangUp1;
          end
          else
          begin
            {$ifdef Deb_Ctrl}
              writeln('SW HangUp');
            {$endif}
            if ChGetModem and Ms_RLSD_ON<>0 then
            begin
              ChATCmd(CH_Str[EscStr],cmd_SendData,CH_Delay[Esc],CH_Delay[Esc],0);
              CH_RepATCt:=0;
              SMC_ChnTime.SaveTime;
              CH_Ctrl2:=CHS2_SWHangUp1;
              goto L_SWHangUp1;
            end
            else
            begin
              ChATCmd(CH_Str[Ath],cmd_CmdAnsw,0,0,CH_TimeOut[CmdAnsw]);
              CH_RepATCt:=0;
              SMC_ChnTime.SaveTime;
              CH_Ctrl2:=CHS2_SWHangUp3;
              goto L_SWHangUp3;
            end;
          end;
        end;
      CHS2_HWHangUp1:
        L_HWHangUp1:
        if SMC_ChnTime.TstTime(CH_Delay[HWHangUp0]) then
        begin
          ChSetModem(SetDTR);
          SMC_ChnTime.SaveTime;
          CH_Ctrl2:=CHS2_HWHangUp2;
          goto L_HWHangUp2;
        end;
      CHS2_HWHangUp2:
        L_HWHangUp2:
        if SMC_ChnTime.TstTime(CH_Delay[HWHangUp1]) then
        begin
          SMC_ChnTime.SaveTime;
          CH_Ctrl2:=CH_Ctrl2Save;
          if CH_Ctrl2Save=CHS_Disconnect then
          begin
            CH_Ctrl :=CHS_DisConnect;
            CH_State:=CH_Ctrl;
          end;
          CH_CdShutDown:=False;
          CH_FlTestCD  :=False;
        end;
      CHS2_SWHangUp1:
        L_SWHangUp1:
        if ChAtCmdReady=SMCS_Ready then
        case ChAtCmdResult of
          ResMod_Ok:
            begin
              ChATCmd('',cmd_RecAnsw,0,0,CH_TimeOut[CmdAnsw]);
              SMC_ChnTime.SaveTime;
              CH_Ctrl2:=CHS2_SWHangUp2;
              goto L_SWHangUp2;
            end;
          else
            begin { chyba pri komunikaci }
              ChSetResult(CH_NumName or Res_ErrSWHangUp);
              SMC_ChnTime.SaveTime;
              CH_Ctrl2:=CHS2_DisConBeg;
              goto L_DisConBeg;
            end;
        end;
      CHS2_SWHangUp2:
        L_SWHangUp2:
        if ChAtCmdReady=SMCS_Ready then
        case ChAtCmdResult of
          ResMod_Ok:
            begin
              ChATCmd(CH_Str[Ath],cmd_CmdAnsw,0,0,CH_TimeOut[CmdAnsw]);
              CH_RepATCt:=0;
              SMC_ChnTime.SaveTime;
              CH_Ctrl2:=CHS2_SWHangUp3;
              goto L_SWHangUp3;
            end;
          else
            begin { chyba pri komunikaci }
              Inc(CH_RepATCt);
              if CH_RepATCt<=CH_RepAT then
              begin
                CH_Result :=res_Ok;
                CH_RResult:=res_Ok;
                CH_SResult:=res_Ok;
                ChATCmd(CH_Str[EscStr],cmd_SendData,CH_Delay[Esc],CH_Delay[Esc],0);
                SMC_ChnTime.SaveTime;
                CH_Ctrl2:=CHS2_SWHangUp1;
                goto L_SWHangUp1;
              end
              else
              begin
                ChSetResult(CH_NumName or Res_ErrSWHangUp);
                SMC_ChnTime.SaveTime;
                CH_Ctrl2:=CHS2_DisConBeg;
                goto L_DisConBeg;
              end;
            end;
        end;
      CHS2_SWHangUp3:
        L_SWHangUp3:
        if ChAtCmdReady=SMCS_Ready then
        case ChAtCmdResult of
          ResMod_Ok:
            begin
              SMC_ChnTime.SaveTime;
              CH_Ctrl2:=CH_Ctrl2Save;
              if CH_Ctrl2Save=CHS_DisConnect then
              begin
                CH_Ctrl :=CHS_DisConnect;
                CH_State:=CH_Ctrl;
              end;
              CH_CdShutDown:=False;
              CH_FlTestCD  :=False;
            end;
          else
            begin { chyba pri komunikaci }
              Inc(CH_RepATCt);
              if CH_RepATCt<=CH_RepAT then
              begin
                CH_Result :=res_Ok;
                CH_RResult:=res_Ok;
                CH_SResult:=res_Ok;
                ChATCmd(CH_Str[Ath],cmd_CmdAnsw,0,0,CH_TimeOut[CmdAnsw]);
                goto L_SWHangUp3;
              end
              else
              begin
                ChSetResult(CH_NumName or Res_ErrSWHangUp);
                SMC_ChnTime.SaveTime;
                CH_Ctrl2:=CHS2_DisConBeg;
                goto L_DisConBeg;
              end;
            end;
        end;
    end; {case}
    CH_Tick:=false;
  end;
end; {ChTick}

{------------------------------}
procedure tChnMod2.ChSendTick;
label
  L_SendBegin, L_Send;
begin
  if not LongBool(InterlockedExchange( integer(CH_STick), Ord(true) )) then
  begin
    case CH_SCtrl of
      CHS_SendReady,   { stabilni stavy - nedeje se nic }
      CHS_SendNoReady:
        begin
        end;
      CHS_SendBegin:
       L_SendBegin:
        begin
         {Master}
          if CH_Master then
          begin
            if (ChReady =CHS_Connect)and   { postrci se automat, CH_Crtl a CH_Ctrl2 }
               (CH_Ctrl2=CHS_Connect)then
            begin
              ChSendHW(CH_PomBuff,CH_PomLen);
              CH_SCtrl:=CHS_Send;
              goto L_Send;
            end;
          end
          else
         {Slave}
          begin
            if ChGetModem and Ms_RLSD_ON<>0 then
            begin
              ChSendHW(CH_PomBuff,CH_PomLen);
              CH_SCtrl:=CHS_Send;
              goto L_Send;
            end
            else
            begin
              ChSendFlush;
              CH_CDShutDown:=True;
              ChSetSendResult(CH_NumName or Res_ErrCDAbsent);
            end;
          end;
        end;
      CHS_Send:
       L_Send:
        if ChSendReadyHW=CHS_SendReady then { ceka se do fyzickeho odvysilani }
        begin
          ChSetSendResult(res_Ok);
          CH_SCtrl:=CHS_SendReady;
        end
        else
        begin
          if ChGetModem and Ms_RLSD_ON=0 then { nastal vypadek CD }
          begin
            {$ifdef Deb_Ctrl}
              writeln('Err - CD ShutDown while Sending');
            {$endif}
            CH_ModSig_CD :=False;
            CH_CDShutDown:=True;
            CH_Ctrl2:=CHS2_DisConBeg; { zacina se Disconnect a potom Connect }
            CH_Ctrl2Save:=CHS2_InitBeg;
            if CH_Master then
            begin
              ChSetSendResult(res_Ok);
              CH_SCtrl:=CHS_SendBegin;
              goto L_SendBegin;
            end
            else
            begin
              ChSetSendResult(CH_NumName or Res_ErrCDAbsent);
              CH_SCtrl:=CHS_SendReady;
            end;
          end;
        end;
    end; {case}
    CH_STick:=false;
  end;
end;

{------------------------------}
procedure tChnMod2.ChReceiveTick;
label L_ReceiveReConn;
begin
  if not LongBool(InterlockedExchange( integer(CH_RTick), Ord(true) )) then
  begin
    case CH_RCtrl of
      CHS_ReceiveReady,
      CHS_ReceiveNoReady: { stabilni stavy - testuje se CD }
        begin
         {Master}
          if CH_Master then
          begin
            if (CH_CdShutDown)or
               (ChGetModem and Ms_RLSD_ON=0) then { nastal vypadek CD zacina se Disconnect a potom Connect }
            begin
              {$ifdef Deb_Ctrl}
                writeln('Err - CD ShutDown while Receiving');
              {$endif}
              ChReceiveFlush;
              CH_ModSig_CD:=False;
              CH_Ctrl2:=CHS2_DisConBeg;
              CH_Ctrl2Save:=CHS2_InitBeg;
              CH_RCtrl:=CHS_ReceiveReConn;
              goto L_ReceiveReConn;
            end;
          end
          else
         {Slave}
          begin
            CH_ModSig_CD:=(ChGetModem and Ms_RLSD_ON)<>0;
            if (CH_ModSig_CD)and
               (not CH_FlTestCD)then
            begin
              CH_FlTestCD:=True;
              {$ifdef Deb_Ctrl}
                writeln('Slave was Connect');
              {$endif}
              ChReceiveFlushHW;
            end;
            if (CH_CDShutDown)or
               ((not CH_ModSig_CD)and(CH_FlTestCD)) then
            begin
              {$ifdef Deb_Ctrl}
                writeln('Err - CD ShutDown while Receiving');
              {$endif}
              CH_CdShutDown:=True;
              ChReceiveFlush;
              CH_Ctrl2:=CHS2_DisConBeg;
              CH_Ctrl2Save:=CHS2_InitBeg;
              CH_RCtrl:=CHS_ReceiveReConn;
              goto L_ReceiveReConn;
            end;
          end;
        end;
      CHS_ReceiveReConn:
       L_ReceiveReConn:
        begin
          if (ChReady=CHS_Connect)and  {postrceni automatu}
             (CH_Ctrl2=CHS_Connect)then CH_RCtrl:=CHS_ReceiveNoReady;
        end;
    end; {case}
    CH_RTick:=false;
  end;
end;

{------------------------------}
procedure tChnMod2.ChOpen;
var R : tChResult;
begin
  if CH_Ctrl=CHS_Close then
  begin
    if Assigned(CH_Chn) then
    begin
     {ChOpen podrizene vrstvy}
      CH_Chn.ChOpen;
      repeat
        R:=CH_Chn.ChResult;
      until (CH_Chn.ChReady=CHS_Open) or (R<>Res_Ok);
      ChSetResult(R);
      if R<>Res_Ok then Exit;
     {ChConnect podrizene vrstvy}
      CH_Chn.ChConnect;
      repeat
        R:=CH_Chn.ChResult;
      until (CH_Chn.ChReady=CHS_Connect) or (R<>Res_Ok);
      ChSetResult(R);
      if R<>Res_Ok then Exit;

      CH_CdShutDown:=False;
      CH_Ctrl :=CHS_Open;
      CH_State:=CH_Ctrl;
      CH_Ctrl2:=CH_Ctrl;
    end
    else
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
  end
  else
    ChSetResult(CH_NumName or res_ErrNoClose);
end; { ChOpen }

{------------------------------}
procedure tChnMod2.ChClose;
var R : tChResult;
begin
  if CH_Ctrl<>CHS_Close then
  begin
    if Assigned(CH_Chn) then
    begin
     {ChDisConnect podrizene vrstvy}
      CH_Chn.ChDisConnect;
      repeat
        R:=CH_Chn.ChResult;
      until (CH_Chn.ChReady=CHS_DisConnect) or (R<>Res_Ok);
      ChSetResult(R);
      if R<>Res_Ok then Exit;
     {ChClose podrizene vrstvy}
      CH_Chn.ChClose;
      repeat
        R:=CH_Chn.ChResult;
      until (CH_Chn.ChReady=CHS_Close) or (R<>Res_Ok);
      ChSetResult(R);
      if R<>Res_Ok then Exit;

      CH_SCtrl:=CHS_SendReady;
      CH_Ctrl :=CHS_Close;
      CH_Ctrl2:=CH_Ctrl;
      CH_State:=CH_Ctrl;
    end
    else
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
  end;
end; { ChClose }

{------------------------------}
procedure tChnMod2.ChConnect;
begin
  if CH_Ctrl=CHS_Open then
  begin
    ChSetResult(Res_Ok);
    CH_Ctrl2:=CHS2_InitBeg;
    CH_Ctrl2Save:=CH_Ctrl2;
    CH_Ctrl:=CH_Ctrl2;
    ChTick;
  end
  else
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
end; { ChConnect }

{------------------------------}
procedure tChnMod2.ChDisConnect;
begin
  if (CH_Ctrl<>CHS_Close     )and
     (CH_Ctrl<>CHS_DisConnect)then
  begin
    ChSetResult(Res_Ok);
    CH_Ctrl2Save:=CHS_DisConnect;
    CH_Ctrl2:=CHS2_DisConBeg;
    CH_Ctrl:=CH_Ctrl2;
    ChTick;
    { CH_Result nastavuje ChTick }
  end;
end; { ChDisConnect }

{------------------------------}
function tChnMod2.ChState;
begin
  ChTick; {nastavuje CH_Result}
  ChState:=CH_State;
end;

{------------------------------}
function tChnMod2.ChReady;
begin
  ChTick; {nastavuje CH_Result}
  ChReady:=CH_Ctrl;
end;

{------------------------------}
procedure tChnMod2.ChSend(Buff: Pointer; Len:Word);
begin
  if CH_Ctrl=CHS_Connect then
  begin
    if Len<>0 then
    begin
      CH_PomBuff:=Buff;
      CH_PomLen :=Len;
      CH_SCtrl:=CHS_SendBegin;
      ChSendTick;
      {CH_SResult nastavuje ChSendTick}
    end
    else
      ChSetSendResult(res_Ok);
  end
  else
    ChSetSendResult(CH_NumName or res_ErrNoConnect);
end; { ChSend }

{------------------------------}
function  tChnMod2.ChSendReady: TCHState;
begin
  ChSendTick;
  { nastavuje CH_SResult }
  if CH_Ctrl=CHS_Connect then
    ChSendReady:=CH_SCtrl
  else
    ChSendReady:=CHS_SendNoReady;
end; { ChSendReady }

{------------------------------}
procedure tChnMod2.ChSendFlush;
begin
  if CH_Ctrl=CHS_Connect then
  begin
    ChSendFlushHW;
    CH_PomLen:=0;
    CH_SCtrl:=CHS_SendReady;
    {CH_SendResult nastavuje ChSendFlushHW}
  end
  else
    ChSetSendResult(CH_NumName or res_ErrNoConnect);
end; { ChSendFlush }

{------------------------------}
procedure tChnMod2.CHSendHW(Buff: Pointer; Len: Word);
begin
  if CH_Ctrl<>CHS_Close then
  begin
    if Assigned(CH_Chn) then
    begin
      CH_Chn.ChSend(Buff,Len);
      ChSetSendResult(CH_Chn.ChSendResult);
    end
    else
    begin
      ChSetSendResult(CH_NumName or Res_ErrChannelNoExist);
    end;
  end
  else
    ChSetSendResult(CH_NumName or res_ErrNoOpen);
end; { ChSendHW }

{------------------------------}
function  tChnMod2.ChSendReadyHW: TCHState;
begin
  if CH_Ctrl<>CHS_Close then
  begin
    if Assigned(CH_Chn) then
    begin
      ChSendReadyHW:=CH_Chn.ChSendReady;
      ChSetSendResult(CH_Chn.ChSendResult);
    end
    else
    begin
      ChSendReadyHW:=CHS_SendReady;
      ChSetSendResult(CH_NumName or Res_ErrChannelNoExist);
    end;
  end
  else
  begin
    ChSendReadyHW:=CHS_SendNoReady;
    ChSetSendResult(CH_NumName or res_ErrNoOpen);
  end;
end; { ChSendReadyHW }

{------------------------------}
procedure tChnMod2.ChSendFlushHW;
begin
  if CH_Ctrl<>CHS_Close then
  begin
    if Assigned(CH_Chn) then
    begin
      CH_Chn.ChSendFlush;
      ChSetSendResult(CH_Chn.ChSendResult);
    end
    else
    begin
      ChSetSendResult(CH_NumName or Res_ErrChannelNoExist);
    end;
  end
  else
    ChSetSendResult(CH_NumName or res_ErrNoOpen);
end; { ChSendFlushHW }

{------------------------------}
function  tChnMod2.ChReceiveReady: TCHState;
begin
  ChReceiveTick;
  { nastavuje CH_RResult }
  if (CH_Ctrl=CHS_Connect)and(CH_RCtrl<>CHS_ReceiveReConn)and(CH_ModSig_CD) then
  begin
    if Assigned(CH_Chn) then
    begin
      ChReceiveReady:=CH_Chn.ChReceiveReady;
      ChSetReceiveResult(CH_Chn.ChReceiveResult);
    end
    else
    begin
      ChReceiveReady:=CHS_ReceiveNoReady;
      ChSetReceiveResult(CH_NumName or Res_ErrChannelNoExist);
    end;
  end
  else
    ChReceiveReady:=CHS_ReceiveNoReady;
end; { ChReceiveReady }

{------------------------------}
procedure tChnMod2.ChReceive(var Len: Word);
var
  FlErr : Boolean;
begin
  Len:=0;
  if (CH_Ctrl=CHS_Connect)and(CH_RCtrl<>CHS_ReceiveReConn) then
  begin
    FlErr:=false;
    if CH_RMess=nil then
      FlErr:=true
    else
      while (ChReceiveReady=CHS_ReceiveReady)and(Len<CH_MRMess)and(not FlErr) do
      begin
        pAByte(CH_RMess)^[Len]:=ChReceiveChar;
        FlErr:=FlErr or (CHReceiveResult<>res_Ok);
        Inc(Len);
      end;
    if FlErr then
      ChSetReceiveResult(CH_NumName or res_Err)
    else
      ChSetReceiveResult(res_Ok);
  end
  else ChSetReceiveResult(CH_NumName or res_ErrNoConnect);
end; { ChReceive }

{------------------------------}
function  tChnMod2.ChReceiveChar: Byte;
begin
  if (CH_Ctrl=CHS_Connect)and(CH_RCtrl<>CHS_ReceiveReConn) then
  begin
    if Assigned(CH_Chn) then
    begin
      ChReceiveChar:=CH_Chn.ChReceiveChar;
      ChSetReceiveResult(CH_Chn.ChReceiveResult);
    end
    else
    begin
      ChReceiveChar:=$0;
      ChSetReceiveResult(CH_NumName or Res_ErrChannelNoExist);
    end;
  end
  else
  begin
    ChReceiveChar:=$0;
    ChSetReceiveResult(CH_NumName or res_ErrNoConnect);
  end;
end; { ChReceiveChar }

{------------------------------}
procedure tChnMod2.ChReceiveFlush;
begin
  if (CH_Ctrl=CHS_Connect)and(CH_RCtrl<>CHS_ReceiveReConn) then
  begin
    if Assigned(CH_Chn) then
    begin
      CH_Chn.ChReceiveFlush;
      ChSetReceiveResult(CH_Chn.ChReceiveResult);
    end
    else
    begin
      ChSetReceiveResult(CH_NumName or Res_ErrChannelNoExist);
    end;
  end
  else
    ChSetReceiveResult(CH_NumName or res_ErrNoConnect);
end; { ChReceiveFlush }

{------------------------------}
function  tChnMod2.ChReceiveReadyHW: TCHState;
begin
  if CH_Ctrl<>CHS_Close then
  begin
    if Assigned(CH_Chn) then
    begin
      ChReceiveReadyHW:=CH_Chn.ChReceiveReady;
      ChSetReceiveResult(CH_Chn.ChReceiveResult);
    end
    else
    begin
      ChReceiveReadyHW:=CHS_ReceiveNoReady;
      ChSetReceiveResult(CH_NumName or Res_ErrChannelNoExist);
    end;
  end
  else
  begin
    ChReceiveReadyHW:=CHS_ReceiveNoReady;
    ChSetReceiveResult(CH_NumName or res_ErrNoOpen);
  end;
end; { ChReceiveReady }

{------------------------------}
function  tChnMod2.ChReceiveCharHW: Byte;
begin
  if CH_Ctrl<>CHS_Close then
  begin
    if Assigned(CH_Chn) then
    begin
      ChReceiveCharHW:=CH_Chn.ChReceiveChar;
      ChSetReceiveResult(CH_Chn.ChReceiveResult);
    end
    else
    begin
      ChReceiveCharHW:=$0;
      ChSetReceiveResult(CH_NumName or Res_ErrChannelNoExist);
    end;
  end
  else
  begin
    ChReceiveCharHW:=$0;
    ChSetReceiveResult(CH_NumName or res_ErrNoOpen);
  end;
end; { ChReceiveCharHWAT }

(*{------------------------------}
procedure tChnMod2.ChReceiveHW(var Len: Word);
var
  Sts : tChResult;
begin
  Len:=0;
  if CH_Ctrl<>CHS_Close then
  begin
    Sts:=res_Ok;
    if CH_RMess=nil then
      Sts:=res_Err
    else
      while (ChReceiveReadyHW=CHS_ReceiveReady)and
            (Len<CH_MRMess)and
            (Sts=res_Ok) do
      begin
        pAByte(CH_RMess)^[Len]:=ChReceiveCharHW;
        Sts:=ChReceiveResult;
        inc(Len);
      end;
    if Sts<>res_Ok then
         ChSetReceiveResult(CH_NumName or Sts)
    else ChSetReceiveResult(res_Ok);
  end
  else
    ChSetReceiveResult(CH_NumName or res_ErrNoOpen);
end;
*)

{------------------------------}
procedure tChnMod2.ChReceiveFlushHW;
begin
  if CH_Ctrl<>CHS_Close then
  begin
    if Assigned(CH_Chn) then
    begin
      CH_Chn.ChReceiveFlush;
      ChSetReceiveResult(CH_Chn.ChReceiveResult);
    end
    else
    begin
      ChSetReceiveResult(CH_NumName or Res_ErrChannelNoExist);
    end;
  end
  else ChSetReceiveResult(CH_NumName or res_ErrNoOpen);
end;

{------------------------------}
function  tChnMod2.ChGetModem: Byte;
begin
  if Assigned(CH_Chn) then
  begin
    ChGetModem:=CH_Chn.ChGetBinParam(CH_Chn.CH_NumName,cmd_GetMSR);
    ChSetResult(CH_Chn.ChResult);
  end
  else
  begin
    ChGetModem:=0;
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
  end;
end;

{------------------------------}
procedure tChnMod2.ChSetModem(S: Byte);
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChSetBinParam(CH_Chn.CH_NumName,cmd_SetMCR,S);
    ChSetResult(CH_Chn.ChResult);
  end
  else
  begin
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
  end;
end;

{------------------------------}
procedure tChnMod2.ChResModem(S: Byte);
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChSetBinParam(CH_Chn.CH_NumName,cmd_SetMCR,not S);
    ChSetResult(CH_Chn.ChResult);
  end
  else
  begin
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
  end;
end;
{================================================================}

{------------------------------}
begin
  ChnCollection.Insert(tAddChnMod2.Init(Nil));

  {$ifdef HardLock}
   if not TestHardLock then RunError(99);
  {$endif}
end.
