unit ChnCom;

          {ͻ}
          {                                                        }
          {  unit ChnCom                                           }
          {                                                        }
          {  jednotka pro obsluhu siriove komunikace s vyuzitim    }
          {  systemu Windows                                       }
          {                                                        }
          {  (C)1998 SofCon, Steovick 49, 160 00 Praha 6        }
          {          Ing. Vladimr Kastner, Na Vlovce 6, Praha 6  }
          {               Adam Wild, Dejvicka 42, Praha 6          }
          {ͼ}

{ define DebError} {ladici vypisy pri chybe}

interface

uses
  WinProcs,WinTypes,Classes,SysUtils, { vazba na Windows }
  ChnTypes,
  ChnVirt,
  uString,
  Timer;

const
  cName  = 'COM';              { jmeno komunikacni jednotky }
  cVer   = 'v4.3, 26.01.1999'; { verze a datum komunikacni jednotky }

type
  tChnCom = class(tChnVirt)
    CH_Num      : Byte;     { cislo serioveho kanalu }
    CH_Addr     : Word;     { adresa sriovho kanl }
    CH_Irq      : tIrq;     { slo IRQ obvodu 8259A na kter bude COM HW-ov peruovat 0..7 }
    CH_Rate     : tRate;    { penosov rychlost }
    CH_Parity   : tParity;  { parita, 0=nen, 1=lich, 2=sud }
    CH_Stop     : tStop;    { poet stop-bit, 1,2 }
    CH_Length   : tLength;  { dlka slova, 5,6,7,8 }
    CH_RSDelay1 : Longint;  { min. prodleva mezi prijmem a vysilanim }
    CH_RSDelay2 : Longint;  { min. prodleva mezi vysilanim a prijmem }
    CH_RecOn    : Boolean;  { false=pri vysilani je zakazan prijem znaku }
    CH_RecDel   : Boolean;  { true =pri zakazanem prijmu behem vysilani vymazat prvni prijaty znak
                              (nutne pro uplne zakazani prijmu behem vysilani na RS422) }
    CH_STime    : tTimer;   { odmerovani casovych intervalu pro vysilac }
    CH_STick    : LongBool; { je vykonavana cinnost vysilaciho automatu }
    CH_FlDTR    : Boolean;  { true=pri open se nastavi signal DTR }
    CH_FlRTS    : Boolean;  { true=pri open se nastavi signal RTS }

   protected
    CH_Handle        : THandle;  { Handle portu COM }
    CH_DCB           : TDCB;     { data popisujici setup kanalu         (Windows) }
    CH_WStat         : TComStat; { data popisujici stav kanalu          (Windows) }
    CH_TimeOuts      : TCOMMTIMEOUTS; { data popisujici timeouty kanalu (Windows) }
    CH_LastLowError  : Longint;  { posledni nenulovy vysledek operace   (Windows) }
    CH_LastRError    : DWord;    { naposledy hlasena Receive-error z GetCommError }
                                 { nuluje se pri poskytnuti do CH_ReceiveResult }
    CH_LastTError    : DWord;    { naposledy hlasena Transmitt-error z GetCommError }
                                 { nuluje se pri poskytnuti do CH_SendResult }
    CH_LastRTime     : Longint;  { okamzik volani posledni receive procedury }
    CH_RBuffPCharBeg : PChar;    { ukazatel do bufferu pro prijem znaku - na 1.neprevzaty znak  }
    CH_RBuffPCharEnd : PChar;    { ukazatel na konec bufferu pro prijem znaku -na volnou pozici }

    CH_TMess         : Pointer;  { ukazatel na vysilanou zpravu }
    CH_TLen          : Word;     { delka vysilane zpravy }

    CH_InQueueLen    : DWord;    { IQU ... delka Input  Queue pro Windows  }
    CH_OutQueueLen   : DWord;    { OQU ... delka Output Queue pro Windows  }
   published
    { vytvoreni, zruseni objektu }
    constructor Init;
                  { vytvoreni objektu }
    constructor ChInitParam(const S: tParamStr);
                  { vytvoreni objektu a nastaveni parametru }
    destructor  Destroy;
                  override; { zruseni objektu }
   protected
    { zadani a zobrazeni zadanych parametru }
    function  ChSetOneParam(const S: tWordString; var CmdL: tCmd): tChResult;
                override; { nove nastaveni jednoho parametru textove }
   published
    function  ChGetParam   (const S: tParamStr): tParamStr;
                override; { prevod parametru kanalu do stringu }
    procedure ChSetBinParam(NumName: tChNumName; Code: Word; Param: longint);
                override; { binarni nastaveni parametru kom. }
    function  ChGetBinParam(NumName: tChNumName; Code: Word): longint;
                override; { binarni cteni parametru kom. }

    { otevreni a zavreni HW kanalu, navazani a zruseni komunikace }
    procedure ChOpen;
                override; { otevereni HW kanalu }
    procedure ChClose;
                override; { zavreni HW kanalu }
    procedure ChConnect;
                override; { pocatek navazovani spojeni }
    procedure ChDisConnect;
                override; { pocatek ukonceni spojeni }

    { vysilani dat }
    procedure ChSend(Buff: Pointer; Len: Word);
                override; { pocatek vysilani }
    function  ChSendReady: TCHState;
                override; { krok vysilaciho aut., stav vysilani }
    procedure ChSendFlush;
                override; { preruseni vysilani }

    { prijem dat }
    function  ChReceiveReady: TCHState;
                override; { krok prij. automatu, stav prijmu }
    procedure ChReceive(var Len: Word);
                override; { prijem zpravy }
    function  ChReceiveChar: Byte;
                override; { prijem 1 znaku zpravy }
    procedure ChReceiveFlush;
                override; { stav jako po inicializaci }

    function  ChResultStr       (Sts  : TChResult) : tResultStr;
                override; { vrati retezec s popisem vysledku operace }

    { provedeni kroku automatu kanalu, vysilace, prijimace }
    procedure ChSendTick;
                override; { krok automatu vysilace }
  end;

type
  TAddChnCom = class(TAddChnVirt)
    function ChInit: tChnVirt; override; { funkce provadejici zalozeni a inicializaci daneho kanalu }
  end;

type
  tRChar = byte;    { prijaty znak }

const
  MaxRBuff       = $7fff; { maximalni velikost vstupniho vyrovnavaciho bufferu }
  IniInQueueLen  = 4000; { IQU ... delka Input  Queue pro Windows  }
  IniOutQueueLen = 4000; { OQU ... delka Output Queue pro Windows  }

  const
  { bity z ClearCommError (viz Win32 API), vztahujici se na Receiver }
  RErrorMsk =CE_RXOVER or CE_OVERRUN or CE_RXPARITY or CE_FRAME or CE_BREAK;
  { bity z ClearCommError (viz Win32 API), vztahujici se na Transmitter }
  TErrorMsk =CE_IOE or CE_TXFULL;

const
 { konstanty kodu pro metodu ChSetBinParam }
  cmd_SetMCR   = $0101; { prikaz pro nastaveni vsech modemovych signalu (MCR) dle Param }
  cmd_SetDTR   = $0102; { prikaz pro nastaveni modemoveho signalu DTR  dle Param.0 }
  cmd_SetRTS   = $0103; { prikaz pro nastaveni modemoveho signalu RTS  dle Param.0 }
 { konstanty kodu pro metodu ChGetBinParam }
  cmd_GetMSR   = $0101; { prikaz pro vraceni stavu vsech modemovych signalu (MSR) }
  cmd_GetCTS   = $0106; { prikaz pro vraceni stavu modemoveho signalu CTS   v 0.bitu vysledku funkce }
  cmd_GetDSR   = $0107; { prikaz pro vraceni stavu modemoveho signalu DSR   v 0.bitu vysledku funkce }
  cmd_GetRI    = $0108; { prikaz pro vraceni stavu modemoveho signalu RI    v 0.bitu vysledku funkce }
  cmd_GetRLSD  = $0109; { prikaz pro vraceni stavu modemoveho signalu RLSD  v 0.bitu vysledku funkce }

implementation

const
  {masky pro nastaveni a detekovani jednotlivych bitu v CH_DCB.Flags}
  cDCBMask              = $FFFF8000; {vymaskovani vsech bitu Flags}
  cDCB_Binary           = $0001; {1bit }{Enable Binary mode - for Windows always TRUE}
  cDCB_Parity           = $0002; {1bit }{Enable parity check}
  cDCB_OutxCtsFlow      = $0004; {1bit }{Enable CTS monitoring, if this is TRUE and CTS is off, output send is suspended}
  cDCB_OutxDsrFlow      = $0008; {1bit }{Enable DSR monitoring, if this is TRUE and DSR is off, output send is suspended}
  cDCB_DtrControl       = $0030; {2bits}{DTR flow control 00=Disable, 01=Enable, 10=HandShake}
  cDCB_DsrSensitivity   = $0040; {1bit }{Enable ignore receive chars until DSR}
  cDCB_TXContinueOnXoff = $0080; {1bit }{Disable transmision stop when input buffer is full}
  cDCB_OutX             = $0100; {1bit }{Enable XON/XOFF transmision flow control}
  cDCB_InX              = $0200; {1bit }{Enable XON/XOFF reception flow control}
  cDCB_ErrorChar        = $0400; {1bit }{Enable replace received bytes with parity error by the ErrorChar byte}
  cDCB_Null             = $0800; {1bit }{Enable discard received null bytes}
  cDCB_RtsControl       = $3000; {2bits}{RTS flow control 00=Disable, 01=Enable, 10=HandShake, 11=Toggle}
  cDCB_AbortOnError     = $4000; {1bit }{Enable terminate all operations if error ocures}
  {hodnoty nastaveni polozky DtrControl}
  cDTR_CONTROL_DISABLE  = $0000 shl 4;
  cDTR_CONTROL_ENABLE   = $0001 shl 4;
  cDTR_CONTROL_HANDSHAKE= $0010 shl 4;
  {hodnoty nastaveni polozky RtsControl}
  cRTS_CONTROL_DISABLE  = $0000 shl 12;
  cRTS_CONTROL_ENABLE   = $0001 shl 12;
  cRTS_CONTROL_HANDSHAKE= $0010 shl 12;
  cRTS_CONTROL_TOGGLE   = $0011 shl 12;

function TAddChnCom.ChInit: tChnVirt;
begin
  ChInit:=tChnCom.Init;
end;
{================================================================}

function BuffLngMin(A,B:longword):longword;
begin
  if A<B then Result:=A else Result:=B;
end;

constructor tChnCom.Init;
begin
  inherited;
  CH_Type     := cName;
  CH_Name     := CH_Type;
  CH_NumName  := ChNumName(CH_Type);
  CH_Num      := 0;
  CH_Addr     := AddrCom1;
  CH_Irq      := IRQ4;
  CH_Rate     := 9600;
  CH_Parity   := ParOdd;
  CH_Stop     := Stop1;
  CH_Length   := Bits8;
  CH_RSDelay1 := 0;
  CH_RSDelay2 := 0;
  CH_RecOn    := true;
  CH_RecDel   := false;
  CH_STick    := false;
  CH_FlDTR    := false;
  CH_FlRTS    := true;

  CH_Handle        := 0;
  CH_LastLowError  := 0;
  CH_LastRError    := 0;
  CH_LastTError    := 0;
  CH_LastRTime     := 0;
  CH_RBuffPCharBeg := nil;
  CH_RBuffPCharEnd := nil;

  CH_TMess         := nil;
  CH_TLen          := 0;

  CH_InQueueLen    := IniInQueueLen;
  CH_OutQueueLen   := IniOutQueueLen;

  CH_STime := tTimer.Init;
end; { Init }

constructor tChnCom.ChInitParam(const S: tParamStr);
begin
  Init;
  ChSetParam(S);
  { CH_Result nastavuje ChSetParam }
end; { ChInitParam }

destructor  tChnCom.Destroy;
begin
  CH_STime.Done;
  CH_STime:=nil;
  CH_MRBuff:=SizeOf(tRChar)*CH_MRBuff;
  inherited;
  { CH_Result nastavuje Done }
end; { Done }

function tChnCom.ChSetOneParam(const S: tWordString; var CmdL: tCmd): tChResult;
          { typicka prikaldy PomS: COM=2 BD=9600 BIT=8 PAR=N }
type
  tParam = (P_ERR,
            P_COM,    { cislo COM portu }
            P_ADDR,   { adresa COM portu }
            P_IRQ,    { cislo preruseni IRQ }
            P_BD,     { bd rychlost }
            P_BIT,    { pocet bitu }
            P_PAR,    { parita (N,E,O) }
            P_STOP,   { pocet stop-bitu }
            P_LRB,    { velikost prijimaciho bufferu }
            P_RS1,    { min. prodleva mezi prijmem a vysilanim }
            P_RS2,    { min. prodleva mezi vysilanim a prijmem }
            P_REC,    { ma byt zakazan prijem behem vysilani }
            P_DTR,    { ma-li se nastavit signal DTR po open }
            P_RTS     { ma-li se nastavit signal RTS po open }
            );
const
  StrParam = 'COM|ADD|IRQ|BD |BIT|PAR|STO|LRB|RS1|RS2|REC|DTR|RTS|';
var
  PomS    : tWordString;
  PomRes  : tChResult;
  Param   : tParam;
  PomCh   : Char;
  ErrFl   : boolean;
  PomL    : longint;
  i,j     : integer;
begin
  PomRes:=res_Ok;
  ErrFl :=false;
  if S='|' then
  begin
    ChNextSetParam(CmdL.ReadRest);
    PomRes:=ChResult;
  end
  else
  begin
    Param:=tParam(NDELIM(S,StrParam));
    case Param of
      P_ERR:
        PomRes:=inherited ChSetOneParam(S,CmdL);
      P_COM:
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            if (PomL>=1) and (PomL<=8) then
            begin
              CH_Num :=PomL;
              CH_Addr:=ACom[PomL];
            end
            else
              ErrFl:=true;
        end;
      P_ADDR:
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            if (PomL>=0) and (PomL<=$ffff) then
            begin
              CH_Addr:=PomL;
              j:=0;
              for i:=1 to 8 do
                if CH_Addr=ACom[i] then
                  j:=i;
              CH_Num:=j
            end
            else
              ErrFl:=true;
        end;
      P_IRQ:
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            if (PomL>=0) and (PomL<=7) then
              CH_Irq:=PomL
            else
              ErrFl:=true;
        end;
      P_BD:
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            if (PomL>=1)and(PomL<=300000) then
              CH_Rate:=PomL
            else
              ErrFl:=true;
        end;
      P_BIT:
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            if (PomL>=5) and (PomL<=8) then
              CH_Length:=PomL
            else
              ErrFl:=true;
        end;
      P_PAR:
        begin
          PomS:=CmdL.ReadWordUpCase;
          PomCh:=PomS[1];
          case PomCh of
          'N':CH_Parity:=ParNone;
          'O':CH_Parity:=ParOdd;
          'E':CH_Parity:=ParEven;
          else ErrFl:=true;
          end; {case}
        end;
      P_STOP:
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            if (PomL>=Stop1) and (PomL<=Stop2) then
              CH_Stop:=PomL
            else
              ErrFl:=true;
        end;
      P_LRB:
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            if (PomL>=1) and (PomL<=MaxRBuff) then
            begin
              if CH_RBuff<>nil then
              begin
                FreeMem(CH_RBuff,SizeOf(tRChar)*CH_MRBuff);
                CH_RBuff:=nil;
              end;
              CH_MRBuff:=PomL;
              GetMem(CH_RBuff,SizeOf(tRChar)*CH_MRBuff);
            end
            else
              ErrFl:=true;
        end;
      P_RS1:
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then CH_RSDelay1:=PomL;
        end;
      P_RS2:
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then CH_RSDelay2:=PomL;
        end;
      P_REC :
        begin
          PomS:=CmdL.ReadWordUpCase;
          if PomS='ON'  then
            begin
              CH_RecOn :=true;
              CH_RecDel:=false;
            end
          else
          if PomS='OFF' then
            begin
              CH_RecOn :=false;
              CH_RecDel:=false;
            end
          else
          if PomS='OFF2'then
            begin
              CH_RecOn :=false;
              CH_RecDel:=true;
            end
          else ErrFl:=true;
        end;
      P_DTR :
        begin
          PomS:=CmdL.ReadWordUpCase;
          if PomS='ON'  then CH_FlDTR:=true
          else
          if PomS='OFF' then CH_FlDTR:=false
          else ErrFl:=true;
        end;
      P_RTS :
        begin
          PomS:=CmdL.ReadWordUpCase;
          if PomS='ON'  then CH_FlRTS:=true
          else
          if PomS='OFF' then CH_FlRTS:=false
          else ErrFl:=true;
        end;
    end; {case}
    if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
  end;
  ChSetOneParam:=PomRes;
end;

function  tChnCom.ChGetParam(const S: tParamStr): tParamStr;
var
  i,j  : Byte;
  ch   : Char;
  ss   : tParamStr;
begin
  ss:='NAM='+CH_Name;
  j:=0;
  for i:=1 to 8 do
    if CH_Addr=ACom[i] then
      j:=i;
  if j<>0 then
    ss:=ss+' COM='+LStr(j)
  else
    ss:=ss+' ADD=$'+IntToHex(CH_Addr,4);
  case CH_Parity of
    ParNone: ch:='N';
    ParOdd : ch:='O';
    ParEven: ch:='E';
    else ch:='O';
  end;
  ss:=ss+' IRQ='+LStr(CH_Irq)+
         ' BD=' +LStr(CH_Rate)+
         ' BIT='+LStr(CH_Length)+
         ' PAR='+ch+
         ' STO='+LStr(CH_Stop)+
         ' LRB='+LStr(CH_MRBuff)+
         ' RS1='+LStr(CH_RSDelay1)+
         ' RS2='+LStr(CH_RSDelay2)+
         ' REC=';
  if CH_RecOn then ss:=ss+'ON'
  else
    if not CH_RecDel then ss:=ss+'OFF'
    else ss:=ss+'OFF2';
  ss:=ss+' DTR=';
  if CH_FlDTR then ss:=ss+'ON'
  else ss:=ss+'OFF';
  ss:=ss+' RTS=';
  if CH_FlRTS then ss:=ss+'ON'
  else ss:=ss+'OFF';
  ChSetResult(res_Ok);
  ChGetParam:=ss;
end; { ChGetParam }

procedure tChnCom.ChSetBinParam(NumName: tChNumName; Code: Word; Param: longint);
var Fl:Boolean;
begin
  NumName:=NumName and $FF00; { pro jistotu orizneme spodni byte }
  if NumName=CH_NumName then
  begin
    case Code of
      cmd_SetMCR :
        begin
          if (Param and MskSetDTR)<>0 then {nastaveni DTR}
               Fl:=EscapeCommFunction(CH_Handle,SetDTR)
          else Fl:=EscapeCommFunction(CH_Handle,ClrDTR);
          if (Param and MskSetRTS)<>0 then {nastaveni RTS}
               Fl:=Fl or EscapeCommFunction(CH_Handle,SetRTS)
          else Fl:=Fl or EscapeCommFunction(CH_Handle,ClrRTS);
          if Fl then
               ChSetResult(res_Ok)
          else ChSetResult(CH_NumName or res_Err);
        end;
      cmd_SetDTR :
        begin
          if (Param and $01)=1 then
               Fl:=EscapeCommFunction(CH_Handle,SetDtr)
          else Fl:=EscapeCommFunction(CH_Handle,ClrDtr);
          if Fl then ChSetResult(res_Ok)
                else ChSetResult(CH_NumName or res_Err);
        end;
      cmd_SetRTS :
        begin
          if (Param and $01)=1 then
               Fl:=EscapeCommFunction(CH_Handle,SetRts)
          else Fl:=EscapeCommFunction(CH_Handle,ClrRts);
          if Fl then ChSetResult(res_Ok)
                else ChSetResult(CH_NumName or res_Err);
        end;
      else
         inherited ChSetBinParam(NumName,Code,Param);
    end;
  end
  else
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChSetBinParam(NumName,Code,Param);
    ChSetResult(CH_Chn.ChResult);
  end
  else
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
end;

function  tChnCom.ChGetBinParam(NumName: tChNumName; Code: Word): longint;
var ModemStat :DWord;
begin
  NumName:=NumName and $FF00; { pro jistotu orizneme spodni byte }
  if NumName=CH_NumName then
  begin
    case Code of
      cmd_GetMSR  :
        begin
          if GetCommModemStatus(CH_Handle,ModemStat) then
          begin
            ChSetResult(res_Ok);
            ChGetBinParam:=ModemStat;
          end
          else
          begin
            ChSetResult(CH_NumName or res_Err);
            ChGetBinParam:=0;
          end;
        end;
      cmd_GetCTS  :
        begin
          if GetCommModemStatus(CH_Handle,ModemStat) then
          begin
            ChSetResult(res_Ok);
            if (ModemStat and MS_CTS_ON)<>0 then
                 ChGetBinParam:=1
            else ChGetBinParam:=0;
          end
          else
          begin
            ChSetResult(CH_NumName or res_Err);
            ChGetBinParam:=0;
          end;
        end;
      cmd_GetDSR  :
        begin
          if GetCommModemStatus(CH_Handle,ModemStat) then
          begin
            ChSetResult(res_Ok);
            if (ModemStat and MS_DSR_ON)<>0 then
                 ChGetBinParam:=1
            else ChGetBinParam:=0;
          end
          else
          begin
            ChSetResult(CH_NumName or res_Err);
            ChGetBinParam:=0;
          end;
        end;
      cmd_GetRI   :
        begin
          if GetCommModemStatus(CH_Handle,ModemStat) then
          begin
            ChSetResult(res_Ok);
            if (ModemStat and MS_RING_ON)<>0 then
                 ChGetBinParam:=1
            else ChGetBinParam:=0;
          end
          else
          begin
            ChSetResult(CH_NumName or res_Err);
            ChGetBinParam:=0;
          end;
        end;
      cmd_GetRLSD :
        begin
          if GetCommModemStatus(CH_Handle,ModemStat) then
          begin
            ChSetResult(res_Ok);
            if (ModemStat and MS_RLSD_ON)<>0 then
                 ChGetBinParam:=1
            else ChGetBinParam:=0;
          end
          else
          begin
            ChSetResult(CH_NumName or res_Err);
            ChGetBinParam:=0;
          end;
        end;
      else
        begin
          ChGetBinParam:=0;
          ChSetResult(CH_NumName or res_Err);
        end;
    end;
  end
  else
  if Assigned(CH_Chn) then
  begin
    ChGetBinParam:=CH_Chn.ChGetBinParam(NumName,Code);
    ChSetResult(CH_Chn.ChResult);
  end
  else
  begin
    ChGetBinParam:=0;
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
  end;
end;

procedure tChnCom.ChOpen;
begin
  if CH_Ctrl=CHS_Close then
  begin
    CH_Ctrl  :=CHS_Open;
    CH_State :=CH_Ctrl;
    ChSetResult(res_Ok);
  end
  else ChSetResult(CH_NumName or res_ErrNoClose);
end; { ChOpen }

procedure tChnCom.ChClose;
begin
  if CH_Ctrl<>CHS_Close then
  begin
    CH_RCtrl:=CHS_ReceiveNoReady;
    CH_SCtrl:=CHS_SendNoReady;
    CH_Ctrl :=CHS_Close;
    CH_State:=CH_Ctrl;
  end;
  CH_Num:=0;
  ChSetResult(res_Ok);
end; { ChClose }

procedure ErrorOutput(i:integer); {na zaklade chyby I vypise MessageBox s hlaskou}
{$ifdef DebError}
var
   P:PCHAR;
{$endif}
begin
 {$ifdef DebError}
  if (i=0) then exit;
  p:=nil;
  if (FormatMessage(
     FORMAT_MESSAGE_ALLOCATE_BUFFER or
     FORMAT_MESSAGE_FROM_SYSTEM or
     FORMAT_MESSAGE_IGNORE_INSERTS,
     nil,
     i,
     0,
     P,
     0,
     nil
     ) <> 0) then
  begin
    MessageBox(0, P, 'Chyba c.'+IntToStr(I), MB_OK or MB_ICONINFORMATION);
    LocalFree(HLOCAL(P));
  end
  else
    MessageBox(0, 'Nelze format', 'pomoc', MB_OK or MB_ICONINFORMATION);
 {$endif}
end;

procedure tChnCom.ChConnect;
Label LExit;
const
  aStopBits : array[Stop1..Stop2]of Word = (0,2);
var
  NameNStr : array[0..5]of char;
  Fl       : Boolean;
begin
  SetLastError(0);
  if CH_Ctrl=CHS_Open then
  begin
    ErrorOutput(GetLastError());
    StrPCopy(NameNStr,'COM'+Chr(Ord('0')+CH_Num));       { window string            }
    CH_Handle:=CreateFile(NameNStr,                      { jmeno COM1..COM8         }
                          GENERIC_READ or GENERIC_WRITE, { access (read-write) mode }
                          0,    { share mode, 0=Prevents the file from being shared }
                          nil,                     { address of security descriptor }
                          OPEN_EXISTING,                 { how to create            }
                          FILE_ATTRIBUTE_NORMAL,         { file attributes          }
                          0);              { handle of file with attributes to copy }


    ErrorOutput(GetLastError());
    if CH_Handle=INVALID_HANDLE_VALUE then
    begin
      ChSetResult(CH_NumName or res_ErrConnect);
      goto LExit;
    end;

    if not SetupComm(CH_Handle,CH_InQueueLen,CH_OutQueueLen)then
    begin
      ErrorOutput(GetLastError());
      ChSetResult(CH_NumName or res_ErrConnect);
      goto LExit;
    end;

    with CH_TimeOuts do
    begin
               { A value of MAXDWORD, combined with zero values for both the
                 ReadTotalTimeoutConstant and ReadTotalTimeoutMultiplier members,
                 specifies that the read operation is to return immediately with
                 the characters that have already been received,
                 even if no characters have been received. }
      ReadIntervalTimeout        :=0{maxdword};
      ReadTotalTimeoutMultiplier :=0{maxdword};
      ReadTotalTimeoutConstant   :=0{maxdword};
               { A value of zero for both the WriteTotalTimeoutMultiplier and
                 WriteTotalTimeoutConstant members indicates that
                 total time-outs are not used for write operations. }
      WriteTotalTimeoutMultiplier:=0;
      WriteTotalTimeoutConstant  :=0;
    end;

    if not SetCommTimeouts(CH_Handle,CH_TimeOuts) then
    begin
      ErrorOutput(GetLastError());
      CloseHandle(CH_Handle);
      CH_Handle:=0;
      ChSetResult(CH_NumName or res_ErrConnect);
      goto LExit;
    end;

    CH_DCB.DCBlength:=SizeOf(TDCB);

    if not GetCommState(CH_Handle,CH_DCB) then
    begin
      ErrorOutput(GetLastError());
      CloseHandle(CH_Handle);
      CH_Handle:=0;
      ChSetResult(CH_NumName or res_ErrConnect);
      goto LExit;
    end;

    with CH_DCB do
    begin
      if      CH_Rate=128000 then
        BaudRate:=$FF00 or cbr_128000
      else if CH_Rate=256000 then
        BaudRate:=$FF00 or cbr_256000
      else BaudRate:=CH_Rate;

      ByteSize:= CH_Length;
      Parity  := CH_Parity;
      StopBits:= aStopBits[CH_Stop];
      XOnChar   :=#0;
      XOffChar  :=#0;
      XOnLim    :=10;
      XOffLim   :=10;
      EofChar   :=#0;
      EvtChar   :=#0;
      Flags:=(Flags and cDCBMask)   or
              cDCB_Binary           or
              cDCB_Parity           or
              cDTR_CONTROL_ENABLE   or
              cDCB_TXContinueOnXoff or
              cRTS_CONTROL_ENABLE     ;
    end;

    if not SetCommState(CH_Handle,CH_DCB) then
    begin
      ErrorOutput(GetLastError());
      CloseHandle(CH_Handle);
      CH_Handle:=0;
      ChSetResult(CH_NumName or res_ErrConnect);
      goto LExit;
    end;

    { akce doplnujici otevreni kanalu }
    { vyprazdneni in a out bufferu }
    if not PurgeComm(CH_Handle,PURGE_TXABORT+PURGE_RXABORT+PURGE_TXCLEAR+PURGE_RXCLEAR) then
    begin
      ErrorOutput(GetLastError());
      CloseHandle(CH_Handle);
      CH_Handle:=0;
      ChSetResult(CH_NumName or res_ErrConnect);
      goto LExit;
    end;

    { DTR }
    if CH_FlDTR then
      Fl:=EscapeCommFunction(CH_Handle,ClrDtr)  { nulovani DTR }
    else
      Fl:=EscapeCommFunction(CH_Handle,SetDtr); { nastaveni DTR }
    if not Fl then
    begin
      ErrorOutput(GetLastError());
      CloseHandle(CH_Handle);
      CH_Handle:=0;
      ChSetResult(CH_NumName or res_ErrConnect);
      goto LExit;
    end;

    { RTS }
    if CH_FlRTS then
      Fl:=EscapeCommFunction(CH_Handle,ClrRts)  { nulovani RTS }
    else
      Fl:=EscapeCommFunction(CH_Handle,SetRts); { nastaveni RTS }
    if not Fl then
    begin
      ErrorOutput(GetLastError());
      CloseHandle(CH_Handle);
      CH_Handle:=0;
      ChSetResult(CH_NumName or res_ErrConnect);
      goto LExit;
    end;

    { nastaveni sledovani vseho }
    if not SetCommMask(CH_Handle,EV_BREAK or EV_CTS  or EV_DSR    or EV_ERR    or
                                 EV_RING  or EV_RLSD or EV_RXCHAR or EV_RXFLAG or EV_TXEMPTY) then
    begin
      ErrorOutput(GetLastError());
      CloseHandle(CH_Handle);
      CH_Handle:=0;
      ChSetResult(CH_NumName or res_ErrConnect);
      goto LExit;
    end;

    CH_Ctrl :=CHS_Connect;
    CH_State:=CH_Ctrl;
    CH_SCtrl:=CHS_SendReady;
    ChSetResult(res_Ok);
  end
  else
    ChSetResult(CH_NumName or res_ErrNoOpen);

LExit:
  ErrorOutput(GetLastError());
end; { ChConnect }

procedure tChnCom.ChDisConnect;
begin
  if CH_Handle<>0 then
  begin
    FlushFileBuffers(CH_Handle); { odvysila zatim neodvysilane } {!Ka}
    PurgeComm(CH_Handle,PURGE_TXABORT or PURGE_RXABORT or PURGE_TXCLEAR or PURGE_RXCLEAR);
    CloseHandle(CH_Handle);
    CH_Handle:=0;
  end;
  { vymazani prijimaciho a vysilaciho bufferu }
  CH_RCtrl:=CHS_ReceiveNoReady;
  CH_SCtrl:=CHS_SendNoReady;
  CH_Ctrl :=CHS_DisConnect;
  CH_State:=CH_Ctrl;
  ChSetResult(res_Ok);
end; { ChDisConnect }

const
  CHS_SendBegin      = 2; { vysilani zahajeno }
  CHS_SendBegin1     = 3; { vysilani zahajeno }
  CHS_Send           = 4; { vysilani }
  CHS_SendEnd        = 5; { konec vysilani }

function  tChnCom.ChResultStr       (Sts : tChResult) : tResultStr;
begin
  if Sts and $FF00 = CH_NumName then
  begin
    Result:=inherited ChResultStr(Sts);
    if Result='' then
    begin
      if Lo(Sts) and MskErrOvr <> 0 then Result:=Result+'OverRun ';
      if Lo(Sts) and MskErrPar <> 0 then Result:=Result+'Parity Error ';
      if Lo(Sts) and MskErrFrm <> 0 then Result:=Result+'Framing Error';
      if Lo(Sts) and MskBrkInt <> 0 then Result:=Result+'Break Interrupt ';
    end;
  end
  else
    ChResultStr:=inherited ChResultStr(Sts);
end;

procedure tChnCom.ChSendTick;
label
  L_SendBegin, L_SendBegin1, L_Send, L_SendEnd;
var
  QErrors  : DWORD;
  WriteCnt : DWORD;
begin
  if not LongBool(InterlockedExchange( integer(CH_STick), Ord(true) )) then
  begin
    case CH_SCtrl of
      CHS_SendReady,
      CHS_SendNoReady :
        begin
        end;
      CHS_SendBegin :
        begin
          if not CH_RecOn then
          begin
            { zakazani preruseni pro prijimac }
            {!Ka}
          end;
          CH_STime.SaveTime;
          CH_SCtrl:=CHS_SendBegin1;
          goto L_SendBegin1;
        end;
      CHS_SendBegin1 :
        L_SendBegin1 :
        begin
          if CH_STime.TstTime(CH_RSDelay1) then
          begin
            if not ClearCommError(CH_Handle,QErrors,Addr(CH_WStat)) then
            begin
              ChSetSendResult(CH_NumName or res_Err);
              {!Bu- doplnit osetreni teto chyby volani fce }
            end;
            CH_LastRError:=CH_LastRError or (QErrors and RErrorMsk);
            CH_LastTError:=CH_LastTError or (QErrors and TErrorMsk);
            if CH_LastTError<>0 then
            begin
              ChSetSendResult(CH_NumName or res_Err);
              CH_LastTError  :=0;
            end;
  {!Ka        while DifCurrTimeMS(CH_LastRTime)<CH_RTDelayTime do ;
            { vytvoreni prodlevy mezi poslednim ctenim a zapisem
              (nelze odvodit exaktne - nelze zjistit okamzik prijmu
               znaku do bufferu pod prerusenim, pouze jeho posledni cteni)
              pro RS485 SofCon zadej pro 9600 bd min. prodlevu 1ms,
                                     pro 2400 bd min. prodlevu 4ms

              !Problem: Windows sluzba GetTime incrementuje po 55 ms !
              Pokus: zaradil jsem MessageBeep(0) - pri 9600 bd nepravidelne
              pipa v int. 0-4 sec (kazdou cca 3-20 vysilanou zpravu)
              -> stale nevim, kolik casu uplyne pred odpovedi -
              je to mene nez 55 ms
            }
            if not WriteFile(CH_Handle,CH_TMess^,CH_TLen,WriteCnt,nil) then
            begin
              ChSetSendResult(CH_NumName or res_Err);
            end
            else if CH_TLen<>WriteCnt then
            begin
              ChSetSendResult(CH_NumName or res_Err);
            end;
            CH_SCtrl:=CHS_Send;
            goto L_Send;
          end;
        end;
      CHS_Send :
        L_Send :
        begin
          if not ClearCommError(CH_Handle,QErrors,Addr(CH_WStat)) then
          begin
            ChSetSendResult(CH_NumName or res_Err);
          end;
          CH_LastRError:=CH_LastRError or (QErrors and RErrorMsk);
          CH_LastTError:=CH_LastTError or (QErrors and TErrorMsk);

          if (CH_LastTError<>0) then
          begin
            ChSetSendResult(CH_NumName or res_Err);
            CH_LastTError  :=0;
          end;
          if CH_WStat.cbOutQue=0 then
          begin
            CH_STime.SaveTime;          { vysilani ukonceno }
            CH_SCtrl:=CHS_SendEnd;
            goto L_SendEnd;
          end
        end;
      CHS_SendEnd :
        L_SendEnd :
        begin
          if CH_STime.TstTime(CH_RSDelay2) then
          begin
            if not CH_RecOn then
            begin
              { bylo zakazano preruseni pro prijimac }
              {!Ka}
            end;
            CH_SCtrl:=CHS_SendReady;
          end;
        end;
    end; {case}
    CH_STick:=False;
  end;
end; { ChSendTick }

procedure tChnCom.ChSend(Buff: Pointer; Len: Word);
begin
  if CH_Ctrl=CHS_Connect then
  begin
   { je-li dlka vysilane zpravy = 0, neprovadej zadnou cinnost }
    if Len<>0 then
    begin
      if Len<=CH_OutQueueLen then
      begin
        CH_TMess :=Buff;        { ukazatel na vysilanou zpravu }
        CH_TLen  :=Len;         { delka vysilane zpravy }
        CH_SCtrl:=CHS_SendBegin;
        ChSendTick;
        ChSetSendResult(res_Ok);
      end
      else
        ChSetSendResult(res_Err);
    end
    else
      ChSetSendResult(res_Ok);
  end
  else ChSetSendResult(CH_NumName or res_ErrNoConnect);
end; { ChSend }

function  tChnCom.ChSendReady: TCHState;
begin
  ChSetSendResult(res_Ok);
  if CH_Ctrl=CHS_Connect then
  begin
    ChSendTick;
    ChSendReady:=CH_SCtrl;
  end
  else
    ChSendReady:=CHS_SendNoReady;
end; { ChSendReady }

procedure tChnCom.ChSendFlush;
begin
  if CH_Ctrl=CHS_Connect then
  begin
    PurgeComm(CH_Handle,{PURGE_TXABORT or} PURGE_TXCLEAR);
    CH_SCtrl:=CHS_SendReady;
    CH_LastTError:=0;
    ChSetSendResult(res_Ok);
  end
  else ChSetSendResult(CH_NumName or res_ErrNoConnect);
end; { ChSendFlush }

function  tChnCom.ChReceiveReady: TCHState;
var
  QErrors : DWORD;
begin
  ChSetReceiveResult(res_Ok);
  if CH_Ctrl=CHS_Connect then
  begin
    if Assigned(CH_RBuff) and (CH_RBuffPCharBeg < CH_RBuffPCharEnd) then
    begin
      Result:=CHS_ReceiveReady;   { prijem znaku ukoncen }
    end
    else
    begin
      if not ClearCommError(CH_Handle,QErrors,Addr(CH_WStat)) then
        ChSetReceiveResult(CH_NumName or res_Err);
      CH_LastRError:=CH_LastRError or (QErrors and RErrorMsk);
      CH_LastTError:=CH_LastTError or (QErrors and TErrorMsk);
      if CH_LastRError<>0 then
      begin
        ChSetReceiveResult(CH_NumName or res_Err);
        CH_LastRError:=0;
      end;
      if CH_WStat.cbInQue>0 then
        Result:=CHS_ReceiveReady   { prijem znaku ukoncen }
      else
        Result:=CHS_ReceiveNoReady;
      end;
  end
  else
    ChReceiveReady:=CHS_ReceiveNoReady;
end; { ChReceiveReady }

function  tChnCom.ChReceiveChar: Byte;
var
  QErrors : DWORD;
  QCount  : DWORD;
  B       : Byte;
begin
  if CH_Ctrl=CHS_Connect then
  begin
    if Assigned(CH_RBuff) then
    begin
      if CH_RBuffPCharBeg < CH_RBuffPCharEnd then
      begin
        Char(Result):=CH_RBuffPCharBeg^;
        CH_RBuffPCharBeg:=CH_RBuffPCharBeg+SizeOf(Char);
      end
      else
      begin
        { nova inicializace prijimaciho bufferu }
        CH_RBuffPCharBeg:=CH_RBuff;
        CH_RBuffPCharEnd:=CH_RBuff;
        { Prijem do prijimaciho bufferu }
        ReadFile(CH_Handle,CH_RBuff^,BuffLngMin(CH_WStat.cbInQue,CH_MRBuff),QCount,nil);
        CH_LastRTime:=GetTickCount;
        if QCount>0 then
        begin
          CH_RBuffPCharEnd:=CH_RBuffPCharEnd+QCount; { prodlouzeni o pocet prijatych znaku }
          Char(Result):=CH_RBuffPCharBeg^;
          CH_RBuffPCharBeg:=CH_RBuffPCharBeg+SizeOf(Char);
        end
        else
        begin
          Char(Result):=#0;
          if not ClearCommError(CH_Handle,QErrors,Addr(CH_WStat)) then
          begin
            ChSetReceiveResult(CH_NumName or res_Err);
          end;
          CH_LastRError:=CH_LastRError or (QErrors and RErrorMsk);
          CH_LastTError:=CH_LastTError or (QErrors and TErrorMsk);
          if CH_LastRError=0 then
          begin
{!Ka
            CH_RResult:=CH_NumName or res_T_ChState or res_E_ChNoReceiveReady;
}
          end
          else
          begin
            ChSetReceiveResult(CH_NumName or res_Err);
            CH_LastRError:=0;
          end;
        end;
      end;
    end
    else
    begin
      ReadFile(CH_Handle,b,1,QCount,nil);
      CH_LastRTime:=GetTickCount;
      Result:=b;
      if QCount<>1 then
      begin
        if QCount>1 then
        begin
          ChSetReceiveResult(CH_NumName or res_Err);
        end
        else
        begin
          if not ClearCommError(CH_Handle,QErrors,Addr(CH_WStat)) then
          begin
            ChSetReceiveResult(CH_NumName or res_Err);
          end;
          CH_LastRError:=CH_LastRError or (QErrors and RErrorMsk);
          CH_LastTError:=CH_LastTError or (QErrors and TErrorMsk);
          if CH_LastRError=0 then
          begin
{!Ka
            CH_RResult:=CH_NumName or res_T_ChState or res_E_ChNoReceiveReady;
}
          end
          else
          begin
            ChSetReceiveResult(CH_NumName or res_Err);
            CH_LastRError:=0;
          end;
        end;
      end;
    end;
  end
  else
  begin
    ChReceiveChar:=$0;
    ChSetReceiveResult(CH_NumName or res_ErrNoConnect);
  end;
end; { ChReceiveChar }

procedure tChnCom.ChReceive(var Len: Word);
var
  QErrors : DWORD;
  QCount  : DWORD;
  FreeLng : DWORD;
begin
  Len:=0;
  if CH_Ctrl=CHS_Connect then
  begin
    if Assigned(CH_RBuff) and (CH_RBuffPCharBeg < CH_RBuffPCharEnd) then
    begin
      { vypocet delky volne casti bufferu, do ktere se bude cist }
      FreeLng:=CH_MRBuff-(CH_RBuffPCharEnd-CH_RBuffPCharBeg);
      { Prijem nakonec prijimaciho bufferu }
      ReadFile(CH_Handle,CH_RBuffPCharEnd^,BuffLngMin(CH_WStat.cbInQue,FreeLng),QCount,nil);
      CH_LastRTime:=GetTickCount;
      CH_RBuffPCharEnd:=CH_RBuffPCharEnd+QCount; { prodlouzeni o prijate znaky }
      Len:=CH_RBuffPCharEnd-CH_RBuffPCharBeg;    { delka dat pro predani }
      { predani nezpracovanych dat z primaciho bufferu }
      if CH_MRMess<Len then
      begin
        StrMove(CH_RMess,CH_RBuffPCharBeg,CH_MRMess);
{!Ka
        CH_RResult:=CH_NumName or res_T_Spec or res_E_Spec_RErr_buf;
}
      end
      else
        StrMove(CH_RMess,CH_RBuffPCharBeg,Len);
      { nova inicializace bufferu - byl predan ke zpracovani az do konce }
      CH_RBuffPCharBeg:=CH_RBuff;
      CH_RBuffPCharEnd:=CH_RBuff;
      if not ClearCommError(CH_Handle,QErrors,Addr(CH_WStat)) then
      begin
        ChSetReceiveResult(CH_NumName or res_Err);
      end;
      CH_LastRError:=CH_LastRError or (QErrors and RErrorMsk);
      CH_LastTError:=CH_LastTError or (QErrors and TErrorMsk);
      if CH_LastRError<>0 then
      begin
        ChSetReceiveResult(CH_NumName or res_Err);
        CH_LastRError:=0;
      end;
    end
    else
    begin
      ReadFile(CH_Handle,CH_RMess^,BuffLngMin(CH_WStat.cbInQue,CH_MRMess),QCount,nil);
      CH_LastRTime:=GetTickCount;
      if QCount>0 then
        Len:=QCount
      else
        Len:=0;
      if not ClearCommError(CH_Handle,QErrors,Addr(CH_WStat)) then
      begin
        ChSetReceiveResult(CH_NumName or res_Err);
      end;
      CH_LastRError:=CH_LastRError or (QErrors and RErrorMsk);
      CH_LastTError:=CH_LastTError or (QErrors and TErrorMsk);
      if CH_LastRError=0 then
      begin
{!Ka
        CH_RResult:=CH_NumName or res_T_ChState or res_E_ChNoReceiveReady;
}
      end
      else
      begin
        ChSetReceiveResult(CH_NumName or res_Err);
        CH_LastRError:=0;
      end;
    end;
  end
  else
  begin
    Len:=0;
    ChSetReceiveResult(CH_NumName or res_ErrNoConnect);
  end;
end; { ChReceive }

procedure tChnCom.ChReceiveFlush;
begin
  if CH_Ctrl=CHS_Connect then
  begin
    CH_RBuffPCharBeg:=CH_RBuff;
    CH_RBuffPCharEnd:=CH_RBuff;
    PurgeComm(CH_Handle,{PURGE_RXABORT or} PURGE_RXCLEAR);
    CH_LastRError:=0;   { ignorovani hlasenych chyb prijimace }
    ChSetReceiveResult(res_Ok);
  end
  else
    ChSetReceiveResult(CH_NumName or res_ErrNoConnect);
end; { ChReceiveFlush }
{================================================================}

begin
  ChnCollection.Insert(tAddChnCom.Init(Nil));

  {$ifdef HardLock}
   if not TestHardLock then RunError(99);
  {$endif}
end.
