unit uForm2; {FormChooseChannel - dialog.box pro vyber komunikacniho kanalu (protokolu, HW apod)}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,
  uGlb;

type
  TFormChooseChannel = class(TForm)
    GroupBoxProtocol   : TGroupBox;
    RadioButtonNoPrt   : TRadioButton;
    RadioButtonChnPrt  : TRadioButton;
    RadioButtonChnLecom: TRadioButton;
    CheckBoxChn        : TCheckBox;
    GroupBox1          : TGroupBox;
    RadioButtonChnCom  : TRadioButton;
    RadioButtonSimCom  : TRadioButton;
    ButtonOk           : TButton;
    ButtonExit         : TButton;
    Label1             : TLabel;
    LabelChannel       : TLabel;
    GroupBoxMiddle     : TGroupBox;
    RadioButtonNoMid   : TRadioButton;
    RadioButtonChnMod2 : TRadioButton;
    procedure FormCreate      (Sender: TObject);
    procedure FormClose       (Sender: TObject; var Action: TCloseAction);
    procedure ButtonOkClick   (Sender: TObject);
    procedure ButtonExitClick (Sender: TObject);
    procedure CheckBoxChnClick(Sender: TObject);
    procedure RadioButtonNoPrtClick   (Sender: TObject);
    procedure RadioButtonChnPrtClick  (Sender: TObject);
    procedure RadioButtonChnLecomClick(Sender: TObject);
    procedure RadioButtonChnComClick  (Sender: TObject);
    procedure RadioButtonSimComClick  (Sender: TObject);
    procedure RadioButtonNoMidClick(Sender: TObject);
    procedure RadioButtonChnMod2Click(Sender: TObject);
  private
    { Private declarations }
    LocChnType : tChnType;
    procedure RefreshLabelChannel; {podle nastaveni upravi LabelChannel.Caption}
    procedure ApplySettings;       {nastaveni v tomto formulari aplikuje na MainForm}
  public
    { Public declarations }
  end;

var
  FormChooseChannel: TFormChooseChannel;

implementation

uses
  uFormM;

{$R *.dfm}

procedure TFormChooseChannel.FormCreate(Sender: TObject);
begin
  LocChnType:=ChnType;
  CheckBoxChn.Checked:=(LocChnType and cMskLayerChn)<>0;
  case LocChnType and cMskLayerPrt of
    cLibChnPrt  : RadioButtonChnPrt  .Checked:=True;
    cLibChnLecom: RadioButtonChnLecom.Checked:=True;
    else          RadioButtonNoPrt   .Checked:=True;
  end;
  case LocChnType and cMskLayerMid of
    cLibChnMod :  RadioButtonChnMod2 .Checked:=True;
    else          RadioButtonNoMid   .Checked:=True;
  end;
  case LocChnType and cMskLayerHW of
    cLibChnCom :  RadioButtonChnCom  .Checked:=True;
    cLibChnMBox:  RadioButtonSimCom  .Checked:=True;
    else          RadioButtonChnCom  .Checked:=True;
  end;
end;

procedure TFormChooseChannel.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  MainForm.Enabled:=True;
  Action:=caFree;
end;

procedure TFormChooseChannel.ButtonOkClick(Sender: TObject);
var Action: TCloseAction;
begin
  ApplySettings;
  OnClose(Sender,Action);
  Release;
end;

procedure TFormChooseChannel.ButtonExitClick(Sender: TObject);
var Action: TCloseAction;
begin
  OnClose(Sender,Action);
  Release;
end;

procedure TFormChooseChannel.CheckBoxChnClick(Sender: TObject);
begin
  if CheckBoxChn.Checked then
  begin
    if (LocChnType and cMskLayerChn)=0 then LocChnType:=LocChnType or cLibChn;
  end
  else
    LocChnType:=LocChnType and (not cMskLayerChn);
  RefreshLabelChannel;  
end;

procedure TFormChooseChannel.RefreshLabelChannel;
var S:string[60];
begin
  if CheckBoxChn.Checked then
       S:='Application -> Chn -> '
  else S:='Application -> ';
  if RadioButtonChnPrt  .Checked then S:=S+'ChnPrt -> ';
  if RadioButtonChnLecom.Checked then S:=S+'ChnLecom -> ';
  if RadioButtonChnMod2 .Checked then S:=S+'ChnMod2 -> ';
  if RadioButtonChnCom  .Checked then S:=S+'ChnCom';
  if RadioButtonSimCom  .Checked then S:=S+'SimCom';
  {@ zde dalsi knihovny}
  LabelChannel.Caption:=S;
end;

procedure TFormChooseChannel.ApplySettings;
begin
  MainForm.ChangeChnType(LocChnType);

  if CheckBoxChn.Checked then
       MainForm.ComboBoxChn.ItemIndex:=1
  else MainForm.ComboBoxChn.ItemIndex:=0;
  if RadioButtonNoPrt   .Checked then MainForm.ComboBoxPrt.ItemIndex:=0;
  if RadioButtonChnPrt  .Checked then MainForm.ComboBoxPrt.ItemIndex:=1;
  if RadioButtonChnLecom.Checked then MainForm.ComboBoxPrt.ItemIndex:=2;
  if RadioButtonNoMid   .Checked then MainForm.ComboBoxMid.ItemIndex:=0;
  if RadioButtonChnMod2 .Checked then MainForm.ComboBoxMid.ItemIndex:=1;
  if RadioButtonChnCom  .Checked then MainForm.ComboBoxHW .ItemIndex:=0;
  if RadioButtonSimCom  .Checked then MainForm.ComboBoxHW .ItemIndex:=1;
  {@ zde dalsi knihovny}
end;

procedure TFormChooseChannel.RadioButtonNoPrtClick(Sender: TObject);
begin
  LocChnType:=(LocChnType and (not cMskLayerPrt)) or cLibNoPrt;
  RefreshLabelChannel;
end;

procedure TFormChooseChannel.RadioButtonChnPrtClick(Sender: TObject);
begin
  LocChnType:=(LocChnType and (not cMskLayerPrt)) or cLibChnPrt;
  RefreshLabelChannel;
end;

procedure TFormChooseChannel.RadioButtonChnLecomClick(Sender: TObject);
begin
  LocChnType:=(LocChnType and (not cMskLayerPrt)) or cLibChnLecom;
  RefreshLabelChannel;
end;

procedure TFormChooseChannel.RadioButtonChnComClick(Sender: TObject);
begin
  LocChnType:=(LocChnType and (not cMskLayerHW)) or cLibChnCom;
  RefreshLabelChannel;
end;

procedure TFormChooseChannel.RadioButtonSimComClick(Sender: TObject);
begin
  LocChnType:=(LocChnType and (not cMskLayerHW)) or cLibChnMBox;
  RefreshLabelChannel;
end;

procedure TFormChooseChannel.RadioButtonNoMidClick(Sender: TObject);
begin
  LocChnType:=(LocChnType and (not cMskLayerMid)) or cLibNoMid;
  RefreshLabelChannel;
end;

procedure TFormChooseChannel.RadioButtonChnMod2Click(Sender: TObject);
begin
  LocChnType:=(LocChnType and (not cMskLayerMid)) or cLibChnMod;
  RefreshLabelChannel;
end;

end.
