unit uBuff;

{     Ŀ      }
{       jednotka (unit)                                }
{                                                      }
{       uBuff = objekty pro obsluhu kruhovych          }
{       ~~~~~   bufferu typu LIFO a FIFO               }
{                                                      }
{       autor: Adam Wild                               }
{          }
{            }

{--------}
interface
{--------}

const
  Ver_uBuff = 'V1.0 15.05.1999';

type
  pBufLIFO = ^tBufLIFO;
  tBufLIFO = object
    Buff    : pointer; { ukazatel na buffer }
    BufSize : word;    { velikost bufferu }
    RecSize : byte;    { velikost jedne polozky }
    URec,              { ukazovatko na prvni obsazene misto v bufferu }
    VRec    : word;    { ukazovatko na prvni volne misto v bufferu}
    FlOver  : boolean; { priznak preteceni bufferu }
    FlUnder : boolean; { priznak podteceni bufferu }
    constructor Init (Size : word; RSize : byte);
    destructor  Done;
   { nastaveni a vraceni velikosti bufferu }
    procedure SetSize(Size : word;
                     RSize : byte);   { zmeni velikost bufferu }
    function  GetBufSize   : word;    { vrati velikost bufferu v bytech }
    function  GetRecSize   : byte;    { vrati velikost jedne polozky }
    function  GetFreeSize  : word;    { vrati velikost volneho mista bufferu v bytech }
    function  GetFullSize  : word;    { vrati velikost zaplneneho mista bufferu v bytech }
   { vraceni stavu preteceni a podteceni }
    function  GetOver      : boolean; { vrati priznak preteceni bufferu }
    function  GetUnder     : boolean; { vrati priznak podteceni bufferu }
   { vkladani a uvolnovani bufferu }
    procedure FlushBuff;              { vyprazdni buffer }
    procedure PushByte(B   : byte);   { vlozi do bufferu byte }
    function  PopByte      : byte;    { vrati z bufferu byte }
  {pozn: - buffer musi mit velikost alespon pro 2 polozky
           protoze 1 polozka se spotrebuje na manipulci }
  end;

{----------}
implementation
{----------}

const
  cMaxAByte = (65535-1) div 1; { maximalni velikost pole bytu }
  cMaxAWord = (65535-2) div 2; { maximalni velikost pole wordu }
  cMaxALong = (65535-4) div 4; { maximalni velikost pole longintu }

type
  pAByte = ^tAByte;
  tAByte = array[0..cMaxAByte] of byte;

  pAWord = ^tAWord;
  tAWord = array[0..cMaxAWord] of word;

  pALong = ^tALong;
  tALong = array[0..cMaxALong] of longint;

{-------------------------------------------------}
constructor tBufLIFO.Init(Size : word; RSize : byte);
begin
  Buff   := nil;
  URec   := 0;
  VRec   := 0;
  FlOver := False;
  FlUnder:= False;
  SetSize(Size,RSize);
end;
{-------------------------------------------------}
destructor tBufLIFO.Done;
begin
  FlushBuff;
  if Buff<>nil then
  begin
    FreeMem(Buff,BufSize*RecSize);
    BufSize:=0;
    Buff:=nil;
  end;
end;
{-------------------------------------------------}
procedure tBufLIFO.SetSize(Size:word; RSize:byte);
begin
 { kontrola rozsahu velikosti }
  if RSize<1 then RSize:=1;
  if Size<2                       then Size:=2;
  if Size>(65535-RSize) div RSize then Size:=(65535-RSize) div RSize;
 { kontrola preteceni }
  if GetFullSize*RecSize>(Size-1)*RSize then
    begin
      FlushBuff;
      FlOver:=True;
    end;
 { uvolneni pameti stareho bufferu }
  if Buff<>nil then
    FreeMem(Buff,BufSize*RecSize);
 { alokace pameti noveho bufferu }
  RecSize:=RSize;
  BufSize:=Size;
  GetMem(Buff,BufSize*RecSize);
end;
{-------------------------------------------------}
function  tBufLIFO.GetBufSize : word;
begin
  GetBufSize:=BufSize-1;
end;
{-------------------------------------------------}
function  tBufLIFO.GetRecSize : byte;
begin
  GetRecSize:=RecSize;
end;
{-------------------------------------------------}
function  tBufLIFO.GetFreeSize: word;
begin
  if VRec=URec then
         GetFreeSize:=BufSize-1
  else
    if VRec>URec then
         GetFreeSize:=BufSize-(VRec-URec)-1
    else GetFreeSize:=URec-VRec-1;
end;
{-------------------------------------------------}
function  tBufLIFO.GetFullSize: word;
begin
  if VRec=URec then
         GetFullSize:=0
  else
    if VRec>URec then
         GetFullSize:=VRec-URec
    else GetFullSize:=BufSize-URec+VRec;
end;
{-------------------------------------------------}
function  tBufLIFO.GetOver :boolean;
begin
  GetOver:=FlOver;
  FlOver :=False;
end;
{-------------------------------------------------}
function  tBufLIFO.GetUnder:boolean;
begin
  GetUnder:=FlUnder;
  FlUnder :=False;
end;
{-------------------------------------------------}
procedure tBufLIFO.FlushBuff;
begin
  URec   := 0;
  VRec   := 0;
  FlOver := False;
  FlUnder:= False;
end;
{-------------------------------------------------}
procedure tBufLIFO.PushByte(B : byte);
begin
  pAByte(Buff)^[VRec]:=B;
  if VRec<BufSize then Inc(VRec)
  else VRec:=0;
  if VRec=URec then
  begin
    if URec<BufSize then Inc(URec)
    else URec:=0;
    FlOver:=True;
  end;
end;
{-------------------------------------------------}
function  tBufLIFO.PopByte   : byte;
begin
  if VRec<>URec then
  begin
    PopByte:=pAByte(Buff)^[URec];
    if URec<BufSize then Inc(URec)
    else URec:=0;
  end
  else
  begin
    FlUnder:=True;
    PopByte:=0;
  end;
end;

{-------------------------------------------------}
End.
