unit ChnSMS;

         {ͻ}
         {                                                               }
         { unit ChnSMS                                                   }
         {                                                               }
         { jednotka pro obsluhu komunikace pres GSM modem                }
         { s vyuzitim zprav SMS                                          }
         {                                                               }
         { (C)1999 SofCon, Steovick 49, 160 00 Praha 6                }
         {              Adam Wild, Dejvicka 42, Praha 6                  }
         {ͼ}

{ define ChnSMSDeb} { definice pro ladici vypisy }

{$ifdef ChnSMSDeb}
  {$define Deb_Ctrl}    { definice pro vypisy stavu vsech automatu }
  {$define Deb_SendRec} { definice pro vypisy celych vysilanych a prijimanych zprav }
  { define Deb_LoRec}   { definice pro vypisy jednotlivych vysilanych a prijimanych znaku }
{$endif}

{----------}
interface
{----------}

{ pouzivane podminky prekladu: }
{ ChnSMSDeb   - zobrazovani ladicich vypisu na monitoru
    Deb_Ctrl    - zobrazovani mezistavu automatu kanalu, prijimace, vysilace
    Deb_SendRec - zobrazovani celych prijimanych a vysilanych zprav z/do modemu
    Deb_LoRec   - zobrazovani vsech prijimanych znaku od modemu }

uses
  WinProcs,WinTypes,Classes, { vazba na Windows }
{  ChnTypes,}
  ChnVirt,
  uString,
  Timer,
  uSMS;

const
  cName     = 'SMS';
  cVer      = 'v4.1, 28.02.2000';

const
  res_Err_WrongPIN = $20; { byl zadan spatny PIN }

type
 { vyctovy typ ruznych delay }
  tDelays = (
    ESC,            { DES - Delay pred a po ESC-stringu v SW Hangup procedure }
    AfterI1S,       { DI1 - Delay po vyslani 1. inicialisacniho stringu }
    AfterI2S,       { DI2 - Delay po vyslani 2. inicialisacniho stringu }
    AfterI3S,       { DI3 - Delay po vyslani 3. inicialisacniho stringu }
    BeforPIN,       { DBP - Delay pred zadanim PINu }
    AfterPIN,       { DAP - Delay po spravnem zadani PINu }
    BeforMemSto,    { DBM - Delay pred dotazem na obsazeni pameti }
    BeforSMSData    { DBS - Delay pred vyslanim SMS dat vysilane zpravy }
    );

 { vyctovy typ ruznych timeout }
  tTimeOuts = (
    SendAtCmd,      { QAT - Timeout pro vysilani zpravy do modemu }
    CmdAnsw,        { QCA - Timeout pro odpoved na ostatni prikazy }
    AnswPIN,        { QAP - Timeout pro odpoved na nastaveni PIN }
    AnswSMS,        { QAS - Timeout pro prijeti dat SMS zpravy }
    SendSMS         { QSS - Timeout pro prijeti odpovedi na vyslani SMS zpravy }
    );

 { vyctovy typ pro ruzne odpovedi modemu a ridicich stringu }
  tStrAnsw = (
    Init1S,         { I1S - 1. inicializacni retezec }
    Init2S,         { I2S - 2. inicializacni retezec }
    Init3S,         { I3S - 3. inicializacni retezec }
    AnswOK,         { OKS - retezec pro odpoved "OK" }
    AnswERROR,      { ERS - retezec pro odpoved "ERROR" }
    ESCStr          { SHS - retezec pro softwarovy prechod do Cmd rezimu }
    );

type
 { typy retezcu pro AT prikazy }
  tStrATCmd       = String[40]; { typ retezce pro standartni AT prikazy }
  tStrSimPin      = String[ 8]; { typ retezce pro SIM PIN }
  tStrSimPuk      = String[12]; { typ retezce pro SIM PUK }

 { stav kroku miniautomatu (pro vyslani jednoho AT prikazu s cekanim na odpoved) }
  tSMC_Ctrl = (
    SMCS_Beg,         { pocatek modem command cyklu }
    SMCS_Delay1,      { prodleva pred vysilanim commandu }
    SMCS_FlowControl, { ceka se na osetreni HW toku dat }
    SMCS_Send,        { vyslani commandu }
    SMCS_SendDelay,   { test na dokonceni vysilani }
    SMCS_Delay2,      { prodleva po odvysilani }
    SMCS_Rec,         { cteni odpovedi }
    SMCS_RecEnd,      { konec cteni, dekodovani semantiky zpravy }
    SMCS_Ready        { konec modem command cyklu - stabilni stav }
    );

 { zaznam struktury bufferu pro vysilani prikazu do modemu pomoci metody ChSetBinParam }
  pAtCmdBuff = ^tATCmdBuff;
  tAtCmdBuff = record
    Mode     : byte;     { zadany mode }
    Delay1,              { pauza v ms pred vyslanim AT prikazu }
    Delay2   : longint;  { pauza v ms po vyslani AT prikazu }
    TimeOut  : longint;  { timeout v ms pro cekani na odpoved }
    CmdStr   : string;   { retezec AT prikazu }
    RecStr   : string;   { retezec odpovedi na AT prikaz }
  end;

 { zaznam struktury s informacemi o pametovem prostoru }
  tMemRec = record
    Name  : string[5]; { jmeno pametoveho prostoru }
    Used  : byte;      { pocet zaplnenych bank }
    UseOld: byte;      { pocet zaplnenych bank z minula }
    Total : byte;      { celkovy pocet bank }
  end;

const
 { kody pro metodu ChSetBinParam }
  cmd_SendCmd   = $10; { poslani prikazu do modemu s doplnenim CR }
  cmd_RecAnsw   = $11; { prijmuti zpravy z modemu s odstranenim CR }
  cmd_CmdAnsw   = $12; { poslani prikazu do modemu s cekanim na odpoved }
  cmd_SendData  = $13; { poslani dat do modemu }
  cmd_RecData   = $14; { prijeti dat z modemu }
 { kody pro metodu ChGetBinParam }
  cmd_CmdReady  = $15; { krok automatu vyslani prikazu a aktualni stav automatu }
  cmd_CmdResult = $16; { vysledek po poslani cmd_SendCmd,RecAnsw,CmdAnsw,SendData,RecData }

 { status po vyslani zpravy do modemu navraceny metodou ChGetBinParam s kodem cmd_CmdResult }
  ResGSM_Ok           =  0;  { bez chyby resp. odezva OK }
  ResGSM_ChannelNil   =  2;  { nelze predat rizeni podrizene vrstve }
  ResGSM_Error        = 12;  { modem hlasi ERROR }
  ResGSM_NoAnswer     = 14;  { modem hlasi NO ANSWER (v teto versi neimpl.)}
  ResGSM_Answer       = 19;  { modem hlasi jinou odpoved }
  ResGSM_LongAnswer   = 20;  { modem hlasi prilis dlouhou odpoved }
  ResGSM_SHwErr       = 21;  { nizka chyba pri vysilani }
  ResGSM_RHwErr       = 22;  { nizka chyba pri prijmu }
  ResGSM_RTimeOut     = 23;  { timeout na prijmu }
  ResGSM_STimeOut     = 24;  { timeout pri vysilani }

  MaxMem = 5; { maximalni pocet pametovych prostoru }

const
 { konstanty AT prikazu a odpovedi }
  cAtCmdGSM_SetPin     = '+CPIN';     { retezec pro dotaz ci nastaveni PIN }
  cAtAnsGSM_AnswSimPin = 'SIM PIN';   { retezec pro odpoved pro zadani SIM PIN }
  cAtAnsGSM_AnswSimPuk = 'SIM PUK';   { retezec pro odpoved pro zadani SIM PUK }
  cAtAnsGSM_AnswReady  = 'READY';     { retezec pro odpoved PIN OK }
  cAtCmdSMS_SetSCNum   = '+CSCA';     { retezec pro dotaz ci nastaveni cisla operatora SMS }
  cAtCmdSMS_SetMode    = '+CMGF';     { retezec pro dotaz ci nastaveni modu (TXT/PDU) }
  cAtCmdSMS_GetMemSto  = '+CPMS';     { retezec pro dotaz obsazeni pameti zpravami }
  cAtCmdSMS_DelMsg     = '+CMGD';     { retezec pro vymazani zpravy z banky }
  cAtCmdSMS_ReadMsg    = '+CMGR';     { retezec pro cteni zpravy z banky }
  cAtCmdSMS_WriteMsg   = '+CMGW';     { retezec pro zapis zpravy do banky }
  cAtCmdSMS_SendMsg    = '+CMGS';     { retezec pro prime poslani zpravy }
  cAtCmdSMS_SendMsg2   = '+CMSS';     { retezec pro poslani zpravy z banky }
  cAtCmdGSM_GetManufID = '+CGMI';     { retezec pro cteni vyrobce GSM stanice }
  cAtCmdGSM_GetModelID = '+CGMM';     { retezec pro cteni modelu GSM stanice }


type
  tChnSMS = class(tChnVirt)
    CH_Tick     : LongBool;  { je vykonavana cinnost kanaloveho automatu }
    CH_STick    : LongBool;  { je vykonavana cinnost vysilaciho automatu }
    CH_RTick    : LongBool;  { je vykonavana cinnost prijimaciho automatu }
    CH_LRMess   : Word;      { delka prijimane zpravy }

    CH_ATCmdBuff: pATCmdBuff;   { ukazatel na pomocny buffer pro miniautomat jednotlivych AT prikazu }
    CH_SimPin   : tStrSimPin;   { retezec pro SIM PIN }
    CH_SimPuk   : tStrSimPuk;   { retezec pro SIM PUK }
    CH_SMSCNum  : tPhoneNumStr; { retezec cisla pro operatora SMS }
    CH_TextMode : boolean;      { priznak pouziti TXT/PDU modu pro SMS zpravy }

    CH_StationID: string[50];   { retezec s identifikaci pripojene GSM stanice }

    CH_Delay    : array [tDelays]   of longint;  { pole ruznych delay }
    CH_TimeOut  : array [tTimeOuts] of longint;  { pole ruznych timeout }
    CH_Str      : array [tStrAnsw]  of tStrATCmd;{ pole typu odpovedi a ridicich retezcu pro modem }
    CH_Mem      : array [1..MaxMem] of tMemRec;  { pole informaci o jednotlivych bankach }

    CH_FlRecRead: boolean;  { priznak prijimani krom novych i jiz prectenych SMS zprav }

    CH_FlowCntrl: byte;     { zpusob rizeni toku dat
                              0 - zadny
                              1 - CTS/RTS
                              2 - DSR/DTR }

    CH_Char_CR  : char;     { znak pro Enter (CR) }
    CH_Char_LF  : char;     { znak pro odradkovani (LF) }
    CH_Char_BS  : char;     { znak pro BackSpace (BS) }

    { vytvoreni, zruseni objektu }
    constructor Init;
                  { vytvoreni objektu }
    constructor ChInitParam(const S: TParamStr);
                  { vytvoreni objektu a nastaveni parametru }
    destructor  Destroy;
                  override; { zruseni objektu }

    { zadani a zobrazeni zadanych parametru }
    function  ChSetOneParam(const S: tWordString; var CmdL: tCmd): tChResult;
                override; { nove nastaveni jednoho parametru textove }
    function  ChGetParam   (const S: TParamStr): TParamStr;
                override; { prevod parametru kanalu do stringu }

    { nastaveni a cteni nekterych stavu a parametru kanalu }
    procedure ChSetBinParam(NumName: Word; Code: Word; Param: longint);
                override;
    function  ChGetBinParam(NumName: Word; Code: Word): longint;
                override;

    { otevreni a zavreni kanalu, navazani a zruseni komunikace }
    procedure ChOpen;
                override; { otevereni kanalu }
    procedure ChClose;
                override; { zavreni kanalu }
    procedure ChConnect;
                override; { pocatek navazovani spojeni }
    procedure ChDisConnect;
                override; { pocatek ukonceni spojeni }

    { vysilani dat }
    procedure ChSend(Buff: Pointer; Len:Word);
                override; { pocatek vysilani }
    function  ChSendReady: TCHState;
                override; { krok vysilaciho aut., stav vysilani }
    procedure ChSendFlush;
                override; { preruseni vysilani }

    { prijem dat }
    function  ChReceiveReady: TCHState;
                override; { krok prij. automatu, stav prijmu }
    procedure ChReceive(var Len: Word);
                override; { prijem zpravy }
    procedure ChReceiveFlush;
                override; { stav jako po inicializaci }

    function  ChState: TChState;
                override; { krok automatu a vraceni naposledy dosazeneho stabilniho stavu kanalu }
    function  ChReady: TChState;
                override; { krok automatu a vraceni aktualniho stavu kanalu }

    { provedeni kroku automatu kanalu, vysilace, prijimace }
    procedure ChTick;
                override; { provedeni kroku kanalu }
    procedure ChSendTick;
                override; { provedeni kroku vysilace }
    procedure ChReceiveTick;
                override; { provedeni kroku prijimace }

  private
    CH_MemBank  : byte;              { cislo ctene banky }
    CH_MemIndex : byte;              { cislo ctene bunky z banky CH_MemBank }
    CH_SendStr  : ShortString;       { pomocny retezec pro vyslani zpravy }
    CH_LenRecSMS: byte;              { pomocna delka retezce prijate SMS zpravy v PDU modu }
    { promenne pro miniautomat SMC }
    SMC_Result  : integer;           { vysledek miniautomatu }
    SMC_Ctrl    : tSMC_Ctrl;         { krok algoritmu miniautomatu }
    SMC_ChnTime : tTimer;            { odmerovani casovych intervalu pro miniautomat }

    procedure ChAtCmd(S:ShortString; Mode_:byte; Del1,Del2,TimOut:longint);
                { zacatek vyslani prikazu do modemu s pripadnym cekanim na odpoved (pocatek algoritmu SMC) }
    function  ChAtCmdReady: tSMC_Ctrl;
                { krok automatu algoritmu SMC + prubezny vysledek algoritmu SMC }
    procedure ChAtCmdTick;
                { krok automatu algoritmu SMC }
    function  ChAtCmdResult:integer;
                { poskytnuti vysledku algoritmu SMC SMC_Result }
    procedure DecodeMemSto(S:tStrAtCmd);
                { rozdekoduje prichozi zpravu na dotaz obsazeni pameti }
    function  DecodeReaded(S:tStrAtCmd):word;
                { rozdekoduje prichozi zpravu v bunce a vrati delku nove prichozi zpravy }
    function  CodePreSendMsg:string;
                { zakoduje predretezec vysilane zpravy v PDU rezimu }
  end;

type
  TAddChnSMS = class(TAddChnVirt)
    function ChInit: tChnVirt; override; { funkce provadejici zalozeni a inicializaci daneho kanalu }
  end;

{-------------}
implementation
{-------------}
uses
 {$ifdef HardLock}
  HardLock,
 {$endif}
  SysUtils;

function tAddChnSMS.ChInit: tChnVirt;
begin
  ChInit:=tChnSMS.Init;
end;

const
 { nestabilni stavy automatu kanalu }
  CHS_Opening1         = 10; { provadi se 1.krok Open (CH_Chn^.ChOpen) }
  CHS_Opening2         = 11; { provadi se 2.krok Open (CH_Chn^.ChConnect) }
  CHS_Closing1         = 12; { provadi se posledni krok Close (CH_Chn^.ChClose) }
  CHS_Closing2         = 13; { provadi se prvni krok Close (CH_Chn^.ChDisConnect) }
  CHS_Connect_1        = 14; { provadi se 1.krok Connect (ATZ) }
  CHS_Connect_Ini1     = 15; { inicialisace modemu, krok 1 }
  CHS_Connect_Ini2     = 16; { inicialisace modemu, krok 2 }
  CHS_Connect_Ini3     = 17; { inicialisace modemu, krok 3 }
  CHS_Connect_AskPin   = 18; { dotaz na PIN }
  CHS_Connect_AskingPin= 19; { dotazovani na PIN }
  CHS_Connect_SetPin   = 20; { zadani PIN }
  CHS_Connect_Delay    = 21; { pauza po spravnem zadani PIN }
  CHS_Connect_SetSCNum = 22; { nastaveni cisla zpravce SMS }
  CHS_Connect_SetMode  = 23; { nastaveni modu (TXT/PDU) }
  CHS_Connect_GetManuf = 24; { cteni vyrobce pripojene GSM stanice }
  CHS_Connect_GetModel = 25; { cteni modelu pripojene GSM stanice }
  CHS_DisCon_1         = 30; { 1.krok DisConnect }

 { nestabilni stavy automatu prijimace }
  CHS_ReceiveBegin     = 02; { zacatek prijimace }
  CHS_ReceiveGetMemSto = 03; { vrati informace o zaplnenych pametech }
  CHS_ReceiveSetMemSto = 04; { nastaveni zaplnovani pameti }
  CHS_ReceiveReadSMS   = 05; { postupne cteni vsech bank pameti }
  CHS_ReceiveReadingSMS= 06; { probiha cteni banky pameti }
  CHS_ReceiveSMSData   = 07; { prijem dat SMS zpravy }
  CHS_ReceiveDelRecSMS = 08; { vymazani prijate zpravy }

 { nestabilni stavy automatu vysilace }
  CHS_SendBegin        = 03; { pocatek vysilani a cekani do stabilniho stavu Connect }
  CHS_SendCmd          = 04; { probiha vysilani prikazu pro poslani SMS zpravy }
  CHS_SendData         = 05; { probiha vyslani dat pro poslani SMS zpravy }
  CHS_SendDataReply    = 06; { probiha prijem odpovedi na vyslani SMS zpravy }

const
 { konstanty prikazu pro metodu CH_Chn^.ChGetBinParam (hodnoty konstant
   musi byt shodne s prislusnymi konstantami podrizene zretezene knihovny)}
  cmd_GetMSR   = $0101; { prikaz pro vraceni stavu vsech modemovych signalu (MSR) }
  cmd_GetCTS   = $0106; { prikaz pro vraceni stavu modemoveho signalu CTS   v 0.bitu vysledku funkce }
  cmd_GetDSR   = $0107; { prikaz pro vraceni stavu modemoveho signalu DSR   v 0.bitu vysledku funkce }
  cmd_GetRI    = $0108; { prikaz pro vraceni stavu modemoveho signalu RI    v 0.bitu vysledku funkce }
  cmd_GetRLSD  = $0109; { prikaz pro vraceni stavu modemoveho signalu RLSD  v 0.bitu vysledku funkce }

{================================================================}
constructor tChnSMS.Init;
var I:byte;
begin
  inherited;
  { CH_Result nastavuje Init }
  CH_Type     := cName;
  CH_Name     := CH_Type;
  CH_NumName  := ChNumName(CH_Type);
  CH_SCtrl    := CHS_SendReady;
  CH_Tick     := false;
  CH_STick    := false;
  CH_RTick    := false;
  CH_LRMess   := 0;
  CH_SimPin   := '1234';
  CH_SimPuk   := '1234';
  CH_SMSCNum  := '420603052000';
  CH_TextMode := False;
  CH_FlRecRead:= False;
  CH_FlowCntrl:= 0;
  CH_Char_CR  := #$0D;
  CH_Char_LF  := #$0A;
  CH_Char_BS  := #$08;
  CH_Delay[ESC]         := 02000;
  CH_Delay[AfterI1S]    := 01500;
  CH_Delay[AfterI2S]    := 00500;
  CH_Delay[AfterI3S]    := 00500;
  CH_Delay[AfterPin]    := 03000;
  CH_Delay[BeforPIN]    := 00250;
  CH_Delay[BeforMemSto] := 00500;
  CH_Delay[BeforSMSData]:= 00500;
  CH_TimeOut[SendAtCmd] := 00500;
  CH_TimeOut[CmdAnsw]   := 02000;
  CH_TimeOut[AnswPIN]   := 03000;
  CH_TimeOut[AnswSMS]   := 04000;
  CH_TimeOut[SendSMS]   := 05000;
  CH_Str[Init1S]        := 'ATZ';
  CH_Str[Init2S]        := '';
  CH_Str[Init3S]        := '';
  CH_Str[AnswOK]        := 'OK';
  CH_Str[AnswERROR]     := 'ERROR';
  CH_Str[EscStr]        := '+++';
  for I:=1 to MaxMem do
    with CH_Mem[I] do
    begin
      Name  :='';
      Used  :=0;
      UseOld:=0;
      Total :=0;
    end;
  New(CH_ATCmdBuff);
  with CH_ATCmdBuff^ do
  begin
    CmdStr :='';
    Delay1 :=0;
    Delay2 :=0;
    TimeOut:=0;
    RecStr :='';
  end;
  SMC_ChnTime := tTimer.Init;
  CH_StationID:='';
end;

{------------------------------}
constructor tChnSMS.ChInitParam(const S: TParamStr);
begin
  Init;
  ChSetParam(S);
  { CH_Result nastavuje CHInitParam }
end;

{------------------------------}
destructor tChnSMS.Destroy;
begin
  SMC_ChnTime.Done;
  SMC_ChnTime:=nil;
  if CH_ATCmdBuff<>nil then
  begin
    Dispose(CH_ATCmdBuff);
    CH_ATCmdBuff:=nil;
  end;
  inherited;
  { CH_Result nastavuje Done }
end;

{------------------------------}
function  tChnSMS.ChSetOneParam(const S: tWordString; var CmdL: tCmd): tChResult;
type
  tParam = (P_ERR,
            { Init Strings, Glob Strings }
            P_PIN,    { retezec pro SIM PIN }
            P_PUK,    { retezec pro SIM PUK }
            P_SCN,    { retezec cisla operatora SMS (Service Center Number) }
            P_TXT,    { Text/PDU mod SMS zprav }
            P_RRM,    { priznak prijimani i jiz drive prectenych zprav }
            P_SFC,    { Typ SW Flow Control }
            P_I1S,    { 1.inicializacni command modemu }
            P_I2S,    { 2.inicializacni command modemu }
            P_I3S,    { 3.inicializacni command modemu }
            P_OKS,    { retezec pro odpoved "OK" }
            P_ERS,    { retezec pro odpoved "ERROR" }
            P_SHS,    { retezec pro softwarovy prechod do Cmd rezimu }
            { Delays }
            P_DES,    { Delay pred a po ESC-stringu v SW Hangup procedure }
            P_DI1,    { Delay po vyslani 1. inicialisacniho stringu }
            P_DI2,    { Delay po vyslani 2. inicialisacniho stringu }
            P_DI3,    { Delay po vyslani 3. inicialisacniho stringu }
            P_DBP,    { Delay pred zadanim PINu }
            P_DAP,    { Delay po spravnem zadani PINu }
            P_DBM,    { Delay pred dotazem na obsazeni pameti }
            { TimeOuts }
            P_QAT,    { Timeout pro vysilani zpravy do modemu }
            P_QCA,    { Timeout pro odpoved na ostatni prikazy }
            P_QAS,    { Timeout pro prijeti dat SMS zpravy }
            P_QSS     { Timeout pro prijeti odpovedi na vyslani SMS zpravy }
            );
const
  StrParam = 'PIN|PUK|SCN|TXT|RRM|SFC|I1S|I2S|I3S|'+
             'OKS|ERS|SHS|'+
             'DES|DI1|DI2|DI3|DBP|DAP|DBM|'+
             'QAT|QCA|QAS|QSS|';
var
  PomS    : tWordString;
  PomRes  : tChResult;
  Param   : tParam;
  ErrFl   : boolean;
  PomL    : longint;
begin
  PomRes:=res_Ok;
  ErrFl:=False;
  if S='|' then
  begin
    ChNextSetParam(CmdL.ReadRest);
    PomRes:=ChResult;
  end
  else
  begin
    Param:=tParam(NDELIM(S,StrParam));
    case Param of
      P_ERR:
        PomRes:=inherited ChSetOneParam(S,CmdL);
      P_PIN:
        begin
          CH_SimPin:=CmdL.ReadString;
        end;
      P_PUK:
        begin
          CH_SimPuk:=CmdL.ReadString;
        end;
      P_SCN:
        begin
          CH_SMSCNum:=CmdL.ReadString;
        end;
      P_TXT:
        begin
          PomS:=CmdL.ReadWordUpCase;
          if PomS='ON'  then CH_TextMode:=true
          else
          if PomS='OFF' then CH_TextMode:=false
          else
            ErrFl:=True;
        end;
      P_RRM:
        begin
          PomS:=CmdL.ReadWordUpCase;
          if PomS='ON'  then CH_FlRecRead:=true
          else
          if PomS='OFF' then CH_FlRecRead:=false
          else
            ErrFl:=True;
        end;
      P_SFC:
        begin
          PomS:=CmdL.ReadWordUpCase;
          if PomS[1]='N' then CH_FlowCntrl:=0
          else
          if PomS='CTS'  then CH_FlowCntrl:=1
          else
          if PomS='DSR'  then CH_FlowCntrl:=2
          else
            ErrFl:=True;
        end;
      P_I1S:
        begin
          CH_Str[Init1S     ]:=CmdL.ReadString;
        end;
      P_I2S:
        begin
          CH_Str[Init2S     ]:=CmdL.ReadString;
        end;
      P_I3S:
        begin
          CH_Str[Init3S     ]:=CmdL.ReadString;
        end;
      P_OKS:
        begin
          CH_Str[AnswOK     ]:=CmdL.ReadString;
        end;
      P_ERS:
        begin
          CH_Str[AnswERROR  ]:=CmdL.ReadString;
        end;
      P_SHS:
        begin
          CH_Str[ESCStr     ]:=CmdL.ReadString;
        end;
      P_DES:    { Delay pred a po ESC-stringu v SW Hangup procedure }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Delay[ESC]:=PomL;
        end;
      P_DI1:    { Delay po vyslani 1. inicialisacniho stringu }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Delay[AfterI1S]:=PomL;
        end;
      P_DI2:    { Delay po vyslani 2. inicialisacniho stringu }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Delay[AfterI2S]:=PomL;
        end;
      P_DI3:    { Delay po vyslani 3. inicialisacniho stringu }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Delay[AfterI3S]:=PomL;
        end;
      P_DBP:
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Delay[BeforPIN]:=PomL;
        end;
      P_DAP:
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Delay[AfterPIN]:=PomL;
        end;
      P_DBM:
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Delay[BeforMemSto]:=PomL;
        end;
      P_QAT:    { Timeout pri vysilani do modemu }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_TimeOut[SendAtCmd]:=PomL;
        end;
      P_QCA:    { Timeout pro odpoved na ostatni prikazy }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_TimeOut[CmdAnsw]:=PomL;
        end;
      P_QAS:    { Timeout pro prijeti dat SMS zpravy }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_TimeOut[AnswSMS]:=PomL;
        end;
      P_QSS:    { Timeout pro prijeti odpovedi na vyslani SMS zpravy }
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_TimeOut[SendSMS]:=PomL;
        end;
    end; {case}
  end;
  if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
  ChSetOneParam:=PomRes;
end;

{------------------------------}
function  tChnSMS.ChGetParam(const S: TParamStr): TParamStr;
var
  ss : tParamStr;
begin
  ss:='';
  if (S='')or(S='1') then     { Zakladni parametry }
  begin
    ss :=  'NAM='+CH_Name+
          ' PIN='''+CH_SimPin+''''+
          ' PUK='''+CH_SimPuk+''''+
          ' SCN='''+CH_sMSCNum+''''+
          ' TXT=';
    if CH_TextMode  then ss:=ss+'ON'
                    else ss:=ss+'OFF';
    ss:=ss+' RRM=';
    if CH_FlRecRead then ss:=ss+'ON'
                    else ss:=ss+'OFF';
    ss:=ss+' SFC=';
    case CH_FlowCntrl of
      1:   ss:=ss+'CTS';
      2:   ss:=ss+'DSR';
      else ss:=ss+'N';
    end;
  end;
  if S='2' then     { retezce }
    ss := ' I1S='''+CH_Str[Init1S     ]+''''+
          ' I2S='''+CH_Str[Init2S     ]+''''+
          ' I3S='''+CH_Str[Init3S     ]+''''+
          ' OKS='''+CH_Str[AnswOK     ]+''''+
          ' ERS='''+CH_Str[AnswERROR  ]+''''+
          ' SHS='''+CH_Str[ESCStr     ]+'''';
  if S='3' then     { Delays and TimeOuts }
    ss := ' DES='+LStr(CH_Delay[ESC      ])+
          ' DI1='+LStr(CH_Delay[AfterI1S ])+
          ' DI2='+LStr(CH_Delay[AfterI2S ])+
          ' DI3='+LStr(CH_Delay[AfterI3S ])+
          ' DBP='+LStr(CH_Delay[BeforPIN ])+
          ' DAP='+LStr(CH_Delay[AfterPIN ])+
          ' DBM='+LStr(CH_Delay[BeforMemSto])+
          ' QAT='+LStr(CH_TimeOut[SendATCmd])+
          ' QCA='+LStr(CH_TimeOut[CmdAnsw  ])+
          ' QAS='+LStr(CH_TimeOut[AnswSMS])+
          ' QSS='+LStr(CH_TimeOut[SendSMS]);
  ChGetParam:=ss;
  ChSetResult(res_Ok);
end; {ChGetParam}

{------------------------------}
procedure tChnSMS.ChSetBinParam(NumName: Word; Code: Word; Param: longint);
begin
  if NumName=CH_NumName then
  begin
    ChSetResult(res_Ok);
    case Code of
      cmd_SendCmd,
      cmd_RecAnsw,
      cmd_CmdAnsw,
      cmd_SendData,
      cmd_RecData:
        begin
          with tAtCmdBuff(pointer(Param)^) do
            ChAtCmd(CmdStr,Code,Delay1,Delay2,TimeOut);
          ChSetResult(res_Ok);
        end;
      else ChSetResult(CH_NumName or res_Err);
    end;
  end
  else
    if CH_Chn<>nil then
    begin
      CH_Chn.ChSetBinParam(NumName,Code,Param);
      ChSetResult(CH_Chn.ChResult);
    end
    else
      ChSetResult(CH_NumName or res_ErrChannelNoExist);
end;

{------------------------------}
function  tChnSMS.ChGetBinParam(NumName: Word; Code: Word): longint;
begin
  if NumName=CH_NumName then
  begin
    ChSetResult(res_Ok);
    case Code of
      cmd_CmdReady:
        begin
          ChGetBinParam:=longint(ChAtCmdReady);
          ChSetResult(res_Ok);
        end;
      cmd_CmdResult:
        begin
          ChGetBinParam:=ChAtCmdResult;
          ChSetResult(res_Ok);
        end;
      else
        begin
          ChGetBinParam:=0;
          ChSetResult(CH_NumName or res_Err);
        end;
    end;
  end
  else
    if CH_Chn<>nil then
    begin
      ChGetBinParam:=CH_Chn.ChGetBinParam(NumName,Code);
      ChSetResult(CH_Chn.ChResult);
    end
    else
    begin
      ChGetBinParam:=0;
      ChSetResult(CH_NumName or res_ErrChannelNoExist);
    end;
end;

{------------------------------}
procedure tChnSMS.ChATCmd(S:ShortString; Mode_:byte; Del1,Del2,TimOut:longint);
{ procedura pro inicialisaci poslani commandu do modemu }
{ S       - pozadovany commnad (string)
  Mode_   - pripustne hodnoty Mode_xx
  Del1    - prodleva pred vyslanim commandu [ms]
  Del2    - prodleva po vyslani commandu    [ms]
  TimOut  - pripustny timeout [ms] )

A. Mode= cmd_SendCmd   - pouze vyslani prikazu S s doplnenim CR
  SMCS_beg
  SMCS_delay1   cekani po dobu Delay1
  SMCS_send     vyprazdneni prijimaciho kanalu, vyslani stringu "s"+cr
  SMCS_delay2   cekani po dobu Delay2
  SMCS_end

B. Mode= cmd_CmdAnsw   - vyslani prikazu S s doplnenim CR
                         a cekani na odpoved s odstranenim CR
  SMCS_beg
  SMCS_delay1   cekani po dobu Delay1
  SMCS_send     vyprazdneni prijimaciho kanalu, vyslani stringu "s"+cr
  SMCS_delay2   cekani po dobu Delay2
  SMCS_rec      prijem odpovedi:
                - ignorovani cr pred zpravou,
                - ignorovani lf vzdy,
                - konec zpravy detekovan pomoci cr resp. uplynutim timeoutu.
                  (cr do answ-stringu nezapisovan!)
                - je-li length(answ)>40 znaku then Result_LongAnsw
                uplyne-li cas TimOut, pak
                - je-li answ='' , pak Result_RTimeout
                - je-li answ<>'' pak prechod na SMCS_recend
  SMCS_recend   - je-li answ=vysilany string, pak jeho ignorovani (jedna se zrejme o echo),
                  prechod zpet na SMCS_rec
                - je-li pocatek answ=IM_OKS (OK-string), pak Result_OK
                - je-li pocatek answ=IM_COS (CONNECT-string), pak Result_Connect
                - je-li pocatek answ=IM_BUS (BUSY-string), pak Result_Busy
                jinak Result_Answ
  SMCS_end

C. Mode= cmd_RecAnsw   - pouze cekani na odpoved bez vyslani prikazu
  SMCS_beg
  SMCS_delay1   cekani po dobu Delay1
  SMCS_send     zadna cinnost
  SMCS_delay2   cekani po dobu Delay2
  SMCS_rec      prijem odpovedi:
                - ignorovani cr pred zpravou,
                - ignorovani lf vzdy,
                - konec zpravy detekovan pomoci cr resp. uplynutim timeoutu.
                  (cr do answ-stringu nezapisovan!)
                - je-li length(answ)>40 znaku then Result_LongAnsw
                uplyne-li cas TimOut, pak
                - je-li answ='' , pak Result_RTimeout
                - je-li answ<>'' pak prechod na SMCS_recend
  SMCS_recend   - je-li answ=vysilany string, pak jeho ignorovani (jedna se zrejme o echo),
                  prechod zpet na SMCS_rec
                - je-li pocatek answ=IM_OKS (OK-string), pak Result_OK
                - je-li pocatek answ=IM_COS (CONNECT-string), pak Result_Connect
                - je-li pocatek answ=IM_BUS (BUSY-string), pak Result_Busy
                jinak Result_Answ
  SMCS_end

D. Mode= cmd_SendData   - vyslani stringu S bez doplneni CR
  SMCS_beg
  SMCS_delay1   cekani po dobu Delay1
  SMCS_send     vyprazdneni prijimaciho kanalu, vyslani stringu "s"
  SMCS_delay2   cekani po dobu Delay2
  SMCS_rec      cekani po dobu TimOut
  SMCS_end

Ve stavu SMCS_end je vracen nektery ze stavu SMC_Result}

begin
  with CH_ATCmdBuff^ do
  begin
    CmdStr :=S;
    Mode   :=Mode_;
    Delay1 :=Del1;
    Delay2 :=Del2;
    TimeOut:=TimOut;
    RecStr :='';
  end;
  SMC_Ctrl  :=SMCS_Beg;
  SMC_Result:=ResGSM_Ok;
  SMC_ChnTime.SaveTime;
  ChAtCmdTick;
end;

{------------------------------}
function  tChnSMS.ChAtCmdReady : TSMC_Ctrl;
begin
  if CH_Chn<>nil then
    begin
      ChAtCmdTick;
        { nastavuje SMC_Result }
      ChAtCmdReady:=SMC_Ctrl;
    end
  else
    begin
      SMC_Result:=ResGSM_ChannelNil;
      ChAtCmdReady:=SMCS_Ready;
    end;
end;

{------------------------------}
procedure tChnSMS.ChAtCmdTick;
label
  L_FlowControl, L_Send, L_SendDelay, L_Delay2, L_Rec, L_RecEnd, L_End, PomL_Za;
var
  ch:char;
begin
  if CH_Chn<>nil then
  with CH_ATCmdBuff^ do
  case SMC_Ctrl of
    SMCS_Beg,
    SMCS_Delay1:   { prodleva delay1 pred vyslanim commandu }
      begin
        if (Delay1=0)or(SMC_ChnTime.TstTime(Delay1)) then
          begin
            SMC_ChnTime.SaveTime;
            SMC_Ctrl:=SMCS_FlowControl;
            goto L_FlowControl;
          end;
      end;
    SMCS_FlowControl:
       L_FlowControl:
      begin
        case CH_FlowCntrl of
          0:begin
              SMC_Ctrl:=SMCS_Send;
              goto L_Send;
            end;
          1:if (CH_Chn.ChGetBinParam(CH_Chn.CH_NumName,cmd_GetCTS)<>0) and
               (CH_Chn.ChResult=res_Ok) then
            begin { je-li signal CTS }
              SMC_Ctrl:=SMCS_Send;
              goto L_Send;
            end
            else  { neni-li signal CTS }
            if SMC_ChnTime.TstTime(TimeOut) then
            begin { byl prekrocen Timeout }
              SMC_Ctrl:=SMCS_Ready;
              SMC_Result:=ResGSM_STimeOut;
            end;
          2:if (CH_Chn.ChGetBinParam(CH_Chn.CH_NumName,cmd_GetDSR)<>0) and
               (CH_Chn.ChResult=res_Ok) then
            begin { je-li signal DSR }
              SMC_Ctrl:=SMCS_Send;
              goto L_Send;
            end
            else  { neni-li signal DSR }
            if SMC_ChnTime.TstTime(TimeOut) then
            begin { byl prekrocen Timeout }
              SMC_Ctrl:=SMCS_Ready;
              SMC_Result:=ResGSM_STimeOut;
            end;
          else
            begin
              SMC_Ctrl:=SMCS_Send;
              goto L_Send;
            end;
        end;
      end;
    SMCS_Send:
       L_Send:
      begin
        CH_Chn.ChSendFlush;
        if CH_Chn.ChSendResult<>res_Ok then
          begin
            SMC_Ctrl:=SMCS_Ready;
            SMC_Result:=ResGSM_SHwErr;
            goto L_End;
          end;
        if Mode in [cmd_SendCmd, cmd_CmdAnsw, cmd_SendData] then
          begin
            {$ifdef Deb_SendRec}
              writeln('out(',CH_Ctrl:2,')>',CmdStr,'<');
            {$endif}
            { vyprazdneni prijimaciho kanalu }
            if Mode in [cmd_SendCmd, cmd_CmdAnsw, cmd_SendData] then
               begin
                 CH_Chn.ChReceiveFlush;
                 if CH_Chn.ChReceiveResult<>res_Ok then
                 begin
                   SMC_Ctrl:=SMCS_Ready;
                   SMC_Result:=ResGSM_SHwErr;
                   goto L_End;
                 end;
                 if Mode<>cmd_SendData then CmdStr:=CmdStr+CH_Char_CR;
               end;
            { vyslani dat }
            CH_Chn.ChSend(@CmdStr[1],Length(CmdStr));
            if CH_Chn.ChSendResult=res_Ok then
               begin
                 SMC_Ctrl:=SMCS_SendDelay;
                 SMC_ChnTime.SaveTime;
               end
            else
               begin
                 SMC_Ctrl:=SMCS_Ready;
                 SMC_Result:=ResGSM_SHwErr;
               end;
          end
        else           { SMC_mode vyzaduje pouze odpoved }
          begin
            SMC_ChnTime.SaveTime;
            if CH_Chn.ChSendReady=CHS_SendReady then
               begin
                 SMC_Ctrl:=SMCS_Delay2;
                 goto L_Delay2;
               end;
            if SMC_ChnTime.TstTime(CH_TimeOut[SendAtCmd]) then
               begin
                 SMC_Ctrl:=SMCS_Ready;
                 SMC_Result:=ResGSM_STimeOut;
                 {$ifdef Deb_SendRec}
                   writeln('TimeOut while Send');
                 {$endif}
               end;
          end;
      end;
    SMCS_SendDelay:
       L_SendDelay:
      begin
        if CH_Chn.ChSendReady=CHS_SendReady then
           begin
             SMC_ChnTime.SaveTime;
             SMC_Ctrl:=SMCS_Delay2;
             goto L_Delay2;
           end;
        if SMC_ChnTime.TstTime(CH_TimeOut[SendAtCmd]) then
           begin
             SMC_Ctrl:=SMCS_Ready;
             SMC_Result:=ResGSM_STimeOut;
             {$ifdef Deb_SendRec}
               writeln('TimeOut while Send');
             {$endif}
           end;
      end;
    SMCS_Delay2:
      L_Delay2:
      begin
        if (Delay2=0) or (SMC_ChnTime.TstTime(Delay2)) then
           begin
             SMC_ChnTime.SaveTime;
             SMC_Ctrl:=SMCS_Rec;
             goto L_Rec;
           end;
      end;
    SMCS_Rec:
      L_Rec:
      begin
        if Mode in [cmd_SendCmd, cmd_SendData] then  { nema se prijimat }
           begin
             SMC_Result:=ResGSM_Ok;
             SMC_Ctrl:=SMCS_Ready;
             goto L_End;
           end
        else  { cekani na prijem }
           begin
             while CH_Chn.ChReceiveReady=CHS_ReceiveReady do   { postupne cteni dat z modemu }
               begin
                 Ch:=UpCase(chr(CH_Chn.ChReceiveChar));
                 if ChReceiveResult<>res_Ok then
                   begin
                     SMC_Result:=ResGSM_RHwErr;
                     SMC_Ctrl:=SMCS_Ready;
                     goto L_End;
                   end
                 else
                   begin
                     if Ch=CH_Char_CR then
                       begin
                         {$ifdef Deb_LoRec}
                           write('[CR]');
                         {$endif}
                         if RecStr<>'' then              { ignorovani cr pred zpravou }
                            begin
                              SMC_ChnTime.SaveTime;
                              SMC_Ctrl:=SMCS_RecEnd;
                              goto L_RecEnd;
                            end;
                       end
                     else
                     if Ch=CH_Char_LF then
                       begin
                         {$ifdef Deb_LoRec}
                           write('[LF]');
                         {$endif}
                         if RecStr<>'' then
                            begin
                              SMC_Result:=ResGSM_LongAnswer;
                              SMC_Ctrl:=SMCS_Ready;
                              goto L_End;
                            end;
                       end
                     else
                       begin
                         {$ifdef Deb_LoRec}
                           write(Ch);
                         {$endif}
                         if Length(RecStr)<(SizeOf(RecStr)-1) then
                            RecStr:=RecStr+ch;            { skladani odpovedi }
                       end;
                   end;
               end;
             if SMC_ChnTime.TstTime(TimeOut) then { test na timeout }
                begin
                  if RecStr='' then
                     begin
                       SMC_Result:=ResGSM_RTimeOut;
                       {$ifdef Deb_SendRec}
                        {$ifdef Deb_LoRec}
                         writeln;
                        {$endif}
                         writeln('Result: ',byte(SMC_Result));
                       {$endif}
                       SMC_Ctrl:=SMCS_Ready;
                       goto L_End;
                     end
                  else
                     begin
                       SMC_ChnTime.SaveTime;
                       SMC_Ctrl:=SMCS_RecEnd;
                       goto L_RecEnd;
                     end;
                end;
           end;
      end;
    SMCS_RecEnd:
      L_RecEnd:
      begin
        if (Mode=cmd_CmdAnsw) and (RecStr+CH_Char_CR=CmdStr) then
                 { prijem=vysilani -> zapnute echo -> jeho ignorovani }
           begin
             RecStr:='';
             SMC_ChnTime.SaveTime;
             SMC_Ctrl:=SMCS_Rec;
             goto L_Rec;
           end
        else
           begin
             if Copy(RecStr,1,Length(CH_Str[AnswOK]))=CH_Str[AnswOK] then
                begin
                  SMC_Result:=ResGSM_Ok;
                  goto PomL_Za;
                end
             else
             if Copy(RecStr,1,length(CH_Str[AnswERROR]))=CH_Str[AnswERROR] then
                begin
                  SMC_Result:=ResGSM_ERROR;
                  goto PomL_Za;
                end
             else
                begin
                  SMC_Result:=ResGSM_Answer;    { nejaka jina odpoved }
                end;
           PomL_Za:
             {$ifdef Deb_SendRec}
              {$ifdef Deb_LoRec}
               writeln;
              {$endif}
               writeln('in (',CH_Ctrl:2,')>',RecStr,'<','  Result: ',byte(SMC_Result));
             {$endif}
             SMC_Ctrl:=SMCS_Ready;
             goto L_End;
           end;
      end;
    SMCS_Ready:
      L_End:
      begin
      end;
  end { case }
  else
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
end;

{------------------------------}
function  tChnSMS.ChAtCmdResult : integer;
begin
  ChAtCmdResult:=SMC_Result;
  SMC_Result:=ResGSM_Ok;
end;

{------------------------------}
function tChnSMS.ChState;
begin
  ChTick;
  ChState:=CH_State;
end;

{------------------------------}
function tChnSMS.ChReady;
begin
  ChTick;
  ChReady:=CH_Ctrl;
end;

{------------------------------}
procedure tChnSMS.DecodeMemSto(S:tStrAtCmd);
type
  tParam = (tpBeg, tpName, tpUsed, tpTotal);
var
  PomS  : tWordString;
  ErrFl : boolean;
  PomL  : longint;
  CmdL  : tCmd;
  I     : byte;
  Param : tParam;
  Ak    : byte;
label
  L_1,
  L_Err;
begin
  CmdL:=tCmd.Create;
  CmdL.InitCmd(S);
  CmdL.Delimiters:=CmdL.Delimiters+[','];
  PomS:=CmdL.ReadWordUpCase;
  ErrFl:=PomS='';
  Param:=tpBeg;
  while not ErrFl do
  begin
    case Param of
      tpBeg:
        begin
          if PomS='+CPMS:' then
            Param:=tpName
          else goto L_Err;
        end;
      tpName:
        begin
          PomS:=CmdL.ReadElement;
          if PomS='' then goto L_Err;
          Ak:=0;
          for I:=1 to MaxMem do { nalezeni stejneho jmena v pameti }
            if CH_Mem[I].Name=PomS then Ak:=I;
          if Ak=0 then { jmeno nebylo nalezeno, jedna se o nove jmeno }
          begin
            for I:=1 to MaxMem do { nalezeni prazdne bunky }
              if CH_Mem[I].Name='' then goto L_1;
            goto L_Err;
           L_1:
            Ak:=I;
            CH_Mem[Ak].Name:=PomS;
          end;
          Param:=tpUsed;
        end;
      tpUsed:
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Mem[Ak].Used:=PomL;
          Param:=tpTotal;
        end;
      tpTotal:
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            CH_Mem[Ak].Total:=PomL;
          Param:=tpName;
        end;
    end;
  end;
 L_Err:
  CmdL.Free;
end;

{------------------------------}
function  tChnSMS.DecodeReaded(S:tStrAtCmd):word;
var
  PomS  : tWordString;
  ErrFl : boolean;
  PomL  : longint;
  CmdL  : tCmd;
begin
  CmdL:=tCmd.Create;
  CmdL.InitCmd(S);
  CmdL.Delimiters:=CmdL.Delimiters+[','];
  PomS:=CmdL.ReadWordUpCase;
  ErrFl:=PomS='';
 {}
  if CH_TextMode then
    begin
      if PomS='"REC_UNREAD"' then
        begin
          if CH_RMess<>nil then
            pRecRecord(CH_RMess)^.MsgStat:=tsRecUnRead;
        end;
      if (CH_FlRecRead)and(PomS='"REC_READ"') then
        begin
          if CH_RMess<>nil then
            pRecRecord(CH_RMess)^.MsgStat:=tsRecRead;
        end;
    end
  else
    begin
      if PomS='0' then
        begin
          if CH_RMess<>nil then
            pRecRecord(CH_RMess)^.MsgStat:=tsRecUnRead;
        end;
      if (CH_FlRecRead)and(PomS='1') then
        begin
          if CH_RMess<>nil then
            pRecRecord(CH_RMess)^.MsgStat:=tsRecRead;
        end;
    end;
 {}
  CmdL.ReadLVal(PomL,ErrFl);
 {}
  if ErrFl then
       DecodeReaded:=0
  else DecodeReaded:=PomL;
  CmdL.Free;
end;

{------------------------------}
function tChnSMS.CodePreSendMsg:string;
var
  S : string;
  {----------}
  procedure SendBStrHex(B: byte);
    { zakodovani bytu jako string s hex representaci B do vysilaciho bufferu }
  begin
    S:=S+IntToHex(B,2);
  end;
  {----------}
  procedure SendPhoneNum(PhoneNum: tPhoneNumStr);
    { zakodovani telefonniho cisla do vysilaciho bufferu }
  var I :byte;
      Ch:char;
  begin
    for I:=1 to Length(PhoneNum) do
      begin
        if (I mod 2)=0 then
        begin
          Ch:=PhoneNum[I-1];
          PhoneNum[I-1]:=PhoneNum[I];
          PhoneNum[I]:=Ch;
        end;
      end;
    if (Length(PhoneNum) mod 2)<>0 then
      begin
        Ch:=PhoneNum[Length(PhoneNum)];
        PhoneNum[Length(PhoneNum)]:='F';
        PhoneNum:=PhoneNum+Ch;
      end;
    S:=S+PhoneNum;
  end;
  {----------}
begin
  S:='';
  SendBStrHex(cPNT_Internat);
  SendPhoneNum(CH_SMSCNum);
  S:=IntToHex(Length(S) div 2,2)+S;
  CodePreSendMsg:=S;
end;

{------------------------------}
procedure tChnSMS.ChTick;
label
  L_Stabil          , L_Opening1         , L_Opening2         ,
  L_Closing1        , L_Closing2         ,
  L_Connect_1       , L_Connect_Ini1     , L_Connect_Ini2     , L_Connect_Ini3 ,
  L_Connect_AskPin  , L_Connect_AskingPin, L_Connect_SetPin   ,
  L_Connect_SetSCNum, L_Connect_SetMode  , L_Connect_GetMemSto,
  L_Connect_GetManuf, L_Connect_GetModel ,
  L_DisCon_1;
begin
  if not LongBool(InterlockedExchange( integer(CH_Tick), Ord(true) )) then
  begin
    { vnitrni automat }
    case CH_Ctrl of
      CHS_Close,
      CHS_Open, {CHS_DisConnect,}
      CHS_Connect: { stabilni stavy - nedeje se nic }
        L_Stabil:
        begin
        end;
      CHS_Opening1:
        L_Opening1:
        begin
          ChSetResult(CH_Chn.ChResult);
          if CH_Chn.ChReady=CHS_Open then
            begin
              {$ifdef Deb_Ctrl}
                writeln('Opening ');
              {$endif}
              CH_Chn.ChConnect;
              CH_Ctrl:=CHS_Opening2;
              goto L_Opening2;
            end;
          if CH_Result<>res_Ok then
            begin
              CH_Chn.ChClose;
              CH_Ctrl:=CHS_Closing1;
              goto L_Closing1;
            end;
        end;
      CHS_Opening2:
        L_Opening2:
        begin
          ChSetResult(CH_Chn.ChResult);
          if CH_Chn.ChReady=CHS_Connect then
            begin
              {$ifdef Deb_Ctrl}
                writeln('Opened ');
              {$endif}
              CH_Ctrl :=CHS_Open;
              CH_State:=CH_Ctrl;
              CH_SCtrl:=CHS_SendReady;
              goto L_Stabil;
            end;
          if CH_Result<>res_Ok then
            begin
              CH_Chn.ChDisConnect;
              CH_Ctrl:=CHS_Closing2;
              goto L_Closing2;
            end;
        end;
      CHS_Closing1:
        L_Closing1:
        begin
          ChSetResult(CH_Chn.ChResult);
          if CH_Chn.ChReady=CHS_Close then
            begin
              {$ifdef Deb_Ctrl}
                writeln('Closed ');
              {$endif}
              CH_Ctrl :=CHS_Close;
              CH_State:=CH_Ctrl;
              CH_SCtrl:=CHS_SendReady;
              goto L_Stabil;
            end;
        end;
      CHS_Closing2:
        L_Closing2:
        begin
          ChSetResult(CH_Chn.ChResult);
          if CH_Chn.ChReady=CHS_DisConnect then
            begin
              {$ifdef Deb_Ctrl}
                writeln('Closing ');
              {$endif}
              CH_Chn.ChClose;
              CH_Ctrl:=CHS_Closing1;
              goto L_Closing1;
            end
          else
          if CH_Chn.ChReady=CHS_Close then
            begin
              {$ifdef Deb_Ctrl}
                writeln('Closed ');
              {$endif}
              CH_Ctrl :=CHS_Close;
              CH_State:=CH_Ctrl;
              CH_SCtrl:=CHS_SendReady;
              goto L_Stabil;
            end
        end;
      CHS_Connect_1:
        L_Connect_1:
        begin
          {$ifdef Deb_Ctrl}
            writeln('Connecting1 ');
          {$endif}
          if CH_Str[Init1S]<>'' then { pocatek vyslani 1.Init retezce }
             ChATCmd(CH_Str[Init1S],cmd_SendCmd,1500,CH_Delay[AfterI1S],0)
          else SMC_Ctrl:=SMCS_Ready;
          CH_Ctrl:=CHS_Connect_Ini1;
          goto L_Connect_Ini1;
        end;
      CHS_Connect_Ini1:  { pokracovani SW init }
        L_Connect_Ini1:
        if ChAtCmdReady=SMCS_Ready then { ceka se do konce provedeni 1.Init retezce }
        begin
          case ChATCmdResult of
            ResGSM_RTimeOut,
            ResGSM_STimeOut,
            ResGSM_SHwErr,
            ResGSM_RHwErr,
            ResGSM_ChannelNil:
              begin { predchozi prikaz se neprovedl spravne }
                ChSetResult(CH_NumName or res_ErrConnect);
                CH_Ctrl:=CHS_Connect_1;
              end;
            ResGSM_Ok:
              begin
                {$ifdef Deb_Ctrl}
                  writeln('Connecting2 ');
                {$endif}
                if CH_Str[Init2S]<>'' then { pocatek vyslani 2.Init retezce }
                   ChATCmd(CH_Str[Init2S],cmd_CmdAnsw,0,CH_Delay[AfterI2S],CH_TimeOut[CmdAnsw])
                else SMC_Ctrl:=SMCS_Ready;
                CH_Ctrl:=CHS_Connect_Ini2;
                goto L_Connect_Ini2;
              end;
            else
              begin
                CH_Ctrl:=CHS_Connect_1;
              end;
          end;
        end;
      CHS_Connect_Ini2:
        L_Connect_Ini2:
        if ChAtCmdReady=SMCS_Ready then { ceka se do konce provedeni 2.Init retezce }
        begin
          case ChATCmdResult of
            ResGSM_RTimeOut,
            ResGSM_STimeOut,
            ResGSM_SHwErr,
            ResGSM_RHwErr,
            ResGSM_ChannelNil:
              begin { predchozi Init retezec se neprovedl spravne }
                ChSetResult(CH_NumName or res_ErrConnect);
                CH_Ctrl:=CHS_Connect_1;
              end;
            ResGSM_Ok:
              begin
                {$ifdef Deb_Ctrl}
                  writeln('Connecting3 ');
                {$endif}
                if CH_Str[Init3S]<>'' then { vyslani 3.Init retezce }
                   ChATCmd(CH_Str[Init3S],cmd_CmdAnsw,0,CH_Delay[AfterI3S],CH_TimeOut[CmdAnsw])
                else SMC_Ctrl:=SMCS_Ready;
                CH_Ctrl:=CHS_Connect_Ini3;
                goto L_Connect_Ini3;
              end;
            else
              begin
                CH_Ctrl:=CHS_Connect_Ini1;
              end;
          end;
        end;
      CHS_Connect_Ini3:
        L_Connect_Ini3:
        if ChAtCmdReady=SMCS_Ready then { ceka se do konce provedeni 3.Init retezce }
        begin
          case ChATCmdResult of
            ResGSM_RTimeOut,
            ResGSM_STimeOut,
            ResGSM_SHwErr,
            ResGSM_RHwErr,
            ResGSM_ChannelNil:
              begin { predchozi Init retezec se neprovedl spravne }
                ChSetResult(CH_NumName or res_ErrConnect);
                CH_Ctrl:=CHS_Connect_1;
              end;
            ResGSM_Ok:
              begin
                {$ifdef Deb_Ctrl}
                  writeln('Reading Manufacturer & Model ID ');
                {$endif}
                ChATCmd('AT'+cAtCmdGSM_GetManufID,cmd_CmdAnsw,0,0,CH_TimeOut[CmdAnsw]);
                CH_Ctrl:=CHS_Connect_GetManuf;
                goto L_Connect_GetManuf;
              end;
            else
              begin
                CH_Ctrl:=CHS_Connect_Ini2;
              end;
          end;
        end;
      CHS_Connect_GetManuf:
        L_Connect_GetManuf:
        if ChAtCmdReady=SMCS_Ready then { ceka se do konce cteni vyrobce }
        begin
          case ChATCmdResult of
            ResGSM_RTimeOut,
            ResGSM_STimeOut,
            ResGSM_SHwErr,
            ResGSM_RHwErr:
              begin
                {$ifdef Deb_Ctrl}
                  writeln('Reading Manufacturer & Model ID ');
                {$endif}
                ChATCmd('AT'+cAtCmdGSM_GetManufID,cmd_CmdAnsw,0,0,CH_TimeOut[CmdAnsw]);
              end;
            ResGSM_Error:
              begin
                CH_Ctrl:=CHS_Connect_AskPin;
                goto L_Connect_AskPin;
              end;
            ResGSM_Answer:
              with CH_ATCmdBuff^ do
              begin
                if Pos(cAtCmdGSM_GetManufID,RecStr)<>0 then Delete(RecStr,1,Length(cAtCmdGSM_GetManufID)+2);
                while (Length(RecStr)>0)and(RecStr[1]=' ') do Delete(RecStr,1,1);
                CH_StationID:=RecStr;
                ChATCmd('',cmd_RecAnsw,0,0,CH_TimeOut[CmdAnsw]);
                goto L_Connect_GetManuf;
              end;
            ResGSM_Ok:
              begin
                ChATCmd('AT'+cAtCmdGSM_GetModelID,cmd_CmdAnsw,0,0,CH_TimeOut[CmdAnsw]);
                CH_Ctrl:=CHS_Connect_GetModel;
                goto L_Connect_GetModel;
              end;
            else
              begin
                ChSetResult(CH_NumName or res_ErrConnect);
                CH_Ctrl:=CHS_Connect_1;
              end;
          end;
        end;
      CHS_Connect_GetModel:
        L_Connect_GetModel:
        if ChAtCmdReady=SMCS_Ready then { ceka se do konce cteni modelu }
        begin
          case ChATCmdResult of
            ResGSM_RTimeOut,
            ResGSM_STimeOut,
            ResGSM_SHwErr,
            ResGSM_RHwErr:
              begin
                {$ifdef Deb_Ctrl}
                  writeln('Reading Manufacturer & Model ID ');
                {$endif}
                ChATCmd('AT'+cAtCmdGSM_GetModelID,cmd_CmdAnsw,0,0,CH_TimeOut[CmdAnsw]);
              end;
            ResGSM_Error:
              begin
                CH_Ctrl:=CHS_Connect_AskPin;
                goto L_Connect_AskPin;
              end;
            ResGSM_Answer:
              with CH_ATCmdBuff^ do
              begin
                if Pos(cAtCmdGSM_GetModelID,RecStr)<>0 then Delete(RecStr,1,Length(cAtCmdGSM_GetModelID)+2);
                while (Length(RecStr)>0)and(RecStr[1]=' ') do Delete(RecStr,1,1);
                CH_StationID:=CH_StationID+' '+RecStr;
                ChATCmd('',cmd_RecAnsw,0,0,CH_TimeOut[CmdAnsw]);
                goto L_Connect_GetModel;
              end;
            ResGSM_Ok:
              begin
                {$ifdef Deb_Ctrl}
                  writeln('Setting SMSC Number ');
                {$endif}
                ChATCmd('AT'+cAtCmdSMS_SetSCNum+'="'+CH_SMSCNum+'", 145',cmd_CmdAnsw,0,0,CH_TimeOut[CmdAnsw]);
                CH_Ctrl:=CHS_Connect_AskPin;
                goto L_Connect_AskPin;
              end;
            else
              begin
                ChSetResult(CH_NumName or res_ErrConnect);
                CH_Ctrl:=CHS_Connect_1;
              end;
          end;
        end;
      CHS_Connect_AskPin:
        L_Connect_AskPin:
        begin
          {$ifdef Deb_Ctrl}
            writeln('Ask PIN ');
          {$endif}
          ChATCmd('AT'+cAtCmdGSM_SetPin+'?',cmd_CmdAnsw,0,0,CH_TimeOut[CmdAnsw]);
          CH_Ctrl:=CHS_Connect_AskingPin;
          goto L_Connect_AskingPin;
        end;
      CHS_Connect_AskingPin:
        L_Connect_AskingPin:
        if ChAtCmdReady=SMCS_Ready then { ceka se do konce provedeni dotazu na pin }
        begin
          case ChATCmdResult of
            ResGSM_RTimeOut,
            ResGSM_STimeOut,
            ResGSM_SHwErr,
            ResGSM_RHwErr,
            ResGSM_ChannelNil:
              begin { predchozi Init retezec se neprovedl spravne }
                ChSetResult(CH_NumName or res_ErrConnect);
                CH_Ctrl:=CHS_Connect_1;
              end;
            ResGSM_Error:
              begin
                CH_Ctrl:=CHS_Connect_AskPin;
                goto L_Connect_AskPin;
              end;
            ResGSM_Answer,
            ResGSM_LongAnswer:
              with CH_ATCmdBuff^ do
              begin
                if Pos(cAtAnsGSM_AnswSimPin,RecStr)<>0 then
                  begin
                    {$ifdef Deb_Ctrl}
                      writeln('Setting SIM PIN ');
                    {$endif}
                    ChATCmd('AT'+cAtCmdGSM_SetPin+'="'+CH_SimPin+'"',cmd_CmdAnsw,CH_Delay[BeforPIN],0,CH_TimeOut[AnswPIN]);
                    CH_Ctrl:=CHS_Connect_SetPin;
                    goto L_Connect_SetPin;
                  end
                else
                if Pos(cAtAnsGSM_AnswSimPuk,RecStr)<>0 then
                  begin
                    {$ifdef Deb_Ctrl}
                      writeln('Setting SIM PUK ');
                    {$endif}
                    ChATCmd('AT'+cAtCmdGSM_SetPin+'="'+CH_SimPuk+'","'+CH_SimPin+'"',
                            cmd_CmdAnsw,CH_Delay[BeforPIN],0,CH_TimeOut[AnswPIN]);
                    CH_Ctrl:=CHS_Connect_SetPin;
                    goto L_Connect_SetPin;
                  end
                else
                if Pos(cAtAnsGSM_AnswReady,RecStr )<>0 then
                  begin
                    {$ifdef Deb_Ctrl}
                      writeln('Setting SMSC Number ');
                    {$endif}
                    ChATCmd('AT'+cAtCmdSMS_SetSCNum+'="'+CH_SMSCNum+'", 145',cmd_CmdAnsw,0,0,CH_TimeOut[CmdAnsw]);
                    CH_Ctrl:=CHS_Connect_SetSCNum;
                    goto L_Connect_SetSCNum;
                  end
                else
                  begin
                    CH_Ctrl:=CHS_Connect_AskPin;
                    goto L_Connect_AskPin;
                  end;
              end;
            else
              begin
                CH_Ctrl:=CHS_Connect_Ini3;
              end;
          end;
        end;
      CHS_Connect_SetPin:
        L_Connect_SetPin:
        if ChAtCmdReady=SMCS_Ready then { ceka se do konce provedeni dotazu na pin }
        begin
          case ChATCmdResult of
            ResGSM_Ok:
              begin
                SMC_ChnTime.SaveTime;
                CH_Ctrl:=CHS_Connect_Delay;
              end;
            ResGSM_Error:
              begin
                ChSetResult(CH_NumName or res_Err_WrongPIN);
              end;
            else
              begin
                ChSetResult(CH_NumName or res_ErrConnect);
                CH_Ctrl:=CHS_Connect_1;
              end;
          end;
        end;
      CHS_Connect_Delay:
        if SMC_ChnTime.TstTime(CH_Delay[AfterPIN]) then
        begin
          CH_Ctrl:=CHS_Connect_AskPin;
          goto L_Connect_AskPin;
        end;
      CHS_Connect_SetSCNum:
        L_Connect_SetSCNum:
        if ChAtCmdReady=SMCS_Ready then { ceka se do konce provedeni nastaveni cisla spravce SMS }
        begin
          case ChATCmdResult of
            ResGSM_RTimeOut,
            ResGSM_STimeOut,
            ResGSM_SHwErr,
            ResGSM_RHwErr,
            ResGSM_Error:
              begin
                {$ifdef Deb_Ctrl}
                  writeln('Setting SMSC Number ');
                {$endif}
                ChATCmd('AT'+cAtCmdSMS_SetSCNum+'="'+CH_SMSCNum+'", 145',cmd_CmdAnsw,0,0,CH_TimeOut[CmdAnsw]);
              end;
            ResGSM_Ok:
              begin
                {$ifdef Deb_Ctrl}
                  writeln('Setting TXT/PDU Mode ');
                {$endif}
                if CH_TextMode then
                     ChATCmd('AT'+cAtCmdSMS_SetMode+'=1',cmd_CmdAnsw,0,0,CH_TimeOut[CmdAnsw])
                else ChATCmd('AT'+cAtCmdSMS_SetMode+'=0',cmd_CmdAnsw,0,0,CH_TimeOut[CmdAnsw]);
                CH_Ctrl:=CHS_Connect_SetMode;
                goto L_Connect_SetMode;
              end;
            else
              begin
                ChSetResult(CH_NumName or res_ErrConnect);
                CH_Ctrl:=CHS_Connect_1;
              end;
          end;
        end;
      CHS_Connect_SetMode:
        L_Connect_SetMode:
        if ChAtCmdReady=SMCS_Ready then { ceka se do prijeti odpovedi na nastaveni modu }
        begin
          case ChATCmdResult of
            ResGSM_RTimeOut,
            ResGSM_STimeOut,
            ResGSM_SHwErr,
            ResGSM_RHwErr,
            ResGSM_Answer:
              begin
                {$ifdef Deb_Ctrl}
                  writeln('Setting TXT/PDU Mode ');
                {$endif}
                if CH_TextMode then
                     ChATCmd('AT'+cAtCmdSMS_SetMode+'=1',cmd_CmdAnsw,0,0,CH_TimeOut[CmdAnsw])
                else ChATCmd('AT'+cAtCmdSMS_SetMode+'=0',cmd_CmdAnsw,0,0,CH_TimeOut[CmdAnsw]);
              end;
            ResGSM_Error:
              begin
                {$ifdef Deb_Ctrl}
                  writeln('Setting TXT/PDU Mode ');
                {$endif}
                CH_TextMode:=not CH_TextMode;
                if CH_TextMode then
                     ChATCmd('AT'+cAtCmdSMS_SetMode+'=1',cmd_CmdAnsw,0,0,CH_TimeOut[CmdAnsw])
                else ChATCmd('AT'+cAtCmdSMS_SetMode+'=0',cmd_CmdAnsw,0,0,CH_TimeOut[CmdAnsw]);
              end;
            ResGSM_Ok:
              begin
                {$ifdef Deb_Ctrl}
                  writeln('Connect End ');
                {$endif}
                CH_Ctrl :=CHS_Connect;
                CH_State:=CH_Ctrl;
                CH_RCtrl:=CHS_ReceiveBegin;
              end;
            else
              begin
                ChSetResult(CH_NumName or res_ErrConnect);
                CH_Ctrl:=CHS_Connect_1;
              end;
          end;
        end;
      CHS_DisCon_1:
        L_DisCon_1:
        begin
          CH_Ctrl :=CHS_DisConnect;
          CH_State:=CH_Ctrl;
        end;
    end; {case}
    CH_Tick:=false;
  end;
end; {ChTick}

{------------------------------}
procedure tChnSMS.ChSendTick;
label
  L_SendBegin, L_SendCmd, L_SendData, L_SendDataReply;
begin
  if not LongBool(InterlockedExchange( integer(CH_STick), Ord(true) )) then
  begin
    case CH_SCtrl of
      CHS_SendReady,   { stabilni stavy - nedeje se nic }
      CHS_SendNoReady:
        begin
        end;
      CHS_SendBegin:
        L_SendBegin:
        if CH_Chn<>nil then
        begin
          {$ifdef Deb_Ctrl}
           writeln('Send SMS Message (Cmd) ');
          {$endif}
          ChATCmd('AT'+cAtCmdSMS_SendMsg+'='+IntToStr(Length(CH_SendStr) div 2),cmd_CmdAnsw,100,0,CH_TimeOut[CmdAnsw]);
          CH_SCtrl:=CHS_SendCmd;
          goto L_SendCmd;
        end
        else
        begin
          CH_SCtrl:=CHS_SendReady;
          ChSetSendResult(CH_NumName or res_ErrChannelNoExist);
        end;
      CHS_SendCmd:
        L_SendCmd:
        if ChAtCmdReady=SMCS_Ready then { ceka se do prijeti odpovedi na vyslani prikazu pro vyslani SMS zpravy }
        begin
          case ChATCmdResult of
            ResGSM_Answer:
              with CH_ATCmdBuff^ do
              begin
                if Pos('>',RecStr)<>0 then
                begin
                  {$ifdef Deb_Ctrl}
                   writeln('Send SMS Message (Data) ');
                  {$endif}
                  if (Pos('SIEMENS',CH_StationID)<>0)and(Pos('M1',CH_StationID)<>0) then
                       ChAtCmd(               CH_SendStr,cmd_SendData,CH_Delay[BeforSMSData],0,CH_TimeOut[CmdAnsw])
                  else ChAtCmd(CodePreSendMsg+CH_SendStr,cmd_SendData,CH_Delay[BeforSMSData],0,CH_TimeOut[CmdAnsw]);
                  CH_SCtrl:=CHS_SendData;
                  goto L_SendData;
                end
                else
                begin
                  ChSetSendResult(CH_NumName or res_Err);
                  CH_SCtrl:=CHS_SendReady;
                end;
              end;
            else
              begin
                ChSetSendResult(CH_NumName or res_Err);
                CH_SCtrl:=CHS_SendReady;
              end;
          end;
        end;
      CHS_SendData:
        L_SendData:
        if ChAtCmdReady=SMCS_Ready then { ceka se do dokonceni vyslani SMS zpravy }
        begin
          case ChATCmdResult of
            ResGSM_Ok:
              begin
                ChATCmd('',cmd_RecAnsw,0,0,CH_TimeOut[SendSMS]);
                CH_SCtrl:=CHS_SendDataReply;
                goto L_SendDataReply;
              end;
            else
              begin
                ChSetSendResult(CH_NumName or res_Err);
                CH_SCtrl:=CHS_SendReady;
              end;
          end;
        end;
      CHS_SendDataReply:
        L_SendDataReply:
        if ChAtCmdReady=SMCS_Ready then { ceka se do dokonceni prijeti odpovedi na vyslani SMS zpravy }
        begin
          case ChATCmdResult of
            ResGSM_RTimeOut,
            ResGSM_STimeOut,
            ResGSM_SHwErr,
            ResGSM_RHwErr,
            ResGSM_Error:
              begin
                ChSetSendResult(CH_NumName or res_Err);
                CH_SCtrl:=CHS_SendReady;
              end;
            ResGSM_Ok,
            ResGSM_Answer:
              with CH_ATCmdBuff^ do
              begin
                if Pos('ERROR',RecStr)=0 then
                begin
                  {$ifdef Deb_Ctrl}
                   writeln('SMS Message was sent ');
                  {$endif}
                  ChSetSendResult(res_Ok);
                end
                else
                  ChSetSendResult(CH_NumName or res_Err);
                CH_SCtrl:=CHS_SendReady;
              end;
            else
              begin
                ChSetSendResult(CH_NumName or res_Err);
                CH_SCtrl:=CHS_SendReady;
              end;
          end;
        end;
    end; {case}
    CH_STick:=false;
  end;
end;

{------------------------------}
procedure tChnSMS.ChReceiveTick;
label
  L_ReceiveBegin  , L_ReceiveGetMemSto, L_ReceiveReadSMS, L_ReceiveReadingSMS,
  L_ReceiveSMSData, L_ReceiveDelRecSMS, L_ReceiveSetMemSto;
var
  I : byte;
begin
  if not LongBool(InterlockedExchange( integer(CH_RTick), Ord(true) )) then
  begin
    case CH_RCtrl of
      CHS_ReceiveReady,
      CHS_ReceiveNoReady: { stabilni stavy - nedeje se nic }
        begin
        end;
      CHS_ReceiveBegin:
        L_ReceiveBegin:
        begin
          CH_LRMess:= 0;
          for I:=1 to MaxMem do
            with CH_Mem[I] do
            if Used>UseOld then { nastala zmena }
              begin
                CH_MemBank :=I;
                CH_MemIndex:=1;
                ChAtCmd('AT'+cAtCmdSMS_GetMemSto+'="'+Name+'"',cmd_CmdAnsw,CH_Delay[BeforMemSto],0,CH_TimeOut[CmdAnsw]);
                CH_RCtrl:=CHS_ReceiveSetMemSto;
                goto L_ReceiveSetMemSto;
              end;
          ChATCmd('AT'+cAtCmdSMS_GetMemSto+'?',cmd_CmdAnsw,CH_Delay[BeforMemSto],0,CH_TimeOut[CmdAnsw]);
          CH_RCtrl:=CHS_ReceiveGetMemSto;
          goto L_ReceiveGetMemSto;
        end;
      CHS_ReceiveGetMemSto:
        L_ReceiveGetMemSto:
        if ChAtCmdReady=SMCS_Ready then { ceka se do prijeti odpovedi na vraceni poctu zaplnenych bank }
        begin
          case ChATCmdResult of
            ResGSM_RTimeOut,
            ResGSM_STimeOut,
            ResGSM_SHwErr,
            ResGSM_RHwErr,
            ResGSM_OK,
            ResGSM_Error:
              begin
                CH_RCtrl:=CHS_ReceiveBegin;
              end;
            ResGSM_Answer:
              with CH_ATCmdBuff^ do
              if Pos('ERROR',RecStr)=0 then
              begin
                DecodeMemSto(RecStr);
                ChATCmd('',cmd_RecAnsw,0,0,CH_TimeOut[CmdAnsw]);
                goto L_ReceiveGetMemSto;
              end
              else
              begin
                CH_RCtrl:=CHS_ReceiveBegin;
              end;
            else
              begin
                ChSetReceiveResult(CH_NumName or res_Err);
                CH_RCtrl:=CHS_ReceiveBegin;
              end;
          end;
        end;
      CHS_ReceiveSetMemSto:
        L_ReceiveSetMemSto:
        if ChAtCmdReady=SMCS_Ready then { ceka se do prijeti odpovedi na nastaveni zaplneni bank }
        begin
          case ChATCmdResult of
            ResGSM_RTimeOut,
            ResGSM_STimeOut,
            ResGSM_SHwErr,
            ResGSM_RHwErr,
            ResGSM_Ok,
            ResGSM_Error:
              begin
                CH_RCtrl:=CHS_ReceiveBegin;
              end;
            ResGSM_Answer:
              if Pos(cAtCmdSMS_GetMemSto,CH_ATCmdBuff^.RecStr)<>0 then
              begin
                CH_RCtrl:=CHS_ReceiveReadSMS;
                goto L_ReceiveReadSMS;
              end
              else
              begin
                CH_RCtrl:=CHS_ReceiveBegin;
              end;
            else
              begin
                ChSetReceiveResult(CH_NumName or res_Err);
                CH_RCtrl:=CHS_ReceiveBegin;
              end;
          end;
        end;
      CHS_ReceiveReadSMS:
        L_ReceiveReadSMS:
        begin
          {$ifdef Deb_Ctrl}
           writeln('Receive Read bank ',CH_MemBank,' bunka ',CH_MemIndex);
          {$endif}
          ChATCmd('AT'+cAtCmdSMS_ReadMsg+'='+IntToStr(CH_MemIndex),cmd_CmdAnsw,100,0,CH_TimeOut[CmdAnsw]);
          CH_RCtrl:=CHS_ReceiveReadingSMS;
          goto L_ReceiveReadingSMS;
        end;
      CHS_ReceiveReadingSMS:
        L_ReceiveReadingSMS:
        if ChAtCmdReady=SMCS_Ready then { ceka se do prijeti odpovedi na cteni zpravy }
        begin
          case ChATCmdResult of
            ResGSM_RTimeOut,
            ResGSM_STimeOut,
            ResGSM_SHwErr,
            ResGSM_RHwErr:
              begin
                CH_RCtrl:=CHS_ReceiveReadSMS;
              end;
            ResGSM_Error:
              begin
                if CH_MemIndex>CH_Mem[CH_MemBank].Total then
                  CH_Mem[CH_MemBank].UseOld:=CH_Mem[CH_MemBank].Used;
                CH_RCtrl:=CHS_ReceiveBegin;
              end;
            ResGSM_Answer:
              with CH_ATCmdBuff^ do
              if (Pos('ERROR',RecStr)=0)and(Pos(cAtCmdSMS_ReadMsg+':',RecStr)<>0) then
              begin
                RecStr:=Copy(RecStr,Pos(cAtCmdSMS_ReadMsg+':',RecStr)+Length(cAtCmdSMS_ReadMsg+':'),Length(RecStr));
                CH_LenRecSMS:=DecodeReaded(RecStr);
                if CH_LenRecSMS<>0 then { jedna se o neprectenou zpravu nenulove delky }
                  begin
                    {$ifdef Deb_Ctrl}
                     writeln('Receive SMS Data');
                    {$endif}
                    ChATCmd('',cmd_RecAnsw,0,0,CH_TimeOut[AnswSMS]);
                    CH_RCtrl:=CHS_ReceiveSMSData;
                    goto L_ReceiveSMSData;
                  end
                else
                  begin
                    Inc(CH_MemIndex);
                    if CH_MemIndex>CH_Mem[CH_MemBank].Total then
                      CH_RCtrl:=CHS_ReceiveBegin
                    else
                      CH_RCtrl:=CHS_ReceiveReadSMS;
                  end;
              end
              else
              begin
                Inc(CH_MemIndex);
                if CH_MemIndex>CH_Mem[CH_MemBank].Total then
                  CH_RCtrl:=CHS_ReceiveBegin
                else
                  CH_RCtrl:=CHS_ReceiveReadSMS;
              end;
            else
              begin
                ChSetResult(CH_NumName or res_Err);
                CH_RCtrl:=CHS_ReceiveBegin;
              end;
          end;
        end;
      CHS_ReceiveSMSData:
        L_ReceiveSMSData:
        if ChAtCmdReady=SMCS_Ready then { ceka se do prijeti odpovedi na cteni dat SMS zpravy }
        begin
          with CH_AtCmdBuff^ do
            RecStr:=Copy(RecStr,Length(RecStr)-CH_LenRecSMS*2+1,CH_LenRecSMS*2);
          if CH_RMess<>nil then
            CH_LRMess:=DecodeRecMsg(pRecRecord(CH_RMess),CH_AtCmdBuff^.RecStr)
          else ChSetReceiveResult(CH_NumName or Res_Err);
          {$ifdef Deb_Ctrl}
           writeln('Deleting Received SMS ');
          {$endif}
          Dec(CH_Mem[CH_MemBank].Used);
          ChAtCmd('AT'+cAtCmdSMS_DelMsg+'='+IntToStr(CH_MemIndex),cmd_CmdAnsw,
                  CH_Delay[BeforMemSto],0,CH_TimeOut[AnswSMS]);
          CH_RCtrl:=CHS_ReceiveDelRecSMS;
          goto L_ReceiveDelRecSMS;
        end;
      CHS_ReceiveDelRecSMS:
        L_ReceiveDelRecSMS:
        if ChAtCmdReady=SMCS_Ready then { ceka se do prijeti odpovedi na vymazani prijate zpravy }
        begin
          case ChATCmdResult of
            ResGSM_RTimeOut,
            ResGSM_STimeOut,
            ResGSM_SHwErr,
            ResGSM_RHwErr,
            ResGSM_Answer,
            ResGSM_Error:
              begin
                {$ifdef Deb_Ctrl}
                 writeln('Deleting Received SMS ');
                {$endif}
                ChAtCmd('AT'+cAtCmdSMS_DelMsg+'='+IntToStr(CH_MemIndex),cmd_CmdAnsw,
                        CH_Delay[BeforMemSto],0,CH_TimeOut[AnswSMS]);
              end;
            ResGSM_Ok:
              begin
                {$ifdef Deb_Ctrl}
                 writeln('Received SMS Message ');
                {$endif}
                CH_RCtrl:=CHS_ReceiveReady;
              end;
            else
              begin
                ChSetResult(CH_NumName or res_Err);
                CH_RCtrl:=CHS_ReceiveBegin;
              end;
          end;
        end;
    end; {case}
    CH_RTick:=false;
  end;
end;

{------------------------------}
procedure tChnSMS.ChOpen;
begin
  if CH_Ctrl=CHS_Close then
    if CH_Chn<>nil then
    begin
      CH_Chn.ChOpen;
      CH_Ctrl:=CHS_Opening1;
      ChTick;
        { CH_Result nastavuje ChTick }
    end
    else
      ChSetResult(CH_NumName or res_ErrChannelNoExist)
  else
    ChSetResult(CH_NumName or res_ErrNoClose);
end; { ChOpen }

{------------------------------}
procedure tChnSMS.ChClose;
begin
  if CH_Ctrl<>CHS_Close then
    if CH_Chn<>nil then
    begin
      CH_Chn.ChClose;
      { ChDoneHW nastavuje CH_Result }
      CH_Ctrl :=CHS_Closing2;
      ChTick;
        { CH_Result nastavuje ChTick }
    end
    else
      ChSetResult(CH_NumName or res_ErrChannelNoExist);
end; { ChClose }

{------------------------------}
procedure tChnSMS.ChConnect;
begin
  if CH_Ctrl=CHS_Open then
    if CH_Chn<>nil then
    begin
      CH_Ctrl :=CHS_Connect_1;
      ChTick;
        { CH_Result nastavuje ChTick }
    end
    else
      ChSetResult(CH_NumName or res_ErrChannelNoExist)
  else
    ChSetResult(CH_NumName or res_ErrNoOpen);
end; { ChConnect }

{------------------------------}
procedure tChnSMS.ChDisConnect;
begin
  if (CH_Ctrl<>CHS_Close     )and
     (CH_Ctrl<>CHS_DisConnect)then
    if CH_Chn<>nil then
    begin
      CH_RCtrl:=CHS_ReceiveNoReady;
      CH_Ctrl:=CHS_DisCon_1;
      ChTick;
        { CH_Result nastavuje ChTick }
    end
    else
      ChSetResult(CH_NumName or res_ErrChannelNoExist);
end; { ChConnect }

{------------------------------}
procedure tChnSMS.ChSend(Buff: Pointer; Len:Word);
begin
  if CH_Ctrl=CHS_Connect then
  begin
    CH_SendStr:=CodeSendMsg(Buff); {zakodovani SMS zpravy}
    if Length(CH_SendStr)>0 then
    begin
      CH_SCtrl:=CHS_SendBegin;
      ChSendTick;
       {CH_SResult nastavuje ChSendTick}
    end
    else
      ChSetSendResult(CH_NumName or res_Err);
  end
  else
    ChSetSendResult(CH_NumName or res_ErrNoConnect);
end; { ChSend }

{------------------------------}
function  tChnSMS.ChSendReady: TCHState;
begin
  ChSendTick;
  { nastavuje CH_SResult }
  if CH_Ctrl=CHS_Connect then
    ChSendReady:=CH_SCtrl
  else
    ChSendReady:=CHS_SendNoReady;
end; { ChSendReady }

{------------------------------}
procedure tChnSMS.ChSendFlush;
begin
  if CH_Ctrl=CHS_Connect then
    if CH_Chn<>nil then
    begin
      CH_Chn.ChSendFlush;
      ChSetSendResult(CH_Chn.ChSendResult);
      CH_SCtrl:=CHS_SendReady;
    end
    else
      ChSetSendResult(CH_NumName or res_ErrChannelNoExist)
  else
    ChSetSendResult(CH_NumName or res_ErrNoConnect);
end; { ChSendFlush }

{------------------------------}
function  tChnSMS.ChReceiveReady: TCHState;
begin
  ChReceiveTick;
  { nastavuje CH_RResult }
  if CH_Ctrl=CHS_Connect then
    ChReceiveReady:=CH_RCtrl
  else
    ChReceiveReady:=CHS_ReceiveNoReady;
end; { ChReceiveReady }

{------------------------------}
procedure tChnSMS.ChReceive(var Len: Word);
begin
  Len:=0;
  if CH_Ctrl=CHS_Connect then
  begin
    if CH_RMess=nil then
      ChSetReceiveResult(CH_NumName or res_Err)
    else
    if CH_RCtrl=CHS_ReceiveReady then
      begin
        Len:=CH_LRMess;
        CH_RCtrl:=CHS_ReceiveBegin;
        ChSetReceiveResult(res_Ok);
      end
    else
      ChSetReceiveResult(CH_NumName or res_ErrNoReceiveReady)
  end
  else
    ChSetReceiveResult(CH_NumName or res_ErrNoConnect);
end; { ChReceive }

{------------------------------}
procedure tChnSMS.ChReceiveFlush;
begin
  if CH_Chn<>nil then
  begin
    CH_Chn.ChReceiveFlush;
    ChSetReceiveResult(CH_Chn.ChReceiveResult);
    CH_RCtrl:=CHS_ReceiveBegin;
  end
  else
    if CH_Ctrl<>CHS_Connect then
      ChSetReceiveResult(CH_NumName or res_ErrNoConnect);
end;

{================================================================}

{------------------------------}
begin
  ChnCollection.Insert(tAddChnSMS.Init(Nil));

  {$ifdef HardLock}
   if not TestHardLock then RunError(99);
  {$endif}
end.
