unit ChnTypes;

          {ͻ}
          {                                                        }
          {  unit ChnTypes - definice zakladnich typu a konstant   }
          {                  pro komunikacni knihovny              }
          {                                                        }
          {  (C)1992 Vladimr Kastner, Na Vlovce 6, Praha 6       }
          {     1998 Adam Wild, Dejvicka 42, Praha 6               }
          {ͼ}

interface

{ konstanty pro obvod 8250 }
const
 { konstanty implicitnich adres COM portu }
  AddrCom1    = $3f8;     { adresa portu COM 1 }
  AddrCom2    = $2f8;     { adresa portu COM 2 }
  AddrCom3    = $3e8;     { adresa portu COM 3 }
  AddrCom4    = $3e0;     { adresa portu COM 4 }
  AddrCom5    = $2f0;     { adresa portu COM 5 }
  AddrCom6    = $2e8;     { adresa portu COM 6 }
  AddrCom7    = $2e0;     { adresa portu COM 7 }
  AddrCom8    = $260;     { adresa portu COM 8 }

  ACom : array[1..8]of Word = { pole adres COM portu }
    (AddrCom1, AddrCom2, AddrCom3, AddrCom4,
     AddrCom5, AddrCom6, AddrCom7, AddrCom8);

 { konstanty hardwaroveho preruseni od 8250 }
  IRQ0        = 0;        { peruen 0 }
  IRQ1        = 1;        { peruen 1 }
  IRQ2        = 2;        { peruen 2 }
  IRQ3        = 3;        { peruen 3 }
  IRQ4        = 4;        { peruen 4 }
  IRQ5        = 5;        { peruen 5 }
  IRQ6        = 6;        { peruen 6 }
  IRQ7        = 7;        { peruen 7 }

 { konstanty posunu registru 8250 }
  AddrComTHR  = $00;      { posunut pro THR - Transmit Holding Register }
  AddrComRBR  = $00;      { posunut pro RBR - Receiver Buffer  Register }
  AddrComIER  = $01;      { posunut pro IER - Interrupt Enable Register }
  AddrComIIR  = $02;      { posunut pro IIR - Interrupt Identification Register }
  AddrComLCR  = $03;      { posunut pro LCR - Line Control Register }
  AddrComMCR  = $04;      { posunut pro MCR - Modem Control Register }
  AddrComLSR  = $05;      { posunut pro LSR - Line Status Register }
  AddrComMSR  = $06;      { posunut pro MSR - Modem Status Register }

 { masky pro nastaveni LCR (Line Control) registru }
  {dodelat}

 { masky pro nastaveni IER (Interrupt Enable) registru }
  MskRecOn       = $01;      { maska pro povolen peruen od pijmae }
  MskRecOff      = $fe;      { maska pro zakzn peruen od pijmae }
  MskTransOn     = $02;      { maska pro povolen peruen od vyslae }
  MskTransOff    = $fd;      { maska pro zakzn peruen od vyslae }
  MskLSROn       = $04;      { maska pro povolen peruen od statusu }
  MskLSROff      = $fb;      { maska pro zakzn peruen od statusu }
  MskMSROn       = $08;      { maska pro povolen peruen od modemovych signalu }
  MskMSROff      = $f7;      { maska pro zakzn peruen od modemovych signalu }
  MskNoInterrupt = $00;      { nebude se generovat dn peruen}

 { masky pro nastaveni MCR (Modem Control) registru }
  MskSetDTR      = $01;      { nastaven signlu DTR/ na vstupu 8250 na 0 }
  MskSetRTS      = $02;      { nastaven signlu RTS/ na vstupu 8250 na 0 }
  MskSetOut2     = $08;      { nastaven signlu OUT2/ na vstupu 8250 na 0 }
                             { 0 povoluje peruen od 8250 }
  MskResDTR      = $fe;      { nastaven signlu DTR/ na vstupu 8250 na 1 }
  MskResRTS      = $fd;      { nastaven signlu RTS/ na vstupu 8250 na 1 }
  MskResOut2     = $f7;      { nastaven signlu OUT2/ na vstupu 8250 na 1 }
                             { 1 zakazuje peruen od 8250 }

 { masky pro testovani IIR (Interrupt Identification) registru }
  MskMIP        = $01;      { identifikuje peruen }
  MskTransReady = $02;      { identifikace zda o peruen d vysla }
  MskRecReady   = $04;      { identifikace zda o peruen d pijma }
  MskErrSTS     = $06;      { identifikace zda peruen je zpsobeno chybou }
  MskModSTS     = $00;      { identifikace zda peruen je zpusobeno modemovym statusem }

 { masky pro testovani LSR (Line Status) registru }
  MskErrLSR     = $1e;      { maska pro odstraneni prebytecnych bitu z LSR registru pro dekodovani chyby }
  MskOkLSR      = $00;      { OK hodnota pro LSR registr }
  MskErrOvr     = $02;      { maska pro dekodovani chyby Overrun }
  MskErrPar     = $04;      { maska pro dekodovani chyby Parity }
  MskErrFrm     = $08;      { maska pro dekodovani chyby Framing }
  MskBrkInt     = $10;      { maska pro dekodovani Break Interruptu }

 { masky pro testovani MSR (Modem Status) registru }
  MskDCTS      = $01;      { maska pro dekodovani modemoveho signalu DCTS  (Delta Clear to Send) }
  MskDDSR      = $02;      { maska pro dekodovani modemoveho signalu DDSR  (Delta Data Set Ready) }
  MskTERI      = $04;      { maska pro dekodovani modemoveho signalu TERI  (Trailing Edge Ring Indicator) }
  MskDRLSD     = $08;      { maska pro dekodovani modemoveho signalu DRLSD (Delta Receive Line Signal Detect) }
  MskCTS       = $10;      { maska pro dekodovani modemoveho signalu CTS   (Clear to Sned) }
  MskDSR       = $20;      { maska pro dekodovani modemoveho signalu DSR   (Data Set Ready) }
  MskRI        = $40;      { maska pro dekodovani modemoveho signalu RI    (Ring Indicator) }
  MskRLSD      = $80;      { maska pro dekodovani modemoveho signalu RLSD  (Receive Line Signal Detect) }
  MskCD        = MskRLSD;  { maska pro dekodovani modemoveho signalu CD    (Carrier Detect) }

(* {!Ka nikdy nebude}
 { nastaveni 8259 }
  IntM59      = $08;      { slo vektoru peruen pro IRQ 0 obvodu 8259 master }
  IntS59      = $70;      { slo vektoru peruen pro IRQ 0 obvodu 8259 slave }
  M59_IMR     = $21;      { adresa masky peruen adie I8259 master }
  S59_IMR     = $a1;      { adresa masky peruen adie I8259 slave }
*)
{ konstanty pro obvod 8251 }
const
 { adresy registru 8251 }
  AddrSCU        = $00f0;     { bazova adresa srioveho komunikacniho adapteru i8251 }
  AddrSCUSRB     = AddrSCU+0; { adresa SRB  (Serial Receive Buffer) registru }
  AddrSCUSTB     = AddrSCU+0; { adresa STB  (Serial Transmit Buffer) registru }
  AddrSCUSST     = AddrSCU+1; { adresa SST  (Serial Status) registru }
  AddrSCUSCM     = AddrSCU+1; { adresa SCM  (Serial Command) registru }
  AddrSCUSMD     = AddrSCU+2; { adresa SMD  (Serial Mode) registru }
  AddrSCUSIMK    = AddrSCU+3; { adresa SIMK (Serial Interrupt Mask) registru }

 { masky pro testovani SST (Serial Status) registru }
  MskSCUTReady  = $01;      { maska pro dekodovani Transmit Buffer Empty }
  MskSCURReady  = $02;      { maska pro dekodovani Receive Buffer Full }
  MskSCUParErr  = $08;      { maska pro dekodovani chyby Parity }
  MskSCUOvrErr  = $10;      { maska pro dekodovani chyby Overun }
  MskSCUFrmErr  = $20;      { maska pro dekodovani chyby Framing }
  MskSCUBrkDet  = $40;      { maska pro dekodovani Break Detect }

 { masky pro nastavovani SCM (Serial Command) registru }
  MskSCUTransOn = $21;      { maska pro povoleni preruseni od vysilace }
  MskSCUTransOff= $fe;      { maska pro zakazani preruseni od vysilace }
  MskSCURecOn   = $34;      { maska pro povoleni preruseni od prijimace s vynulovanim Error Flagu }
  MskSCURecOff  = $fb;      { maska pro zakazani preruseni od prijimace }
  MskSCUBrkOn   = $28;      { maska pro nastaveni Break Interruptu }
  MskSCUBrkOff  = $f7;      { maska pro zruseni Break Interruptu }
  MskSCUNoInt   = $20;      { maska pro zakazani vsech preruseni }

 { masky pro nastaveni SIMK (Serial Interrupt Mask) registru }
  MskSIMKNoInt  = $03;      { zakazani prijimace a vyslae }
  MskSIMKOnInt  = $00;      { povoleni prijimace a vysilace }

{ kosntanty a typy spolecne pro oba obvody 8250 i 8251 }

const
 { konstanty parity, stop bitu a datovych bitu }
  ParNone     = 0;        { bez parity }
  ParOdd      = 1;        { lich parita }
  ParEven     = 2;        { sud parita }

  Stop1       = 1;        { jeden stop-bit }
  Stop2       = 2;        { dva stop-bity }

  Bits5       = 5;        { 5 datovch bit }
  Bits6       = 6;        { 6 datovch bit }
  Bits7       = 7;        { 7 datovch bit }
  Bits8       = 8;        { 8 datovch bit }

type
 { intervalove typy parametru }
  tIrq        = Irq0   ..Irq7;
  tRate       = 1     ..300000;    {!Ka ??? je-li interval -> divne pri ladeni zobrazuje}
  tParity     = ParNone..ParEven;
  tStop       = Stop1  ..Stop2;
  tLength     = Bits5  ..Bits8;

implementation

End.
