unit ChnMBox;

          {ͻ}
          {                                                        }
          {  unit ChnMBox                                          }
          {                                                        }
          {  jednotka pro obsluhu sriov komunikace s vyuitm    }
          {  schranek o.s. ReTOS                                   }
          {                                                        }
          {  (C)1998 SofCon, Steovick 49, 160 00 Praha 6        }
          {          Ing. Vladimr Kastner, Na Vlovce 6, Praha 6  }
          {          Adam Wild, Dejvicka 42, Praha 6               }
          {ͼ}

interface

uses
  ChnVirt,
  uString;

const
  cName = 'MBOX';
  cVer  = 'v4.1, 04.01.1999';

const
  MaxRBuf = 65535;
type
  pBuff = ^tBuff;
  tBuff = array[0..MaxRBuf]of byte;

  tMailBox = class(TObject)
    MailBuff  : pBuff;   { ukazatel na buffer }
    BuffSize  : word;    { velikost bufferu }
    constructor Init(Size : word);
    destructor  Destroy;   override;
   { nastaveni a vraceni velikosti bufferu }
    procedure SetBuffSize(Size : word);virtual; { zmeni velikost bufferu }
    function  GetBuffSize      : word; virtual; { vrati velikost bufferu v bytech }
    function  GetFreeSize      : word; virtual; { vrati velikost volneho mista bufferu v bytech }
    function  GetFullSize      : word; virtual; { vrati velikost zaplneneho mista bufferu v bytech }
   { vraceni stavu preteceni a podteceni }
    function  GetOver      : boolean;  virtual; { vrati priznak preteceni bufferu }
    function  GetUnder     : boolean;  virtual; { vrati priznak podteceni bufferu }
   { vkladani a uvolnovani bufferu }
    procedure Empty;                   virtual; {vyprazdneni bufferu}
    procedure InsChar(B   : byte);     virtual; { vlozi do bufferu znak }
    function  GetChar     : byte;      virtual; { vrati z bufferu znak }
  {pozn: - buffer musi mit velikost alespon pro 2 polozky
           protoze 1 polozka se spotrebuje na manipulci }
   private
    URec,              { ukazovatko na prvni obsazene misto v bufferu }
    VRec    : word;    { ukazovatko na prvni volne misto v bufferu}
    FlOver  : boolean; { priznak preteceni bufferu }
    FlUnder : boolean; { priznak podteceni bufferu }
  end;

type
  tChnMBox = class(tChnVirt)
    CH_SendMailBox : tMailBox;  { ukazatel na schranku, ze ktere budou zpravy odesilany }
    CH_RecMailBox  : tMailBox;  { ukazatel na schranku, do ktere budou zpravy prijimany }

   { vytvoreni, zruseni objektu }
    constructor Init;
                  { vytvoreni objektu }
    constructor ChInitParam(const S: tParamStr);
                  { vytvoreni objektu a nastaveni parametru }
    destructor  Destroy;
                  override; { zruseni objektu }

   { zadani a zobrazeni zadanych parametru }
   protected
    function  ChSetOneParam(const S: tWordString; var CmdL: tCmd): tChResult;
                override; { nove nastaveni parametru textove spolecnych pro vsechny knihovny }
   published
    function  ChGetParam   (const S: tParamStr): tParamStr;
                override; { prevod parametru kanalu do stringu }

   { navazani a ruseni spojeni }
    procedure ChConnect;
                override; { pocatek navazovani spojeni }

   { vysilani dat }
    procedure ChSend(Buff: Pointer; Len: Word);
                override; { pocatek vysilani }
    function  ChSendReady: TCHState;
                override; { krok vysilaciho aut., stav vysilani }

   { prijem dat }
    function  ChReceiveReady: TCHState;
                override; { krok prij. automatu, stav prijmu }
    procedure ChReceive(var Len: Word);
                override; { prijem zpravy }
    function  ChReceiveChar: Byte;
                override; { prijem 1 znaku zpravy }
    procedure ChReceiveFlush;
                override; { stav jako po inicializaci }
  end;

type
  tAddChnMBox = class(tAddChnVirt)
    function ChInit: tChnVirt; override;
  end;

implementation
uses
 {$ifdef HardLock}
  HardLock,
 {$endif}
  SysUtils;

{-------------------------------------------------}
constructor tMailBox.Init(Size : word);
begin
  inherited;
  MailBuff := nil;
  URec     := 0;
  VRec     := 0;
  FlOver   := False;
  FlUnder  := False;
  SetBuffSize(Size);
end;
{-------------------------------------------------}
destructor tMailBox.Destroy;
begin
  Empty;
  if MailBuff<>nil then
  begin
    FreeMem(MailBuff,BuffSize);
    BuffSize:=0;
    MailBuff:=nil;
  end;
  inherited;
end;
{-------------------------------------------------}
procedure tMailBox.SetBuffSize(Size:word);
begin
 { kontrola rozsahu velikosti }
  if Size<2     then Size:=2;
 { kontrola preteceni }
  if GetFullSize>Size-1 then
  begin
    Empty;
    FlOver:=True;
  end;
 { uvolneni pameti stareho bufferu }
  if MailBuff<>nil then
    FreeMem(MailBuff,BuffSize);
 { alokace pameti noveho bufferu }
  BuffSize:=Size;
  GetMem(MailBuff,BuffSize);
end;
{-------------------------------------------------}
function  tMailBox.GetBuffSize : word;
begin
  GetBuffSize:=BuffSize-1;
end;
{-------------------------------------------------}
function  tMailBox.GetFreeSize: word;
begin
  if VRec=URec then
         GetFreeSize:=BuffSize-1
  else
    if VRec>URec then
         GetFreeSize:=BuffSize-(VRec-URec)-1
    else GetFreeSize:=URec-VRec-1;
end;
{-------------------------------------------------}
function  tMailBox.GetFullSize: word;
begin
  if VRec=URec then
         GetFullSize:=0
  else
    if VRec>URec then
         GetFullSize:=VRec-URec
    else GetFullSize:=BuffSize-URec+VRec;
end;
{-------------------------------------------------}
function  tMailBox.GetOver :boolean;
begin
  GetOver:=FlOver;
  FlOver :=False;
end;
{-------------------------------------------------}
function  tMailBox.GetUnder:boolean;
begin
  GetUnder:=FlUnder;
  FlUnder :=False;
end;
{-------------------------------------------------}
procedure tMailBox.Empty;
begin
  URec   := 0;
  VRec   := 0;
  FlOver := False;
  FlUnder:= False;
end;
{-------------------------------------------------}
procedure tMailBox.InsChar(B : byte);
begin
  MailBuff^[VRec]:=B;
  if VRec<BuffSize then Inc(VRec)
  else VRec:=0;
  if VRec=URec then
  begin
    if URec<BuffSize then Inc(URec)
    else URec:=0;
    FlOver:=True;
  end;
end;
{-------------------------------------------------}
function  tMailBox.GetChar   : byte;
begin
  if VRec<>URec then
  begin
    GetChar:=MailBuff^[URec];
    if URec<BuffSize then Inc(URec)
    else URec:=0;
  end
  else
  begin
    FlUnder:=True;
    GetChar:=0;
  end;
end;
{============================================================}

function tAddChnMBox.ChInit: tChnVirt;
begin
  ChInit:=tChnMBox.Init;
end;

{============================================================}
constructor tChnMBox.Init;
begin
  inherited;
  CH_Type        := cName;
  CH_Name        := CH_Type;
  CH_NumName     := ChNumName(CH_Type);
  CH_RecMailBox  := nil;
  CH_SendMailBox := nil;
end;

{ -------------------------------------------- }
constructor tChnMBox.ChInitParam(const S: tParamStr);
begin
  Init;
  ChSetParam(S);
  { CH_Result nastavuje ChSetParam }
end;

{ -------------------------------------------- }
destructor  tChnMBox.Destroy;
begin
  inherited;
  { CH_Result nastavuje Done }
end;

type
  tStrPtr = String[20];

{ -------------------------------------------- }
function tChnMBox.ChSetOneParam(const S: tWordString; var CmdL: tCmd): tChResult;
type
  tParam = (P_ERR,
            P_RMB,    { adresa schranky odkud budou prijimany zpravy }
            P_SMB,    { adresa schranky kam budou zasilany zpravy }
            P_LRB     { velikost prijimaciho bufferu }
            );
const
  StrParam = 'RMB|SMB|LRB|';
var
  PomRes  : tChResult;
  Param   : tParam;
  ErrFl   : boolean;
  PomL    : longint;
begin
  PomRes:=res_Ok;
  ErrFl :=false;
  if S='|' then
  begin
    ChNextSetParam(CmdL.ReadRest);
    PomRes:=ChResult;
  end
  else
  begin
    Param:=tParam(NDELIM(S,StrParam));
    case Param of
      P_ERR:
        PomRes:=inherited ChSetOneParam(S,CmdL);
      P_RMB:
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            Pointer(CH_RecMailBox):=Pointer(PomL)
          else
            PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_SMB:
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            Pointer(CH_SendMailBox):=Pointer(PomL)
          else
            PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_LRB:
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            if (PomL>=1) and (PomL<=MaxRBuf) then
            begin
              if CH_RBuff<>nil then
              begin
                FreeMem(CH_RBuff,CH_MRBuff);
                CH_RBuff:=nil;
              end;
              CH_MRBuff:=PomL;
              GetMem(CH_RBuff,CH_MRBuff)
            end
            else
              ErrFl:=true;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
    end; {case}
  end;
  ChSetOneParam:=PomRes;
end;

{ -------------------------------------------- }
function  tChnMBox.ChGetParam(const S: tParamStr): tParamStr;
var
  ss   : tParamStr;
begin
  ss:='NAM='+CH_Name+
      ' RMB='+IntToStr(longint(pointer(CH_RecMailBox )))+
      ' SMB='+IntToStr(longint(pointer(CH_SendMailBox)))+
      ' LRB='+LStr(CH_MRBuff);
  ChGetParam:=ss;
  ChSetResult(res_Ok);
end;

{ -------------------------------------------- }
procedure tChnMBox.ChConnect;
begin
  if CH_Ctrl=CHS_Open then
  begin
    if Assigned(CH_SendMailBox) and Assigned(CH_RecMailBox) then
    begin
      CH_Ctrl :=CHS_Connect;
      CH_State:=CH_Ctrl;
      ChSetResult(res_Ok);
    end
    else
      ChSetResult(CH_NumName or res_ErrConnect);
  end
  else
    if CH_Ctrl<>CHS_Connect then
      ChSetResult(CH_NumName or res_ErrNoOpen);
end;

{ -------------------------------------------- }
procedure tChnMBox.ChSend(Buff: Pointer; Len: Word);
var
  i : Word;
begin
  if CH_Ctrl=CHS_Connect then
  begin
    ChSetSendResult(res_Ok);
    for i:=0 to Len-1 do
    begin
      CH_SendMailBox.InsChar(pBuff(Buff)^[i]);
      if CH_SendMailBox.GetOver then
      begin
        ChSetSendResult(CH_NumName or res_Err);
        Break;
      end;
    end;
  end
  else ChSetSendResult(CH_NumName or res_ErrNoConnect);
end; { ChSend }

{ -------------------------------------------- }
function  tChnMBox.ChSendReady: TCHState;
begin
  if CH_Ctrl=CHS_Connect then
  begin
    ChSendReady:=CHS_SendReady;
    ChSetSendResult(res_Ok);
  end
  else
  begin
    ChSendReady:=CHS_SendNoReady;
    ChSetSendResult(CH_NumName or res_ErrNoConnect);
  end;
end; { ChSendReady }

{ -------------------------------------------- }
function  tChnMBox.ChReceiveReady: TCHState;
begin
  if CH_Ctrl=CHS_Connect then
  begin
    if CH_RecMailBox.GetFullSize>0 then
      ChReceiveReady:=CHS_ReceiveReady
    else
      ChReceiveReady:=CHS_ReceiveNoReady;
    ChSetReceiveResult(res_Ok);
  end
  else
  begin
    ChReceiveReady:=CHS_ReceiveNoReady;
    ChSetReceiveResult(CH_NumName or res_ErrNoConnect);
  end;
end; { ChReceiveReady }

{ -------------------------------------------- }
function  tChnMBox.ChReceiveChar: Byte;
begin
  if CH_Ctrl=CHS_Connect then
  begin
    if ChReceiveReady=CHS_ReceiveReady then
    begin
      ChReceiveChar:=CH_RecMailBox.GetChar;
      ChSetReceiveResult(res_Ok);
    end
    else
    begin
      ChReceiveChar:=$0;
      ChSetReceiveResult(CH_NumName or res_ErrNoReceiveReady);
    end
  end
  else
  begin
    ChReceiveChar:=$0;
    ChSetReceiveResult(CH_NumName or res_ErrNoConnect)
  end;
end; { ChReceiveChar }

{ -------------------------------------------- }
procedure tChnMBox.ChReceive(var Len: Word);
begin
  Len:=0;
  if CH_Ctrl=CHS_Connect then
  begin
    if Assigned(CH_RBuff) then
    begin
      if ChReceiveReady=CHS_ReceiveReady then
      begin
        while ChReceiveReady=CHS_ReceiveReady do
        begin
          pBuff(CH_RBuff)^[Len]:=CH_RecMailBox.GetChar;
          Inc(Len);
        end;
        ChSetReceiveResult(res_Ok);
      end
      else
        ChSetReceiveResult(CH_NumName or res_ErrNoReceiveReady);
    end
    else ChSetReceiveResult(CH_NumName or res_Err)
  end
  else ChSetReceiveResult(CH_NumName or res_ErrNoConnect);
end; { ChReceive }

{ -------------------------------------------- }
procedure tChnMBox.ChReceiveFlush;
begin
  if CH_Ctrl=CHS_Connect then
  begin
    CH_RecMailBox.Empty;
    ChSetReceiveResult(res_Ok);
  end
  else ChSetReceiveResult(CH_NumName or res_ErrNoConnect);
end; { ChReceiveFlush }

{============================================================}
begin
  ChnCollection.Insert(tAddChnMBox.Init(Nil));

  {$ifdef HardLock}
   if not TestHardLock then RunError(99);
  {$endif}
end.
