unit ChnVirt;

          {ͻ}
          {                                                          }
          {  unit ChnVirt                                            }
          {                                                          }
          { jednotka definujici virtualni komunikacni objekt ChnVirt }
          {                                                          }
          {  (C)1998 SofCon, Steovick 49, 160 00 Praha 6          }
          {          Ing. Vladimr Kastner                           }
          {               Adam Wild                                  }
          {                                                          }
          {ͼ}

interface

uses
  uString;

const
  cName = 'VIRT';             { implicitni jmeno a jmeno typu komunikacni jednotky }
  cVer  = 'v6.0, 30.10.2001'; { verze a datum komunikacni jednotky }

type
  tChName     = String[10];  { typ textoveho jmena kom.objektu }
  tResultStr  = String[40];  { typ retezce pro textovy vyslede operace }
  tChNumName  = Word;        { typ ciselneho jmena kom.objektu }
  tChResult   = Word;        { typ vysledku operace }
  tChState    = Word;        { typ stavu kanalu }
  tNode       = Word;        { typ cisla (adresy) stanice }

const
{ === stavy kanalu === }
 { stabilni stavy kanalu }
  CHS_Close      = 0;        { kanal zavren }
  CHS_Open       = 1;        { kanal otevren }
  CHS_Connect    = 2;        { kanal otevren, modem spojen, moznost prijmu a vysilani }
  CHS_DisConnect = CHS_Open; { kanal otevren, modem nespojen, nelze prijimat a vysilat }

 { stabilni stavy prijimace }
  CHS_ReceiveReady   = 0;    { prijata zprava }
  CHS_ReceiveNoReady = 1;    { zprava neni prijata }

 { stabilni stavy vysilace }
  CHS_SendReady      = 0;    { vysilani ukonceno, mozno opet vysilat }
  CHS_SendNoReady    = 1;    { vysilani neni ukonceno }
{ Pozn: Dalsi jednotky mohou definovat dalsi stabilni (pripadne i nestabilni) stavy. }

{ === vysledky operace === }
  res_Ok                 = $0000; { O.K. - bez chyby }

  res_ErrNoReceiveReady  = $00c0; { prijimac nema k dispozici prijata data }
  res_ErrNoSendReady     = $00d0; { vysilac neni pripraven pro vysilani dalsich zprav }

  res_ErrNoClose         = $00e0; { kanal neni ve stavu CHS_Close   }
  res_ErrNoOpen          = $00e1; { kanal neni ve stavu CHS_Open    }
  res_ErrNoConnect       = $00e2; { kanal neni ve stavu CHS_Connect }
  res_ErrOpen            = $00e3; { chyba pri ChOpen       }
  res_ErrConnect         = $00e4; { chyba pri ChConnect    }
  res_ErrDisConnect      = $00e5; { chyba pri ChDisConnect }
  res_ErrClose           = $00e6; { chyba pri ChClose      }

  res_ErrIllegalUnit     = $00fa; { nasledujici zretezeny kom. objekt je nepripustny }
  res_ErrChannelNoExist  = $00fb; { pokus o odkaz na neexistujici nasledny kom. objekt }
  res_ErrParamStr        = $00fc; { chybne parametry pri volani ChSetParam }
  res_Err                = $00ff; { blize nespecifikovana chyba }
{ Pozn: Dalsi knihovny mohou definovat nove res_Xxx, ale pozor na jiz existujici ciselne hodnoty !!! }

type
  TChnVirt = class;
  TClassChnVirt = class of TChnVirt;
  TChnVirt = class(TObject) { rodicovsky objekt pro ostatni kom. objekty }
    CH_Type    : TChName;       { jmeno typu kom. objektu }
    CH_Name    : TChName;       { uzivatelem definovane jmeno kom. objektu }
    CH_NumName : TChNumName;    { ciselne jmeno komunikacniho objektu = ChNumName(Ch_Name) }
    CH_NumNameParents: TChNumName; { ciselne jmeno rodicovskeho kom. objektu }
    CH_Chn     : TChnVirt;      { ukazatel na nasledujici (zretezeny) kom. objekt }
    CH_Ctrl    : TChState;      { aktualni stav automatu kom. kanalu }
    CH_RCtrl   : TChState;      { aktualni stav automatu prijimace kanalu }
    CH_SCtrl   : TChState;      { aktualni stav automatu vysilace kanalu }
    CH_State   : TChState;      { naposled dosazeny stabilni stav kom. kanalu }
    CH_Result  : TChResult;     { vysledek prvni chybne operace nad kom. kanalem }
    CH_RResult : TChResult;     { vysledek prvni chybne operace nad prijimacem }
    CH_SResult : TChResult;     { vysledek prvni chybne operace nad vysilacem }
    CH_Node    : TNode;         { cislo (adresa) teto stanice v komunikacni siti }
    CH_DNode   : TNode;         { cislo (adresa) stanice pro ktereho bude dalsi zprava }
    CH_RSNode  : TNode;         { adresa odesilatele po prijeti zpravy }
    CH_RDNode  : TNode;         { adresa adresovaneho po prijeti zpravy }
    CH_RBuff   : Pointer;       { ukazatel na prijimaci buffer }
    CH_MRBuff  : Word;          { velikost prijimaciho bufferu }
    CH_RMess   : Pointer;       { ukazatel na uzivatelsky buffer pro prijatou zpravu }
    CH_MRMess  : Word;          { velikost uzivatelskeho bufferu pro prijatou zpravu }

{ pokyny pro vytvareni metod dedicnych objektu
   - z hlediska predefinovavani
      C - musime vzdy predefinovat
      M - smime predefinovat
      X - nesmime nikdy predefinovat
   - z hlediska volani jako "inherited"
      I - musime vzdy pouzit inherited
      J - muzeme pouzivat inherited
      K - nema smysl inherited
      O - nesmime pouzit inherited
   - z hlediska volani metody zretezeneho kom. objektu
      P - musime pouzit i next metodu CH_Chn.Xxx, pokud je vytvorena
      N - muzeme pouzit next metodu
      L - nesmime pouzit next metodu, nesmime volat v aplikacich
}
     { vytvoreni, zruseni objektu }
{CIN} constructor Init;
                    { vytvoreni a inicializace objektu }
{CIN} constructor ChInitParam(const S: tParamStr);
                    { vytvoreni objektu a nastaveni parametru }
{MIN} destructor  Destroy;
                    override; { zruseni objektu }
{XKN} procedure   Done;
                    virtual;  { zruseni objektu - jen kvuli kompatibilite }

     { prevod textoveho jmena na ciselne jmeno a zpet }
{XJN} class function  ChNumName(Name: tChName): tChNumName;
                  virtual; { funkce prevadi textove jmeno kom. objektu na ciselne }
{XJN} class function  ChName(NumName: tChNumName): tChName;
                  virtual; { funkce prevadi ciselne jmeno kom. objektu na textove }
{XJN} class function  ChNumNameClass(NumName: tChNumName) : TClass;
                  virtual; { funkce vrati typ (tridu) kom. objektu s ciselnym jmenem NumName }
{XJN} class function  ChNameClass(Name: tChName) : TClass;
                  virtual; { funkce vrati typ (tridu) kom. objektu se jmenem Name }

     { poskytne seznam vsech dostupnych jmen }
{XJN} class function  ChAllNumName: String;
                  { navrati textova a ciselna jmena dostupnych kom. objektu }
{XJN} class function  ChAllName   : String;
                  { navrati textova jmena dostupnych kom. objektu }

     { nastaveni a vraceni parametru komunikace }
{MON} procedure ChSetParam    (const S: tParamStr);
                  virtual; { nove nastaveni parametru textove }
     protected
{CJL} function  ChSetOneParam (const S: tWordString; var CmdL: tCmd): tChResult;
                  virtual; { nove nastaveni jednoho parametru textove }
{MKL} procedure ChNextSetParam(const S: tParamStr);
                  virtual; { nove nastaveni parametru textove pro nasledny zret.objekt }
     published
{CON} function  ChGetParam    (const S: tParamStr): tParamStr;
                  virtual; { prevod parametru kom.objektu do stringu }
{MJP} procedure ChSetBinParam(NumName: tChNumName; Code: Word; Param: longint);
                  virtual; { binarni nastaveni parametru kom. }
{MJP} function  ChGetBinParam(NumName: tChNumName; Code: Word): longint;
                  virtual; { binarni cteni parametru kom. }

     { otevreni a zavreni HW kanalu, navazani a zruseni komunikace }
{MJN} procedure ChOpen;
                  virtual; { pocatek otevreni kanalu }
{MJN} procedure ChClose;
                  virtual; { pocatek zavreni kanalu }
{MJN} procedure ChConnect;
                  virtual; { pocatek navazovani spojeni }
{MJN} procedure ChDisConnect;
                  virtual; { pocatek ukonceni spojeni }

{MJN} function  ChState: TChState;
                  virtual; { krok automatu a vraceni naposledy dosazeneho stabilniho stavu kanalu }
{MJN} function  ChReady: TChState;
                  virtual; { krok automatu a vraceni aktualniho stavu kanalu }

     { vysilani dat }
{MKN} procedure ChDestNode(Node: TNode);
                  virtual; { urceni cisla (adresy) cilove stanice }
{MJN} procedure ChSend(Buff: Pointer; Len: Word);
                  virtual; { pocatek vysilani }
{MKN} function  ChSendReady: TChState;
                  virtual; { krok vysilaciho aut. a vraceni aktual. stavu vysilace }
{MKN} procedure ChSendFlush;
                  virtual; { preruseni vysilani }

     { prijem dat }
{MKN} procedure ChReceiveBuffer(Buff: pointer; Len: Word);
                  virtual; { definovani prijimaciho bufferu }
{MJN} function  ChReceiveReady: TChState;
                  virtual; { krok prijimaciho aut. a vraceni aktual. stavu prijimace }
{MJN} procedure ChReceive(var Len: Word);
                  virtual; { prijem zpravy a vraceni jeji delky }
{MJN} function  ChReceiveChar: Byte;
                  virtual; { prijem 1 znaku zpravy }
{MJN} procedure ChReceiveFlush;
                  virtual; { vyprazdneni prijimaciho bufferu }
{MKN} procedure ChGetNode(var SNode, DNode: TNode);
                  virtual; { ziskani odesilatele a adresata z prijmute zpravy }

     { cteni/nastaveni vysledku provedenych operaci (chyby) }
{MKN} function  ChResult       : TChResult;
                  virtual; { vrati vysledek operace nad kanalem }
{MKN} function  ChReceiveResult: TChResult;
                  virtual; { vrati vysledek operace nad prijimacem }
{MKN} function  ChSendResult   : TChResult;
                  virtual; { vrati vysledek operace nad vysilacem }
{XKL} procedure ChSetResult       (Value: TChResult);
                  virtual; { nastavi vysledek operace nad kanalem }
{XKL} procedure ChSetReceiveResult(Value: TChResult);
                  virtual; { nastavi vysledek operace nad prijimacem }
{XKL} procedure ChSetSendResult   (Value: TChResult);
                  virtual; { nastavi vysledek operace nad vysilacem }
{MKN} function  ChResultStr       (Sts  : TChResult) : tResultStr;
                  virtual; { vrati retezec s popisem vysledku operace }
     { automaty kanalu, vysilace a prijimace }
{MKN} procedure ChTick;
                  virtual; { automat kanalu }
{MKN} procedure ChSendTick;
                  virtual; { automat vysilace }
{MKN} procedure ChReceiveTick;
                  virtual; { automat prijimace }

     { pro praci s retezenym komunikacnim kanalem }
{XKN} function  ChGetLastChn : tChnVirt;
                  virtual; { vrati ukazatel na posledni objekt v komunikacnim kanalu }
{XKN} function  ChGetLastClass : TClassChnVirt;
                  virtual; { vrati typ (tridu) posledniho objektu v komunikacnim kanalu }
{XKN} function  ChGetNumChn : byte;
                  virtual; { vrati pocet zretezenych kanalu }
  end;

{ prvek tohoto typu zarazujeme metodou ChnCollection^.Insert do ChnCollection }
type
  TAddChnVirt = class(TObject) { objekt spravce komunikacnich objektu }
    ChType    : TChName;                  { jmeno typu kom. objektu }
    ChName    : TChName;                  { uzivatelske jmeno kom. objektu }
    ChNumName : TChNumName;               { ciselne jmeno kom. objektu }
    Channel   : tChnVirt;                 { ukazatel na jiz vytvorenou instanci kanalu }
{MI}constructor Init(Chn: tChnVirt);      { pro vsechny knihovny Chn=Nil }
{CK}function ChInit: tChnVirt; virtual;   { funkce vytvori konstruktorem Init instanci daneho kanalu }
  end;

{ typ pro seznam objektu spravcu pripojenych kom.objektu }

const
{ Maximum TCollection size }
  MaxCollectionSize = 65520 div SizeOf(Pointer);
type
{ TCollection types }
  PItemList = ^TItemList;
  TItemList = array[0..MaxCollectionSize - 1] of tAddChnVirt;

{ TCollection object }
  TCollection = class(TObject)
    Items: PItemList; 
    Count: Integer;
    Limit: Integer;
    Delta: Integer;
    constructor Init(ALimit, ADelta: Integer);
    destructor Destroy; override;
    function  At(Index: Integer): tAddChnVirt;
    procedure AtDelete(Index: Integer);
    procedure AtInsert(Index: Integer; Item: tAddChnVirt);
    procedure Delete(Item: tAddChnVirt);
    procedure FreeAll;
    procedure FreeItem(Item: tAddChnVirt); virtual;
    function  IndexOf(Item: tAddChnVirt): Integer; virtual;
    procedure Insert(Item: tAddChnVirt); virtual;
    procedure SetLimit(ALimit: Integer); virtual;
  end;

  TChnCollection = class(TCollection) { objekt seznamu objektu spravcu kom. objektu }
    constructor Init;
    procedure Insert(Item: tAddChnVirt);
                override; { }
    procedure ChInsert(Chn: tChnVirt);
                virtual; { vlozi odkaz na instanci knihovny do collection }
    procedure ChDelete(Chn: tChnVirt);
                virtual; { zrusi odkaz na instanci knihovny v collection }
    function  ChNewInit(Name: tChName): tChnVirt;
                { funkce vytvori instanci daneho kom.objektu z ChnCollection a provede Init }
    function  ChNumName(Name: tChName): tChNumName;
                { nalezne v ChnCollection prvni prvek s danym jmenem Name
                  a navrati jeho index jako hodnotu jeho ciselneho jmena NumName }
    function  ChName(NumName: tChNumName): tChName;
                { nalezne v ChnCollection prvni prvek s danym ciselnym jmenem
                  NumName a navrati jeho textove jmeno Name; pokud prvek nenalezne, vrati ''}
    function  ChNumNameClass(NumName: tChNumName) : TClass;
                { nalezne v ChnCollection prvni prvek s danym ciselnym jmenem
                  NumName a vrati jeho typ tridy; pokud prvek nenalezne vrati TObject}
    function  ChNameClass(Name: tChName) : TClass;
                { nalezne v ChnCollection prvni prvek s danym jmenem
                  Name a vrati jeho typ tridy; pokud prvek nenalezne vrati TObject}
    function  ChAllName   : String;
                { navrati vsechna textova jmena kom.objektu spravovanych seznamem spravcu }
    function  ChAllNumName: String;
                { navrati vsechna textova i ciselna jmena kom.objektu spravovanych seznamem spravcu }
  end;

const
  ChnCollection : tChnCollection = nil;  { seznam spravcu kom. objektu }


implementation

uses
  SysUtils;

type
  TAddChannel = class(TAddChnVirt)
    function ChInit: tChnVirt; override;{ navracejici ukazatel na dany kom.objekt }
  end;

{ ---------------------------------------- }
constructor TAddChnVirt.Init(Chn: tChnVirt);
begin
  Create;
  Channel:=Chn;
  if Channel=Nil then
    Chn:=ChInit;
  ChType:=Chn.CH_Type;
  ChName:=Chn.CH_Name;
  ChNumName:=Chn.CH_NumName;
  if Channel=Nil then
    Chn.Free;
end;

{ ---------------------------------------- }
function TAddChnVirt.ChInit: tChnVirt;
begin
  { dedicove zde definuji ChInit:=tChnXxx.Init; }
  ChInit:=tChnVirt.Init;
end;

{ ---------------------------------------- }
function TAddChannel.ChInit: tChnVirt;
begin
  ChInit:=Channel;
end;

{ --------------------------------------- }

{ TCollection }

constructor TCollection.Init(ALimit, ADelta: Integer);
begin
  Create;
  Items := nil;
  Count := 0;
  Limit := 0;
  Delta := ADelta;
  SetLimit(ALimit);
end;

destructor TCollection.Destroy;
begin
  FreeAll;
  SetLimit(0);
  inherited;
end;

function TCollection.At(Index: Integer): tAddChnVirt;
begin
  if (Index>=0)or(Index<Count) then
    At:=Items[Index]
  else
  begin
    At:=nil;
    {RunError(255);}
  end;
end;

procedure TCollection.AtDelete(Index: Integer);
begin
  if (Index>=0)or(Index<Count) then
  begin
    Dec(Count);
    if Index<Count then
      Move(Items[Index+1],Items[Index],SizeOf(Pointer)*(Count-Index));
  end
  {else
    RunError(255);}
end;

procedure TCollection.AtInsert(Index: Integer; Item: tAddChnVirt);
begin
  if (Index>=0)or(Index>Count) then
  begin
    if (Index>=Limit) then
      SetLimit(Limit+Delta);
    if (Index<>Count) then
      Move(Items[Index],Items[Index+1],SizeOf(Pointer)*(Count-Index));
    Items[Index]:=Item;
    Inc(Count);
  end
  {else
    RunError(255);}
end;

procedure TCollection.Delete(Item: tAddChnVirt);
begin
  AtDelete(IndexOf(Item));
end;

procedure TCollection.FreeAll;
var
  I: Integer;
begin
  for I := 0 to Count - 1 do FreeItem(At(I));
  Count := 0;
end;

procedure TCollection.FreeItem(Item: tAddChnVirt);
begin
  if Assigned(Item) then Item.Free;
end;

function TCollection.IndexOf(Item: tAddChnVirt): Integer;
var
  i : Integer;
begin
  Result:=-1;
  for i:=0 to Count-1 do
  begin
    if Item=Items[i] then
    begin
      Result:=i;
      Break;
    end;
  end;
end;

procedure TCollection.Insert(Item: tAddChnVirt);
begin
  AtInsert(Count, Item);
end;

procedure TCollection.SetLimit(ALimit: Integer);
var
  AItems: PItemList;
begin
  if ALimit < Count then ALimit := Count;
  if ALimit > MaxCollectionSize then ALimit := MaxCollectionSize;
  if ALimit <> Limit then
  begin
    if ALimit = 0 then
      AItems := nil
    else
    begin
      GetMem(AItems, ALimit * SizeOf(Pointer));
      if (Count <> 0) and (Items <> nil) then
        Move(Items^, AItems^, Count * SizeOf(Pointer));
    end;
    if Limit <> 0 then FreeMem(Items, Limit * SizeOf(Pointer));
    Items := AItems;
    Limit := ALimit;
  end;
end;

{ --------------------------------------- }
constructor TChnCollection.Init;
begin
   inherited Init(10,10);
end;

{ --------------------------------------- }
procedure TChnCollection.Insert(Item: tAddChnVirt);
var
  NN: set of 0..255;
  p:tAddChnVirt;
  i:Integer;
begin
  NN:=[0];
  p:=nil;
  for i:=0 to Count-1 do
  begin
    if Item.ChName=Items^[i].ChName then
    begin
      p:=Items^[i];
      Break;
    end
    else
    begin
      NN:=NN+[Items^[i].ChNumName shr 8];
    end;
  end;
  if p=nil then
  begin
    i:=0;
    while i in NN do Inc(i);
    if Item.ChNumName=0 then
      Item.ChNumName:=i shl 8;
    inherited Insert(Item);
  end;
end;

{ --------------------------------------- }
procedure TChnCollection.ChInsert(Chn: tChnVirt);
var
  pAdd: tAddChannel;
  Fl  : Boolean;
  i   : Integer;
begin
  Fl:=True;
  for i:=0 to Count-1 do
  begin
    if Chn.CH_Name=Items^[i].ChName then
    begin
      Fl:=False;
      Break;
    end;
  end;
  if Fl then
  begin
    pAdd:=tAddChannel.Init(Chn);
    Insert(pAdd);
  end;
end;

{ --------------------------------------- }
procedure TChnCollection.ChDelete(Chn: tChnVirt);
var
  pAdd: tAddChnVirt;
  i   : Integer;
begin
  pAdd:=nil;
  for i:=0 to Count-1 do
  begin
    if Chn.CH_Name=Items^[i].ChName then
    begin
      pAdd:=Items^[i];
      Break;
    end;
  end;
  if pAdd<>nil then
    Delete(pAdd);
end;

{ ---------------------------------------- }
function TChnCollection.ChNewInit(Name: tChName): tChnVirt;
{ nalezne v ChnCollection prvni prvek s danym jmenem,
  vytvori instanci a inicializaci prislusneho kom.objektu,
  navraci pointer na vytvoreny kom.objekt,
  nenalezne-li prvek s danym jmenem, vraci nil. }
var
  p: tAddChnVirt;
  i: Integer;
begin
  p:=nil;
  for i:=0 to Count-1 do
  begin
    if Name=Items^[i].ChName then
    begin
      p:=Items[i];
      Break;
    end;
  end;
  if p<>nil then
    ChNewInit:=p.ChInit
  else
    ChNewInit:=nil;
end;

{ ---------------------------------------- }
function TChnCollection.ChNumName(Name: tChName): tChNumName;
{ nalezne v ChnCollection prvni prvek s danym jmenem Name
  a navrati jeho index jako hodnotu jeho ciselneho jmena NumName }
var
  P:tAddChnVirt;
  i:Integer;
begin
  p:=nil;
  for i:=0 to Count-1 do
  begin
    if Name=Items^[i].ChName then
    begin
      p:=Items[i];
      Break;
    end;
  end;
  if P<>nil then
    ChNumName:=P.ChNumName
  else
    ChNumName:=0;
end;

{ ---------------------------------------- }
function TChnCollection.ChName(NumName: tChNumName): tChName;
{ nalezne v ChnCollection prvni prvek s danym ciselnym jmenem NumName
  a navrati jeho textove jmeno Name }
var
  P:tAddChnVirt;
  i:Integer;
begin
  NumName:=NumName and $FF00; { pro jistotu orizneme spodni byte }
  p:=nil;
  for i:=0 to Count-1 do
  begin
    if NumName=Items^[i].ChNumName then
    begin
      p:=Items[i];
      Break;
    end;
  end;
  if P<>nil then
    ChName:=P.ChName
  else
    ChName:='';
end;

{ ---------------------------------------- }
function  TChnCollection.ChNumNameClass(NumName: tChNumName) : TClass;
{ nalezne v ChnCollection prvni prvek s danym ciselnym jmenem
  NumName a vrati jeho typ tridy}
var
  P:tAddChnVirt;
  i:Integer;
begin
  NumName:=NumName and $FF00; { pro jistotu orizneme spodni byte }
  p:=nil;
  for i:=0 to Count-1 do
  begin
    if NumName=Items^[i].ChNumName then
    begin
      p:=Items[i];
      Break;
    end;
  end;
  if Assigned(P) then
    if Assigned(P.Channel) then
      ChNumNameClass:=P.Channel.ClassType
    else
      ChNumNameClass:=TObject
  else
    ChNumNameClass:=TObject;
end;

{ ---------------------------------------- }
function  TChnCollection.ChNameClass(Name: tChName) : TClass;
{ nalezne v ChnCollection prvni prvek s danym jmenem
  Name a vrati jeho typ tridy; pokud prvek nenalezne vrati TObject}
var
  P:tAddChnVirt;
  i:Integer;
begin
  p:=nil;
  for i:=0 to Count-1 do
  begin
    if Name=Items^[i].ChName then
    begin
      p:=Items[i];
      Break;
    end;
  end;
  if Assigned(P) then
    if Assigned(P.Channel) then
      ChNameClass:=P.Channel.ClassType
    else
      ChNameClass:=TObject
  else
    ChNameClass:=TObject;
end;

{ ---------------------------------------- }
function TChnCollection.ChAllName: String;
{ vrati vsechna textova jmena dostupnych kom.objektu v collection }
var
  i : Integer;
begin
  Result:='';
  for i:=0 to Count-1 do
  begin
    if Length(Result)<(255-10) then
      Result:=Result+' '+Items[I].ChName
    else
      Result:=Result+'...';
  end;
end;

{ ---------------------------------------- }
function TChnCollection.ChAllNumName: String;
{ vrati vsechna textiva i ciselna jmena dostupnych kom.objektu v collection }
var
  i : Integer;
begin
  Result:='';
  for i:=0 to Count-1 do
  begin
    if Length(Result)<(255-10) then
      Result:=Result+' '+Items^[i].ChName+'='+IntToStr(Items^[i].ChNumName)
    else
      Result:=Result+'...';
  end;
end;

{ ================= object tChnVirt ===================== }
constructor TChnVirt.Init;
begin
  Create;
  CH_Type    := cName;              { jmena typu }
  CH_Name    := CH_Type;            { uzivatelske jmeno }
  CH_NumName := ChNumName(CH_Type); { definovani ciselneho jmena }
  CH_NumNameParents := CH_NumName;  { definovani jmena rodicovskeho komunikacniho objektu }
                                    { ChnVirt je prvni, proto ma jmeno rodice stejne se svym }
  CH_Chn     := nil;
  CH_Ctrl    := CHS_Close;
  CH_State   := CHS_Close;
  CH_RCtrl   := CHS_ReceiveNoReady;
  CH_SCtrl   := CHS_SendNoReady;     {!Ka}
  CH_Result  := res_Ok;
  CH_RResult := res_Ok;
  CH_SResult := res_Ok;
  CH_Node    := 0;
  CH_DNode   := 0;
  CH_RSNode  := 0;
  CH_RDNode  := 0;
  CH_RBuff   := nil;
  CH_MRBuff  := 0;
  CH_RMess   := nil;
  CH_MRMess  := 0;
end;

{ ---------------------------------------- }
constructor TChnVirt.ChInitParam(const S: tParamStr);
begin
  Init;
  ChSetParam(S);
  { CH_Result nastavuje ChSetParam }
end;

{ ---------------------------------------- }
destructor TChnVirt.Destroy;
begin
  if ChState<>CHS_Close then { uzavreni kanalu }
  begin
    ChClose;
    repeat
    until ChReady=CHS_Close;
  end;
  if Assigned(CH_Chn) then  { pripadne zruseni podrizeneho kom.objektu }
  begin
    CH_Chn.Free;
    CH_Chn:=nil;
  end;
  if Assigned(CH_RBuff) then   { pripadne uvolneni prijimaciho bufferu }
  begin
    FreeMem(CH_RBuff,CH_MRBuff);
    CH_RBuff:=nil;
  end;
  inherited;
end;

{ ---------------------------------------- }
procedure TChnVirt.Done;
begin
  Free;
end;

{ ---------------------------------------- }
class function  TChnVirt.ChNumName(Name: tChName): tChNumName;
begin
  ChNumName:=ChnCollection.ChNumName(Name);
end;

{ ---------------------------------------- }
class function  TChnVirt.ChName(NumName: tChNumName): tChName;
begin
  ChName:=ChnCollection.ChName(NumName and $FF00 { pro jistotu orizneme spodni byte });
end;

{ ---------------------------------------- }
class function  TChnVirt.ChNumNameClass(NumName: tChNumName) : TClass;
begin
  ChNumNameClass:=ChnCollection.ChNumNameClass(NumName and $FF00 { pro jistotu orizneme spodni byte });
end;

{ ---------------------------------------- }
class function  TChnVirt.ChNameClass(Name: tChName) : TClass;
begin
  ChNameClass:=ChnCollection.ChNameClass(Name);
end;

{ ---------------------------------------- }
class function  TChnVirt.ChAllNumName: String;
begin
  ChAllNumName:=ChnCollection.ChAllNumName;
end;

{ ---------------------------------------- }
class function  TChnVirt.ChAllName: String;
begin
  ChAllName:=ChnCollection.ChAllName;
end;

{ ---------------------------------------- }
procedure TChnVirt.ChSetParam(const S: tParamStr);
{ dekodovani parametru do oddelovace "|" nebo do ciziho jmena
  a predani zbytku parametru dalsi zretezene knihovne
  inherited nelze volat }
type
  tParam = (P_ERR
            );
const
  StrParam = '   |';
var
  PomS   : tWordString;
  PomRes : tChResult;
  Param  : tParam;
  CmdL   : tCmd;
begin
  CmdL:=tCmd.Create;
  CmdL.InitCmd(S);
  PomS:=CmdL.ReadWordUpCase;
  PomRes:=res_Ok;
  while (Poms<>'') and (PomRes=res_Ok) do
  begin
    Param:=tParam(NDELIM(PomS,StrParam));
    case Param of
      P_ERR:
        PomRes:=ChSetOneParam(PomS,CmdL);
    end; {case}
    Poms:=CmdL.ReadWordUpCase;
  end;
  ChSetResult(PomRes);
  CmdL.Free;
end;

{ ---------------------------------------- }
function TChnVirt.ChSetOneParam(const S: tWordString; var CmdL: tCmd): tChResult;
{ dekodovani default parametru }
{ inherited mozno volat }
type
  tParam = (P_ERR,
            P_TYP,    { jmeno typu kom.objektu }
            P_NAM,    { uzivatelske jmeno kom.objektu }
            P_DNA,    { definovani noveho uzivatelskeho jmena kom.objektu }
            P_CNA,    { nastaveni uzivatelskeho jmena kom.objektu na implic. hodnotu }
            P_DONE,   { zrusi vytvorenou instanci podrizeneho kom.objektu }
            P_NIL
            );
const
  StrParam = 'TYP|NAM|DNA|CNA|DON|NIL';
var
  PomName : tChName;
  PomRes  : tChResult;
  Param   : tParam;
begin
  PomRes:=res_Ok;
  if S='|' then
  begin
    ChNextSetParam(CmdL.ReadRest);
    PomRes:=ChResult;
  end
  else
  begin
    Param:=tParam(NDELIM(S,StrParam));
    case Param of
      P_ERR:
        { nejsou zadne zdedene parametry }
        PomRes:=CH_NumName or res_ErrParamStr;
      P_TYP:
        begin
          PomName:=CmdL.ReadWordUpCase;
          if PomName<>CH_Type then
          begin
            ChNextSetParam('TYP='+PomName+' '+CmdL.ReadRest);
            PomRes:=ChResult;
          end;
        end;
      P_NAM:
        begin
          PomName:=CmdL.ReadWordUpCase;
          if (PomName<>CH_Name)and(PomName<>CH_Type) then
          begin
            ChNextSetParam('NAM='+PomName+' '+CmdL.ReadRest);
            PomRes:=ChResult;
          end;
        end;
      P_DNA:
        begin
          PomName:=CmdL.ReadWordUpCase;
          if CH_Name=CH_Type then
          begin
            CH_Name:=PomName;
            ChnCollection.ChInsert(Self);
          end
          else
            PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_CNA:
        begin
          ChnCollection.ChDelete(Self);
          CH_Name:=CH_Type;
        end;
      P_DONE :
        begin
          if Assigned(CH_Chn) then
          begin
            CH_Chn.Free;
            CH_Chn:=nil;
          end;
        end;
      P_NIL :
        begin
          if Assigned(CH_Chn) then
          begin
            if CH_Chn.CH_Name<>CH_Chn.CH_Type then
              CH_Chn:=nil
            else
              PomRes:=CH_NumName or res_ErrParamStr;
          end;
        end;
    end; {case}
  end;
  ChSetOneParam:=PomRes;
end;

{ ---------------------------------------- }
procedure TChnVirt.ChNextSetParam(const S: tParamStr);
{ tuto metodu volame pri predani zbytku parametru dalsi zretezene knihovne
  inherited nelze volat, volat jen v metode ChSetParam }
type
  tParam = (P_ERR,
            P_TYP,    { jmeno typu kom.objektu }
            P_NAM     { uzivatelske jmeno kom.objektu }
            );
const
  StrParam = 'TYP|NAM|';
var
  PomS    : tChName;
  PomName : tChName;
  Param   : TParam;
  CmdL    : tCmd;
begin
  if S<>'' then
  begin
    if Assigned(CH_Chn) then
    begin
      CH_Chn.ChSetParam(S);
      ChSetResult(CH_Chn.ChResult);
    end
    else
    begin
      PomName:='';
      CmdL:=tCmd.Create;
      CmdL.InitCmd(S);
      Poms:=CmdL.ReadWordUpCase;
      while (Poms<>'') do
      begin
        Param:=tParam(NDELIM(Poms,StrParam));
        case Param of
          P_ERR: ;
          P_TYP,
          P_NAM: begin
                   PomName:=CmdL.ReadWordUpCase;
                   Break;
                 end;
        end; {case}
        Poms:=CmdL.ReadWordUpCase;
      end;
      CmdL.Free;
      CH_Chn:=ChnCollection.ChNewInit(PomName);
      if not Assigned(CH_Chn) then
        ChSetResult(CH_NumName or res_ErrChannelNoExist)
      else
      begin
        CH_Chn.ChSetParam(S);
        ChSetResult(CH_Chn.ChResult);
      end;
    end;
  end;
end;

{ ---------------------------------------- }
function TChnVirt.ChGetParam(const S: tParamStr): tParamStr;
{ navraci parametry kom.objektu a podrizenych }
{ inherited nelze volat }
begin
  if not Assigned(CH_Chn) then
  begin
    ChGetParam:='NAM='+CH_Name;
    ChSetResult(res_Ok);
  end
  else
  begin
    ChGetParam:='NAM='+CH_Name+' '+CH_Chn.ChGetParam(S); { volame tutez metodu z podrizeneho kom.objektu }
    ChSetResult(CH_Chn.ChResult);
  end;
end;

{ ---------------------------------------- }
procedure TChnVirt.ChSetBinParam(NumName: tChNumName; Code: Word; Param: longint);
{ umoznuje v binarnim tvaru nastavit parametry nebo provadet prikazy }
{ inherited mozno volat }
begin
  NumName:=NumName and $FF00; { pro jistotu orizneme spodni byte }
  if NumName=CH_NumName then
  begin
    { zde vykonani prikazu Code nebo ulozeni hodnoty Param do parametru Code }
    ChSetResult(CH_NumName or res_Err);
  end
  else
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChSetBinParam(NumName,Code,Param);
    ChSetResult(CH_Chn.ChResult);
  end
  else
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
end;

{ ---------------------------------------- }
function  TChnVirt.ChGetBinParam(NumName: tChNumName; Code: Word): longint;
{ umoznuje v binarnim tvaru cist parametry nebo stav }
{ inherited mozno volat }
begin
  NumName:=NumName and $FF00; { pro jistotu orizneme spodni byte }
  if NumName=CH_NumName then
  begin
    { ChGetBinParam:= vykonani prikazu Code nebo vyzvednuti hodnoty Param z parametru Code }
    ChGetBinParam:=0;
    ChSetResult(CH_NumName or res_Err);
    { ostatni knihovny zde mohou dekodovat hodnotu parametru Code a provadet prislusne akce }
  end
  else
  if Assigned(CH_Chn) then
  begin
    ChGetBinParam:=CH_Chn.ChGetBinParam(NumName,Code);
    ChSetResult(CH_Chn.ChResult);
  end
  else
  begin
    ChGetBinParam:=0;
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
  end;
end;

{ ---------------------------------------- }
function TChnVirt.ChState;
{ predefinovat pri transformaci dat, fyzickem rozhranni nebo nepozadujeme-li next.ChState }
{ inherited mozno volat }
begin
  if Assigned(CH_Chn) then
  begin
    CH_Ctrl :=CH_Chn.ChReady; { vola se ChTick zretezene knihovny }
    CH_State:=CH_Chn.CH_State;
    ChSetResult(CH_Chn.ChResult);
  end;
  ChTick;
  ChState:=CH_State;
end;

{ ---------------------------------------- }
function TChnVirt.ChReady;
{ predefinovat pri transformaci dat, fyzickem rozhranni nebo nepozadujeme-li next.ChReady }
{ inherited mozno volat }
begin
  if Assigned(CH_Chn) then
  begin
    CH_Ctrl :=CH_Chn.ChReady; { vola se ChTick zretezene knihovny }
    CH_State:=CH_Chn.CH_State;
    ChSetResult(CH_Chn.ChResult);
  end;
  ChTick;
  ChReady:=CH_Ctrl;
end;

{ ---------------------------------------- }
procedure TChnVirt.ChOpen;
{ predefinovat fyzickem rozhranni nebo nepozadujeme-li next.ChOpen }
{ inherited mozno volat }
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChOpen;
    ChSetResult(CH_Chn.ChResult);
    CH_Ctrl :=CH_Chn.CH_Ctrl;
    CH_State:=CH_Chn.CH_State;
  end
  else
  begin
    if CH_Ctrl=CHS_Close then
    begin
      CH_Ctrl :=CHS_Open;
      CH_State:=CH_Ctrl;
      ChSetResult(res_Ok);
    end
    else
      if CH_Ctrl<>CHS_Open then
        ChSetResult(CH_NumName or res_ErrNoClose);
  end;
end;

{ ---------------------------------------- }
procedure TChnVirt.ChClose;
{ predefinovat fyzickem rozhranni nebo nepozadujeme-li next.ChClose }
{ inherited mozno volat }
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChClose;
    ChSetResult(CH_Chn.ChResult);
    CH_Ctrl :=CH_Chn.CH_Ctrl;
    CH_State:=CH_Chn.CH_State;
  end
  else
  begin
    CH_Ctrl :=CHS_Close;
    CH_State:=CH_Ctrl;
    ChSetResult(res_Ok);
  end;
end;

{ ---------------------------------------- }
procedure TChnVirt.ChConnect;
{ predefinovat fyzickem rozhranni nebo nepozadujeme-li next.ChConnect }
{ inherited mozno volat }
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChConnect;
    ChSetResult(CH_Chn.ChResult);
    CH_Ctrl :=CH_Chn.CH_Ctrl;
    CH_State:=CH_Chn.CH_State;
  end
  else
  begin
    if CH_Ctrl=CHS_Open then
    begin
      CH_Ctrl :=CHS_Connect;
      CH_State:=CH_Ctrl;
      ChSetResult(res_Ok);
    end
    else
      if CH_Ctrl<>CHS_Connect then
        ChSetResult(CH_NumName or res_ErrNoOpen);
  end;
end;

{ ---------------------------------------- }
procedure TChnVirt.ChDisConnect;
{ predefinovat fyzickem rozhranni nebo nepozadujeme-li next.ChDisConnect }
{ inherited mozno volat }
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChDisConnect;
    ChSetResult(CH_Chn.ChResult);
    CH_Ctrl :=CH_Chn.CH_Ctrl;
    CH_State:=CH_Chn.CH_State;
  end
  else
  if (CH_Ctrl<>CHS_Close     )and
     (CH_Ctrl<>CHS_DisConnect)then
  begin
    CH_Ctrl :=CHS_DisConnect;
    CH_State:=CH_Ctrl;
    CH_RCtrl:=CHS_ReceiveNoReady;
    CH_SCtrl:=CHS_SendNoReady;
    ChSetResult(res_Ok);
  end;
end;

{ ---------------------------------------- }
procedure TChnVirt.ChDestNode(Node: TNode);
{ predefinovat nepozadujeme-li next.ChDestNode }
{ inherited nema smysl }
begin
  CH_DNode:=Node;     {z duvodu kompatibility}
  ChSetResult(res_Ok);
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChDestNode(Node);
    ChSetResult(CH_Chn.ChResult);
  end;
end;

{ ---------------------------------------- }
procedure TChnVirt.ChSend(Buff:pointer; Len:word);
{ predefinovat pri transformaci dat nebo fyzickem rozhranni }
{ inherited mozno volat po transformaci dat }
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChSend(Buff,Len);
    ChSetSendResult(CH_Chn.ChSendResult);
  end
  else
  begin
    if CH_Ctrl<>CHS_Connect then
      ChSetSendResult(CH_NumName or res_ErrNoConnect);
  end;
end;

{ ---------------------------------------- }
function TChnVirt.ChSendReady: TChState;
{ predefinovat pri fyzickem rozhranni nebo nepozadujeme-li next.ChSendReady }
{ inherited nema smysl }
begin
  ChSendTick;
  { nastavuje CH_SResult }
  if Assigned(CH_Chn) then
  begin
    ChSendReady:=CH_Chn.ChSendReady;
    ChSetSendResult(CH_Chn.ChSendResult);
  end
  else
    if CH_Ctrl=CHS_Connect then
      ChSendReady:=CH_SCtrl
    else
      ChSendReady:=CHS_SendNoReady;
end;

{ ---------------------------------------- }
procedure TChnVirt.ChSendFlush;
{ predefinovat pri fyzickem rozhranni nebo nepozadujeme-li next.ChSendFlush }
{ inherited nema smysl }
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChSendFlush;
    ChSetSendResult(CH_Chn.ChSendResult);
  end
  else
    if CH_Ctrl<>CHS_Connect then
      ChSetSendResult(CH_NumName or res_ErrNoConnect);
end;

{ ---------------------------------------- }
procedure TChnVirt.ChReceiveBuffer(Buff: pointer; Len: Word);
{ predefinovat pozadujeme-li next.ChReceiveBuffer }
{ inherited nema smysl }
begin
  CH_RMess:=Buff;
  CH_MRMess:=Len;
  ChSetReceiveResult(res_Ok);
end;

{ ---------------------------------------- }
function TChnVirt.ChReceiveReady: TChState;
{ predefinovat pri transformaci dat, fyzickem rozhranni nebo pozadujeme-li next.ChReceiveReady }
{ inherited mozno volat pred vlastnim telem }
begin
  ChReceiveTick;
  { nastavuje CH_RResult }
  if Assigned(CH_Chn) then
  begin
    ChReceiveReady:=CH_Chn.ChReceiveReady;
    ChSetReceiveResult(CH_Chn.ChReceiveResult);
  end
  else
    if CH_Ctrl=CHS_Connect then
      ChReceiveReady:=CH_RCtrl
    else
      ChReceiveReady:=CHS_ReceiveNoReady;
end;

{ ---------------------------------------- }
procedure TChnVirt.ChReceive(var Len: Word);
{ predefinovat pri transformaci dat, fyzickem rozhranni nebo nepozadujeme-li next.ChReceive }
{ inherited mozno volat pred transformaci dat }
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChReceive(Len);
    ChSetReceiveResult(CH_Chn.ChReceiveResult);
  end
  else
  begin
    Len:=0;
    ChSetReceiveResult(CH_NumName or res_ErrChannelNoExist);
  end;
end;

{ ---------------------------------------- }
function TChnVirt.ChReceiveChar: Byte;
{ predefinovat pri transformaci dat, fyzickem rozhranni nebo nepozadujeme-li next.ChReceiveChar }
{ inherited mozno volat pred transformaci dat }
begin
  if Assigned(CH_Chn) then
  begin
    ChReceiveChar:=CH_Chn.ChReceiveChar;
    ChSetReceiveResult(CH_Chn.ChReceiveResult);
  end
  else
  begin
    ChReceiveChar:=0;
    ChSetReceiveResult(CH_NumName or res_ErrChannelNoExist);
  end;
end;

{ ---------------------------------------- }
procedure TChnVirt.ChReceiveFlush;
{ predefinovat pri transformaci dat, fyzickem rozhranni nebo nepozadujeme-li next.ChReceiveFlush }
{ inherited mozno volat pred vlastnim telem }
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChReceiveFlush;
    ChSetReceiveResult(CH_Chn.ChReceiveResult);
  end
  else
    if CH_Ctrl<>CHS_Connect then
      ChSetReceiveResult(CH_NumName or res_ErrNoConnect);
end;

{ ---------------------------------------- }
procedure TChnVirt.ChGetNode(var SNode, DNode: TNode);
{ predefinovat nepozadujeme-li next.ChGetNode }
{ inherited nema smysl }
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChGetNode(SNode,DNode);
    ChSetReceiveResult(CH_Chn.ChReceiveResult);
  end
  else
  begin
    SNode:=CH_RSNode;
    DNode:=CH_RDNode;
    ChSetReceiveResult(res_Ok);
  end;
end;

{ ---------------------------------------- }
function TChnVirt.ChResult: TChResult;
{ predefinovat pozadujeme-li next.ChResult }
{ inherited nema smysl }
begin
  ChResult:=CH_Result;
  CH_Result:=res_Ok;
end;

{ ---------------------------------------- }
function TChnVirt.ChReceiveResult: TChResult;
{ predefinovat pozadujeme-li next.ChReceiveResult }
{ inherited nema smysl }
begin
  ChReceiveResult:=CH_RResult;
  CH_RResult:=res_Ok;
end;

{ ---------------------------------------- }
function TChnVirt.ChSendResult: TChResult;
{ predefinovat pozadujeme-li next.ChSendResult }
{ inherited nema smysl }
begin
  ChSendResult:=CH_SResult;
  CH_SResult:=res_Ok;
end;

{ ---------------------------------------- }
procedure TChnVirt.ChSetResult(Value:TChResult);
{ predefinovat nema smysl }
{ inherited nema smysl }
begin
  { nemaze pripadnou puvodni chybu }
  if CH_Result=res_Ok then CH_Result:=Value;
end;

{ ---------------------------------------- }
procedure TChnVirt.ChSetReceiveResult(Value:TChResult);
{ predefinovat nema smysl }
{ inherited nema smysl }
begin
  { nemaze pripadnou puvodni chybu }
  if CH_RResult=res_Ok then CH_RResult:=Value;
end;

{ ---------------------------------------- }
procedure TChnVirt.ChSetSendResult(Value:TChResult);
{ predefinovat nema smysl }
{ inherited nema smysl }
begin
  { nemaze pripadnou puvodni chybu }
  if CH_SResult=res_Ok then CH_SResult:=Value;
end;

{ ---------------------------------------- }
function  TChnVirt.ChResultStr       (Sts : tChResult) : tResultStr;
{ mozno predefinovat }
{ mozno volat inherited }
begin
  if Sts and $FF00 = CH_NumName then
    case Lo(Sts) of
      res_Ok                : ChResultStr:='Ok';
      res_ErrNoReceiveReady : ChResultStr:='Not Receive Ready';
      res_ErrNoSendReady    : ChResultStr:='Not Send Ready';
      res_ErrNoClose        : ChResultStr:='Not Close';
      res_ErrNoOpen         : ChResultStr:='Not Open';
      res_ErrNoConnect      : ChResultStr:='Not Connect';
      res_ErrOpen           : ChResultStr:='Open Error';
      res_ErrConnect        : ChResultStr:='Connect Error';
      res_ErrDisConnect     : ChResultStr:='DisConnect Error';
      res_ErrClose          : ChResultStr:='Close Error';
      res_ErrIllegalUnit    : ChResultStr:='Next Channel is Inadmissible';
      res_ErrChannelNoExist : ChResultStr:='Next Channel Not Exists';
      res_ErrParamStr       : ChResultStr:='ParamString Error';
      res_Err               : ChResultStr:='Global Error';
      else                    ChResultStr:='';
    end
  else
    if Assigned(CH_Chn) then
      ChResultStr:=CH_Chn.ChResultStr(Sts)
    else
      ChResultStr:='Unknown Error for this Channel $'+IntToHex(Sts,4);
end;

{ ---------------------------------------- }
procedure TChnVirt.ChTick;
{ predefinovat pri transformaci dat nebo fyzickem rozhranni }
{ inherited nema smysl, nikdy nevolat next.ChTick }
begin
  ChSetResult(res_Ok);
end;

{ ---------------------------------------- }
procedure TChnVirt.ChSendTick;
{ predefinovat pri transformaci dat nebo fyzickem rozhranni }
{ inherited nema smysl, nikdy nevolat next.ChSendTick }
begin
  ChSetSendResult(res_Ok);
end;

{ ---------------------------------------- }
procedure TChnVirt.ChReceiveTick;
{ predefinovat pri transformaci dat nebo fyzickem rozhranni }
{ inherited nema smysl, nikdy nevolat next.ChReceiveTick }
begin
  ChSetReceiveResult(res_Ok);
end;

{ ---------------------------------------- }
function  TChnVirt.ChGetLastChn : tChnVirt;
var PomChn:tChnVirt;
begin
  PomChn:=Self;
  while Assigned(PomChn.CH_Chn) do PomChn:=PomChn.CH_Chn;
  ChGetLastChn:=PomChn;
end;

{ ---------------------------------------- }
function  TChnVirt.ChGetLastClass : TClassChnVirt;
var PomChn:tChnVirt;
begin
  PomChn:=Self;
  while Assigned(PomChn.CH_Chn) do PomChn:=PomChn.CH_Chn;
  Pointer(Result) := PPointer(PomChn)^;
end;

{ ---------------------------------------- }
function  TChnVirt.ChGetNumChn : byte;
var PomChn:tChnVirt;
begin
  Result:=1;
  PomChn:=CH_Chn;
  while Assigned(PomChn) do
  begin
    Result:=Result+1;
    PomChn:=PomChn.CH_Chn;
  end;
end;
{ =============================================================== }

var
  ExitSave: Pointer;

{$F+}
procedure ChnVirtExit;
begin
  ExitProc:=ExitSave;
  if Assigned(ChnCollection) then
  begin
    ChnCollection.Free;
    ChnCollection:=nil;
  end;
end;
{$F-}

Begin
  ExitSave:=ExitProc;
  ExitProc:=@ChnVirtExit;

  ChnCollection:=tChnCollection.Init;

 { dalsi kom. knihovny zde zpristupnuji dany kom.objekt }
  { ChnCollection.Insert(tAddChnXxx.Init(nil)); }
  ChnCollection.Insert(tAddChnVirt.Init(Nil));
End.
