unit ChnLecom;

          {ͻ}
          {                                                        }
          {  unit ChnLecom                                         }
          {                                                        }
          {  jednotka definujici komunikacni protokol Lecom        }
          {                                                        }
          {  (C)1997 SofCon, Steovick 49, 160 00 Praha 6        }
          {          Ing. Vladimr Kastner, Na Vlovce 6, Praha 6  }
          {               Adam Wild, Dejvicka 42, Praha 6          }
          {ͼ}

interface

uses
  ChnVirt,
  uString,
  Timer,
  Xor8;

const
  cName   = 'LECOM';
  cVer    = 'v4.3, 22.03.1999';

const
  ACK     = $06;
  ENQ     = $05;
  EOT     = $04;
  ETX     = $03;
  NAK     = $15;
  STX     = $02;

  res_ErrSum   = $20; { chyba kontrolniho souctu BCC }
  res_ErrEOT   = $21; { chyba - prijmut EOT znak }
  res_ErrLen   = $22; { chyba delky zpravy }
  res_ErrVal   = $23; { chyba ciselne hodnoty }

  cSLen   = 15;  { maximalni delka retezce }
  cRLen   = 12;  { maximalni delka realneho cisla }
  cWLen   =  8;  { maximalni delka hexadecimalniho cisla }
  cOLen   = 15;  { maximalni delka stringu v oktalovem formatu }

const
  MaxCode = 6229;

type
  tRW      = (Rd,Wr);
  tCode    = 0..65535;
  tSubCode = 0..255;
  tParam   = (tpReal, tpByte, tpWord, tpLong, tpString, tpOktStr);

type
  pSendRecord = ^tSendRecord;
  tSendRecord = record
    Code    : tCode;
    SubCode : tSubCode;
    case RW : tRW of
      Wr :
        (case Par : tParam of
           tpReal   : (R : Real);
           tpByte   : (B : Byte);
           tpWord   : (W : Word);
           tpLong   : (L : Longint);
           tpString : (S : String[cSLen]);
           tpOktStr : (O : Longint);
        );
      Rd :
        ( );
  end;

  pRecRecord = ^tRecRecord;
  tRecRecord = tSendRecord;

  tRec = (Znk, ACKZnk, NAKZnk, STXZnk, ETXZnk, EOTZnk, ENQZnk, NoZnk, Err);

type
  tChnLecom = class(tChnVirt)
    CH_RTick   : LongBool; { je vykonavana cinnost prijimaciho automatu }
    CH_SBuff   : Pointer;  { vysilaci buffer }
    CH_MSBuff  : Word;     { delka vysilaciho bufferu }
    CH_RSum    : tXor8;    { kontrolni soucet prijimace }
    CH_SSum    : tXor8;    { kontrolni soucet vysilace }
    CH_Master  : Boolean;  { master / slave jednotka }
    CH_UseSCD  : Boolean;  { pouzivani/nepouuzivani subcodu }

    constructor Init;                      { vytvoreni objektu }
    constructor ChInitParam(const S: tParamStr); { vytvoreni objektu a nastaveni parametru }
    destructor  Destroy;
                  override; { zruseni objektu }

    { zadani a zobrazeni zadanych parametru }
   protected
    function  ChSetOneParam(const S: tWordString; var CmdL: tCmd): tChResult;
                override; { nove nastaveni jednoho parametru textove }
   published
    function  ChGetParam   (const S: tParamStr): tParamStr;
                override; { prevod parametru kanalu do stringu }

    { otevreni a zavreni HW kanalu, navazani a zruseni komunikace }
    procedure ChConnect;
                override; { pocatek navazovani spojeni }
    procedure ChDisConnect;
                override; { pocatek ukonceni spojeni }

    { vysilani dat }
    procedure ChSend(Buff: Pointer; Len: Word);
                override; { pocatek vysilani }

    { prijem dat }
    function  ChReceiveReady: TChState;
                override; { vrati aktualni stav automatu prijimace }
    procedure ChReceive(var Len: Word);
                override; { prijem zpravy }
    procedure ChReceiveFlush;
                override; { stav jako po inicializaci }
    procedure ChGetNode(var SNode, DNode: TNode);
                override; { ziskani odesilatele a adresata z prijmute zpravy }

    function  ChResultStr (Sts  : TChResult) : tResultStr;
                override; { vrati retezec s popisem vysledku operace }

    { provedeni kroku automatu kanalu, vysilace, prijimace }
    procedure ChReceiveTick;
                override; { krok automatu prijimace }

  private
    { presunuto z ChReceiveTick - obsah nasledujicich 4 promennych
      se jinak pri prepnuti master/slave ztratil }
    R_C1        : word;
    R_PomS      : String[4];
    R_NewCode   : Boolean; { jednali se o nove kodovani nebo standartniho
                             kodovani pri prijimani Code }
    R_WhatCode  : 0..6;    { o jake cislo z Code se jedna }

    function  RecB(var Data: Byte): TRec;
    function  Rec (var Data: Byte): TRec;
  end;

type
  TAddChnLecom = class(TAddChnVirt)
    function ChInit: tChnVirt; override; { funkce provadejici zalozeni a inicializaci daneho kanalu }
  end;

const
  MaxTBuf = 32750;  { max. velikost vyslacho bufferu }

{----------}
implementation
{----------}

uses
 {$ifdef HardLock}
  HardLock,
 {$endif}
  Windows,
  SysUtils;

const
  CHS_ReceiveBeginMa   = 2;
  CHS_ReceiveCodeH     = 3;
  CHS_ReceiveCodeL     = 4;
  CHS_ReceiveData      = 5;
  CHS_ReceiveDataR     = 6;
  CHS_ReceiveDataH     = 7;
  CHS_ReceiveDataS     = 8;
  CHS_ReceiveBCC       = 9;
  CHS_ReceiveErrSumSl  = 10;
  CHS_ReceiveBCC2      = 11;
  CHS_ReceiveBeginSl   = 20;
  CHS_ReceiveAD1       = 21;
  CHS_ReceiveAD2       = 22;
  CHS_ReceiveSlX       = 23;
  CHS_ReceiveCodeLSlR  = 24;
  CHS_ReceiveCodeHSlS  = 25;
  CHS_ReceiveEnq       = 26;
  CHS_ReceiveDataO     = 27;

{--------------------}
function ReverseStr(const S:string):string;
  {prevrati poradi znaku v retezci}
var
  PomS:string;
  I   :byte;
begin
  PomS:='';
  for I:=Length(S) downto 1 do
    PomS:=PomS+S[I];
  ReverseStr:=PomS;
end;
{--------------------}
const
  KonvTable : array[$0..$F] of char = '0123456789ABCDEF'; { pomocne pole znaku pro prevody cisel na string }

function  IntToOct (I : Integer): ShortString;
  {prevede cislo na retezec v oktalove reprezentaci cisla}
var
  TmpS : ShortString;
begin
  TmpS:='';
  repeat
    Insert(KonvTable[I-((I shr 3) shl 3)],TmpS,1);
    I:=I shr 3;
  until I=0;
  IntToOct := TmpS;
end;
{--------------------}
function  StrToHex (const S : string): integer;
  {prevede retezec s hexadecimalni reprezentaci cisla na cislo}
var I:integer;
    L:integer;
begin
  L:=0;
  for I:=1 to Length(S) do
    case S[I] of
      '0'..'9': L:=(L shl 4)+(Ord(S[I])-Ord('0'));
      'A'..'F',
      'a'..'f': L:=(L shl 4)+(Ord(UpCase(S[I]))-Ord('A')+10);
    end;
  StrToHex:=L;
end;
{--------------------}
function  StrToOct (const S : string): integer;
  {prevede retezec s oktalovou reprezentaci cisla na cislo}
var I:integer;
    L:integer;
begin
  L:=0;
  for I:=1 to Length(S) do
    if S[I] in ['0'..'7']then
      L:=(L shl 3)+(Ord(S[I])-Ord('0'));
  StrToOct:=L;
end;

{--------------------}
function TAddChnLecom.ChInit: tChnVirt;
begin
  ChInit:=tChnLecom.Init;
end;

type
  PAByte = ^TAByte;
  TAByte = array[0..65534]of byte;

{ =============================================================== }
constructor tChnLecom.Init;
begin
  inherited;
  CH_Type    := cName;
  CH_Name    := CH_Type;
  CH_NumName := ChNumName(CH_Type);
  CH_RTick   := false;
  CH_SBuff   := nil;
  CH_MSBuff  := 0;
  CH_RSNode  := 0;
  CH_RDNode  := 0;
  CH_Master  := false;
  CH_UseSCD  := false;
  CH_RSum    := tXor8.Init;
  CH_SSum    := tXor8.Init;
end;

{ ---------------------------------------- }
constructor tChnLecom.ChInitParam(const S: tParamStr);
begin
  Init;
  ChSetParam(S);
  { CH_Result nastavuje ChSetParam }
end;

{ ---------------------------------------- }
destructor tChnLecom.Destroy;
begin
  if CH_SBuff<>nil then
  begin
    FreeMem(CH_SBuff,CH_MSBuff);
    CH_SBuff:=nil;
  end;
  CH_RSum.Done;
  CH_SSum.Done;
  inherited;
  { CH_Result nastavuje Done }
end;

{ ---------------------------------------- }
function tChnLecom.ChSetOneParam(const S: tWordString; var CmdL: tCmd): tChResult;
          { typicka syntaxe : NAM=LECOM LSB=100 NODE=1 DNODE=2 | ... }
type
  tParam = (P_ERR,
            P_MASL,   { master / slave jednotka }
            P_LSB,    { velikost vysilaciho bufferu }
            P_NODE,   { node stanice }
            P_DNODE,  { node adresata }
            P_SCD     { pouzivani subcodu }
            );
const
  StrParam = 'MAS|LSB|NOD|DNO|SCD|';
var
  PomS    : tWordString;
  PomRes  : tChResult;
  Param   : tParam;
  ErrFl   : boolean;
  PomL    : longint;
begin
  PomRes:=res_Ok;
  if S='|' then
  begin
    ChNextSetParam(CmdL.ReadRest);
    PomRes:=ChResult;
  end
  else
  begin
    Param:=tParam(NDELIM(S,StrParam));
    case Param of
      P_ERR:
        PomRes:=inherited ChSetOneParam(S,CmdL);
      P_MASL:
        begin
          PomS:=CmdL.ReadWordUpCase;
          if PomS='MASTER' then CH_Master:=true
          else
          if PomS='SLAVE'  then CH_Master:=false
          else
          PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_LSB:
        begin
          CmdL.ReadLVal(Poml,ErrFl);
          if not ErrFl then
            if (PomL>=1) and (PomL<=MaxTBuf) then
            begin
              if CH_SBuff<>nil then
                FreeMem(CH_SBuff,CH_MSBuff);
              GetMem(CH_SBuff,PomL);
              CH_MSBuff:=PomL;
            end
            else
              ErrFl:=true;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_NODE:
        begin
          CmdL.ReadLVal(Poml,ErrFl);
          if not ErrFl then
            if (PomL>=0) and (PomL<=255) then
              CH_Node:=PomL
            else
              ErrFl:=true;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_DNODE:
        begin
          CmdL.ReadLVal(PomL,ErrFl);
          if not ErrFl then
            if (PomL>=0) and (PomL<=255) then
              CH_DNode:=PomL
            else
              ErrFl:=true;
          if ErrFl then PomRes:=CH_NumName or res_ErrParamStr;
        end;
      P_SCD:
        begin
          PomS:=CmdL.ReadWordUpCase;
          if PomS='ON'  then CH_UseSCD:=true
          else
          if PomS='OFF' then CH_UseSCD:=false
          else
          PomRes:=CH_NumName or res_ErrParamStr;
        end;
      end; {case}
    end;
  ChSetOneParam:=PomRes;
end;

{ ---------------------------------------- }
function tChnLecom.ChGetParam(const S: tParamStr): tParamStr;
var
  ss : tParamStr;
begin
  ss:='NAM='+CH_Name+
     ' MAS=';
  if CH_Master then ss:=ss+'MASTER'
  else ss:=ss+'SLAVE';
  ss:=ss+' LSB='+LStr(CH_MSBuff)+
         ' NOD='+LStr(CH_Node)+
         ' DNO='+LStr(CH_DNode)+
         ' SCD=';
  if CH_UseSCD then ss:=ss+'ON'
  else ss:=ss+'OFF';
  ChSetResult(res_Ok);
  if Assigned(CH_Chn) then
  begin
    ss:=ss+' '+CH_Chn.ChGetParam(S);
    ChSetResult(CH_Chn.ChResult);
  end;
  ChGetParam:=ss;
end;

{ ---------------------------------------- }
procedure tChnLecom.ChConnect;
begin
  inherited;
  if CH_Result=res_Ok then
    if CH_Master then
      CH_RCtrl := CHS_ReceiveBeginMa
    else
      CH_RCtrl := CHS_ReceiveBeginSl;
end;

{ ---------------------------------------- }
procedure tChnLecom.ChDisConnect;
begin
  inherited;
  if CH_Result=res_Ok then
     CH_RCtrl := CHS_ReceiveNoReady;
end;

{ ---------------------------------------- }
procedure tChnLecom.ChSend(Buff: Pointer; Len: Word);
  {----------}
  procedure MessSend(var LBuf: word; var Sts: word);
  var
    J : Word;
    {----------}
    procedure Send(B: Byte);
    begin
      PAByte(CH_SBuff)^[J]:=B;
      CH_SSum.MakeSum(B);
      if J<CH_MSBuff-1 then Inc(J);
    end;
    {----------}
    procedure SendNode(Nod: Byte);    { vysle Node }
    begin
      Send(Ord('0')+(Nod div 10));
      Send(Ord('0')+(Nod mod 10));
    end;
    {----------}
    procedure SendCode(Cod: Word; SbCod: Byte);    { vysle code }
    var
      ss : String[cSLen];
      ii : Byte;
    begin
      if CH_UseSCD then
        begin
          ss:='!'+IntToHex(Cod,4)+IntToHex(SbCod,2);
          for ii:=1 to 7 do
            Send(Ord(ss[ii]));
        end
      else
        begin
          Send(((Cod mod 790)div 10)+Ord('0'));
          Send(((Cod mod 790)mod 10)+(Cod div 790)*10+Ord('0'));
        end;
    end;
    {----------}
  var
    ss  : String[cSLen];
    ii  : Byte;
  begin
    with CH_SSum, PSendRecord(Buff)^ do
      begin
        J:=0;
        if CH_Master then
       { Master }
        begin
          Send(EOT);
          SendNode(CH_DNode);
          case RW of
            Rd :
              begin
                SendCode(Code,SubCode);
                Send(ENQ);
              end;
            Wr :
              begin
                Send(STX);
                SetSum(0);
                SendCode(Code,SubCode);
                case Par of
                  tpReal :
                    begin
                      ss:=FloatToStrF(R,ffGeneral,cRLen-1,cRLen);
                      if Pos(',',ss)<>0 then ss[Pos(',',ss)]:='.';
                      if ss[Length(ss)]='.' then Delete(ss,Length(ss),1);
                      for ii:=1 to Length(ss) do
                        Send(Ord(ss[ii]));
                    end;

                  tpByte :
                    begin
                      Send(Ord('H'));
                      ss:=IntToHex(B,2);
                      for ii:=1 to Length(ss) do
                        Send(Ord(ss[ii]));
                    end;

                  tpWord :
                    begin
                      Send(Ord('H'));
                      ss:=IntToHex(W,4);
                      for ii:=1 to Length(ss) do
                        Send(Ord(ss[ii]));
                    end;

                  tpLong :
                    begin
                      Send(Ord('H'));
                      ss:=IntToHex(L,8);
                      for ii:=1 to Length(ss) do
                        Send(Ord(ss[ii]));
                    end;

                  tpString :
                    begin
                      Send(Ord('S'));
                      if Length(S)>cSLen then SetLength(S,cSLen);
                      for ii:=1 to Length(S) do
                        Send(Ord(S[ii]));
                    end;

                  tpOktStr :
                    begin
                      Send(Ord('O'));
                      ss:=IntToOct (O);
                      ss:=ReverseStr(ss);
                      for ii:=1 to Length(ss) do
                        Send(Ord(ss[ii]));
                    end;
                end;
                Send(ETX);
                Send(GetSum);
              end;
          end;
        end
        else
       { Slave }
        begin
          case RW of
            Rd :
              begin
                if Length(S)>0 then
                   case S[1] of
                     Chr(ACK), Chr(NAK) :
                       begin
                         Send(Ord(s[1]));
                       end;
                     '?' :
                       begin
                         Send(STX);
                         SetSum(0);
                         SendCode(Code,SubCode);
                         Send(Ord('?'));
                         Send(ETX);
                         Send(GetSum);
                       end;
                     Chr(EOT) :
                       begin
                         Send(STX);
                         SendCode(Code,SubCode);
                         Send(EOT);
                       end;
                   end
                else
                  begin
                    Send(STX);
                    SendCode(Code,SubCode);
                    Send(EOT);
                  end;
              end;
            Wr :
              begin
                Send(STX);
                SetSum(0);
                SendCode(Code,SubCode);
                case Par of
                  tpReal :
                    begin
                      ss:=FloatToStrF(R,ffGeneral,cRLen-1,cRLen);
                      if Pos(',',ss)<>0 then ss[Pos(',',ss)]:='.';
                      if ss[Length(ss)]='.' then Delete(ss,Length(ss),1);
                      for ii:=1 to Length(ss) do
                        Send(Ord(ss[ii]));
                    end;

                  tpByte :
                    begin
                      Send(Ord('H'));
                      ss:=IntToHex(B,2);
                      for ii:=1 to Length(ss) do
                        Send(Ord(ss[ii]));
                    end;

                  tpWord :
                    begin
                      Send(Ord('H'));
                      ss:=IntToHex(W,4);
                      for ii:=1 to Length(ss) do
                        Send(Ord(ss[ii]));
                    end;

                  tpLong :
                    begin
                      Send(Ord('H'));
                      ss:=IntToHex(L,8);
                      for ii:=1 to Length(ss) do
                        Send(Ord(ss[ii]));
                    end;

                  tpString :
                    begin
                      Send(Ord('S'));
                      if Length(S)>cSLen then SetLength(S,cSLen);
                      for ii:=1 to Length(S) do
                        Send(Ord(S[ii]));
                    end;

                  tpOktStr :
                    begin
                      Send(Ord('O'));
                      ss:=IntToOct(O);
                      ss:=ReverseStr(ss);
                      for ii:=1 to Length(ss) do
                        Send(Ord(ss[ii]));
                    end;
                end;
                Send(ETX);
                Send(GetSum);
              end;
          end;
        end;

        LBuf:=J;
        if J<CH_MSBuff then Sts:=0
                       else Sts:=$ffff;
      end;
  end;
{----------}
var
  L   : Word;
  Sts : Word;
begin
  if CH_Ctrl=CHS_Connect then
    begin
      MessSend(L,Sts);
      if Sts=0 then
      begin
        CH_Chn.ChSend(CH_SBuff,L);
        ChSetSendResult(CH_Chn.ChSendResult);
      end
      else
        ChSetSendResult(CH_NumName or res_Err);
    end
  else
    ChSetSendResult(CH_NumName or res_ErrNoConnect);
end;

{ ---------------------------------------- }
function tChnLecom.RecB(var Data: Byte): TRec;
begin
  if Assigned(CH_Chn) then
    if CH_Chn.ChReceiveReady=CHS_ReceiveReady then
    begin
      Data:=CH_Chn.ChReceiveChar;
      if CH_Chn.ChReceiveResult=res_Ok then
           RecB:=Znk
      else RecB:=Err;
    end
    else
      RecB:=NoZnk
  else
    RecB:=NoZnk;
end;

{ ---------------------------------------- }
function tChnLecom.Rec(var Data: Byte): TRec;
var
  v : TRec;
begin
  v:=RecB(Data);
  case v of
    Znk :
      begin
        case Data of
          EOT : Rec:=EOTZnk;
          STX : Rec:=STXZnk;
          ENQ : Rec:=ENQZnk;
          ACK : Rec:=ACKZnk;
          NAK : Rec:=NAKZnk;
          ETX : Rec:=ETXZnk;
          else  Rec:=Znk;
        end
      end;
    else Rec:=v;
  end;
end;

{ ---------------------------------------- }
function  tChnLecom.ChResultStr (Sts : tChResult) : tResultStr;
begin
  if Sts and $FF00 = CH_NumName then
  begin
    Result:=inherited ChResultStr(Sts);
    if Result='' then
    case Lo(Sts) of
      res_ErrSum : ChResultStr:='BCC Error';
      res_ErrEOT : ChResultStr:='EOT Error';
      res_ErrLen : ChResultStr:='Len Msg Error';
      res_ErrVal : ChResultStr:='Numeric Value Error';
    end;
  end
  else
    ChResultStr:=inherited ChResultStr(Sts);
end;

{ ---------------------------------------- }
procedure tChnLecom.ChReceiveTick;
label
  L_ReceiveReady,    L_ReceiveBeginMa,   L_ReceiveCodeH,    L_ReceiveCodeL,
  L_ReceiveData,     L_ReceiveDataH,     L_ReceiveDataS,    L_ReceiveDataR,
  L_ReceiveDataO,    L_ReceiveBCC,       L_ReceiveErrSumSl, L_ReceiveBCC2,
  L_ReceiveBeginSl,  L_ReceiveAD1,       L_ReceiveAD2,      L_ReceiveSlX,
  L_ReceiveCodeLSlR, L_ReceiveCodeHSlWS, L_ReceiveEnq;
var
  zz : Byte;
  vv : TRec;
  C2 : Byte;
  ii : integer;
  LL : longint;
begin
  if not LongBool(InterlockedExchange( integer(CH_RTick), Ord(true) )) then
  begin
    with PRecRecord(CH_RMess)^ do
    case CH_RCtrl of
      CHS_ReceiveNoReady,
      CHS_ReceiveReady :
       L_ReceiveReady  :
        begin
        end;

      { Slave }
      CHS_ReceiveBeginSl:
       L_ReceiveBeginSl :                    { EOT }
        begin
          repeat
            vv:=Rec(zz);
          until vv in [EOTZnk,NoZnk];
          R_NewCode :=false;
          R_WhatCode:=0;
          case vv of
            EOTZnk :
              begin
                CH_RCtrl:=CHS_ReceiveAD1;
                goto L_ReceiveAD1;
              end;
          end;
        end;
      CHS_ReceiveAD1:
       L_ReceiveAD1 :                        { AD1 }
        begin
          case Rec(zz) of
            Znk    :
              if Chr(zz) in ['0'..'9'] then  { od '0' do '9' }
              begin
                CH_RSum.MakeSum(zz);
                Code:=tCode(zz);
                CH_RCtrl:=CHS_ReceiveAD2;
                goto L_ReceiveAD2;
              end
              else
              begin
                CH_RCtrl:=CHS_ReceiveBeginSl;
                goto L_ReceiveBeginSl;
              end;
            NoZnk  : ;
            EOTZnk :
              begin
                goto L_ReceiveAD1;
              end;
            else
              begin
                CH_RCtrl:=CHS_ReceiveBeginSl;
                goto L_ReceiveBeginSl;
              end;
          end;
        end;
      CHS_ReceiveAD2:
       L_ReceiveAD2 :                       { AD2 }
        begin
          case Rec(zz) of
            Znk    :
              if Chr(zz) in ['0'..'9'] then
              begin
                CH_RSum.MakeSum(zz);
                L:=Ord(Ord(Code-Ord('0'))*10+(zz-Ord('0')));
                if (L>=0)and(L<=99) then Code:=L
                else
                  begin
                    CH_RCtrl:=CHS_ReceiveBeginSl;
                    goto L_ReceiveBeginSl;
                  end;
                if Code=CH_Node then
                  begin
                    CH_RDNode:=Code;
                    CH_RCtrl:=CHS_ReceiveSlX;
                    goto L_ReceiveSlX;
                  end
                else
                  begin
                    CH_RCtrl:=CHS_ReceiveBeginSl;
                    goto L_ReceiveBeginSl;
                  end;
              end
              else
              begin
                CH_RCtrl:=CHS_ReceiveBeginSl;
                goto L_ReceiveBeginSl;
              end;
            NoZnk  : ;
            else
              begin
                CH_RCtrl:=CHS_ReceiveBeginSl;
                goto L_ReceiveBeginSl;
              end;
          end;
        end;
      CHS_ReceiveSlX:
       L_ReceiveSlX :                      { STX, CodeH }
        begin
          case Rec(zz) of
            Znk    :
              begin
                if Chr(zz)='!' then
                begin
                  CH_RSum.MakeSum(zz);
                  RW:=Rd;
                  R_NewCode:=true;
                  R_WhatCode:=1;
                  R_PomS:='';
                  goto L_ReceiveSlX;
                end
                else
                  if R_WhatCode=0 then R_NewCode:=false;
                if R_NewCode then
                   begin
                     zz:=Ord(UpCase(Chr(zz)));
                     if not(Chr(zz) in ['0'..'9','A'..'F']) then
                        begin
                          CH_RCtrl:=CHS_ReceiveBeginSl;
                          goto L_ReceiveBeginSl;
                        end;
                     case R_WhatCode of
                       1..4:
                         begin
                           R_PomS:=R_PomS+Chr(zz);
                           if R_WhatCode=4 then
                           begin
                             L:=StrToHex(R_PomS);
                             if (L<=MaxCode)and(L>=0) then
                               Code:=L
                             else
                               begin
                                 CH_RCtrl:=CHS_ReceiveBeginSl;
                                 goto L_ReceiveBeginSl;
                               end;
                           end;
                           Inc(R_WhatCode);
                           goto L_ReceiveSlX;
                         end;
                       5:
                         begin
                           R_PomS:=Chr(zz);
                           Inc(R_WhatCode);
                           goto L_ReceiveSlX;
                         end;
                       6:
                         begin
                           R_PomS:=R_PomS+Chr(zz);
                           L:=StrToHex(R_PomS);
                           if (L>=0)and(L<=255)then
                             SubCode:=L
                           else
                             begin
                               CH_RCtrl:=CHS_ReceiveBeginSl;
                               goto L_ReceiveBeginSl;
                             end;
                           R_WhatCode:=0;
                           CH_RCtrl:=CHS_ReceiveEnq;
                           goto L_ReceiveEnq;
                         end;
                     end;
                   end;
                if not R_NewCode then
                   if zz in [0+Ord('0')..78+Ord('0')] then
                     begin
                       CH_RSum.MakeSum(zz);
                       RW:=Rd;
                       R_C1:=zz;
                       CH_RCtrl:=CHS_ReceiveCodeLSlR;
                       goto L_ReceiveCodeLSlR;
                     end
                   else
                     begin
                       CH_RCtrl:=CHS_ReceiveBeginSl;
                       goto L_ReceiveBeginSl;
                     end;
              end;
            NoZnk  : ;
            STXZnk :
              begin
                if ((R_NewCode)and(R_WhatCode=6))or(not R_NewCode) then
                   begin
                     RW:=Wr;
                     CH_RSum.SetSum(0);
                     CH_RCtrl:=CHS_ReceiveCodeH;
                     goto L_ReceiveCodeH;
                   end
                else
                   begin
                     CH_RCtrl:=CHS_ReceiveBeginSl;
                     goto L_ReceiveBeginSl;
                   end;
              end;
            else
              begin
                CH_RCtrl:=CHS_ReceiveBeginSl;
                goto L_ReceiveBeginSl;
              end;
          end;
        end;
      CHS_ReceiveCodeLSlR:
       L_ReceiveCodeLSlR :                 { CodeL rec }
        begin
          case Rec(zz) of
            Znk    :
              begin
                if zz in [0+Ord('0')..78+Ord('0')] then
                begin
                  C2:=zz;
                  L:=((C2-Ord('0')) div 10)*790 + (R_C1-Ord('0'))*10 + ((C2-Ord('0')) mod 10);
                  if (L>=0)and(L<=MaxCode) then
                    begin
                      Code:=L;
                      SubCode:=0;
                      CH_RCtrl:=CHS_ReceiveEnq;
                      goto L_ReceiveEnq;
                    end
                  else
                    begin
                      CH_RCtrl:=CHS_ReceiveBeginSl;
                      goto L_ReceiveBeginSl;
                    end;
                end
                else
                begin
                  CH_RCtrl:=CHS_ReceiveBeginSl;
                  goto L_ReceiveBeginSl;
                end;
              end;
            NoZnk  : ;
            else
              begin
                CH_RCtrl:=CHS_ReceiveBeginSl;
                goto L_ReceiveBeginSl;
              end;
          end;
        end;
      CHS_ReceiveEnq:
       L_ReceiveEnq :                     { ENQ }
        begin
          case Rec(zz) of
            NoZnk  : ;
            ENQZnk :
              begin
                ChSetReceiveResult(res_Ok);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
            else
              begin
                CH_RCtrl:=CHS_ReceiveBeginSl;
                goto L_ReceiveBeginSl;
              end;
          end;
        end;

      { Master }
      CHS_ReceiveBeginMa:
       L_ReceiveBeginMa :                    { ACK,NAK,STX }
        begin
          repeat
            vv:=Rec(zz);
          until vv in [ACKZnk,NAKZnk,STXZnk,NoZnk];
          R_NewCode :=false;
          R_WhatCode:=0;
          case vv of
            ACKZnk,
            NAKZnk :
              begin
                RW:=Rd;
                Par:=tpString;
                S:=Chr(zz);
                ChSetReceiveResult(res_Ok);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
            STXZnk :
              begin
                CH_RSum.SetSum(0);
                CH_RCtrl:=CHS_ReceiveCodeH;
                goto L_ReceiveCodeH;
              end;
          end;
        end;
      CHS_ReceiveCodeH:
       L_ReceiveCodeH :                    { CodeH }
        begin
          case Rec(zz) of
            Znk    :
              begin
                if Chr(zz)='!' then
                begin
                  CH_RSum.MakeSum(zz);
                  RW:=Rd;
                  R_NewCode:=true;
                  R_WhatCode:=1;
                  R_PomS:='';
                  goto L_ReceiveCodeH;
                end
                else
                  if R_WhatCode=0 then R_NewCode:=false;
                if R_NewCode then
                   begin
                     zz:=Ord(UpCase(Chr(zz)));
                     if not(Chr(zz) in ['0'..'9','A'..'F']) then
                        begin
                          CH_RCtrl:=CHS_ReceiveBeginMa;
                          goto L_ReceiveBeginMa;
                        end;
                     case R_WhatCode of
                       1..4:
                         begin
                           CH_RSum.MakeSum(zz);
                           R_PomS:=R_PomS+Chr(zz);
                           if R_WhatCode=4 then
                             begin
                               L:=StrToHex(R_PomS);
                               if (L>=0)and(L<=MaxCode) then
                                 Code:=L
                               else
                                 begin
                                   CH_RCtrl:=CHS_ReceiveBeginSl;
                                   goto L_ReceiveBeginSl;
                                 end;
                             end;
                           Inc(R_WhatCode);
                           goto L_ReceiveCodeH;
                         end;
                       5:
                         begin
                           CH_RSum.MakeSum(zz);
                           R_PomS:=Chr(zz);
                           Inc(R_WhatCode);
                           goto L_ReceiveCodeH;
                         end;
                       6:
                         begin
                           CH_RSum.MakeSum(zz);
                           R_PomS:=R_PomS+Chr(zz);
                           L:=StrToHex(R_PomS);
                           if (L>=0)and(L<=255) then
                             begin
                               SubCode:=L;
                               R_WhatCode:=0;
                               CH_RCtrl:=CHS_ReceiveData;
                               goto L_ReceiveData;
                             end
                           else
                             begin
                               CH_RCtrl:=CHS_ReceiveBeginSl;
                               goto L_ReceiveBeginSl;
                             end;
                         end;
                     end;
                   end;
                if not R_NewCode then
                   if zz in [0+Ord('0')..78+Ord('0')] then
                      begin
                        CH_RSum.MakeSum(zz);
                        RW:=Rd;
                        R_C1:=zz;
                        CH_RCtrl:=CHS_ReceiveCodeL;
                        goto L_ReceiveCodeL;
                      end
                   else
                      begin
                        CH_RCtrl:=CHS_ReceiveBeginMa;
                        goto L_ReceiveBeginMa;
                      end;
              end;
            NoZnk  : ;
            ACKZnk,
            NAKZnk :
              begin
                RW:=Rd;
                Par:=tpString;
                S:=Chr(zz);
                ChSetReceiveResult(res_Ok);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
            else
              begin
                CH_RCtrl:=CHS_ReceiveBeginMa;
                goto L_ReceiveBeginMa;
              end;
          end;
        end;
      CHS_ReceiveCodeL:
       L_ReceiveCodeL :                    { CodeL }
        begin
          case Rec(zz) of
            Znk    :
              if zz in [0+Ord('0')..78+Ord('0')] then
              begin
                CH_RSum.MakeSum(zz);
                C2:=zz;
                L:=((C2-Ord('0')) div 10)*790 + (R_C1-Ord('0'))*10 + ((C2-Ord('0')) mod 10);
                if (L>=0)and(L<=MaxCode) then Code:=L
                else
                  begin
                    CH_RCtrl:=CHS_ReceiveBeginMa;
                    goto L_ReceiveBeginMa;
                  end;
                SubCode:=0;
                CH_RCtrl:=CHS_ReceiveData;
                goto L_ReceiveData;
              end
              else
              begin
                CH_RCtrl:=CHS_ReceiveBeginMa;
                goto L_ReceiveBeginMa;
              end;
            NoZnk  : ;
            ACKZnk,
            NAKZnk :
              begin
                RW:=Rd;
                Par:=tpString;
                S:=Chr(zz);
                ChSetReceiveResult(res_Ok);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
            else
              begin
                CH_RCtrl:=CHS_ReceiveBeginMa;
                goto L_ReceiveBeginMa;
              end;
          end;
        end;
      CHS_ReceiveData:
       L_ReceiveData :                    { Data }
        begin
          case Rec(zz) of
            Znk    :
              begin
                S:='';
                CH_RSum.MakeSum(zz);
                case Chr(zz) of
                  'H': begin
                         RW:=Wr;
                         Par:=tpLong; { upravy na tpByte a tpWord se deji podle delky dale v ReceiveDataH }
                         CH_RCtrl:=CHS_ReceiveDataH;
                         goto L_ReceiveDataH;
                       end;
                  'S': begin
                         RW:=Wr;
                         Par:=tpString;
                         CH_RCtrl:=CHS_ReceiveDataS;
                         goto L_ReceiveDataS;
                       end;
                  'O': begin
                         RW:=Wr;
                         Par:=tpOktStr;
                         CH_RCtrl:=CHS_ReceiveDataO;
                         goto L_ReceiveDataO;
                       end;
                  '?': begin
                         RW:=Rd;
                         Par:=tpString;
                         S:='?';
                         CH_RCtrl:=CHS_ReceiveErrSumSl;
                         goto L_ReceiveErrSumSl;
                       end;
                  else begin
                         RW:=Wr;
                         Par:=tpReal;
                         S:=Chr(zz);
                         CH_RCtrl:=CHS_ReceiveDataR;
                         goto L_ReceiveDataR;
                       end;
                end;
              end;
            NoZnk  : ;
            EOTZnk :
              begin
                RW:=Rd;
                Par:=tpString;
                S:=Chr(EOT);
                ChSetReceiveResult(res_Ok);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
            ACKZnk,
            NAKZnk :
              begin
                RW:=Rd;
                Par:=tpString;
                S:=Chr(zz);
                ChSetReceiveResult(res_Ok);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
            else
              begin
                CH_RCtrl:=CHS_ReceiveBeginMa;
                goto L_ReceiveBeginMa;
              end;
          end;
        end;
      CHS_ReceiveDataS:
       L_ReceiveDataS :                    { DataS }
        begin
          case Rec(zz) of
            Znk    :
              begin
                if Length(S)<cSLen then
                begin
                  CH_RSum.MakeSum(zz);
                  S:=S+Chr(zz);
                  goto L_ReceiveDataS;
                end
                else
                begin
                  ChSetReceiveResult(CH_NumName or res_ErrLen);
                  CH_RCtrl:=CHS_ReceiveReady;
                end;
              end;
            NoZnk  : ;
            EOTZnk :
              begin
                ChSetReceiveResult(CH_NumName or res_ErrEOT);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
            ACKZnk,
            NAKZnk :
              begin
                RW:=Rd;
                Par:=tpString;
                S:=Chr(zz);
                ChSetReceiveResult(res_Ok);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
            ETXZnk :
              begin
                CH_RSum.MakeSum(ETX);
                CH_RCtrl:=CHS_ReceiveBCC;
                goto L_ReceiveBCC;
              end;
            else
              begin
                CH_RCtrl:=CHS_ReceiveBeginMa;
                goto L_ReceiveBeginMa;
              end;
          end;
        end;
      CHS_ReceiveDataH:
       L_ReceiveDataH :                    { DataH }
        begin
          case Rec(zz) of
            Znk    :
              begin
                if Length(S)<cWLen then
                begin
                  CH_RSum.MakeSum(zz);
                  S:=S+Chr(zz);
                  goto L_ReceiveDataH;
                end
                else
                begin
                  ChSetReceiveResult(CH_NumName or res_ErrLen);
                  CH_RCtrl:=CHS_ReceiveReady;
                end;
              end;
            NoZnk  : ;
            EOTZnk :
              begin
                ChSetReceiveResult(CH_NumName or res_ErrEOT);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
            ACKZnk,
            NAKZnk :
              begin
                RW:=Rd;
                Par:=tpString;
                S:=Chr(zz);
                ChSetReceiveResult(res_Ok);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
            ETXZnk :
              begin
                if Length(S) in [2,4,8] then
                begin
                  CH_RSum.MakeSum(ETX);
                  LL:=StrToHex(S);
                  case Length(S) of
                    2:begin Par:=tpByte; B:=Byte(LL); end;
                    4:begin Par:=tpWord; W:=Word(LL); end;
                    8:begin Par:=tpLong; L:=LL; end;
                  end;
                  CH_RCtrl:=CHS_ReceiveBCC;
                  goto L_ReceiveBCC;
                end
                else
                begin
                  ChSetReceiveResult(CH_NumName or res_ErrLen);
                  CH_RCtrl:=CHS_ReceiveReady;
                end;
              end;
            else
              begin
                CH_RCtrl:=CHS_ReceiveBeginMa;
                goto L_ReceiveBeginMa;
              end;
          end;
        end;
      CHS_ReceiveDataO:
       L_ReceiveDataO :                    { DataH }
        begin
          case Rec(zz) of
            Znk    :
              begin
                if Length(S)<cOLen then
                begin
                  CH_RSum.MakeSum(zz);
                  S:=S+Chr(zz);
                  goto L_ReceiveDataO;
                end
                else
                begin
                  ChSetReceiveResult(CH_NumName or res_ErrLen);
                  CH_RCtrl:=CHS_ReceiveReady;
                end;
              end;
            NoZnk  : ;
            EOTZnk :
              begin
                ChSetReceiveResult(CH_NumName or res_ErrEOT);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
            ACKZnk,
            NAKZnk :
              begin
                RW:=Rd;
                Par:=tpString;
                S:=Chr(zz);
                ChSetReceiveResult(res_Ok);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
            ETXZnk :
              begin
                CH_RSum.MakeSum(ETX);
                S:=ReverseStr(S);
                O:=StrToOct(S);
                CH_RCtrl:=CHS_ReceiveBCC;
                goto L_ReceiveBCC;
              end;
            else
              begin
                CH_RCtrl:=CHS_ReceiveBeginMa;
                goto L_ReceiveBeginMa;
              end;
          end;
        end;
      CHS_ReceiveDataR:
       L_ReceiveDataR :                    { DataR }
        begin
          case Rec(zz) of
            Znk    :
              begin
                if Length(S)<cRLen then
                begin
                  CH_RSum.MakeSum(zz);
                  S:=S+Chr(zz);
                  goto L_ReceiveDataR;
                end
                else
                begin
                  ChSetReceiveResult(CH_NumName or res_ErrLen);
                  CH_RCtrl:=CHS_ReceiveReady;
                end;
              end;
            NoZnk  : ;
            EOTZnk :
              begin
                ChSetReceiveResult(CH_NumName or res_ErrEOT);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
            ACKZnk,
            NAKZnk :
              begin
                RW:=Rd;
                Par:=tpString;
                S:=Chr(zz);
                ChSetReceiveResult(res_Ok);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
            ETXZnk :
              begin
                CH_RSum.MakeSum(ETX);
                Val(S,R,ii);
                if ii=0 then
                begin
                  CH_RCtrl:=CHS_ReceiveBCC;
                  goto L_ReceiveBCC;
                end
                else
                begin
                  ChSetReceiveResult(CH_NumName or res_ErrVal);
                  CH_RCtrl:=CHS_ReceiveReady;
                end;
              end;
            else
              begin
                CH_RCtrl:=CHS_ReceiveBeginMa;
                goto L_ReceiveBeginMa;
              end;
          end;
        end;
      CHS_ReceiveBCC:
       L_ReceiveBCC :                     { BCC }
        begin
          case Rec(zz) of
            NoZnk  : ;
            Err    :
              begin
                ChSetReceiveResult(CH_NumName or res_Err);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
            else
              begin
                if zz=CH_RSum.GetSum then
                  ChSetReceiveResult(res_Ok)
                else
                  ChSetReceiveResult(CH_NumName or res_ErrSum);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
          end;
        end;
      CHS_ReceiveErrSumSl:
       L_ReceiveErrSumSl :                { ErrSumSl }
        begin
          case Rec(zz) of
            NoZnk  : ;
            ETXZnk :
              begin
                CH_RSum.MakeSum(ETX);
                CH_RCtrl:=CHS_ReceiveBCC2;
                goto L_ReceiveBCC2;
              end;
            else
              begin
                ChSetReceiveResult(CH_NumName or res_Err);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
          end;
        end;
      CHS_ReceiveBCC2:
       L_ReceiveBCC2 :                    { BCC2 }
        begin
          case Rec(zz) of
            NoZnk  : ;
            Err    :
              begin
                ChSetReceiveResult(CH_NumName or res_Err);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
            else
              begin
                if zz=CH_RSum.GetSum then
                begin
                  ChSetReceiveResult(res_Ok);
                  CH_RCtrl:=CHS_ReceiveReady;
                end
                else
                  ChSetReceiveResult(CH_NumName or res_ErrSum);
                CH_RCtrl:=CHS_ReceiveReady;
              end;
          end;
        end;

      else
        begin
          if CH_Master then
          begin
            CH_RCtrl:=CHS_ReceiveBeginMa;
            goto L_ReceiveBeginMa;
          end
          else
          begin
            CH_RCtrl:=CHS_ReceiveBeginSl;
            goto L_ReceiveBeginSl;
          end;
        end;
    end;{case}
    CH_RTick:=false;
  end;
end;

{ ---------------------------------------- }
function tChnLecom.ChReceiveReady: TChState;
begin
  ChReceiveTick;
  { nastavuje CH_RResult }
  if CH_Ctrl=CHS_Connect then
    ChReceiveReady:=CH_RCtrl
  else
    ChReceiveReady:=CHS_ReceiveNoReady;
end;

{ ---------------------------------------- }
procedure tChnLecom.ChReceive(var Len: Word);
begin
  Len:=0;
  if CH_Ctrl=CHS_Connect then
    if CH_RCtrl=CHS_ReceiveReady then
    begin
      if CH_Master then
        CH_RCtrl:=CHS_ReceiveBeginMa
      else
        CH_RCtrl:=CHS_ReceiveBeginSl;
      ChSetReceiveResult(res_Ok);
    end
    else
      ChSetReceiveResult(CH_NumName or res_ErrNoReceiveReady)
  else
    ChSetReceiveResult(CH_NumName or res_ErrNoConnect);
end;

{ ---------------------------------------- }
procedure tChnLecom.ChReceiveFlush;
begin
  inherited;
  if CH_RResult=res_Ok then
    if CH_Master then
      CH_RCtrl:=CHS_ReceiveBeginMa
    else
      CH_RCtrl:=CHS_ReceiveBeginSl;
end;

{ ---------------------------------------- }
procedure tChnLecom.ChGetNode(var SNode, DNode: TNode);
begin
  SNode:=CH_RSNode;
  DNode:=CH_RDNode;
  ChSetReceiveResult(res_Ok);
end;

{ =============================================================== }
Begin
  ChnCollection.Insert(tAddChnLecom.Init(Nil));

  {$ifdef HardLock}
   if not TestHardLock then RunError(99);
  {$endif}
End.
