unit uFormM; {MainForm - hlavni formular aplikace}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,
  uString,
 {komunikacni knihovny}
  ChnVirt,
  Chn,
  ChnCom,
  ChnMBox,
  ChnPrt,
  ChnLecom,
  ChnMod2,
 {@ zde dalsi knihovny}
  uGlb, {globalni typy a promenne}
  uPom, {pomocne funkce}
  ExtCtrls, Menus, CustomizeDlg, ComCtrls, Buttons, TabNotBk, ToolWin;

type
 {hlavni formular}
  TMainForm = class(TForm)
    ButtonChnAInit  : TButton;
    ButtonChnASend  : TButton;
    ButtonChnBInit  : TButton;
    ButtonChnBSend  : TButton;
    ButtonChnABInit : TBitBtn;
    ButtonChnABDone : TBitBtn;
    Timer1          : TTimer;
    ListBoxChnA     : TListBox;
    ListBoxChnB     : TListBox;
    ButtonChnAClear : TButton;
    ButtonChnBClear : TButton;
   {}
    LabelChannelA          : TLabel;
    LabelChannelB          : TLabel;
    ChannelAState          : TLabel;
    ChannelBState          : TLabel;
    GroupBoxCharSet        : TGroupBox;
    RadioButtonAscii       : TRadioButton;
    RadioButtonHex         : TRadioButton;
    RadioButtonDec         : TRadioButton;
    ButtonStartStopRecA    : TButton;
    ButtonStartStopRecB    : TButton;
   {pro ChnLecom}
    {A}
    GrBoxLecomSendA        : TGroupBox;
    LabelLecomACode        : TLabel;
    LabelLecomASubCode     : TLabel;
    EditLecomACode         : TEdit;
    EditLecomASubCode      : TEdit;
    GrBoxLecomA_RW         : TGroupBox;
    RadioButtonLecomARead  : TRadioButton;
    RadioButtonLecomAWrite : TRadioButton;
    GrBoxLecomA_TypePar    : TGroupBox;
    RadioButtonLecomAReal  : TRadioButton;
    RadioButtonLecomAByte  : TRadioButton;
    RadioButtonLecomAWord  : TRadioButton;
    RadioButtonLecomALong  : TRadioButton;
    RadioButtonLecomAString: TRadioButton;
    RadioButtonLecomAOktStr: TRadioButton;
    LabelLecomAData        : TLabel;
    EditLecomAData         : TEdit;
    {B}
    GrBoxLecomSendB        : TGroupBox;
    LabelLecomBCode        : TLabel;
    LabelLecomBSubCode     : TLabel;
    EditLecomBCode         : TEdit;
    EditLecomBSubCode      : TEdit;
    GrBoxLecomB_Reply      : TGroupBox;
    RadioButtonLecomBACK   : TRadioButton;
    RadioButtonLecomBNAK   : TRadioButton;
    RadioButtonLecomBData  : TRadioButton;
    RadioButtonLecomBErrCrc: TRadioButton;
    GrBoxLecomB_TypePar    : TGroupBox;
    RadioButtonLecomBReal  : TRadioButton;
    RadioButtonLecomBByte  : TRadioButton;
    RadioButtonLecomBWord  : TRadioButton;
    RadioButtonLecomBLong  : TRadioButton;
    RadioButtonLecomBString: TRadioButton;
    RadioButtonLecomBOktStr: TRadioButton;
    LabelLecomBData        : TLabel;
    EditLecomBData         : TEdit;
   {pro ChnPrt a NoPrt}
    {A}
    GrBoxComPrtSendA       : TGroupBox;
    EditComPrtAData        : TEdit;
    {B}
    GrBoxComPrtSendB       : TGroupBox;
    EditComPrtBData        : TEdit;
   {horni roletove menu}
    MainMenu               : TMainMenu;
    MenuItChannel          : TMenuItem;
    MenuItChooseChn        : TMenuItem;
    MenuItMethods          : TMenuItem;
    MenuHelp               : TMenuItem;
    MenuDebChnHier         : TMenuItem;
    MenuExit               : TMenuItem;
    MenuInitBothChn        : TMenuItem;
    MenuAbout              : TMenuItem;
    N1: TMenuItem;
    Edit1: TMenuItem;
    Object1: TMenuItem;
    Links1: TMenuItem;
    N4: TMenuItem;
    GoTo1: TMenuItem;
    Replace1: TMenuItem;
    Find1: TMenuItem;
    N5: TMenuItem;
    PasteSpecial1: TMenuItem;
    Paste1: TMenuItem;
    Copy1: TMenuItem;
    Cut1: TMenuItem;
    N6: TMenuItem;
    Repeatcommand1: TMenuItem;
    Undo1: TMenuItem;
    Window1: TMenuItem;
    Show1: TMenuItem;
    Hide1: TMenuItem;
    N7: TMenuItem;
    ArrangeAll1: TMenuItem;
    Cascade1: TMenuItem;
    ile1: TMenuItem;
   {panel nastroju}
    Panel1                 : TPanel;
    SpeedButtonInitB       : TSpeedButton;
    SpeedButtonInitA       : TSpeedButton;
    SpeedButtonInitAB      : TSpeedButton;
    SpeedButtonChooseChannel:TSpeedButton;
    Label3                 : TLabel;
    ComboBoxDataFormat     : TComboBox;
   {dolni stavova lista}
    MainStatusBar          : TStatusBar;
   {parametry jednotlivych vrstev}
    TabbedParamNoteBook    : TTabbedNotebook;
    EditParamChn_A         : TEdit;
    EditParamPrt_A         : TEdit;
    EditParamMid_A         : TEdit;
    EditParamHW_A          : TEdit;
    EditParamChn_B         : TEdit;
    EditParamPrt_B         : TEdit;
    EditParamMid_B         : TEdit;
    EditParamHW_B          : TEdit;
    LabelParameters        : TLabel;

    ProgressBarChnA        : TProgressBar;
    ProgressBarChnB        : TProgressBar;
    GroupBoxChnType        : TGroupBox;
    ComboBoxChn            : TComboBox;
    ComboBoxPrt            : TComboBox;
    ComboBoxMid            : TComboBox;
    ComboBoxHW             : TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label4: TLabel;

   {vytvoreni a zruseni formulare}
    procedure FormCreate              (Sender: TObject);
    procedure FormClose               (Sender: TObject; var Action: TCloseAction);
   {tlacitka Init a Send, Clear a Stop Rec}
    procedure ButtonChnABInitClick    (Sender: TObject);
    procedure ButtonChnAInitClick     (Sender: TObject);
    procedure ButtonChnASendClick     (Sender: TObject);
    procedure ButtonChnBInitClick     (Sender: TObject);
    procedure ButtonChnBSendClick     (Sender: TObject);
    procedure ButtonChnABDoneClick    (Sender: TObject);
    procedure ButtonChnAClearClick    (Sender: TObject);
    procedure ButtonChnBClearClick    (Sender: TObject);
    procedure ButtonStartStopRecAClick(Sender: TObject);
    procedure ButtonStartStopRecBClick(Sender: TObject);
   {casovac prijimace}
    procedure Timer1Timer             (Sender: TObject);
   {vyber znakove sady pro znakove protokoly}
    procedure RadioButtonAsciiClick   (Sender: TObject);
    procedure RadioButtonHexClick     (Sender: TObject);
    procedure RadioButtonDecClick     (Sender: TObject);
   {prikazy horniho roletoveho menu}
    procedure MenuItChooseChnClick    (Sender: TObject);
    procedure MenuExitClick           (Sender: TObject);
    procedure MenuInitBothChnClick    (Sender: TObject);
    procedure MenuAboutClick          (Sender: TObject);
    procedure MenuDebChnHierClick     (Sender: TObject);
   {prikazy panelu nastroju}
    procedure SpeedButtonInitAClick   (Sender: TObject);
    procedure SpeedButtonInitBClick   (Sender: TObject);
    procedure SpeedButtonInitABClick  (Sender: TObject);
    procedure SpeedButtonChooseChannelClick(Sender: TObject);

    procedure FormResize              (Sender: TObject);
   {vyber typu vrstev komunikacniho kanalu}
    procedure ComboBoxChnChange       (Sender: TObject);
    procedure ComboBoxPrtChange       (Sender: TObject);
    procedure ComboBoxMidChange       (Sender: TObject);
    procedure ComboBoxHWChange        (Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ChangeChnType(NewChnType : tChnType);
                  {zmena ChnType na NewChnType}
    function  GetChannelHierarchyStr(ChnType : tChnType) : ShortString;
                  {vrati retezec zretezeni kanalu podle ChnType}
    procedure GlobalMake;
                  {globalni obsluha automatu komunikace apod}
  end;

var
  MainForm: TMainForm;

implementation

uses uForm2, uAbout, uFrmHier;

{$R *.DFM}

procedure TMainForm.ButtonChnAInitClick(Sender: TObject);
begin
  with Channel['A'] do
  begin
    if ChannelInStabilState then
         InitChn
    else DoneChn;
  end;
end;

procedure TMainForm.ButtonChnASendClick(Sender: TObject);
begin
  Channel['A'].SendChn; 
end;

procedure TMainForm.ButtonChnBInitClick(Sender: TObject);
begin
  with Channel['B'] do
  begin
    if ChannelInStabilState then
         InitChn
    else DoneChn;
  end;
end;

procedure TMainForm.ButtonChnBSendClick(Sender: TObject);
begin
  Channel['B'].SendChn;
end;

procedure TMainForm.GlobalMake;
begin
 {obsluha automatu komunikaci}
  Channel['A'].MakeChn;
  Channel['B'].MakeChn;
 {obsluha vypisu zaplnene pameti}
  MainStatusBar.Panels.Items[0].Text:='Memory Allocated: '+GetAllocatedMemStr+' Kb';
end;

procedure TMainForm.Timer1Timer(Sender: TObject);
begin
  GlobalMake;
end;

procedure TMainForm.ButtonChnAClearClick(Sender: TObject);
begin
  ListBoxChnA.Clear;
end;

procedure TMainForm.ButtonChnBClearClick(Sender: TObject);
begin
  ListBoxChnB.Clear;
end;

procedure TMainForm.ChangeChnType(NewChnType : byte);
begin
  if ChnType=NewChnType then Exit;
 {zruseni obou kanalu}
  Channel['A'].DoneChn;
  Channel['B'].DoneChn;
 {novy typ kanalu}
  Channel['A'].SaveParChn;
  Channel['B'].SaveParChn;
   ChnType:=NewChnType;
  Channel['A'].LoadParChn;
  Channel['B'].LoadParChn;
  MainStatusBar.Panels.Items[1].Text:='Channel hierarchy: '+GetChannelHierarchyStr(ChnType);
 {zruseni zobrazeni vsech objektu kanalu}
  GroupBoxCharSet .Enabled:=False;
  GroupBoxCharSet .Visible:=False;
  GrBoxComPrtSendA.Visible:=False;
  GrBoxComPrtSendA.Enabled:=False;
  GrBoxComPrtSendB.Visible:=False;
  GrBoxComPrtSendB.Enabled:=False;
  GrBoxLecomSendA .Visible:=False;
  GrBoxLecomSendA .Enabled:=False;
  GrBoxLecomSendB .Visible:=False;
  GrBoxLecomSendB .Enabled:=False;
  ComboBoxDataFormat.Enabled:=False;
  {@ zde dalsi knihovny}
 {zobrazeni objektu pro dany kanal}
  case ChnType and cMskLayerPrt of
    cLibNoPrt,
    cLibChnPrt:
      begin
        GroupBoxCharSet .Enabled:=True;
        GroupBoxCharSet .Visible:=True;
        GrBoxComPrtSendA.Visible:=True;
        GrBoxComPrtSendA.Enabled:=True;
        GrBoxComPrtSendB.Visible:=True;
        GrBoxComPrtSendB.Enabled:=True;
        ComboBoxDataFormat.Enabled:=True;
      end;
    cLibChnLecom:
      begin
        GrBoxLecomSendA.Visible:=True;
        GrBoxLecomSendA.Enabled:=True;
        GrBoxLecomSendB.Visible:=True;
        GrBoxLecomSendB.Enabled:=True;
      end;
    {@ zde dalsi knihovny}
  end;
 {zobrazeni tablu Notebooku parametru}
  if ((ChnType and cMskLayerChn)=0)and(TabbedParamNoteBook.PageIndex=0) then
    TabbedParamNoteBook.PageIndex:=1;
  if ((ChnType and cMskLayerPrt)=cLibNoPrt)and(TabbedParamNoteBook.PageIndex=1) then
    TabbedParamNoteBook.PageIndex:=2;
  if ((ChnType and cMskLayerMid)=cLibNoMid)and(TabbedParamNoteBook.PageIndex=2) then
    TabbedParamNoteBook.PageIndex:=3;
end;

function  TMainForm.GetChannelHierarchyStr(ChnType : tChnType) : ShortString;
begin
  if (ChnType and cMskLayerChn)<>0 then
       Result:='Chn -> '
  else Result:='';
  case ChnType and cMskLayerPrt of
    cLibNoPrt   : ;
    cLibChnPrt  :Result:=Result+'ChnPrt -> ';
    cLibChnLecom:Result:=Result+'ChnLecom -> ';
    else         Result:=Result+'unknown protocol -> ';
  end;
  case ChnType and cMskLayerMid of
    cLibNoMid   : ;
    cLibChnMod  :Result:=Result+'ChnMod -> ';
    else         Result:=Result+'unknown';
  end;
  case ChnType and cMskLayerHW of
    cLibChnCom  :Result:=Result+'ChnCom';
    cLibChnMBox :Result:=Result+'SimCom';
    else         Result:=Result+'unknown';
  end;
  {@ zde dalsi knihovny}
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  ChnType := cLibNoPrt or cLibChnCom;

  Channel['A']:=tChannel.Create('A',ChannelAState,ListBoxChnA,ButtonChnAInit,ButtonChnASend,EditParamChn_A,EditParamPrt_A,EditParamMid_A,EditParamHW_A,ProgressBarChnA);
  Channel['B']:=tChannel.Create('B',ChannelBState,ListBoxChnB,ButtonChnBInit,ButtonChnBSend,EditParamChn_B,EditParamPrt_B,EditParamMid_B,EditParamHW_B,ProgressBarChnB);

  ChnViewChar := tpHex;

  MainStatusBar.Panels.Items[1].Text:='Channel hierarchy: '+GetChannelHierarchyStr(ChnType);
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
var Ch:tChannelRange;
begin
  for Ch:=Low(tChannelRange) to High(tChannelRange) do
  begin
    Channel[Ch].Free;
    Channel[Ch]:=nil;
  end;
  Action:=caFree;
end;

procedure TMainForm.RadioButtonAsciiClick(Sender: TObject);
begin
  ChnViewChar:=tpASCII;
end;

procedure TMainForm.RadioButtonHexClick(Sender: TObject);
begin
  ChnViewChar:=tpHex;
end;

procedure TMainForm.RadioButtonDecClick(Sender: TObject);
begin
  ChnViewChar:=tpDec;
end;

procedure TMainForm.ButtonStartStopRecAClick(Sender: TObject);
begin
  with Channel['A'] do
  begin
    ChnRecStop:=not ChnRecStop;
    if ChnRecStop then
         ButtonStartStopRecA.Caption:='Start Receive'
    else ButtonStartStopRecA.Caption:='Stop Receive';
  end;
end;

procedure TMainForm.ButtonStartStopRecBClick(Sender: TObject);
begin
  with Channel['B'] do
  begin
    ChnRecStop:=not ChnRecStop;
    if ChnRecStop then
         ButtonStartStopRecB.Caption:='Start Receive'
    else ButtonStartStopRecB.Caption:='Stop Receive';
  end;
end;

procedure TMainForm.MenuItChooseChnClick(Sender: TObject);
begin
  Enabled:=False;
  FormChooseChannel:=TFormChooseChannel.Create(Self);
  FormChooseChannel.Show;
end;

procedure TMainForm.MenuExitClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.ButtonChnABInitClick(Sender: TObject);
begin
  ButtonChnAInitClick(Sender);
  ButtonChnBInitClick(Sender);
end;

procedure TMainForm.ButtonChnABDoneClick(Sender: TObject);
begin
  Channel['A'].DoneChn;
  Channel['B'].DoneChn;
end;

procedure TMainForm.MenuInitBothChnClick(Sender: TObject);
begin
  Channel['A'].InitChn;
  Channel['B'].InitChn;
end;

procedure TMainForm.MenuAboutClick(Sender: TObject);
begin
  Enabled:=False;
  AboutBox:=TAboutBox.Create(Self);
  AboutBox.Show;
end;

procedure TMainForm.MenuDebChnHierClick(Sender: TObject);
begin
  Enabled:=False;
  FormChannelHierarchy:=TFormChannelHierarchy.Create(Self);
  FormChannelHierarchy.Show;
end;

procedure TMainForm.SpeedButtonInitAClick(Sender: TObject);
begin
  ButtonChnAInitClick(Sender);
end;

procedure TMainForm.SpeedButtonInitBClick(Sender: TObject);
begin
  ButtonChnBInitClick(Sender);
end;

procedure TMainForm.SpeedButtonInitABClick(Sender: TObject);
begin
  ButtonChnABInitClick(Sender);
end;

procedure TMainForm.SpeedButtonChooseChannelClick(Sender: TObject);
begin
  MenuItChooseChnClick(Sender);
end;

procedure TMainForm.FormResize(Sender: TObject);
var I:integer;
begin
 {uprava sirky editace parametru}
  I:=ClientWidth-TabbedParamNoteBook.Left-5;
  if I<225 {minimalni sirka} then I:=225;
  TabbedParamNoteBook.Width:=I;
  EditParamChn_A.Width:=I-8;
  EditParamChn_B.Width:=I-8;
  EditParamPrt_A.Width:=I-8;
  EditParamPrt_B.Width:=I-8;
  EditParamMid_A.Width:=I-8;
  EditParamMid_B.Width:=I-8;
  EditParamHW_A .Width:=I-8;
  EditParamHW_B .Width:=I-8;
 {uprava sirky vysilanych zprav pro ChnCom a ChnPrt}
  I:=ClientWidth-GrBoxComPrtSendA.Left-5;
  if I<225 {minimalni sirka} then I:=225;
  GrBoxComPrtSendA.Width:=I;
  GrBoxComPrtSendB.Width:=I;
  EditComPrtAData.Width:=I-16;
  EditComPrtBData.Width:=I-16;
 {uprava sirky a vysky pozic prijimacich oken a prislusnych tlacitek}
  I:=(ClientWidth div 2)-15;
  if I<350 {minimalni sirka prijimaciho okna} then I:=350;
  ListBoxChnA.Width:=I;
  ListBoxChnB.Width:=I;
  I:=ClientHeight-ListBoxChnA.Top-49;
  if I<50 {minimalni vyska prijimaciho okna} then I:=50;
  ListBoxChnA.Height:=I;
  ListBoxChnB.Height:=I;
  ListBoxChnB.Left :=ClientWidth-ListBoxChnB.Width-(ListBoxChnA.Left);
  if ListBoxChnB.Left<ListBoxChnA.Left+ListBoxChnA.Width+5 then
    ListBoxChnB.Left:=ListBoxChnA.Left+ListBoxChnA.Width+5;
  LabelChannelA.Left:=ListBoxChnA.Left;
  LabelChannelB.Left:=ListBoxChnB.Left;
  ChannelAState.Left:=ListBoxChnA.Left;
  ChannelAState.Top :=ListBoxChnA.Top+ListBoxChnA.Height;
  ChannelBState.Left:=ListBoxChnB.Left;
  ChannelBState.Top :=ListBoxChnB.Top+ListBoxChnB.Height;
  ButtonChnAClear    .Top :=ListBoxChnA.Top +ListBoxChnA.Height;
  ButtonChnAClear    .Left:=ListBoxChnA.Left+ListBoxChnA.Width-ButtonChnAClear.Width;
  ButtonChnBClear    .Top :=ListBoxChnB.Top +ListBoxChnB.Height;
  ButtonChnBClear    .Left:=ListBoxChnB.Left+ListBoxChnB.Width-ButtonChnBClear.Width;
  ButtonStartStopRecA.Top :=ListBoxChnA.Top +ListBoxChnA.Height;
  ButtonStartStopRecA.Left:=ListBoxChnA.Left+ListBoxChnA.Width-ButtonChnAClear.Width-ButtonStartStopRecA.Width;
  ButtonStartStopRecB.Top :=ListBoxChnB.Top +ListBoxChnB.Height;
  ButtonStartStopRecB.Left:=ListBoxChnB.Left+ListBoxChnB.Width-ButtonChnBClear.Width-ButtonStartStopRecB.Width;
  ProgressBarChnA.Top :=ListBoxChnA.Top+ListBoxChnA.Height+2;
  ProgressBarChnA.Left:=ButtonStartStopRecA.Left-ProgressBarChnA.Width-5;
  ProgressBarChnB.Top :=ListBoxChnB.Top+ListBoxChnB.Height+2;
  ProgressBarChnB.Left:=ButtonStartStopRecB.Left-ProgressBarChnB.Width-5;
end;

procedure TMainForm.ComboBoxChnChange(Sender: TObject);
var NewChnType:tChnType;
begin
  NewChnType:=ChnType;
  case ComboBoxChn.ItemIndex of
    0:NewChnType:=NewChnType and (not cMskLayerChn);
    1:NewChnType:=NewChnType or cLibChn;
  end;
  if NewChnType<>ChnType then
    ChangeChnType(NewChnType);
end;

procedure TMainForm.ComboBoxPrtChange(Sender: TObject);
var NewChnType:tChnType;
begin
  NewChnType:=ChnType;
  case ComboBoxPrt.ItemIndex of
    0:NewChnType:=(NewChnType and (not cMskLayerPrt)) or cLibNoPrt;
    1:NewChnType:=(NewChnType and (not cMskLayerPrt)) or cLibChnPrt;
    2:NewChnType:=(NewChnType and (not cMskLayerPrt)) or cLibChnLecom;
  end;
  if NewChnType<>ChnType then
    ChangeChnType(NewChnType);
end;

procedure TMainForm.ComboBoxMidChange(Sender: TObject);
var NewChnType:tChnType;
begin
  NewChnType:=ChnType;
  case ComboBoxMid.ItemIndex of
    0:NewChnType:=(NewChnType and (not cMskLayerMid)) or cLibNoMid;
    1:NewChnType:=(NewChnType and (not cMskLayerMid)) or cLibChnMod;
  end;
  if NewChnType<>ChnType then
    ChangeChnType(NewChnType);
end;

procedure TMainForm.ComboBoxHWChange(Sender: TObject);
var NewChnType:tChnType;
begin
  NewChnType:=ChnType;
  case ComboBoxHW.ItemIndex of
    0:NewChnType:=(NewChnType and (not cMskLayerHW)) or cLibChnCom;
    1:NewChnType:=(NewChnType and (not cMskLayerHW)) or cLibChnMBox;
  end;
  if NewChnType<>ChnType then
    ChangeChnType(NewChnType);
end;

end.

