unit NumToStr;

          {ͻ}
          {                                                        }
          {  unit NumToStr                                         }
          {                                                        }
          {  jednotka pro prevody cisel a ruznych struktur         }
          {  na string a zpet                                      }
          {                                                        }
          {  (C)1999 SofCon, Steovick 49, 160 00 Praha 6        }
          {          Ondrej Sury                                   }
          {          Ing. Vladimr Kastner                         }
          {          Adam Wild                                     }
          {                                                        }
          {ͼ}

{----------}
interface
{$H-}          {!Ka musi byt}
{----------}

const
  Ver_NumToStr = '3.59  05.02.1999';
     { verze knihovny }

type
  Nibble    = $0..$F;
     { interval zahrnujici 4 bity }

  tString1  = String[1];
  tString2  = String[2];
  tString3  = String[3];
  tString4  = String[4];
  tString5  = String[5];
  tString6  = String[6];
  tString8  = String[8];
  tString9  = String[9];
  tString10 = String[10];
  tString11 = String[11];
  tString12 = String[12];
  tString16 = String[16];
  tString19 = String[19];
  tString32 = String[32];
  tString39 = String[39];
     { typy delkovych stringu pro usetreni zasobniku }

type
  tIntType = (tpDec, tpBin, tpOkt, tpHex);
     { vyctovy typ ciselnych soustav }

  tRealType = (tpMaxDes, tpFixedDes, tpFixedLen);
     { vyctovy typ zarovnavani realnych cisel }

  tLanguage = (Us, Cz, CzWin);
     { vyctovy typ pouzivanych jazyku }

  tByteSet  = Set of Byte;
     { mnozina bytu }
  tCharSet  = Set of Char;
     { mnozina znaku }

  tConvTabWord = array[0..15] of Byte;
  tConvTabByte = array[0.. 7] of Byte;
     { tabulky pro funkce ConvertByteBits a ConvertWordBits }

const
 { konstanty maximalniho a minimalniho datumu a casu v zapakovanem tvaru }
  MaxDateTime = $FF9FBF7D;
    { 31.12.2107 23:59:58 }
  MinDateTime = $00210000;
    { 01.01.1980 00:00:00 }

const
  Language : tLanguage = Cz;
    { aktualni pouzivany jazyk }

{ prevody celych cisel na string do binarniho zapisu a zpet }
function  NibbleStrBin  (N : Nibble)    : tString4;
function  ByteStrBin    (B : Byte)      : tString9;
function  WordStrBin    (W : Word)      : tString19;
function  LongIntStrBin (L : LongInt)   : tString39;

function  BinStrNibble  (const S : tString8)  : Nibble;
function  BinStrByte    (const S : tString16) : Byte;
function  BinStrWord    (const S : tString32) : Word;
function  BinStrLongInt (const S : tString39) : LongInt;

function  SetStrBin     (S : LongInt; Len : Byte) : tString32;

{ prevody celych cisel na string do octaloveho zapisu a zpet }
function  NibbleStrOct  (N : Nibble)    : tString2;
function  ByteStrOct    (B : Byte)      : tString4;
function  WordStrOct    (W : Word)      : tString8;
function  LongIntStrOct (L : LongInt)   : tString16;

function  OctStrNibble  (const S : tString4)  : Nibble;
function  OctStrByte    (const S : tString8)  : Byte;
function  OctStrWord    (const S : tString16) : Word;
function  OctStrLongInt (const S : tString32) : LongInt;

{ prevody celych cisel na string do hexadecimalniho zapisu a zpet }
function  NibbleStrHex  (N : Nibble)    : tString1;
function  ByteStrHex    (B : Byte)      : tString2;
function  WordStrHex    (W : Word)      : tString4;
function  LongIntStrHex (L : LongInt)   : tString8;

function  HexStrNibble  (const S : tString2)  : Nibble;
function  HexStrByte    (const S : tString4)  : Byte;
function  HexStrWord    (const S : tString8)  : Word;
function  HexStrLongInt (const S : tString16) : LongInt;

{ prevody celych cisel na string do dekadickeho zapisu }
function  NibbleStrDec  (N : Nibble;  Len : Byte) : tString2;
function  ByteStrDec    (B : Byte;    Len : Byte) : tString3;
function  WordStrDec    (W : Word;    Len : Byte) : tString5;
function  IntegerStrDec (I : Integer; Len : Byte) : tString6;
function  LongIntStrDec (L : LongInt; Len : Byte) : tString11;

{ univerzalni jednoduche a velice ucinne funkce pro prevody celych cisel
  na string do zvoleneho zapisu a zpet }
function  IntToStr (L : LongInt;   Typ : tIntType;     Len     : Byte)    : tString32;
function  StrToInt (S : tString39; Typ : tIntType; var ErrCode : Integer) : LongInt;

{ prevody realnych cisel na string }
function  RealStrDec (R : Real; Len : Byte; Flt : Byte)      : tString32;
function  RealStrExp (R : Real; Len : Byte)                  : tString16;
function  RealToStr  (R : Real; Len : Byte; Typ : tRealType) : tString32;

{ prevody datumu a casu na string a zpet }
function  TimeToStr      (DT : tDateTime;  const Param : tString39) : tString39;
            { Vrati retezec s casem ve formatu zadanem parametrem Param }
function  TimeToStrPT    (Time : LongInt; const Param : tString39) : tString39;
            { Vrati retezec s casem ve formatu zadanem parametrem Param }
function  DateToStr      (DT : tDateTime;  const Param : tString39) : tString39;
            { Vrati retezec s datem ve formatu zadanem parametrem Param }
function  DateToStrPT    (Time : LongInt; const Param : tString39) : tString39;
            { Vrati retezec s datem ve formatu zadanem parametrem Param }
function  StrToDate      (const S : tString39; var DT : tDateTime)  : Boolean;
            { Vrati priznak uspesnosti prevodu retezce S na datum }
function  StrToTime      (const S : tString39; var DT : tDateTime)  : Boolean;
            { Vrati priznak uspesnosti prevodu retezce S na cas }
function  StrToDatePT    (const S : tString39; var DT : LongInt )  : Boolean;
            { Vrati priznak uspesnosti prevodu retezce S na zapakovane datum }
function  StrToTimePT    (const S : tString39; var DT : LongInt )  : Boolean;
            { Vrati priznak uspesnosti prevodu retezce S na zapakovany cas }
function  GetPackTime                                              : LongInt;
            { Vrati aktualni udaj datumu a casu v zapakovanem tvaru }
function  fPackTime      (DT : tDateTime)                           : LongInt;
            { Vrati udaj datumu a casu DT v zapakovanem tvaru }
function  GetDayOfWeek   (DT : tDateTime)                           : Byte;
            { Vrati cislo dne v tydnu vypocteneho z data v Time }
function  GetDayOfWeekPT (Time : LongInt)                          : Byte;
            { Vrati cislo dne v tydnu vypocteneho z data v Time }

{ prevody mnozin bajtu a znaku na string a zpet }
procedure StrToByteSet (const Str : String; var ByteSet : tByteSet; var ErrCode : Integer);
            { Prevede retezec s vyctem ci intervalem mnoziny bytu do zadane mnoziny bytu }
procedure StrToCharSet (const Str : String; var CharSet : tCharSet; var ErrCode : Integer);
            { Prevede retezec s vyctem ci intervalem mnoziny znaku do zadane mnoziny znaku }

function  ByteSetToStr (ByteSet : tByteSet; HexOrDec : Boolean) : String;
            { Prevede zadanou mnozinu bytu do retezce }
function  CharSetToStr (CharSet : tCharSet; HexOrDec : Boolean) : String;
            { Prevede zadanou mnozinu znaku do retezce }

{ prevody ruznych uzitecnych struktur na string a zpet }
function  BufferStrHex  (P : Pointer; Len : Byte) : String;
            { Hexadecimalni prevod bufferu dane delky do stringu tvaru "00a20c" }
function  BufferStrHex2 (P : Pointer; Len : Byte) : String;
            { Hexadecimalni prevod bufferu dane delky do stringu tvaru "$00 $a2 $0c " }
function  StrHexBuffer  (const S : String; P : pointer) : Byte;
            { Prevede zadany string na pole bytu, ktere ulozi na adresu zadanou parametrem P,
              jako funkci hodnotu vrati pocet prevedenych bytu }

function  PtrToStr(P : Pointer  ) : tString11;
            { Prevod pointeru na string }
function  StrToPtr(S : tString11) : Pointer;
            { Prevod stringu na pointer }
function  PtrToLongint(P : Pointer) : LongInt;
            { Prevod pointeru na longint }
function  LongintToPtr(L : LongInt) : Pointer;
            { Prevod longintu na pointer }

function  ConvertByteBits(B : Byte; const ConvTabB : tConvTabByte) : Byte;
            { Podle tabulky ConvTabB, kde je poradi bitu ve vysledku funkce
              (cisla 0..7), prehazi bity vstupujiciho byte a vrati to jako
              vysledek. Pro prehazovani bitu pouziva nasobeni vektoru matici. }
function  ConvertWordBits(W : Word; const ConvTabW : tConvTabWord) : Word;
            { Podle tabulky ConvTabW, kde je poradi bitu ve vysledku funkce
              (cisla 0..15), prehazi bity vstupujiciho wordu a vrati to jako
              vysledek. Pro prehazovani bitu pouziva nasobeni vektoru matici. }

{-------------}
implementation
{-------------}

const
  KonvTable : array[$0..$F] of char = '0123456789ABCDEF'; { pomocne pole znaku pro prevody cisel na string }

const
  cMonths : array[tLanguage,1..12]of tString10 = { konstanty nazvu mesicu }
  { Us }  (('January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December')
  { Cz }  ,('leden',
            'unor',
            'brezen',
            'duben',
            'kveten',
            'cerven',
            'cervenec',
            'srpen',
            'zari',
            'rijen',
            'listopad',
            'prosinec')
 { CzWin },('leden',
            'nor',
            'bezen',
            'duben',
            'kvten',
            'erven',
            'ervenec',
            'srpen',
            'z',
            'jen',
            'listopad',
            'prosinec'));

  cWholeDays : array[tLanguage,0..6]of tString10 = { konstanty nazvu dni }
  { Us }  (('Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday')
  { Cz }  ,('nedele',
            'pondeli',
            'utery',
            'streda',
            'ctvrtek',
            'patek',
            'sobota')
 { CzWin },('nedle',
            'pondl',
            'ter',
            'steda',
            'tvrtek',
            'ptek',
            'sobota'));

  cPartDays : array[tLanguage,0..6]of tString2 = { konstanty zkratek nazvu dni }
  { Us }  (('Su',
            'Mo',
            'Tu',
            'We',
            'Th',
            'Fr',
            'Sa')
  { Cz }  ,('ne',
            'po',
            'ut',
            'st',
            'ct',
            'pa',
            'so')
 { CzWin },('ne',
            'po',
            't',
            'st',
            't',
            'p',
            'so'));


{-------------------------------------------------}
function ReadWVal(const S : tString39; var I : Byte): Word;
   { pomocna funkce pro nacteni dekadickeho cisla velikosti Word ze stringu S
     od pozice I, funkce nalezne prvni dekadickou cislici a pote zacne dekodovat }
var
  ErrCode : Integer;
  WS      : tString5;
begin
  WS := '';
  while (I<=Length(S))and(not (S[I] in ['0'..'9'])) do
    Inc(I); { nalezeni prvni cislice }
  while (I<=Length(S))and(S[I] in ['0'..'9'])and(Length(WS)<4) do
  begin
    WS:=WS+S[I];
    Inc(I);
  end;
  ReadWVal:=Word(StrToInt(WS,tpDec,ErrCode));
end;

{ ************************************************************************** }
{-------------------------------------------------}
function NibbleStrBin(N : Nibble) : tString4;
var
  TmpS : tString4;
begin
  TmpS := KonvTable[(N shr $03) and $01] +
          KonvTable[(N shr $02) and $01] +
          KonvTable[(N shr $01) and $01] +
          KonvTable[(N        ) and $01];
  NibbleStrBin := TmpS;
end;

{-------------------------------------------------}
function ByteStrBin(B : Byte) : tString9;
var
  TmpS : tString9;
begin
  TmpS := KonvTable[(B shr $07) and $01] +
          KonvTable[(B shr $06) and $01] +
          KonvTable[(B shr $05) and $01] +
          KonvTable[(B shr $04) and $01] +
          ' '                            +
          KonvTable[(B shr $03) and $01] +
          KonvTable[(B shr $02) and $01] +
          KonvTable[(B shr $01) and $01] +
          KonvTable[(B        ) and $01];
  ByteStrBin := TmpS;
end;

{-------------------------------------------------}
function WordStrBin(W : Word) : tString19;
var
  TmpS : tString19;
begin
  TmpS := KonvTable[(W shr $0F) and $01] +
          KonvTable[(W shr $0E) and $01] +
          KonvTable[(W shr $0D) and $01] +
          KonvTable[(W shr $0C) and $01] +
          ' '                            +
          KonvTable[(W shr $0B) and $01] +
          KonvTable[(W shr $0A) and $01] +
          KonvTable[(W shr $09) and $01] +
          KonvTable[(W shr $08) and $01] +
          ' '                            +
          KonvTable[(W shr $07) and $01] +
          KonvTable[(W shr $06) and $01] +
          KonvTable[(W shr $05) and $01] +
          KonvTable[(W shr $04) and $01] +
          ' '                            +
          KonvTable[(W shr $03) and $01] +
          KonvTable[(W shr $02) and $01] +
          KonvTable[(W shr $01) and $01] +
          KonvTable[(W        ) and $01];
  WordStrBin := TmpS;
end;

{-------------------------------------------------}
function LongIntStrBin(L : LongInt) : tString39;
var
  TmpS : tString39;
begin
  TmpS := KonvTable[(L shr $1F) and $01] +
          KonvTable[(L shr $1E) and $01] +
          KonvTable[(L shr $1D) and $01] +
          KonvTable[(L shr $1C) and $01] +
          ' '                            +
          KonvTable[(L shr $1B) and $01] +
          KonvTable[(L shr $1A) and $01] +
          KonvTable[(L shr $19) and $01] +
          KonvTable[(L shr $18) and $01] +
          ' '                            +
          KonvTable[(L shr $17) and $01] +
          KonvTable[(L shr $16) and $01] +
          KonvTable[(L shr $15) and $01] +
          KonvTable[(L shr $14) and $01] +
          ' '                            +
          KonvTable[(L shr $13) and $01] +
          KonvTable[(L shr $12) and $01] +
          KonvTable[(L shr $11) and $01] +
          KonvTable[(L shr $10) and $01] +
          ' '                            +
          KonvTable[(L shr $0F) and $01] +
          KonvTable[(L shr $0E) and $01] +
          KonvTable[(L shr $0D) and $01] +
          KonvTable[(L shr $0C) and $01] +
          ' '                            +
          KonvTable[(L shr $0B) and $01] +
          KonvTable[(L shr $0A) and $01] +
          KonvTable[(L shr $09) and $01] +
          KonvTable[(L shr $08) and $01] +
          ' '                            +
          KonvTable[(L shr $07) and $01] +
          KonvTable[(L shr $06) and $01] +
          KonvTable[(L shr $05) and $01] +
          KonvTable[(L shr $04) and $01] +
          ' '                            +
          KonvTable[(L shr $03) and $01] +
          KonvTable[(L shr $02) and $01] +
          KonvTable[(L shr $01) and $01] +
          KonvTable[(L        ) and $01];
  LongIntStrBin := TmpS;
end;

{-------------------------------------------------}
function BinStrNibble(const S : tString8) : Nibble;
var
  N : Nibble;
  I : Byte;
begin
   N:=0;
   for I:=1 to length(S) do
   begin
     if S[I] in ['0','1'] then
       N:=((N and $7) shl 1)+(Ord(S[I])-Ord('0'));
   end;
   BinStrNibble:=N;
end;

{-------------------------------------------------}
function BinStrByte(const S : tString16) : Byte;
var
  B : Byte;
  I : Byte;
begin
   B:=0;
   for I:=1 to length(S) do
   begin
     if S[I] in ['0','1'] then
       B:=((B and $7F) shl 1)+(Ord(S[I])-Ord('0'));
   end;
   BinStrByte:=B;
end;

{-------------------------------------------------}
function BinStrWord(const S : tString32) : Word;
var
  W : Word;
  I : Byte;
begin
   W:=0;
   for I:=1 to length(S) do
   begin
     if S[I] in ['0','1'] then
       W:=((W and $7FFF) shl 1)+(Ord(S[I])-Ord('0'));
   end;
   BinStrWord:=W;
end;

{-------------------------------------------------}
function BinStrLongInt(const S : tString39) : LongInt;
var
  L : LongInt;
  I : Byte;
begin
   L:=0;
   for I:=1 to length(S) do
   begin
     if S[I] in ['0','1'] then
       L:=((L and $7FFFFFFF) shl 1)+(Ord(S[I])-Ord('0'));
   end;
   BinStrLongInt:=L;
end;

{-------------------------------------------------}
function SetStrBin(S : LongInt; Len : Byte) : tString32;
var
  I : Byte;
  TmpS : tString32;
begin
  TmpS := '';
  for I := (Len - 1) downto 0 do
    TmpS := TmpS + KonvTable[(S shr I) and $01];
  SetStrBin := TmpS;
end;

{ ************************************************************************** }
{-------------------------------------------------}
function NibbleStrOct(N : Nibble) : tString2;
var
  TmpS : tString2;
begin
  TmpS := KonvTable[(N shr $03) and $01] +
          KonvTable[(N        ) and $07];
  NibbleStrOct := TmpS;
end;

{-------------------------------------------------}
function ByteStrOct(B : Byte) : tString4;
var
  TmpS : tString4;
begin
  TmpS := KonvTable[(B shr $06) and $03] +
          KonvTable[(B shr $03) and $07] +
          KonvTable[(B        ) and $07];
  ByteStrOct := TmpS;
end;

{-------------------------------------------------}
function WordStrOct(W : Word) : tString8;
var
  TmpS : tString8;
begin
  TmpS := KonvTable[(W shr $0F) and $01] +
          KonvTable[(W shr $0C) and $07] +
          KonvTable[(W shr $09) and $07] +
          KonvTable[(W shr $06) and $07] +
          KonvTable[(W shr $03) and $07] +
          KonvTable[(W        ) and $07];
  WordStrOct := TmpS;
end;

{-------------------------------------------------}
function LongIntStrOct(L : LongInt) : tString16;
var
  TmpS : tString16;
begin
  TmpS := KonvTable[(L shr $1E) and $03] +
          KonvTable[(L shr $1B) and $07] +
          KonvTable[(L shr $18) and $07] +
          KonvTable[(L shr $15) and $07] +
          KonvTable[(L shr $12) and $07] +
          KonvTable[(L shr $0F) and $07] +
          KonvTable[(L shr $0C) and $07] +
          KonvTable[(L shr $09) and $07] +
          KonvTable[(L shr $06) and $07] +
          KonvTable[(L shr $03) and $07] +
          KonvTable[(L        ) and $07];
  LongIntStrOct := TmpS;
end;

{-------------------------------------------------}
function OctStrNibble(const S : tString4) : Nibble;
var
  N : Nibble;
  I : Byte;
begin
   N:=0;
   for I:=1 to length(S) do
   begin
     if S[I] in ['0'..'7'] then
       N:=((N and $1) shl 3)+(Ord(S[I])-Ord('0'));
   end;
   OctStrNibble:=N;
end;

{-------------------------------------------------}
function OctStrByte(const S : tString8) : Byte;
var
  B : Byte;
  I : Byte;
begin
   B:=0;
   for I:=1 to length(S) do
   begin
     if S[I] in ['0'..'7'] then
       B:=((B and $1F) shl 3)+(Ord(S[I])-Ord('0'));
   end;
   OctStrByte:=B;
end;

{-------------------------------------------------}
function OctStrWord(const S : tString16) : Word;
var
  W : Word;
  I : Byte;
begin
   W:=0;
   for I:=1 to length(S) do
   begin
     if S[I] in ['0'..'7'] then
       W:=((W and $1FFF) shl 3)+(Ord(S[I])-Ord('0'));
   end;
   OctStrWord:=W;
end;

{-------------------------------------------------}
function OctStrLongInt(const S : tString32) : LongInt;
var
  L : LongInt;
  I : Byte;
begin
   L:=0;
   for I:=1 to length(S) do
   begin
     if S[I] in ['0'..'7'] then
       L:=((L and $1FFFFFFF) shl 3)+(Ord(S[I])-Ord('0'));
   end;
   OctStrLongInt:=L;
end;

{ ************************************************************************** }
{-------------------------------------------------}
function NibbleStrHex(N : Nibble) : tString1;
var
  TmpS : tString1;
begin
  TmpS := KonvTable[(N and $0F)];
  NibbleStrHex := TmpS;
end;

{-------------------------------------------------}
function ByteStrHex(B : Byte) : tString2;
var
  TmpS : tString2;
begin
  TmpS := KonvTable[(B shr $04) and $0F] +
          KonvTable[(B        ) and $0F];
  ByteStrHex := TmpS;
end;

{-------------------------------------------------}
function WordStrHex(W : Word) : tString4;
var
  TmpS : tString4;
begin
  TmpS := KonvTable[(W shr $0C) and $0F] +
          KonvTable[(W shr $08) and $0F] +
          KonvTable[(W shr $04) and $0F] +
          KonvTable[(W        ) and $0F];
  WordStrHex := TmpS;
end;

{-------------------------------------------------}
function LongIntStrHex(L : LongInt) : tString8;
var
  TmpS : tString8;
begin
  TmpS := KonvTable[(L shr $1C) and $0F] +
          KonvTable[(L shr $18) and $0F] +
          KonvTable[(L shr $14) and $0F] +
          KonvTable[(L shr $10) and $0F] +
          KonvTable[(L shr $0C) and $0F] +
          KonvTable[(L shr $08) and $0F] +
          KonvTable[(L shr $04) and $0F] +
          KonvTable[(L        ) and $0F];
  LongIntStrHex := TmpS;
end;

{-------------------------------------------------}
function HexStrNibble(const S : tString2) : Nibble;
var
  N : Nibble;
  I : Byte;
begin
   N:=0;
   for I:=1 to length(S) do
   begin
     if S[I] in ['0'..'9','A'..'F','a'..'f'] then
     begin
       if Ord(S[I])>Ord('9') then
            N:=((N and $0) shl 4)+(Ord(UpCase(S[I]))-Ord('0')-7)
       else N:=((N and $0) shl 4)+(Ord(UpCase(S[I]))-Ord('0'));
     end;
   end;
   HexStrNibble:=N;
end;

{-------------------------------------------------}
function HexStrByte(const S : tString4) : Byte;
var
  B : Byte;
  I : Byte;
begin
   B:=0;
   for I:=1 to length(S) do
   begin
     if S[I] in ['0'..'9','A'..'F','a'..'f'] then
     begin
       if Ord(S[I])>Ord('9') then
            B:=((B and $0F) shl 4)+(Ord(UpCase(S[I]))-Ord('0')-7)
       else B:=((B and $0F) shl 4)+(Ord(UpCase(S[I]))-Ord('0'));
     end;
   end;
   HexStrByte:=B;
end;

{-------------------------------------------------}
function HexStrWord(const S : tString8) : Word;
var
  W : Word;
  I : Byte;
begin
   W:=0;
   for I:=1 to length(S) do
   begin
     if S[I] in ['0'..'9','A'..'F','a'..'f'] then
     begin
       if Ord(S[I])>Ord('9') then
            W:=((W and $0FFF) shl 4)+(Ord(UpCase(S[I]))-Ord('0')-7)
       else W:=((W and $0FFF) shl 4)+(Ord(UpCase(S[I]))-Ord('0'));
     end;
   end;
   HexStrWord:=W;
end;

{-------------------------------------------------}
function HexStrLongInt(const S : tString16) : LongInt;
var
  L : LongInt;
  I : Byte;
begin
   L:=0;
   for I:=1 to length(S) do
   begin
     if S[I] in ['0'..'9','A'..'F','a'..'f'] then
     begin
       if Ord(S[I])>Ord('9') then
            L:=((L and $0FFFFFFF) shl 4)+(Ord(UpCase(S[I]))-Ord('0')-7)
       else L:=((L and $0FFFFFFF) shl 4)+(Ord(UpCase(S[I]))-Ord('0'));
     end;
   end;
   HexStrLongInt:=L;
end;

{ ************************************************************************** }
{-------------------------------------------------}
function NibbleStrDec(N : Nibble; Len : Byte) : tString2;
var
  TmpS  : tString2;
begin
  Str((N and $0F) : Len, TmpS);
  NibbleStrDec := TmpS;
end;

{-------------------------------------------------}
function ByteStrDec(B : Byte; Len : Byte) : tString3;
var
  TmpS  : tString3;
begin
  Str(B : Len, TmpS);
  ByteStrDec := TmpS;
end;

{-------------------------------------------------}
function WordStrDec(W : Word; Len : Byte) : tString5;
var
  TmpS  : tString5;
begin
  Str(W : Len, TmpS);
  WordStrDec := TmpS;
end;

{-------------------------------------------------}
function IntegerStrDec(I : Integer; Len : Byte) : tString6;
var
  TmpS  : tString6;
begin
  Str(I : Len, TmpS);
  IntegerStrDec := TmpS;
end;

{-------------------------------------------------}
function LongIntStrDec(L : LongInt; Len : Byte) : tString11;
var
  TmpS  : tString11;
begin
  Str(L : Len, TmpS);
  LongIntStrDec := TmpS;
end;

{ ************************************************************************** }
{-------------------------------------------------}
function IntToStr(L : LongInt; Typ : tIntType; Len : Byte) : tString32;
const
  cPredChar = '0';
var
  PomS   : tString32;
  Zaklad : Byte;
begin
  PomS:='';
  case Typ of { typ ciselne soustavy }
    tpDec : Str(L,PomS);
    tpHex : Zaklad:=4;
    tpBin : Zaklad:=1;
    tpOkt : Zaklad:=3;
  end;
  if Typ<>tpDec then
    repeat
      Insert(KonvTable[L-((L shr Zaklad) shl Zaklad)],PomS,1);
      L:=L shr Zaklad;
    until L=0;
  while Length(PomS)<Len do
    if PomS[1]='-' then Insert(cPredChar,PomS,2)
                   else Insert(cPredChar,PomS,1);
  IntToStr:=PomS;
end;

{-------------------------------------------------}
function StrToInt(S : tString39; Typ : tIntType; var ErrCode : Integer) : LongInt;
{$ifdef Ver6}
label
  L_End;
{$endif}
var
  I      : Byte;
  PomLI  : LongInt;
  Zaklad : Byte;
  DelkaS : Byte;
begin
  DelkaS :=0;
  PomLI  :=0;
  ErrCode:=0;
 { vyhazeni vsech mezer }
  I:=1;
  while I<=Length(S) do
  if S[I]=' ' then Delete(S,I,1)
  else Inc(I);
 { vyhazeni vsech pozatecnich nul }
  if Typ<>tpDec then
    while (Length(S)>1)and(S[1]='0') do
    Delete(S,1,1);
 { kontrola cislic pro danou soustavu a vlastni prevod }
  case Typ of { typ ciselne soustavy }
    tpDec :
      begin
        Val(S,PomLI,ErrCode);
      end;
    tpBin :
      begin
        Zaklad:=1;
        for I:=1 to Length(S) do
          if (S[I] in ['0','1'])and(I<33)then
            Inc(DelkaS)
          else
          begin
            ErrCode:=I;
            {$ifdef Ver6}
              goto L_End;
            {$else}
              Break;
            {$endif}
          end;
      end;
    tpHex :
      begin
        Zaklad:=4;
        for I:=1 to Length(S) do
          if (S[I] in ['0'..'9','A'..'F','a'..'f'])and(I<9)then
          begin
            Inc(DelkaS);
            if S[I] in ['A'..'F','a'..'f'] then S[I]:=Chr(Ord(UpCase(S[I]))-7);
          end
          else
          begin
            ErrCode:=I;
            {$ifdef Ver6}
              goto L_End;
            {$else}
              Break;
            {$endif}
          end;
      end;
    tpOkt :
      begin
        Zaklad:=3;
        for I:=1 to Length(S) do
          if (S[I] in ['0'..'7'])and(I<12)then
            Inc(DelkaS)
          else
          begin
            ErrCode:=I;
            {$ifdef Ver6}
              goto L_End;
            {$else}
              Break;
            {$endif}
          end;
      end;
  end;
 {$ifdef Ver6}
  L_End:
 {$endif}
  if Typ<>tpDec then
    for I:=1 to DelkaS do
      PomLI:=(PomLI shl Zaklad)+(Ord(S[I])-Ord('0'));
  StrToInt:=PomLI;
end;

{ ************************************************************************** }
{-------------------------------------------------}
function RealStrDec(R : Real; Len : Byte; Flt : Byte) : tString32;
var
  TmpS : tString32;
begin
  if Len=Flt then
  begin
    Str(R : Len : Flt-1, TmpS);
    RealStrDec:=Copy(TmpS,1,Len);
  end
  else
  begin
    Str(R : Len : Flt, TmpS);
    RealStrDec := TmpS;
  end;
end;

{-------------------------------------------------}
function RealStrExp(R : Real; Len : Byte) : tString16;
var
  TmpS : tString16;
begin
  if Len>15 then Len:=15;
  Str(R : Len, TmpS);
  RealStrExp:=TmpS;
end;

{-------------------------------------------------}
function RealToStr(R : Real; Len : Byte; Typ : tRealType) : tString32;
var
  PomS : tString32;
begin
  Str(R:1:Len,PomS);
  case Typ of { format vypisu }
    tpMaxDes   : { Len je maximalni pocet desetinnych mist }
      begin
        while (Pos('.',PomS)<Length(PomS))and(PomS[Length(PomS)]='0') do
          Delete(PomS,Length(PomS),1);
        if PomS[Length(PomS)]='.' then Delete(PomS,Length(PomS),1);
      end;
    tpFixedDes : { Len je pevny pocet desetinnych mist }
      begin
        PomS:=PomS;
      end;
    tpFixedLen : { Len je pevny pocet platnych mist vcetne des. carky }
      begin
        if Pos('.',PomS)>(Len-1) then
             PomS:=Copy(PomS,1,Pos('.',PomS)-1)
        else PomS:=Copy(PomS,1,Len);
        if Length(PomS)<Len then PomS:=' '+PomS;
      end;
  end;
  RealToStr:=PomS;
end;

{ ************************************************************************** }
{-------------------------------------------------}
function TimeToStr(DT : tDateTime; const Param : tString39) : tString39;
const
  CharHour = 'H';
  CharMin  = 'M';
  CharSec  = 'S';
var
  PomS : tString39;
  PomW : Word;
  I    : Byte;
begin
{!Ka}
  RunError(99);
(*
  PomS:='';
  I:=1;
  while Length(Param)>=I do
  case Param[I] of
    CharHour:
      begin
        if Copy(Param,I,2)=CharHour+CharHour then
        begin
          PomS:=PomS+IntToStr(DT.Hour,tpDec,2);
          Inc(I,2);
        end
        else
        begin
          PomS:=PomS+IntToStr(DT.Hour,tpDec,1);
          Inc(I);
        end;
      end;
    CharMin :
      begin
        if Copy(Param,I,2)=CharMin+CharMin then
        begin
          PomS:=PomS+IntToStr(DT.Min,tpDec,2);
          Inc(I,2);
        end
        else
        begin
          PomS:=PomS+IntToStr(DT.Min,tpDec,1);
          Inc(I);
        end;
      end;
    CharSec :
      begin
        if Copy(Param,I,2)=CharSec+CharSec then
        begin
          PomS:=PomS+IntToStr(DT.Sec,tpDec,2);
          Inc(I,2);
        end
        else
        begin
          PomS:=PomS+IntToStr(DT.Sec,tpDec,1);
          Inc(I);
        end;
      end;
    else
      begin
        PomS:=PomS+Param[I];
        Inc(I);
      end;
  end;
  TimeToStr:=PomS;
*)
end;

{-------------------------------------------------}
function TimeToStrPT(Time : LongInt; const Param : tString39) : tString39;
var
  PomW : Word;
  DT   : tDateTime;
begin
{!Ka}
  RunError(99);
(*
  if Time=0 then
    with DT do
    GetTime(Hour,Min,Sec,PomW)
  else
    UnPackTime(Time,DT);
  TimeToStrPT:=TimeToStr(DT,Param);
*)
end;

{-------------------------------------------------}
function DateToStr(DT : tDateTime; const Param : tString39) : tString39;
const
  CharYear = 'Y';
  CharMon  = 'M';
  CharDay  = 'D';
  CharDoW  = 'W';
var
  PomS : tString39;
  PomW : Word;
  I    : Byte;
begin
{!Ka}
  RunError(99);
(*
  PomS:='';
  I:=1;
  while Length(Param)>=I do
  case Param[I] of
    CharYear:
      begin
        if Copy(Param,I,4)=CharYear+CharYear+CharYear+CharYear then
        begin
          PomS:=PomS+IntToStr(DT.Year,tpDec,4);
          Inc(I,4);
        end
        else
        if Copy(Param,I,3)=CharYear+CharYear+CharYear then
        begin
          PomS:=PomS+IntToStr(DT.Year,tpDec,3);
          Inc(I,3);
        end
        else
        if Copy(Param,I,2)=CharYear+CharYear then
        begin
          PomS:=PomS+IntToStr(DT.Year mod 100,tpDec,2);
          Inc(I,2);
        end
        else
        begin
          PomS:=PomS+IntToStr(DT.Year mod 100,tpDec,1);
          Inc(I);
        end;
      end;
    CharDoW:
      begin
        if Copy(Param,I,4)=CharDoW+CharDoW+CharDoW+CharDoW then
        begin
          PomS:=PomS+cWholeDays[Language,GetDayOfWeek(DT)];
          Inc(I,4);
        end
        else
        if Copy(Param,I,3)=CharDoW+CharDoW+CharDoW then
        begin
          PomS:=PomS+cWholeDays[Language,GetDayOfWeek(DT)];
          Inc(I,3);
        end
        else
        if Copy(Param,I,2)=CharDoW+CharDoW then
        begin
          PomS:=PomS+cPartDays[Language,GetDayOfWeek(DT)];
          Inc(I,2);
        end
        else
        begin
          PomS:=PomS+cPartDays[Language,GetDayOfWeek(DT)];
          Inc(I);
        end;
      end;
    CharMon:
      begin
        if Copy(Param,I,4)=CharMon+CharMon+CharMon+CharMon then
        begin
          PomS:=PomS+cMonths[Language,DT.Month];
          Inc(I,4);
        end
        else
        if Copy(Param,I,2)=CharMon+CharMon then
        begin
          PomS:=PomS+IntToStr(DT.Month,tpDec,2);
          Inc(I,2);
        end
        else
        begin
          PomS:=PomS+IntToStr(DT.Month,tpDec,1);
          Inc(I);
        end;
      end;
    CharDay:
      begin
        if Copy(Param,I,2)=CharDay+CharDay then
        begin
          PomS:=PomS+IntToStr(DT.Day,tpDec,2);
          Inc(I,2);
        end
        else
        begin
          PomS:=PomS+IntToStr(DT.Day,tpDec,1);
          Inc(I);
        end;
      end;
    else
      begin
        PomS:=PomS+Param[I];
        Inc(I);
      end;
  end;
  DateToStr:=PomS;
*)
end;

{-------------------------------------------------}
function DateToStrPT(Time : LongInt; const Param : tString39) : tString39;
var
  PomW : Word;
  DT   : tDateTime;
begin
{!Ka}
  RunError(99);
(*
  if Time=0 then
    with DT do
    GetDate(Year,Month,Day,PomW)
  else
    UnPackTime(Time,DT);
  DateToStrPT:=DateToStr(DT,Param);
*)
end;

{-------------------------------------------------}
function GetPackTime : LongInt;
var
  DT    : tDateTime;
  PomLI : LongInt;
  PomW  : Word;
begin
{!Ka}
  RunError(99);
(*
  with DT do
  begin
    GetDate(Year,Month,Day,PomW);
    GetTime(Hour,Min,Sec,PomW);
  end;
  PackTime(DT,PomLI);
  GetPackTime:=PomLI;
*)
end;

{-------------------------------------------------}
function fPackTime(DT : tDateTime) : LongInt;
var
  PomLI : LongInt;
begin
{!Ka}
  RunError(99);
(*
  PackTime(DT,PomLI);
  fPAckTime:=PomLI;
*)
end;

{-------------------------------------------------}
function GetDayOfWeek(DT : tDateTime) : Byte;
const
  Cm : array[1..12] of Word
       = (0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334);
begin
{!Ka}
  RunError(99);
(*
  with DT do
  begin
    if (Year mod 4 = 0)and
       ((Year mod 100 <> 0)or(Year mod 1000 = 0))and
       (Month<3)then Dec(Day);
    GetDayOfWeek:=(Day+Cm[Month]+LongInt(Year)*365+(Year div 4 - Year div 100 + Year div 1000)+2) mod 7;
  end;
*)
end;

{-------------------------------------------------}
function GetDayOfWeekPT(Time : LongInt) : Byte;
var
  DT   : tDateTime;
  PomW : Word;
begin
{!Ka}
  RunError(99);
(*
  if Time=0 then
    with DT do
    GetDate(Year,Month,Day,PomW)
  else
    UnPackTime(Time,DT);
  GetDayOfWeekPT:=GetDayOfWeek(DT);
*)
end;

{-------------------------------------------------}
function StrToDate(const S : tString39; var DT : tDateTime) : Boolean;
type
  tWhat = (tpDay, tpMonth, tpYear);
var
  PomDT : tDateTime;
  PomW  : Word;
  ErrFl : Boolean;
  What  : tWhat;
  I     : Byte;
label
  L_End;
begin
{!Ka}
  RunError(99);
(*
  PomDT:=DT;
  ErrFl:=False;
  What :=tpDay;
  I:=1;
  PomW:=ReadWVal(S,I);
  while not ErrFl do
  begin
    case What of
      tpDay:
        begin
          if (PomW>0)and(PomW<32) then
            PomDT.Day:=PomW
          else
          begin
            ErrFl:=True;
            goto L_End;
          end;
          What:=tpMonth;
        end;
      tpMonth:
        begin
          if (PomW>0)and(PomW<13) then
            PomDT.Month:=PomW
          else
          begin
            ErrFl:=True;
            goto L_end;
          end;
          What:=tpYear;
        end;
      tpYear:
        begin
          if PomW>=1980 then { cely udaj roku }
            PomDT.Year:=PomW
          else
          if (PomW>=80)and(PomW<=99) then { posledni dvojcisli roku 1980 az 1999 }
            PomDT.Year:=PomW+1900
          else
          if (PomW>=0)and(PomW<=79) then { posledni dvojcisli roku 2000 az 2079 }
            PomDT.Year:=PomW+2000
          else            { chybny udaj roku }
            ErrFl:=True;
          goto L_End;
        end;
    end;
    PomW:=ReadWVal(S,I);
  end;
 L_End:
  DT:=PomDT;
  StrToDate:=not ErrFl;
*)
end;

{-------------------------------------------------}
function StrToTime(const S : tString39; var DT : tDateTime) : Boolean;
type
  tWhat = (tpHour, tpMin, tpSec);
var
  PomDT : tDateTime;
  PomW  : Word;
  ErrFl : Boolean;
  What  : tWhat;
  I     : Byte;
label
  L_End;
begin
{!Ka}
  RunError(99);
(*
  PomDT:=DT;
  ErrFl:=False;
  What :=tpHour;
  I:=1;
  PomW:=ReadWVal(S,I);
  while not ErrFl do
  begin
    case What of
      tpHour:
        begin
          if (PomW>=0)and(PomW<24) then
            PomDT.Hour:=PomW
          else
          begin
            ErrFl:=True;
            goto L_End;
          end;
          What:=tpMin;
        end;
      tpMin:
        begin
          if (PomW>=0)and(PomW<60) then
            PomDT.Min:=PomW
          else
          begin
            ErrFl:=True;
            goto L_end;
          end;
          What:=tpSec;
        end;
      tpSec:
        begin
          if (PomW>=0)and(PomW<60) then
            PomDT.Sec:=PomW
          else
            ErrFl:=True;
          goto L_End;
        end;
    end;
    PomW:=ReadWVal(S,I);
  end;
 L_End:
  DT:=PomDT;
  StrToTime:=not ErrFl;
*)
end;

{-------------------------------------------------}
function StrToDatePT(const S : tString39; var DT : LongInt ) : Boolean;
var
  PomDT : tDateTime;
begin
{!Ka}
  RunError(99);
(*
  UnPackTime(DT,PomDT);
  StrToDatePT:=StrToDate(S,PomDT);
  DT:=fPackTime(PomDT);
*)
end;

{-------------------------------------------------}
function StrToTimePT(const S : tString39; var DT : LongInt ) : Boolean;
var
  PomDT : tDateTime;
begin
{!Ka}
  RunError(99);
(*
  UnPackTime(DT,PomDT);
  StrToTimePT:=StrToTime(S,PomDT);
  DT:=fPackTime(PomDT);
*)
end;

{ ************************************************************************** }
{-------------------------------------------------}
procedure StrToByteSet(const Str : String; var ByteSet : tByteSet; var ErrCode : Integer);
type
  tInterval = (tpNone, tpWork, tpOk);
var
  PomS     : tString8;
  PomL     : Longint;
  I,J,
  PomB,
  LoMez,
  HiMez    : Byte;
  Interval : tInterval;
  Typ      : tIntType;
label
  L_End;
begin
  ByteSet  := [];
  PomS     := '';
  Interval := tpNone;
  ErrCode  := 0;
  PomB     := 0;
  Typ      := tpDec;
  for I:=1 to Length(Str) do
  begin
    case Str[I] of
      '0'..'9','A'..'F','a'..'f':
        begin
          if ((Typ=tpDec)and(not (Str[I] in ['0'..'9'])))or
             ((Typ=tpHex)and(not (Str[I] in ['0'..'9','A'..'F','a'..'f']))) then
          begin
            ErrCode:=I;
            goto L_End;
          end
          else
            PomS:=PomS+Str[I];
        end;
      '$':
        begin
          if PomS<>'' then
          begin
            ErrCode:=I;
            goto L_End;
          end
          else
            Typ:=tpHex;
        end;
      ',':
        begin
          if I=Length(Str) then
          begin
            ErrCode:=I;
            goto L_End;
          end;
          PomL:=StrToInt(PomS,Typ,ErrCode);
          if PomL>$FF then
            ErrCode:=I
          else
            PomB:=PomL;
          Typ:=tpDec;
          PomS:='';
          if ErrCode<>0 then
          begin
            ErrCode:=I;
            goto L_End;
          end;
          case Interval of
            tpNone:
              begin
                {$ifdef Ver6}
                 ByteSet:=ByteSet+[PomB];
                {$else}
                 Include(ByteSet,PomB);
                {$endif}
              end;
            tpWork:
              begin
                ErrCode:=I;
                goto L_End;
              end;
            tpOk  :
              begin
                Interval:=tpNone;
                HiMez:=PomB;
                for J:=LoMez to HiMez do
                {$ifdef Ver6}
                 ByteSet:=ByteSet+[J];
                {$else}
                 Include(ByteSet,J);
                {$endif}
              end;
          end;
        end;
      '.':
        begin
          Typ:=tpDec;
          if (Interval=tpOk)or(I=Length(Str)) then
          begin
            ErrCode:=I;
            goto L_End;
          end;
          Inc(Interval);
          if Interval=tpWork then
          begin
            PomL:=StrToInt(PomS,Typ,ErrCode);
            if PomL>$FF then
              ErrCode:=I
            else
              LoMez:=PomL;
            PomS:='';
            if ErrCode<>0 then
            begin
              ErrCode:=I;
              goto L_End;
            end;
          end;
        end;
      ' ':
        begin
          Typ:=tpDec;
        end;
      else
        begin
          ErrCode:=I;
          goto L_End;
        end;
    end;
  end;
  if PomS<>'' then
  begin
    PomL:=StrToInt(PomS,Typ,ErrCode);
    if PomL>$FF then
      ErrCode:=I
    else
      PomB:=PomL;
    Typ:=tpDec;
    PomS:='';
    if ErrCode<>0 then
    begin
      ErrCode:=I;
      goto L_End;
    end;
    case Interval of
      tpNone:
        begin
          {$ifdef Ver6}
           ByteSet:=ByteSet+[PomB];
          {$else}
           Include(ByteSet,PomB);
          {$endif}
        end;
      tpWork:
        begin
          ErrCode:=I;
          goto L_End;
        end;
      tpOk  :
        begin
          Interval:=tpNone;
          HiMez:=PomB;
          for J:=LoMez to HiMez do
          {$ifdef Ver6}
           ByteSet:=ByteSet+[J];
          {$else}
           Include(ByteSet,J);
          {$endif}
        end;
    end;
  end;
 L_End:
end;

{-------------------------------------------------}
function ByteSetToStr(ByteSet : tByteSet; HexOrDec : Boolean) : String;
type
  tWhat = (tpBegin,tpPredch,tpInterval);
var
  PomS   : String;
  I,
  Predch : Byte;
  What   : tWhat;
begin
  PomS:='';
  What:=tpBegin;
  for I:=0 to 255 do
    if I in ByteSet then
    begin
      case What of
        tpBegin:
          begin
            Predch:=I;
            What:=tpPredch;
            if HexOrDec then
              PomS:=PomS+'$'+ByteStrHex(I)
            else
              PomS:=PomS+ByteStrDec(I,1);
          end;
        tpPredch:
          begin
            if I-1=Predch then
              What:=tpInterval
            else
              if HexOrDec then
                PomS:=PomS+',$'+ByteStrHex(I)
              else
                PomS:=PomS+','+ByteStrDec(I,1);
            Predch:=I;
          end;
        tpInterval:
          begin
            Predch:=I;
          end;
      end;
    end
    else
    begin
      if What=tpInterval then
      begin
        if HexOrDec then
          PomS:=PomS+'..$'+ByteStrHex(Predch)
        else
          PomS:=PomS+'..'+ByteStrDec(Predch,1);
        What:=tpPredch;
      end;
    end;
  if What=tpInterval then
    if HexOrDec then
      PomS:=PomS+'..$'+ByteStrHex(Predch)
    else
      PomS:=PomS+'..'+ByteStrDec(Predch,1);
  ByteSetToStr:=PomS;
end;

{-------------------------------------------------}
procedure StrToCharSet(const Str : String; var CharSet : tCharSet; var ErrCode : Integer);
type
  tInterval = (tpNone, tpWork, tpOk);
  tWhat     = (tpBegin, tpChar, tpEnd);
var
  I           : Byte;
  J,PomCh,
  LoMez,HiMez : Char;
  Interval    : tInterval;
  What        : tWhat;
  FlChar      : Boolean;
label
  L_End;
begin
  CharSet  := [];
  Interval := tpNone;
  What     := tpEnd;
  ErrCode  := 0;
  PomCh    := #0;
  FlChar   := False;
  for I:=1 to Length(Str) do
  begin
    case What of
      tpBegin:
        begin
          PomCh:=Str[I];
          What:=tpChar;
        end;
      tpChar :
        begin
          if Str[I]='''' then
          begin
            What:=tpEnd;
            FlChar:=True;
          end
          else
          begin
            ErrCode:=I;
            goto L_End;
          end;
        end;
      tpEnd  :
        begin
          FlChar:=False;
          case Str[I] of
            '''':
              What:=tpBegin;
            ',' :
              begin
                if I=Length(Str) then
                begin
                  ErrCode:=I;
                  goto L_End;
                end;
                case Interval of
                  tpNone:
                    {$ifdef Ver6}
                     CharSet:=CharSet+[PomCh];
                    {$else}
                     Include(CharSet,PomCh);
                    {$endif}
                  tpWork:
                    begin
                      ErrCode:=I;
                      goto L_End;
                    end;
                  tpOk  :
                    begin
                      Interval:=tpNone;
                      HiMez:=PomCh;
                      for J:=LoMez to HiMez do
                      {$ifdef Ver6}
                       CharSet:=CharSet+[J];
                      {$else}
                       Include(CharSet,J);
                      {$endif}
                    end;
                end;
              end;
            '.' :
              begin
                if (Interval=tpOk)or(I=Length(Str)) then
                begin
                  ErrCode:=I;
                  goto L_End;
                end;
                Inc(Interval);
                if Interval=tpWork then LoMez:=PomCh;
              end;
            ' ': ;
            else
              begin
                ErrCode:=I;
                goto L_End;
              end;
          end;
        end;
    end;
  end;
  if FlChar then
    case Interval of
      tpNone:
        {$ifdef Ver6}
         CharSet:=CharSet+[PomCh];
        {$else}
         Include(CharSet,PomCh);
        {$endif}
      tpWork:
        begin
          ErrCode:=I;
          goto L_End;
        end;
      tpOk  :
        begin
          Interval:=tpNone;
          HiMez:=PomCh;
          for J:=LoMez to HiMez do
          {$ifdef Ver6}
           CharSet:=CharSet+[J];
          {$else}
           Include(CharSet,J);
          {$endif}
        end;
    end;
 L_End:
end;

{-------------------------------------------------}
function CharSetToStr(CharSet : tCharSet; HexOrDec : Boolean) : String;
type
  tWhat = (tpBegin, tpPredch, tpInterval);
var
  PomS     : String;
  I,Predch : char;
  What     : tWhat;
begin
  PomS:='';
  What:=tpBegin;
  for I:=#0 to #255 do
  if I in CharSet then
  begin
    case What of
      tpBegin:
        begin
          Predch:=I;
          What:=tpPredch;
          if I in [#32..#255] then
            PomS:=PomS+''''+I+''''
          else
            if HexOrDec then
              PomS:=PomS+'#$'+ByteStrHex(Ord(I))
            else
              PomS:=PomS+'#'+ByteStrDec(Ord(I),1);
        end;
      tpPredch:
        begin
          if Chr(Ord(I)-1)=Predch then
            What:=tpInterval
          else
            if I in [#32..#255] then
              PomS:=PomS+','''+I+''''
            else
              if HexOrDec then
                PomS:=PomS+',#$'+ByteStrHex(Ord(I))
              else
                PomS:=PomS+',#'+ByteStrDec(Ord(I),1);
          Predch:=I;
        end;
      tpInterval:
        begin
          Predch:=I;
        end;
    end;
  end
  else
  begin
    if What=tpInterval then
    begin
      if Predch in [#32..#255] then
        PomS:=PomS+'..'''+Predch+''''
      else
        if HexOrDec then
          PomS:=PomS+'..#$'+ByteStrHex(Ord(Predch))
        else
          PomS:=PomS+'..#'+ByteStrDec(Ord(Predch),1);
      What:=tpPredch;
    end;
  end;
  if What=tpInterval then
    if Predch in [#32..#255] then
      PomS:=PomS+'..'''+Predch+''''
    else
      if HexOrDec then
        PomS:=PomS+'..#$'+ByteStrHex(Ord(Predch))
      else
        PomS:=PomS+'..#'+ByteStrDec(Ord(Predch),1);
  CharSetToStr:=PomS;
end;

{ ************************************************************************** }
{-------------------------------------------------}
function BufferStrHex(P : Pointer; Len : Byte) : String;
var
  I    : Byte;
  PomS : String;
  B    : ^Byte;
begin
  PomS:='';
  if Len>127 then Len:=127;
  B:=P;
  for I:=1 to Len do
  begin
    if I<>1 then Inc(B);
    PomS:=PomS+ByteStrHex(B^);
  end;
  BufferStrHex:=PomS;
end;

{-------------------------------------------------}
function BufferStrHex2(P : Pointer; Len : Byte) : String;
var
  I    : Byte;
  PomS : String;
  B    : ^Byte;
begin
  PomS:='';
  if Len>64 then Len:=64;
  B:=P;
  for I:=1 to Len do
  begin
    if I<>1 then Inc(B);
    PomS:=PomS+'$'+ByteStrHex(B^)+' ';
  end;
  BufferStrHex2:=PomS;
end;

{-------------------------------------------------}
function StrHexBuffer(const S : String; P : pointer) : Byte;
type
  tWhat = (tpNone, tpHi, tpLo);
var
  B    : ^Byte;
  I    : Byte;
  What : tWhat;
  PomS : tString2;
  Len  : Byte;
  procedure Sett;
  begin
    What:=tpNone;
    B^:=HexStrByte(PomS);
    PomS:='';
    Inc(B);
    Inc(Len);
  end;
begin
  B:=P;
  I:=1;
  Len:=0;
  What:=tpNone;
  PomS:='';
  while I<=Length(S) do
  begin
    if not (S[I] in ['0'..'9','A'..'F','a'..'f']) then
    begin
      if What<>tpNone then Sett;
    end
    else
      case What of
        tpNone,
        tpHi  :
          begin
            Inc(What);
            PomS:=PomS+S[I];
          end;
        tpLo  :
          begin
            Sett;
            Dec(I);
          end;
      end;
    Inc(I);
  end;
  if What<>tpNone then Sett;
  StrHexBuffer:=Len;
end;

{-------------------------------------------------}
function PtrToStr(P : Pointer) : tString11;
begin
{!Ka}
  RunError(99);
(*
  PtrToStr:='$'+WordStrHex(Seg(P^))+':$'+WordStrHex(Ofs(P^));
*)
end;

{-------------------------------------------------}
function StrToPtr(S : tString11) : Pointer;
type
  tWhat = (tpBeg1, tpSeg, tpBeg2, tpOfs);
var
  SegStr,
  OfsStr  : tString4;
  FlErr   : Boolean;
  What    : tWhat;
  I       : Byte;
begin
{!Ka}
  RunError(99);
(*
  SegStr := '';
  OfsStr := '';
  FlErr  := false;
  What   := tpBeg1;
  I      := 1;
  while (not FlErr)and(I<=Length(S)) do
  begin
    if S[I]<>' ' then
      case What of
        tpBeg1:
          begin
            if S[I]='$' then
              What  := tpSeg
            else
              FlErr := true;
          end;
        tpSeg :
          begin
            if (S[I] in ['0'..'9','a'..'f','A'..'F'])and(Length(SegStr)<4) then
              SegStr := SegStr+S[I]
            else
              if S[I]=':' then
                What  := tpBeg2
              else
                FlErr := true;
          end;
        tpBeg2:
          begin
            if S[I]='$' then
              What  := tpOfs
            else
              FlErr := true;
          end;
        tpOfs :
          begin
            if (S[I] in ['0'..'9','a'..'f','A'..'F'])and(Length(OfsStr)<4) then
              OfsStr := OfsStr+S[I]
            else
              FlErr  := true;
          end;
      end;
    Inc(I);
  end;
  if FlErr then
    StrToPtr := nil
  else
    StrToPtr := Ptr(HexStrWord(SegStr),HexStrWord(OfsStr));
*)
end;

{-------------------------------------------------}
function PtrToLongint(P : Pointer) : LongInt;
begin
{!Ka}
  RunError(99);
(*
  PtrToLongint:=(longint(Seg(P^)) shl 16)+Ofs(P^);
*)
end;

{-------------------------------------------------}
function LongintToPtr(L : LongInt) : Pointer;
begin
{!Ka}
  RunError(99);
(*
  LongintToPtr:=Ptr(word(L shr 16),word(L and $0000FFFF));
*)
end;

{-------------------------------------------------}
function ConvertByteBits(B : Byte; const ConvTabB : tConvTabByte) : Byte;
var
  O, J : Byte;
begin
  O:=0;
  for J:=0 to 7 do
  begin
    O:=O shl 1;
    if (B and (1 shl (ConvTabB[J])))<>0 then
      Inc(O);
  end;
  ConvertByteBits:=O;
end;

{-------------------------------------------------}
function ConvertWordBits(W : Word; const ConvTabW : tConvTabWord) : Word;
var
  O, J : Word;
begin
  O:=0;
  for J:=0 to 15 do
  begin
    O:=O shl 1;
    if (W and (1 shl (ConvTabW[J])))<>0 then
      Inc(O);
  end;
  ConvertWordBits:=O;
end;

{ ************************************************************************** }
{-------------------------------------------------}
End.
