unit Chn;

          {ͻ}
          {                                                        }
          {  unit Chn                                              }
          {                                                        }
          {  jednotka obecneho komunikacniho kanalu                }
          {                                                        }
          {  (C)1998 SofCon, Steovick 49, 160 00 Praha 6        }
          {          Ing. Vladimr Kastner, Na Vlovce 6, Praha 6  }
          {               Adam Wild, Dejvicka 42, Praha 6          }
          {ͼ}

interface

uses
  ChnVirt,
  uString;

const
  cName     = 'CHN';
  cVer      = 'v4.0, 04.01.1999';

type
  tChn = class(tChnVirt)
    constructor Init;                      { vytvoreni objektu }
    constructor ChInitParam(const S: TParamStr); { vytvoreni objektu a nastaveni parametru }
    destructor  Destroy;
                  override;             { zruseni objektu }

   { zadani a zobrazeni zadanych parametru }
    function  ChGetParam(const S: TParamStr): TParamStr;
                override; { prevod parametru kanalu do stringu }

   { otevreni a zavreni HW kanalu, navazani a zruseni komunikace }
    procedure ChOpen;
                override; { otevereni HW kanalu }
    procedure ChClose;
                override; { zavreni HW kanalu }
    procedure ChConnect;
                override; { pocatek navazovani spojeni }
    procedure ChDisConnect;
                override; { pocatek ukonceni spojeni }
    function  ChState: TCHState;
                override; { naposledy dosazeny stabilni stav }
    function  ChReady: TCHState;
                override; { krok automatu,cteni stavu kanalu}

   { vysilani dat }
    procedure ChDestNode(Node: TNode);
                override; { urceni adresata zpravy }
    procedure ChSend(Buff: Pointer; Len: Word);
                override; { pocatek vysilani }
    function  ChSendReady: TCHState;
                override; { krok vysilaciho aut., stav vysilani }
    procedure ChSendFlush;
                override; { preruseni vysilani }

   { prijem dat }
    procedure ChReceiveBuffer(Buff: pointer; Len: Word);
                override; { definovani prijimaciho bufferu }
    function  ChReceiveReady: TCHState;
                override; { krok prij. automatu, stav prijmu }
    procedure ChReceive(var Len: Word);
                override; { prijem zpravy }
    function  ChReceiveChar: Byte;
                override; { prijem 1 znaku zpravy }
    procedure ChReceiveFlush;
                override; { stav jako po inicializaci }
    procedure ChGetNode(var SNode, DNode: TNode);
                override; { odesilatel, adresat zpravy }

   { provedeni kroku automatu kanalu, vysilace, prijimace }
    procedure ChTick;
                override;
  end;

type
  TAddChn = class(TAddChnVirt)
    function ChInit: tChnVirt; override; { funkce provadejici zalozeni a inicializaci daneho kanalu }
  end;

implementation

{$ifdef HardLock}
uses
  HardLock;
{$endif}

function TAddChn.ChInit: tChnVirt;
begin
  ChInit:=tChn.Init;
end;

{===================================================}
constructor TChn.Init;
begin
  inherited;
  CH_Type     := cName;
  CH_Name     := CH_Type;
  CH_NumName  := ChNumName(CH_Type);
end;

constructor TChn.ChInitParam(const S: TParamStr);
begin
  Init;
  ChSetParam(S);
end;

destructor  TChn.Destroy;
begin
  inherited;
end;

function TChn.ChGetParam(const S: TParamStr): TParamStr;
begin
  if CH_Chn=nil then
  begin
    ChGetParam:='NAM='+CH_Name;
    ChSetResult(res_Ok);
  end
  else
  begin
    ChGetParam:='NAM='+CH_Name+' '+CH_Chn.ChGetParam(S); { volame tutez metodu z podrizeneho kanalu }
    ChSetResult(CH_Chn.ChResult);
  end;
end;

procedure TChn.ChOpen;
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChOpen;
    ChSetResult(CH_Chn.ChResult);
    if CH_Result=res_Ok then
    begin
      CH_Ctrl :=CH_Chn.CH_Ctrl;{CHS_Open;}
      CH_State:=CH_Chn.CH_State;{CH_Ctrl;}
    end;
  end
  else
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
end;

procedure TChn.ChClose;
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChClose;
    ChSetResult(CH_Chn.ChResult);
    if CH_Result=res_Ok then
    begin
      CH_Ctrl :=CH_Chn.CH_Ctrl;{CHS_Close;}
      CH_State:=CH_Chn.CH_State;{CH_Ctrl;}
    end;
  end
  else
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
end;

procedure TChn.ChConnect;
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChConnect;
    ChSetResult(CH_Chn.ChResult);
    if CH_Result=res_Ok then
    begin
      CH_Ctrl :=CH_Chn.CH_Ctrl;{CHS_Connect;}
      CH_State:=CH_Chn.CH_State;{CH_Ctrl;}
    end;
  end
  else
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
end;

procedure TChn.ChDisConnect;
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChDisConnect;
    ChSetResult(CH_Chn.ChResult);
    if CH_Result=res_Ok then
    begin
      CH_Ctrl :=CH_Chn.CH_Ctrl;{CHS_DisConnect;}
      CH_State:=CH_Chn.CH_State;{CH_Ctrl;}
    end;
  end
  else
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
end;

function TChn.ChState: TCHState;
begin
  if Assigned(CH_Chn) then
  begin
    CH_Ctrl :=CH_Chn.ChReady; { vola se ChTick zretezene knihovny }
    CH_State:=CH_Chn.CH_State;
    ChSetResult(CH_Chn.ChResult);
  end
  else
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
  ChTick;
  ChState:=CH_State;
end;

function  TChn.ChReady: TCHState;
begin
  if Assigned(CH_Chn) then
  begin
    CH_Ctrl :=CH_Chn.ChReady; { vola se ChTick zretezene knihovny }
    CH_State:=CH_Chn.CH_State;
    ChSetResult(CH_Chn.ChResult);
  end
  else
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
  ChTick;
  ChReady:=CH_State;
end;

procedure TChn.ChDestNode(Node: TNode);
begin
  CH_DNode:=Node;
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChDestNode(Node);
    ChSetResult(CH_Chn.ChResult);
  end
  else
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
end;

procedure TChn.ChSend(Buff: Pointer; Len: Word);
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChSend(Buff,len);
    ChSetSendResult(CH_Chn.ChSendResult);
  end
  else
    ChSetSendResult(CH_NumName or res_ErrChannelNoExist);
end;

function  TChn.ChSendReady: TCHState;
begin
  ChSendTick;
  if Assigned(CH_Chn) then
  begin
    ChSendReady:=CH_Chn.ChSendReady;
    ChSetSendResult(CH_Chn.ChSendResult);
  end
  else
  begin
    ChSendReady:=CHS_SendNoReady;
    ChSetSendResult(CH_NumName or res_ErrChannelNoExist);
  end;
end;

procedure TChn.ChSendFlush;
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChSendFlush;
    ChSetSendResult(CH_Chn.ChSendResult);
  end
  else
    ChSetSendResult(CH_NumName or res_ErrChannelNoExist);
end;

procedure TChn.ChReceiveBuffer(Buff: pointer; Len: Word);
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChReceiveBuffer(Buff,Len);
    ChSetReceiveResult(CH_Chn.ChReceiveResult);
  end
  else
    ChSetReceiveResult(CH_NumName or res_ErrChannelNoExist);
end;

function  TChn.ChReceiveReady: TChState; 
begin
  if Assigned(CH_Chn) then
  begin
    ChReceiveReady:=CH_Chn.ChReceiveReady;
    ChSetReceiveResult(res_Ok);
  end
  else
  begin
    ChReceiveReady:=CHS_ReceiveNoReady;
    ChSetReceiveResult(CH_NumName or res_ErrChannelNoExist);
  end;
end;

procedure TChn.ChReceive(var Len: Word);
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChReceive(Len);
    ChSetReceiveResult(CH_Chn.ChReceiveResult);
  end
  else
  begin
    Len:=0;
    ChSetReceiveResult(CH_NumName or res_ErrChannelNoExist);
  end;
end;

function TChn.ChReceiveChar: Byte;
begin
  if Assigned(CH_Chn) then
  begin
    ChReceiveChar:=CH_Chn.ChReceiveChar;
    ChSetReceiveResult(CH_Chn.ChReceiveResult);
  end
  else
  begin
    ChReceiveChar:=0;
    ChSetReceiveResult(CH_NumName or res_ErrChannelNoExist);
  end;
end;

procedure TChn.ChReceiveFlush;
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChReceiveFlush;
    ChSetReceiveResult(CH_Chn.ChReceiveResult);
  end
  else
    ChSetReceiveResult(CH_NumName or res_ErrChannelNoExist);
end;

procedure TChn.ChGetNode(var SNode, DNode: TNode);
begin
  if Assigned(CH_Chn) then
  begin
    CH_Chn.ChGetNode(SNode,DNode);
    ChSetReceiveResult(CH_Chn.ChReceiveResult);
  end
  else
    ChSetReceiveResult(CH_NumName or res_ErrChannelNoExist);
end;

procedure TChn.ChTick;
begin
  if Assigned(CH_Chn) then
    CH_Chn.ChTick
  else
    ChSetResult(CH_NumName or res_ErrChannelNoExist);
end;
{===================================================}

Begin
  ChnCollection.Insert(tAddChn.Init(Nil));

  {$ifdef HardLock}
  if not TestHardLock then RunError(99);
  {$endif}
End.
