unit Timer;

          {ͻ}
          {                                                        }
          {  unit Timer                                            }
          {                                                        }
          {  jednotka pro odmerovani casovych intervalu            }
          {                                                        }
          {  (C)2001 SofCon, Stresovicka 49, 160 00 Praha 6        }
          {               Adam Wild                                }
          {                                                        }
          {ͼ}


interface

uses
  ExtCtrls;

const
  cName     = 'Timer';
  cVer      = 'v4.0, 11.11.2001';

const
  IRQTime : word = 55;

type
  tTimer = class(TObject)
    constructor Init;
    destructor Done; virtual;
    procedure SaveTime;
    function  TstTime (Ms:LongInt):Boolean;
                { Test, zda uplynulo Ms milisekund }
    function  ReadTime   :LongInt;
                { Vraci kolik ms uplynulo od nastaveni }
    procedure SetCount(Ms:LongInt);
                { Zaznamena jak dlouho se ma cekat }
    function  TstCount   :Boolean;
                { Vraci true, pokud zadany cas jiz ubehl }
    function  ReadCount  :LongInt;
                { Vraci kolik ms zbyva do vyprseni nastaveneho casu }
   private
    Tm         : ExtCtrls.tTimer;

    vTime      : Longint;
    cTime      : Longint;

    procedure TmOnTimer(Sender: TObject);
  end;

implementation

constructor tTimer.Init;
begin
  Create;
  Tm:=ExtCtrls.tTimer.Create(nil);
  Tm.Enabled:=False;
  Tm.Interval:=IRQTime;
end;

destructor tTimer.Done;
begin
  Tm.Free;
  Tm:=nil;
  inherited;
end;

procedure tTimer.SaveTime;
  { zaznamena hodnotu aktualniho casu }
begin
  Tm.Enabled:=False;
  vTime:=0;
  Tm.Interval:=IRQTime;
  Tm.OnTimer:=TmOnTimer;
  Tm.Enabled:=True;
end;

procedure tTimer.SetCount(Ms:LongInt);
  { zaznamena jak dlouho se ma cekat }
begin
  cTime:=Ms;
end;

function tTimer.TstTime(Ms: LongInt):Boolean;
  {test, zda uplynulo Ms milisekund}
begin
  TstTime := vTime >= Ms;
end;

function tTimer.ReadTime:LongInt;
  {Vraci kolik ms uplynulo od nastaveni}
begin
  ReadTime:=vTime;
end;

function tTimer.TstCount:Boolean;
  { funkce vraci true, pokud zadany cas jiz ubehl }
begin
  TstCount := vTime >= cTime;
end;

function tTimer.ReadCount:LongInt;
  {Vraci kolik ms zbyva do vyprseni nastaveneho casu}
begin
  ReadCount:=cTime-vTime;
end;

procedure tTimer.TmOnTimer(Sender: TObject);
begin
  if vTime<High(vTime)-IRQTime then
    Inc(vTime,IRQTime);
end;

end.
