unit uGlb;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, Buttons, ToolWin,
  StdCtrls,
  uString,
 {komunikacni knihovny}
  ChnVirt,
  Chn,
  ChnCom,
  ChnMBox,
  ChnSMS,
  ChnMod2,
  ChnPrt,
  ChnLecom;
 {@ zde dalsi knihovny}

const
 {konstanty knihoven - naplnuje se jimi promenna ChnType typu tChnType}
  {konstanty knihoven fyzicke vrstvy (HW layer)}
  cLibChnCom   = 0 shl 0;
  cLibChnMBox  = 1 shl 0;
  {konstanty knihoven mezivrstvy (Middle layer)}
  cLibNoMid    = 0 shl 2;
  cLibChnMod   = 1 shl 2;
  {konstanty knihoven protokolove vrstvy (Prt layer)}
  cLibNoPrt    = 0 shl 4;
  cLibChnPrt   = 1 shl 4;
  cLibChnLecom = 2 shl 4;
  {konstanta pro pouziti nejvyssi vrstvy obecne knihovny (Chn)}
  cLibChn      = 1 shl 7;

 {struktura promenne ChnType
     7     6   5   4     3      2       1   0
  ----------------------------------------------
  | Chn  | Prt layer | Middle layer | HW layer |
  ----------------------------------------------
 }
 {konstanty pro vymaskovani jednotlivych vrstev}
  cMskLayerHW  = $03; {pro vymaskovani fyzicke vrstvy}
  cMskLayerMid = $0C; {pro vymaskovani mezivrstvy}
  cMskLayerPrt = $70; {pro vymaskovani protokolove vrstvy}
  cMskLayerChn = $80; {pro vymaskovani nejvyssi vrstvy obecne knihovny}

type
  tChnType = byte;

type
  tChnState = {vycet stavu komunikacniho kanalu aplikace}
   (tpDone,          {kanal je zrusen - nil}
    tpInit,          {kanal je nainicializovan a zavren a proveden SetParam}
     tpOpenning,     {kanal se otvira}
    tpOpen,          {kanal je otevren}
     tpConnecting,   {kanal navazuje spojeni}
    tpConnect,       {kanal navazal spojeni - muzou se posilat a prijimat data}
     tpDisConnecting,{kanal se DisConnecti}
    tpDisConnect,    {kanal je DisConnect}
     tpClosing       {kanal se zavira}
    );

type
  tChannelRange = 'A'..'B';

const
  cParChn      : array[tChannelRange] of string =
    ('NAM=CHN',
     'NAM=CHN');

  cParChnPrt   : array[tChannelRange] of string =
    ('NAM=PRT NOD=1 DNO=2 LSB=1000',
     'NAM=PRT NOD=2 DNO=1 LSB=1000');
  cParChnLecom : array[tChannelRange] of string =
    ('NAM=LECOM NOD=1 DNO=2 SCD=ON LSB=1000 MAS=MASTER',
     'NAM=LECOM NOD=2 DNO=1 SCD=ON LSB=1000 MAS=SLAVE');

  cParChnMod2  : array[tChannelRange] of string =
    ('NAM=MOD2 MAS=MASTER I1S=''ATZ'' I2S=''ATL1M3'' I3S=''ATS0=1'' PNS=''ATD'' '+
      'REP=1 DES=500 DIL=500 DIH=500 DHL=500 DHH=500 QD1=35000',
     'NAM=MOD2 MAS=SLAVE  I1S=''ATZ'' I2S=''ATL1M3'' I3S=''ATS0=1'' PNS=''ATD'' '+
      'REP=1 DES=500 DIL=500 DIH=500 DHL=500 DHH=500 QD1=35000');

  cParChnMBox  : array[tChannelRange] of string =
    ('NAM=MBOX',
     'NAM=MBOX');
  cParChnCom   : array[tChannelRange] of string =
    ('NAM=COM COM=1 BD=9600 BIT=8 PAR=N STO=1 LRB=1000',
     'NAM=COM COM=2 BD=9600 BIT=8 PAR=N STO=1 LRB=1000');
 {@ zde dalsi knihovny - retezce parametru}

const
  MaxLength = 10000;

type
  tViewChar = {vycet druhu vypisu prijatych znaku pro znakove protokoly}
   (tpASCII,
    tpHex,
    tpDec);

type
  pBuff = ^tBuff;
  tBuff = array[0..MaxLength-1]of Byte; {prijimaci buffer znakovych protokolu}

type
 {zaznam jednoho kanalu}
  tChannel = class(TObject)
    ChannelChar       : tChannelRange; { identifikacni znak kanalu }
    ChnObj            : tChnVirt;      { ukazatel na instanci kanalu }
    WantChnState      : tChnState;     { pozadovany stav celeho komunikacniho kanalu }
    ChnParam          : tParamStr;     { aktualni parametry kanalu }
    ChnSendBuff       : pointer;       { ukazatel na vysilaci buffer }
    ChnLenSendBuff    : word;          { velikost vysilaciho bufferu }
    ChnRecBuff        : pointer;       { ukazatel na prijimaci buffer }
    ChnLenRecBuff     : word;          { velikost prijimaciho bufferu }
    ChnRecStop        : Boolean;       { priznak pozastaveni prijmu }
    ChnParChnMBox     : tParamStr;     { parametry pro kanal s fyzickou vrstvou ChnMBox }
    ChnParChnCom      : tParamStr;     { parametry pro kanal s fyzickou vrstvou ChnCom }
    ChnParChnPrt      : tParamStr;     { parametry pro kanal s protokolem ChnPrt }
    ChnParChnLecom    : tParamStr;     { parametry pro kanal s protokolem ChnLecom }
    ChnParChnMod2     : tParamStr;     { parametry pro kanal pres modem }
    ChnParChn         : tParamStr;     { parametry pro kanal pres Chn }
    {@ zde dalsi knihovny - retezce parametru ChnParChnXxx}
   private
    {ovladaci komponenty - jsou ukazateli na skutecne komponenty formulare - proto je nevytvaret ani nerusit}
    AktChnState       : tChnState;     {aktualni stav celeho komunikacniho kanalu}
    LabelChnState     : tLabel;        {komponenta napisu se stavem kanalu}
    ListBox           : tListBox;      {komponenta okna pro vypis prijatych znaku}
    ButtonInit        : TButton;       {komponenta tlacitka pro inicializaci kanalu}
    ButtonSend        : TButton;       {komponenta tlacitka pro odeslani zpravy}
    EditParamChn,
    EditParamPrt,
    EditParamMid,
    EditParamHW       : tEdit;          {komponenty pro parametry kanalu}
    ProgressBar       : tProgressBar;   {komponenta pro indikaci prubehu prace s kanalem}
   published
    constructor Create(CharChn    : tChannelRange;
                       StateLabel : tLabel;
                       RecListBox : tListBox;
                       InitButton,
                       SendButton : tButton;
                       EdParChn,EdParPrt,EdParMid,EdParHW: tEdit;
                       StateProgressBar: tProgressBar);
    destructor  Destroy; override;
    function  ChannelParamStr : string; {posklada retezce vsech vstev kanalu}
    procedure DoneChn;    {pocatek zruseni navazaneho spojeni a instance komunikacniho kanalu}
    procedure InitChn;    {pocatek vytvoreni instance komunikacniho kanalu a navazani spojeni}
    procedure SendChn;    {pocatek Send komunikacniho kanalu - volat v aplikaci napr. pri stisku nejakeho tlacitka}
    procedure ReadChn;    {obsluha Receive komunikacniho kanalu - vola se periodicky v MakeChn, nikde jinde nevolat}
    procedure MakeChn;    {automat kompletni obsluhy kanalu - vola se periodicky v casovaci}
    procedure SaveParChn; {ulozeni retezcu parametru z komponent EditParamXxx do retezcu ChnParChnXxx - volat pred zmenou ChnType}
    procedure LoadParChn; {nahrani ulozenych retezcu parametru v ChnParChnXxx do komponent EditParamXxx - volat po zmene ChnType}
    function  ChannelInStabilState : boolean; {vrati True je-li automat kanalu (MakeChn) v nejakem stabilnim stavu}
    function  ErrorStr(Res:tChResult):ShortString; {vrati retezec s pripadnou chybou nebo Ok}
   private
    procedure ChnOpen;      {pocatek otvirani kanalu - volano v MakeChn po InitChn}
    procedure ChnConnect;   {pocatek navazovani spojeni - volano v MakeChn po InitChn a hnOpen}
    procedure ChnDisConnect;{pocatek ruseni navazaneho spojeni - volano v DoneChn}
    procedure ChnClose;     {pocatek zavirani kanalu - volano v MakeChn po DoneChn}

    procedure LabelChnStateCaption(const S:shortstring; C:tColor); {nastavi vlastnost Caption komponenty LabelChnState na S a vlastnost Font.Color na C}
    procedure ListBoxAppend(const S:string); {prida na konec listboxu ListBox radek S a pripadne odroluje nahoru aby byl dolni radek videt}
    procedure ProgressBarClr;    {vymaze progressbar ProgressBar}
    procedure ProgressBarStepIt; {provede krok progress baru ProgressBar s pulzovanim dopredu (k Max) a zpet (k Min)}
  end;

const
  ChnType      : tChnType   = cLibChnCom; { typ kanalu - viz konstanty cLibChnXxx }
  ChnViewChar  : tViewChar  = tpHex;      { typ vypisu prijatych znaku pro znakove protokoly }
const
  Channel : array[tChannelRange]of tChannel = (nil,nil);
const
  ChnMailBox1  : tMailBox = nil;{ 1.schranka pro komunikace pres ChnMBox }
  ChnMailBox2  : tMailBox = nil;{ 2.schranka pro komunikace pres ChnMBox }

type
  {vycet vrstev komunikacniho kanalu}
  tLayer =
   (tlNil,      {vrstva neni nainicializovana}
    tlChn,      {vrstva je obecny kanal pres Chn}
    tlPrt,      {vrstva je nektery z protokolu (napr. ChnPrt)}
    tlMid,      {vrstva je stredni (napr. ChnMod2)}
    tlHW,       {vrstva je hardwarova (napr. ChnCom)}
    tlUnknown,  {neznama - jina vrstva}
    tlVirt);    {vrstva je virtualni - ChnVirt}

function GetTypeOfChnLayer(Ch:tChnVirt): tLayer;
  {vrati typ komunikacni vrstvy}

{-------------}
implementation
{-------------}

uses
  uFormM;

{=====================================================================}
{                           t C h a n n e l                           }
{=====================================================================}
constructor tChannel.Create(CharChn: tChannelRange; StateLabel: tLabel; RecListBox: tListBox; InitButton, SendButton: tButton; EdParChn,EdParPrt,EdParMid,EdParHW: tEdit; StateProgressBar: tProgressBar);
begin
  ChannelChar       := CharChn;
  ChnObj            := nil;
  WantChnState      := tpDone;
  AktChnState       := WantChnState;
  ChnParam          := '';
  ChnSendBuff       := nil;
  ChnLenSendBuff    := 0;
  ChnRecBuff        := nil;
  ChnLenRecBuff     := 0;
  ChnRecStop        := false;
  ChnParChnMBox     := cParChnMBox [ChannelChar];
  ChnParChnCom      := cParChnCom  [ChannelChar];
  ChnParChnPrt      := cParChnPrt  [ChannelChar];
  ChnParChnLecom    := cParChnLecom[ChannelChar];
  ChnParChnMod2     := cParChnMod2 [ChannelChar];
  ChnParChn         := cParChn     [ChannelChar];
  {@ zde dalsi knihovny - retezce parametru ChnParChnXxx}
  LabelChnState     := StateLabel;
  ListBox           := RecListBox;
  ButtonInit        := InitButton;
  ButtonSend        := SendButton;
  EditParamChn      := EdParChn;
  EditParamPrt      := EdParPrt;
  EditParamMid      := EdParMid;
  EditParamHW       := EdParHW;
  ProgressBar       := StateProgressBar;
  LoadParChn;
end;
{---------------------------------------------------------------------}
destructor  tChannel.Destroy;
begin
  DoneChn;
end;
{---------------------------------------------------------------------}
function  tChannel.ChannelParamStr : string;
begin
  if Assigned(EditParamChn) then
    if EditParamChn.Text<>'' then
         Result:=EditParamChn.Text+' '
    else Result:=''
  else Result:='';
  if Assigned(EditParamPrt) then if EditParamPrt.Text<>'' then Result:=Result+EditParamPrt.Text+' ';
  if Assigned(EditParamMid) then if EditParamMid.Text<>'' then Result:=Result+EditParamMid.Text+' ';
  if Assigned(EditParamHW ) then if EditParamHW .Text<>'' then Result:=Result+EditParamHW .Text;
end;
{---------------------------------------------------------------------}
procedure tChannel.DoneChn;
begin
  if Assigned(ButtonSend) then ButtonSend.Enabled:=False;
  WantChnState:=tpDone;

  ProgressBarClr;
  if Assigned(ChnObj) then
  with ChnObj do
  begin
    if ChState=CHS_Connect then
    begin
      ChnDisConnect;
    end
    else
    if ChState=CHS_Open then
    begin
      ChnClose;
    end
    else
    if ChState=CHS_Close then
    begin
      if Assigned(ChnRecBuff ) then FreeMem(ChnRecBuff ,ChnLenRecBuff); ChnRecBuff :=nil;
      if Assigned(ChnSendBuff) then FreeMem(ChnSendBuff,ChnLenSendBuff);ChnSendBuff:=nil;
      ChnObj.Done;
      ChnObj:=nil;
      WantChnState:=tpDone;
      AktChnState:=WantChnState;
      LabelChnStateCaption('Channel not Inited',clRed);
      ProgressBarClr;
      ButtonInit.Caption:='Init Channel '+ChannelChar;
    end;
  end;
end;
{---------------------------------------------------------------------}
procedure tChannel.InitChn;
var
  s         : tParamStr;
  Sts       : word;
begin
 {pri nainicializovanem kanalu ho zrusit}
  DoneChn;
  WantChnState:=tpConnect;
  if AktChnState<>tpDone then Exit;

  ButtonInit.Caption:='Done Channel '+ChannelChar;
 {inicializace kanalu}
  ProgressBarClr;
  if (ChnType and cMskLayerChn)<>0 then
  begin
    ChnObj:=tChn.Init;
  end
  else
  case ChnType and cMskLayerPrt of
    cLibChnPrt  : ChnObj:=tChnPrt  .Init;
    cLibChnLecom: ChnObj:=tChnLecom.Init;
    else
      case ChnType and cMskLayerMid of
        cLibChnMod :ChnObj:=tChnMod2.Init;
        else
          case ChnType and cMskLayerHW of
            cLibChnCom :ChnObj:=tChnCom .Init;
            cLibChnMBox:ChnObj:=tChnMBox.Init;
            else        ChnObj:=tChn    .Init;
          end;
      end;
    {@ zde dalsi knihovny}
  end;
  LabelChnStateCaption('Channel is Closed',clBlue);
  with ChnObj do
  begin
    ChnParam:=ChannelParamStr;
    ChSetParam(ChnParam);
    Sts:=ChResult;
    if Sts<>res_OK then ListBoxAppend('ChSetParam '+ErrorStr(Sts));
    s:=ChGetParam('');
    if Sts=res_Ok then {ChSetParam probehl v poradku}
    begin
      {inicializace prijimacich a vysilacich bufferu}
      case ChnType and cMskLayerPrt of
        cLibNoPrt   ,
        cLibChnPrt  :
          begin
            ChnLenSendBuff:=MaxLength;
            ChnLenRecBuff :=MaxLength;
          end;
        cLibChnLecom:
          begin
            ChnLenSendBuff:=SizeOf(ChnLecom.tSendRecord);
            ChnLenRecBuff :=SizeOf(ChnLecom.tRecRecord);
          end;
        {@ zde dalsi knihovny}
      end;
      case ChnType and cMskLayerHW of
        cLibChnMBox :
          begin
            if not Assigned(ChnMailBox1) then ChnMailBox1:=tMailBox.Init(1000);
            if not Assigned(ChnMailBox2) then ChnMailBox2:=tMailBox.Init(1000);
            case ChannelChar of
              'A':ChSetParam('NAM=MBOX RMB='+IntToStr(longint(pointer(ChnMailBox1)))+' SMB='+IntToStr(longint(pointer(ChnMailBox2))));
              'B':ChSetParam('NAM=MBOX RMB='+IntToStr(longint(pointer(ChnMailBox2)))+' SMB='+IntToStr(longint(pointer(ChnMailBox1))));
            end;
            Sts:=ChResult;
            if Sts<>res_OK then ListBoxAppend('ChSetParam '+ErrorStr(Sts));
          end;
        cLibChnCom:
          begin
          end;
        {@ zde dalsi knihovny}
      end;
      if not Assigned(ChnRecBuff ) then GetMem(ChnRecBuff ,ChnLenRecBuff);
      if not Assigned(ChnSendBuff) then GetMem(ChnSendBuff,ChnLenSendBuff);
      ChReceiveBuffer(ChnRecBuff,ChnLenRecBuff);
      if ChReceiveResult<>res_Ok then ;
      ProgressBarStepIt;

      WantChnState:=tpConnect;
      ChnOpen;
    end;
  end;
end;
{---------------------------------------------------------------------}
function  tChannel.ErrorStr(Res:tChResult):ShortString;
var S:tResultStr;
begin
  if Res<>Res_Ok then
  begin
    S:=ChnObj.ChResultStr(Res);
    if S<>'' then
      Result:='Error in '+ChnCollection.ChName(Res)+' "'+S+'"'
    else
      Result:='Error in '+ChnCollection.ChName(Res)+' $'+IntToHex(Lo(Res),2);
  end
  else
    Result:='Ok';
end;
{---------------------------------------------------------------------}
procedure tChannel.ChnOpen;
var Sts:tChResult;
begin
  ButtonInit.Caption:='Done Channel '+ChannelChar;
  LabelChnStateCaption('Openning Channel',clBlue);
  with ChnObj do
  begin
    ChOpen;
    Sts:=ChResult;
    if Sts=res_Ok then
    begin
      ProgressBarStepIt;
      AktChnState:=tpOpenning;
    end
    else
    begin
      ListBoxAppend('ChOpen '+ErrorStr(Sts));
      WantChnState:=tpInit;
      ChnClose;
    end;
  end;
end;
{---------------------------------------------------------------------}
procedure tChannel.ChnConnect;
var Sts:tChResult;
begin
  ButtonInit.Caption:='Done Channel '+ChannelChar;
  LabelChnStateCaption('Connecting Channel',clBlue);
  with ChnObj do
  begin
    ChConnect;
    Sts:=ChResult;
    if Sts=res_Ok then
    begin
      ProgressBarStepIt;
      AktChnState:=tpConnecting;
    end
    else
    begin
      ListBoxAppend('ChConnect '+ErrorStr(Sts));
      WantChnState:=tpOpen;
      ChnDisConnect;
    end;
  end;
end;
{---------------------------------------------------------------------}
procedure tChannel.ChnDisConnect;
var Sts:tChResult;
begin
  ButtonInit.Caption:='Done Channel '+ChannelChar;
  LabelChnStateCaption('DisConnecting Channel',clBlue);
  with ChnObj do
  begin
    ChDisConnect;
    Sts:=ChResult;
    if Sts=res_Ok then
    begin
      ProgressBarStepIt;
      AktChnState:=tpDisConnecting;
    end
    else
    begin
      ListBoxAppend('ChDisConnect '+ErrorStr(Sts));
      WantChnState:=tpInit;
      ChnClose;
    end;
  end;
end;
{---------------------------------------------------------------------}
procedure tChannel.ChnClose;
var Sts:tChResult;
begin
  ButtonInit.Caption:='Done Channel '+ChannelChar;
  LabelChnStateCaption('Closing Channel',clBlue);
  with ChnObj do
  begin
    ChClose;
    Sts:=ChResult;
    if Sts=res_Ok then
    begin
      ProgressBarStepIt;
      AktChnState:=tpClosing;
    end
    else
    begin
      ListBoxAppend('ChClose '+ErrorStr(Sts));
      WantChnState:=tpInit;
      InitChn;
    end;
  end;
end;
{---------------------------------------------------------------------}
procedure tChannel.SendChn;
var I:integer;
    Sts:word;
    ErCode:integer;
begin
  if not Assigned(ChnObj) then
  begin
    MessageDlg('Can''t send, Channel '+ChannelChar+' is nil',mtError,[mbOk],0);
  end
  else
  if ChnObj.ChState<>CHS_Connect then
  begin
    MessageDlg('Can''t send, Channel '+ChannelChar+' is not Connect',mtError,[mbOk],0);
  end
  else
  with ChnObj, MainForm do
  case ChannelChar of
    'A':begin
          case ChnType and cMskLayerPrt of
            cLibNoPrt:
              case ChnType and cMskLayerHW of
                cLibChnMBox,
                cLibChnCom:
                  begin
                    for I:=1 to Length(EditComPrtAData.Text) do
                      pBuff(ChnSendBuff)^[I-1]:=Ord(EditComPrtAData.Text[I]);
                    ChSend(ChnSendBuff,Length(EditComPrtAData.Text));
                    {repeat}
                      Sts:=ChSendResult;
                      if Sts<>res_Ok then
                        ListBoxAppend('Send '+ErrorStr(Sts));
                    {until (ChSendReady=CHS_SendReady)or(Sts<>res_Ok);}
                  end;
              end;
            cLibChnPrt:
              begin
                for I:=1 to Length(EditComPrtAData.Text) do
                  pBuff(ChnSendBuff)^[I-1]:=Ord(EditComPrtAData.Text[I]);
                ChSend(ChnSendBuff,Length(EditComPrtAData.Text));
                {repeat}
                  Sts:=ChSendResult;
                  if Sts<>res_Ok then
                    ListBoxAppend('Send '+ErrorStr(Sts));
                {until (ChSendReady=CHS_SendReady)or(Sts<>res_Ok);}
              end;
            cLibChnLecom:
              {Master}
              with pSendRecord(ChnSendBuff)^ do
              begin
                Code   := StrToIntDef(EditLecomACode.Text,0);
                SubCode:= StrToIntDef(EditLecomASubCode.Text,0);
                if RadioButtonLecomARead.Checked then
                     RW:= Rd
                else RW:= Wr;
                if RW=Wr then
                begin
                  if RadioButtonLecomAReal.Checked then Par:=tpReal
                  else
                  if RadioButtonLecomAByte.Checked then Par:=tpByte
                  else
                  if RadioButtonLecomAWord.Checked then Par:=tpWord
                  else
                  if RadioButtonLecomALong.Checked then Par:=tpLong
                  else
                  if RadioButtonLecomAString.Checked then Par:=tpString
                  else
                  if RadioButtonLecomAOktStr.Checked then Par:=tpOktStr;
                  case Par of
                    tpReal   : Val(EditLecomAData.Text,R,ErCode);
                    tpByte   : B := StrToIntDef(EditLecomAData.Text,0);
                    tpWord   : W := StrToIntDef(EditLecomAData.Text,0);
                    tpLong   : L := StrToIntDef(EditLecomAData.Text,0);
                    tpString : S := EditLecomAData.Text;
                    tpOktStr : O := StrToIntDef(EditLecomAData.Text,0);
                  end;
                end;
                ChSend(ChnSendBuff,0);
                {repeat}
                  Sts:=ChSendResult;
                  if Sts<>res_Ok then
                    ListBoxAppend('Send '+ErrorStr(Sts));
                {until (ChSendReady=CHS_SendReady)or(Sts<>res_Ok);}
              end;
            else
              begin
                MessageDlg('Can''t send, Unknown Channel A',mtError,[mbOk],0);
              end;
            {@ zde dalsi knihovny}
          end;
        end;
    'B':begin
          case ChnType and cMskLayerPrt of
            cLibNoPrt:
              case ChnType and cMskLayerHW of
                cLibChnMBox,
                cLibChnCom:
                  begin
                    for I:=1 to Length(EditComPrtBData.Text) do
                      pBuff(ChnSendBuff)^[I-1]:=Ord(EditComPrtBData.Text[I]);
                    ChSend(ChnSendBuff,Length(EditComPrtBData.Text));
                    {repeat}
                      Sts:=ChSendResult;
                      if Sts<>res_Ok then
                        ListBoxAppend('Send '+ErrorStr(Sts));
                    {until (ChSendReady=CHS_SendReady)or(Sts<>res_Ok);}
                  end;
              end;
            cLibChnPrt:
              begin
                for I:=1 to Length(EditComPrtBData.Text) do
                  pBuff(ChnSendBuff)^[I-1]:=Ord(EditComPrtBData.Text[I]);
                ChSend(ChnSendBuff,Length(EditComPrtBData.Text));
                {repeat}
                  Sts:=ChSendResult;
                  if Sts<>res_Ok then
                    ListBoxAppend('Send '+ErrorStr(Sts));
                {until (ChSendReady=CHS_SendReady)or(Sts<>res_Ok);}
              end;
            cLibChnLecom:
              {Slave}
              with pSendRecord(ChnSendBuff)^ do
              begin
                if RadioButtonLecomBACK.Checked then
                begin
                  RW:=Rd;
                  Par:=tpString;
                  S:=Chr(ChnLecom.ACK);
                end
                else
                if RadioButtonLecomBNAK.Checked then
                begin
                  RW:=Rd;
                  Par:=tpString;
                  S:=Chr(ChnLecom.NAK);
                end
                else
                if RadioButtonLecomBErrCrc.Checked then
                begin
                  RW:=Rd;
                  Par:=tpString;
                  S:='?';
                end
                else
                if RadioButtonLecomBData.Checked then
                begin
                  Code   := StrToIntDef(EditLecomBCode.Text,0);
                  SubCode:= StrToIntDef(EditLecomBSubCode.Text,0);
                  if RadioButtonLecomBACK.Checked then
                       RW:= Rd
                  else RW:= Wr;
                  if RW=Wr then
                  begin
                    if RadioButtonLecomBReal.Checked then Par:=tpReal
                    else
                    if RadioButtonLecomBByte.Checked then Par:=tpByte
                    else
                    if RadioButtonLecomBWord.Checked then Par:=tpWord
                    else
                    if RadioButtonLecomBLong.Checked then Par:=tpLong
                    else
                    if RadioButtonLecomBString.Checked then Par:=tpString
                    else
                    if RadioButtonLecomBOktStr.Checked then Par:=tpOktStr;
                    case Par of
                      tpReal   : Val(EditLecomBData.Text,R,ErCode);
                      tpByte   : B := StrToIntDef(EditLecomBData.Text,0);
                      tpWord   : W := StrToIntDef(EditLecomBData.Text,0);
                      tpLong   : L := StrToIntDef(EditLecomBData.Text,0);
                      tpString : S := EditLecomBData.Text;
                      tpOktStr : O := StrToIntDef(EditLecomBData.Text,0);
                    end;
                  end;
                end;
                ChSend(ChnSendBuff,0);
                {repeat}
                  Sts:=ChSendResult;
                  if Sts<>res_Ok then
                    ListBoxAppend('Send '+ErrorStr(Sts));
                {until (ChSendReady=CHS_SendReady)or(Sts<>res_Ok);}
              end;
            else
              begin
                MessageDlg('Can''t send, Unknown Channel B',mtError,[mbOk],0);
              end;
            {@ zde dalsi knihovny}
          end;
        end;
  end;
end;
{---------------------------------------------------------------------}
procedure tChannel.ReadChn;
var
  Sts : Word;
  SS  : ShortString;
  I   : Integer;
  RecLen : Word;
  NumRecChar : integer;
  Master : Boolean;
begin
  with ChnObj do
  begin
    RecLen:=0;
    if ChReceiveReady=CHS_ReceiveReady then
    begin
      Sts:=ChReceiveResult;
      if (Sts<>Res_Ok)and(not ChnRecStop) then ListBoxAppend('Receive '+ErrorStr(Sts));
      if (ChnType and cMskLayerPrt)=cLibNoPrt then {pjem po znacch}
      begin
        NumRecChar:=0;
        while (ChReceiveReady=CHS_ReceiveReady)and(NumRecChar<100) do
        begin
          Inc(NumRecChar);
          pBuff(ChnRecBuff)^[NumRecChar]:=ChReceiveChar;
          RecLen:=NumRecChar;
        end;
      end
      else {prijem po zpravach}
      begin
        ChReceive(RecLen);
        if RecLen>254 then
        begin
          ListBoxAppend('Received too long Msg with length '+IntToStr(RecLen));
          RecLen:=254;
        end;
      end;
      Sts:=ChReceiveResult;
      if not ChnRecStop then
      begin
        if Sts<>Res_Ok then ListBoxAppend('Receive '+ErrorStr(Sts));
        SS:='';
        case ChnType and cMskLayerPrt of
          cLibNoPrt :
            begin
              case ChnViewChar of
                tpASCII:
                  for i:=1 to RecLen do
                    SS:=SS+Char(pBuff(ChnRecBuff)^[i]);
                tpHex:
                  for i:=1 to RecLen do
                    SS:=SS+' $'+IntToHex(pBuff(ChnRecBuff)^[i],2);
                tpDec:
                  for i:=1 to RecLen do
                    SS:=SS+' '+IntToStr(pBuff(ChnRecBuff)^[i]);
              end;
              ListBoxAppend(SS);
            end;
          cLibChnPrt:
            begin
              case ChnViewChar of
                tpASCII:
                  for i:=1 to RecLen do
                    SS:=SS+Char(pBuff(ChnRecBuff)^[i-1]);
                tpHex:
                  for i:=1 to RecLen do
                    SS:=SS+' $'+IntToHex(pBuff(ChnRecBuff)^[i-1],2);
                tpDec:
                  for i:=1 to RecLen do
                    SS:=SS+' '+IntToStr(pBuff(ChnRecBuff)^[i-1]);
              end;
              ListBoxAppend(SS);
            end;
          cLibChnLecom:
            with pRecRecord(ChnRecBuff)^ do
            begin
              if MainForm.ComboBoxChn.ItemIndex=0 then
                   Master:=(ChnObj as tChnLecom).CH_Master
              else Master:=(ChnObj.CH_Chn as tChnLecom).CH_Master;
              if Master then {Master}
              begin
                if (RW=Rd)and(Par=tpString)and(S=Chr(ChnLecom.ACK)) then
                  ListBoxAppend('Reply: ACK')
                else
                if (RW=Rd)and(Par=tpString)and(S=Chr(ChnLecom.NAK)) then
                  ListBoxAppend('Reply: NAK')
                else
                if (RW=Rd)and(Par=tpString)and(S='?') then
                  ListBoxAppend('Reply: Err Crc')
                else
                if (RW=Rd)and(Par=tpString)and(S=Chr(ChnLecom.EOT)) then
                  ListBoxAppend('Reply: Unknown Code')
                else
                if RW=Wr then
                begin
                  case Par of
                    tpReal   : SS:='  Real '+FloatToStrF(R,ffGeneral,cRLen-1,cRLen);
                    tpByte   : SS:='  Byte '+IntToStr(B);
                    tpWord   : SS:='  Word '+IntToStr(W);
                    tpLong   : SS:='  Long '+IntToStr(L);
                    tpString : SS:='  String '''+S+'''';
                    tpOktStr : SS:='  OktString ';
                  end;
                  ListBoxAppend('Reply  Code:'+IntToStr(Code)+'  SubCode:'+IntToStr(SubCode)+SS);
                end
                else
                  ListBoxAppend('Received Wrong Message');
              end
              else  {Slave}
              begin
                case RW of
                  Rd: SS:='Read ' +'  Code:'+IntToStr(Code)+'  SubCode:'+IntToStr(SubCode);
                  Wr: SS:='Write '+'  Code:'+IntToStr(Code)+'  SubCode:'+IntToStr(SubCode);
                end;
                if RW=Wr then
                begin
                  case Par of
                    tpReal   : SS:=SS+'  Real '+FloatToStrF(R,ffGeneral,cRLen-1,cRLen);
                    tpByte   : SS:=SS+'  Byte '+IntToStr(B);
                    tpWord   : SS:=SS+'  Word '+IntToStr(W);
                    tpLong   : SS:=SS+'  Long '+IntToStr(L);
                    tpString : SS:=SS+'  String '''+S+'''';
                    tpOktStr : SS:=SS+'  OktString ';
                  end;
                end;
                ListBoxAppend(SS);
              end;
            end;
         {@ zde dalsi knihovny}
        end;
      end;
    end;
  end;
end;
{---------------------------------------------------------------------}
procedure tChannel.MakeChn;
var
  Sts : word;
begin
 {inicializace kanalu}
  case AktChnState of
    tpConnect:      {kanal navazal spojeni - muzou se posilat a prijimat data}
      if Assigned(ChnObj) then
      with ChnObj do
      if ChState=CHS_Connect then
      begin
        ReadChn;    {obsluha prijmu}
        if ChSendReady<>CHS_SendReady then ProgressBarStepIt;
        Sts:=ChSendResult;
        if Sts<>res_Ok then
        begin
          ListBoxAppend('ChSend '+ErrorStr(Sts));
          ChSendFlush; if ChSendResult<>res_Ok then ;
        end;
      end;
    tpOpenning:      {kanal se otvira}
      with ChnObj do
      begin
        ProgressBarStepIt;
        Sts:=ChResult;
        if Sts<>res_Ok then
        begin
          ListBoxAppend('ChOpen '+ErrorStr(Sts));
          WantChnState:=tpInit;
          ChnClose;
          Exit;
        end;
        if ChState=CHS_Open then
        begin
          LabelChnStateCaption('Channel is Opened',clBlue);
          if WantChnState=tpConnect then
            ChnConnect
          else
          begin
            AktChnState:=tpOpen;
            ButtonInit.Caption:='Init Channel '+ChannelChar;
          end;
        end;
      end;
    tpConnecting:   {kanal navazuje spojeni}
      with ChnObj do
      begin
        ProgressBarStepIt;
        Sts:=ChResult;
        if Sts<>res_Ok then
        begin
          ListBoxAppend('ChConnect '+ErrorStr(Sts));
          WantChnState:=tpDisConnect;
          ChnDisConnect;
          Exit;
        end;
        if ChState=CHS_Connect then
        begin
          LabelChnStateCaption('Channel is Connected',clGreen);
          if Assigned(ListBox) then ListBox.Items.Clear;
          if Assigned(ButtonSend) then ButtonSend.Enabled:=True;
          ProgressBarClr;
          AktChnState:=tpConnect;
          ButtonInit.Caption:='Init Channel '+ChannelChar;
        end;
      end;
    tpDisConnecting:{kanal se DisConnecti}
      with ChnObj do
      begin
        ProgressBarStepIt;
        Sts:=ChResult;
        if Sts<>res_Ok then
        begin
          ListBoxAppend('ChDisConnect '+ErrorStr(Sts));
          WantChnState:=tpInit;
          ChnClose;
          Exit;
        end;
        if ChState=CHS_DisConnect then
        begin
          LabelChnStateCaption('Channel is Open',clBlue);
          if Assigned(ButtonSend) then ButtonSend.Enabled:=False;
          if WantChnState in [tpDone,tpInit,tpConnect] then
               ChnClose
          else
          begin
            AktChnState:=tpDisConnect;
            ButtonInit.Caption:='Init Channel '+ChannelChar;
          end;
        end;
      end;
    tpClosing:      {kanal se zavira}
      with ChnObj do
      begin
        ProgressBarStepIt;
        Sts:=ChResult;
        if Sts<>res_Ok then
        begin
          ListBoxAppend('ChClose '+ErrorStr(Sts));
          WantChnState:=tpInit;
          ChnClose;
          Exit;
        end;
        if ChState=CHS_Close then
        begin
          LabelChnStateCaption('Channel is Closed',clBlue);
          if WantChnState in [tpDone] then DoneChn
          else
          if WantChnState in [tpInit] then
          begin
            AktChnState:=tpInit;
            ButtonInit.Caption:='Init Channel '+ChannelChar;
          end
          else InitChn;
        end;
      end;

    tpInit,         {kanal je nainicializovan a proveden SetParam}
    tpOpen,         {kanal je otevren}
    tpDisConnect,   {kanal je DisConnect}
    tpDone:         {kanal je zrusen - nil}
      begin
      end;
  end;
end;
{---------------------------------------------------------------------}
procedure tChannel.LoadParChn;
begin
  if Assigned(EditParamHW) then
    case ChnType and cMskLayerHW of
      cLibChnMBox: EditParamHW.Text:=ChnParChnMBox;
      cLibChnCom : EditParamHW.Text:=ChnParChnCom;
      else         EditParamHW.Text:='Unknown HW layer';
    end;
  if Assigned(EditParamMid) then
    case ChnType and cMskLayerMid of
      cLibNoMid  : EditParamMid.Text:='';
      cLibChnMod : EditParamMid.Text:=ChnParChnMod2;
      else         EditParamMid.Text:='Unknown Mid layer';
    end;
  if Assigned(EditParamPrt) then
    case ChnType and cMskLayerPrt of
      cLibNoPrt  : EditParamPrt.Text:='';
      cLibChnPrt : EditParamPrt.Text:=ChnParChnPrt;
      cLibChnLecom:EditParamPrt.Text:=ChnParChnLecom;
      else         EditParamPrt.Text:='Unknown Prt layer';
    end;
  if Assigned(EditParamChn) then
    if (ChnType and cLibChn)<>0 then
         EditParamChn.Text:=ChnParChn
    else EditParamChn.Text:='';
  {@ zde dalsi knihovny}
end;
{---------------------------------------------------------------------}
procedure tChannel.SaveParChn;
begin
  if Assigned(EditParamHW) then
    case ChnType and cMskLayerHW of
      cLibChnMBox : ChnParChnMBox:=EditParamHW.Text;
      cLibChnCom  : ChnParChnCom :=EditParamHW.Text;
    end;
  if Assigned(EditParamMid) then
    case ChnType and cMskLayerMid of
      cLibChnMod  : ChnParChnMod2:=EditParamMid.Text;
    end;
  if Assigned(EditParamPrt) then
    case ChnType and cMskLayerPrt of
      cLibChnPrt  : ChnParChnPrt  :=EditParamPrt.Text;
      cLibChnLecom: ChnParChnLecom:=EditParamPrt.Text;
    end;
  if Assigned(EditParamChn) then
    if (ChnType and cLibChn)<>0 then
      ChnParChn:=EditParamChn.Text;
  {@ zde dalsi knihovny}
end;
{---------------------------------------------------------------------}
function  tChannel.ChannelInStabilState : boolean;
begin
  {Result:=WantChnState=AktChnState;}
  Result:=AktChnState in [tpDone,
                          tpInit,
                          tpOpen,
                          tpConnect,
                          tpDisConnect];
end;
{---------------------------------------------------------------------}
procedure tChannel.LabelChnStateCaption(const S:shortstring; C:tColor);
begin
  if Assigned(LabelChnState) then
  with LabelChnState do
  begin
    Caption   :=S;
    Font.Color:=C;
  end;
end;
{---------------------------------------------------------------------}
procedure tChannel.ListBoxAppend(const S:string);
begin
  if Assigned(ListBox) then
  with ListBox do
  begin
    Items.Append(S);
    if Count>Height/ItemHeight then
      TopIndex:=Round(Count-Height/ItemHeight)+1;
  end;
end;
{---------------------------------------------------------------------}
procedure tChannel.ProgressBarClr;
begin
  if Assigned(ProgressBar) then
  with ProgressBar do
  begin
    Position:=0;
    Step:=Abs(Step);
  end;
end;
{---------------------------------------------------------------------}
procedure tChannel.ProgressBarStepIt;
begin
  if Assigned(ProgressBar) then
  with ProgressBar do
  begin
    ProgressBar.StepIt;
    if Position>=Max then Step:=-Step
    else
    if Position<=Min then Step:=Abs(Step);
  end;
end;
{=====================================================================}
{                           t C h a n n e l                           }
{=====================================================================}

{---------------------------------------------------------------------}
function GetTypeOfChnLayer(Ch:tChnVirt): tLayer;
var C:tClass;
begin
  if Assigned(Ch) then
  begin
    C:=Ch.ClassType;
    if C=tChnVirt  then Result:=tlVirt
    else
    if C=tChn      then Result:=tlChn
    else
    if C=tChnCom   then Result:=tlHW
    else
    if C=tChnMBox  then Result:=tlHW
    else
    if C=tChnPrt   then Result:=tlPrt
    else
    if C=tChnLecom then Result:=tlPrt
    else
    if C=tChnMod2  then Result:=tlMid
    {@ zde dalsi knihovny}
    else                Result:=tlUnknown;
  end
  else                  Result:=tlNil;
end;

initialization
  ChnMailBox1:=tMailBox.Init(1000);
  ChnMailBox2:=tMailBox.Init(1000);

finalization
  if Assigned(ChnMailBox1) then begin ChnMailBox1.Free; ChnMailBox1:=nil; end;
  if Assigned(ChnMailBox2) then begin ChnMailBox2.Free; ChnMailBox2:=nil; end;

end.
