unit uFrmHier; {FormChannelHierarchy - dialog.box se zobrazenim hierarchie komunikacniho kanalu}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

const
  cMaxClassLayer = 5;

type
  TFormChannelHierarchy = class(TForm)
    ButtonOk: TButton;
    Label1: TLabel;
    LabelChannel: TLabel;
    LabelChnNotInited: TLabel;
    GroupBoxLayerChn: TGroupBox;
    GroupBoxLayerPrt: TGroupBox;
    GroupBoxLayerMid: TGroupBox;
    GroupBoxLayerHW: TGroupBox;
    Label2: TLabel;
    LabelClassHier: TLabel;
    LabelChnHier: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ButtonOkClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    LabelChn : array[1..cMaxClassLayer]of TLabel;
    LabelPrt : array[1..cMaxClassLayer]of TLabel;
    LabelMid : array[1..cMaxClassLayer]of TLabel;
    LabelHW  : array[1..cMaxClassLayer]of TLabel;

    procedure RefreshLabelChannel; {podle nastaveni upravi LabelChannel.Caption}

    procedure AddLabelChn(I:byte; const Cap:Shortstring; X,Y:integer);
    procedure AddLabelPrt(I:byte; const Cap:Shortstring; X,Y:integer);
    procedure AddLabelMid(I:byte; const Cap:Shortstring; X,Y:integer);
    procedure AddLabelHW (I:byte; const Cap:Shortstring; X,Y:integer);
    function  IsUsedLayerChn:Boolean;
    function  IsUsedLayerPrt:Boolean;
    function  IsUsedLayerMid:Boolean;
    function  IsUsedLayerHW :Boolean;

    procedure Line(Canv:TCanvas; X1,Y1,X2,Y2:integer);
  end;

var
  FormChannelHierarchy: TFormChannelHierarchy;

implementation

uses
  ChnVirt,
  uGlb,
  uFormM;

{$R *.dfm}

procedure TFormChannelHierarchy.FormClose(Sender: TObject;
  var Action: TCloseAction);
var I:byte;
begin
  for I:=1 to cMaxClassLayer do
  begin
    if Assigned(LabelChn[I]) then begin LabelChn[I].Free; LabelChn[I]:=nil; end;
    if Assigned(LabelPrt[I]) then begin LabelPrt[I].Free; LabelPRt[I]:=nil; end;
    if Assigned(LabelMid[I]) then begin LabelMid[I].Free; LabelMid[I]:=nil; end;
    if Assigned(LabelHW [I]) then begin LabelHW [I].Free; LabelHW [I]:=nil; end;
  end;

  MainForm.Enabled:=True;
  Action:=caFree;
end;

procedure TFormChannelHierarchy.ButtonOkClick(Sender: TObject);
var Action: TCloseAction;
begin
  OnClose(Sender,Action);
  Release;
end;

procedure TFormChannelHierarchy.FormCreate(Sender: TObject);
var
  I       :byte;
  PomClass:tClass;
  PomObj  :tChnVirt;
label
  L_1;
begin
  for I:=1 to cMaxClassLayer do
  begin
    LabelChn[I]:=nil;
    LabelPRt[I]:=nil;
    LabelMid[I]:=nil;
    LabelHW [I]:=nil;
  end;
  RefreshLabelChannel;
  PomObj:=Channel['A'].ChnObj;
 L_1:
  case GetTypeOfChnLayer(PomObj) of
    tlNil:
      begin
        GroupBoxLayerChn.Hide;
        GroupBoxLayerPrt.Hide;
        GroupBoxLayerMid.Hide;
        GroupBoxLayerHW .Hide;
        LabelChnHier  .Hide;
        LabelClassHier.Hide;
        Label2.Hide;
        LabelChnNotInited.Visible:=True;
      end;
    tlVirt:
      begin
        GroupBoxLayerChn.Hide;
        GroupBoxLayerPrt.Hide;
        GroupBoxLayerMid.Hide;
        GroupBoxLayerHW .Hide;
        LabelChnHier  .Hide;
        LabelClassHier.Hide;
        Label2.Hide;
        LabelChnNotInited.Visible:=True;
        LabelChnNotInited.Caption:='Channel is only ChnVirt';
      end;
    tlChn:
      begin
        I:=1; PomClass:=PomObj.ClassType;
        AddLabelChn(I,PomClass.ClassName,20,130-I*20);
        repeat
          Inc(I);
          PomClass:=PomClass.ClassParent;
          AddLabelChn(I,PomClass.ClassName,20,130-I*20);
        until PomClass=TObject;
        PomObj:=PomObj.CH_Chn;
        if Assigned(PomObj) then goto L_1;
      end;
    tlPrt:
      begin
        I:=1; PomClass:=PomObj.ClassType;
        AddLabelPrt(I,PomClass.ClassName,20,130-I*20);
        repeat
          Inc(I);
          PomClass:=PomClass.ClassParent;
          AddLabelPrt(I,PomClass.ClassName,20,130-I*20);
        until PomClass=TObject;
        PomObj:=PomObj.CH_Chn;
        if Assigned(PomObj) then goto L_1;
      end;
    tlMid:
      begin
        I:=1; PomClass:=PomObj.ClassType;
        AddLabelMid(I,PomClass.ClassName,20,130-I*20);
        repeat
          Inc(I);
          PomClass:=PomClass.ClassParent;
          AddLabelMid(I,PomClass.ClassName,20,130-I*20);
        until PomClass=TObject;
        PomObj:=PomObj.CH_Chn;
        if Assigned(PomObj) then goto L_1;
      end;
    tlHW :
      begin
        I:=1; PomClass:=PomObj.ClassType;
        AddLabelHW(I,PomClass.ClassName,20,130-I*20);
        repeat
          Inc(I);
          PomClass:=PomClass.ClassParent;
          AddLabelHW(I,PomClass.ClassName,20,130-I*20);
        until PomClass=TObject;
      end;
    else
      begin
        GroupBoxLayerChn.Hide;
        GroupBoxLayerPrt.Hide;
        GroupBoxLayerMid.Hide;
        GroupBoxLayerHW .Hide;
        LabelChnHier  .Hide;
        LabelClassHier.Hide;
        Label2.Hide;
        LabelChnNotInited.Visible:=True;
        LabelChnNotInited.Caption:='Unknown type of Channel';
      end;
  end;
  if not IsUsedLayerChn then AddLabelChn(1,'Not used',20,60);
  if not IsUsedLayerPrt then AddLabelPrt(1,'Not used',20,60);
  if not IsUsedLayerMid then AddLabelMid(1,'Not used',20,60);
  if not IsUsedLayerHW  then AddLabelHW (1,'Not used',20,60);
end;

procedure TFormChannelHierarchy.FormPaint(Sender: TObject);
begin
  if not LabelChnNotInited.Visible then
  begin
   {vykresleni vertikalni sipky}
    with LabelClassHier do
    begin
      Line(Self.Canvas,12,Top+6,12,170);
      Line(Self.Canvas,12,Top+6,Left-2,Top+6);
      Line(Self.Canvas,12-4,169-11,12,169);
      Line(Self.Canvas,12+4,169-11,12,169);
    end;
   {vykresleni horizontalni sipky}
    with LabelChnHier do
    begin
      Line(Self.Canvas,35,Top+6,Left-2,Top+6);
      Line(Self.Canvas,322,Top+6,Self.Width-35,Top+6);
      Line(Self.Canvas,Self.Width-45,Top+ 2,Self.Width-34,Top+6);
      Line(Self.Canvas,Self.Width-45,Top+10,Self.Width-34,Top+6);
    end;
  end;
end;

procedure TFormChannelHierarchy.Line(Canv:TCanvas; X1,Y1,X2,Y2:integer);
begin
  with Canv do
  begin
    MoveTo(X1,Y1);
    LineTo(X2,Y2);
  end;
end;

procedure TFormChannelHierarchy.RefreshLabelChannel;
var S:string[60];
begin
  if (ChnType and cMskLayerChn)<>0 then
       S:='Application -> Chn -> '
  else S:='Application -> ';
  case ChnType and cMskLayerPrt of
    cLibNoPrt   :;
    cLibChnPrt  :S:=S+'ChnPrt -> ';
    cLibChnLecom:S:=S+'ChnLecom -> ';
    else         S:=S+'Unknown Prt -> ';
  end;
  case ChnType and cMskLayerHW of
    cLibChnCom  :S:=S+'ChnCom';
    cLibChnMBox :S:=S+'SimCom';
    else         S:=S+'Unknown HW';
  end;
  {@ zde dalsi knihovny}
  LabelChannel.Caption:=S;
end;

procedure TFormChannelHierarchy.AddLabelChn(I:byte; const Cap:Shortstring; X,Y:integer);
begin
  LabelChn[I]:=TLabel.Create(GroupBoxLayerChn);
  with LabelChn[I] do
  begin
    Parent:=GroupBoxLayerChn;
    Caption:=Cap;
    Top :=Y;
    Left:=X;
  end;
end;
procedure TFormChannelHierarchy.AddLabelPrt(I:byte; const Cap:Shortstring; X,Y:integer);
begin
  LabelPrt[I]:=TLabel.Create(GroupBoxLayerPrt);
  with LabelPrt[I] do
  begin
    Parent:=GroupBoxLayerPrt;
    Caption:=Cap;
    Top :=Y;
    Left:=X;
  end;
end;
procedure TFormChannelHierarchy.AddLabelMid(I:byte; const Cap:Shortstring; X,Y:integer);
begin
  LabelMid[I]:=TLabel.Create(GroupBoxLayerMid);
  with LabelMid[I] do
  begin
    Parent:=GroupBoxLayerMid;
    Caption:=Cap;
    Top :=Y;
    Left:=X;
  end;
end;
procedure TFormChannelHierarchy.AddLabelHW(I:byte; const Cap:Shortstring; X,Y:integer);
begin
  LabelHW[I]:=TLabel.Create(GroupBoxLayerHW);
  with LabelHW[I] do
  begin
    Parent:=GroupBoxLayerHW;
    Caption:=Cap;
    Top :=Y;
    Left:=X;
  end;
end;

function  TFormChannelHierarchy.IsUsedLayerChn:Boolean;
var I:byte;
begin
  Result:=False;
  for I:=1 to cMaxClassLayer do
    if Assigned(LabelChn[I]) then
    begin
      Result:=True;
      Break;
    end;
end;
function  TFormChannelHierarchy.IsUsedLayerPrt:Boolean;
var I:byte;
begin
  Result:=False;
  for I:=1 to cMaxClassLayer do
    if Assigned(LabelPrt[I]) then
    begin
      Result:=True;
      Break;
    end;
end;
function  TFormChannelHierarchy.IsUsedLayerMid:Boolean;
var I:byte;
begin
  Result:=False;
  for I:=1 to cMaxClassLayer do
    if Assigned(LabelMid[I]) then
    begin
      Result:=True;
      Break;
    end;
end;
function  TFormChannelHierarchy.IsUsedLayerHW :Boolean;
var I:byte;
begin
  Result:=False;
  for I:=1 to cMaxClassLayer do
    if Assigned(LabelHW[I]) then
    begin
      Result:=True;
      Break;
    end;
end;

end.
