{$A+,B-,D+,E+,F+,G+,I+,L+,N-,O+,P-,Q-,R-,S+,T-,V+,X+,Y+}
{$M 16384,0,655360}
Program Jednoduchy_Master_NetTerm06;

{komunikace v sitove vrstve}

uses
    Strings,
    uString,
    ChnVirt,
    ChnCom,
    ChnPrt,
    Crt;

const
     BaudRate = 9600;

     delay1 = (1/BaudRate)*11*1000;

     delay2 = (1/BaudRate)*11*20*1000;

     ParamStr1 : tParamStr = 'NAM=PRT LSB=500 NOD=1 DNO=2'+
                            ' NAM=COM COM=3 ADD=$0110 IRQ=5 BD=9600 BIT=8 PAR=N STO=1 LRB=1000';
     ParamStr2 : tParamStr = 'NAM=PRT LSB=500 NOD=1 DNO=3'+
                            ' NAM=COM COM=3 ADD=$0110 IRQ=5 BD=9600 BIT=8 PAR=N STO=1 LRB=1000';

type
   tmess = array [0..65500] of Byte;

var
   Chn1,Chn2       : pChnVirt;
   SMess1,SMess2   : ^tmess;
   RMess1,RMess2   : ^tmess;
   LRMess1,LRMess2 : Word;
   LSMEss1,LSMEss2 : Word;
   res             : byte;
   OKSend          : Boolean;
   i,j             : LongInt;

begin

     New(SMess1);
     New(RMess1);
     New(SMess2);
     New(RMess2);


     SMess1^[0]:=$C1;   {command = 1}
     LSMess1:=1;

     SMess2^[0]:=$C1;   {command = 1}
     LSMess2:=1;

     { vytvoreni instance komunikacniho objektu Chn1 }

     Chn1:=ChnCollection^.ChNewInit(ChnPrt.cName);
     Chn2 :=ChnCollection^.ChNewInit(ChnPrt.cName);

repeat

     with Chn1^ do
     begin
       { nastavni parametru komunikace }
       ChSetParam(ParamStr1);
       if ChResult <> res_OK then halt;
       {otevreni komunikacniho kanalu}
       ChOpen;
       repeat
         if ChResult <> res_Ok then Writeln('Chyba otevreni kanalu');
       until ChReady = CHS_Open;
       if ChResult <> res_Ok then WriteLn('Chyba otevreni kanalu');

       { definice prijimaciho bufferu }
       ChReceiveBuffer(RMess1,SizeOf(tmess));
       if ChReceiveResult <> res_OK then WriteLn('Chyba otevreni bufferu');

       { Pripojeni kanalu }
       ChConnect;
       repeat
         if ChResult <> res_Ok then WriteLn ('Chyba pripojeni kanalu')
       until ChReady = CHS_Connect;
       if ChResult <> res_Ok then WriteLn('Chyba pripojeni kanalu');
     end;

     with Chn1^ do
     begin
       OKSend := True;
       repeat
           { vyslani zpravy do terminalu NODE 2 }
           write('S2 ');
           if ChSendReady = CHS_SendReady then
             begin
               ChSend(SMess1,LSMess1);
               { cekani na odvysilani zpravy }
               repeat
                 if ChSendResult <> res_Ok then WriteLn('Chyba pri odesilani zpravy');
               until ChSendReady = CHS_SendReady;
               if ChSendResult <> res_Ok then WriteLn('Zprava neodeslana');
               OKSend := True;
             end
           else
             WriteLn('Zprava neodeslana z duvodu nepripravenosti zarizeni');
           { Cekani na odezvu }
           write('W2 ');
           i := 0;
           while (ChReceiveReady <> CHS_ReceiveReady ) AND OKSend do
           begin
             inc (i);
             if ChReceiveResult <> res_OK then WriteLn('Chyba pri cekani na zpravu');
             if i > 50 then
               begin
                 OKSend := False;
                 Delay (round(delay2));
                 Write('NODE 2 err ');
               end;
             delay(round(delay1));
           end;

       until OKSend;

       { Prijem zpravy }
       write('R2 ');
       ChReceive(LRMess1);
       if ChReceiveResult <> Res_Ok then WriteLn('Chyba pri prijmu zpravy ',res);

       with Chn1^ do
       begin
         ChDisconnect;
         ChClose
       end;

       { Zpracovani prijate zpravy }
       if LRMess1 > 1 then
         begin
           for i:= 1 to (LRMess1) do SMess1^[i] := RMess1^[i] + $40
         end;
       LSMess1 := LRMess1;
     end;

     with Chn2^ do
     begin
       { nastavni parametru komunikace }
       ChSetParam(ParamStr2);
       if ChResult <> res_OK then halt;
       {otevreni komunikacniho kanalu}
       ChOpen;
       repeat
         if ChResult <> res_Ok then Writeln('Chyba otevreni kanalu');
       until ChReady = CHS_Open;
       if ChResult <> res_Ok then WriteLn('Chyba otevreni kanalu');

       { definice prijimaciho bufferu }
       ChReceiveBuffer(RMess2,SizeOf(tmess));
       if ChReceiveResult <> res_OK then WriteLn('Chyba bufferu');

       { Pripojeni kanalu }
       ChConnect;
       repeat
         if ChResult <> res_Ok then WriteLn ('Chyba pripojeni kanalu')
       until ChReady = CHS_Connect;
       if ChResult <> res_Ok then WriteLn('Chyba pripojeni kanalu');
     end;

     with Chn2^ do
     begin
       OKSend := True;
       repeat
           { vyslani zpravy do terminalu 1 }
           write('S3 ');
           if ChSendReady = CHS_SendReady then
             begin
               ChSend(SMess2,LSMess2);
               { cekani na odvysilani zpravy }
               repeat
                 if ChSendResult <> res_Ok then WriteLn('Chyba pri odesilani zpravy');
               until ChSendReady = CHS_SendReady;
               if ChSendResult <> res_Ok then WriteLn('Zprava neodeslana');
               OKSend := True;
             end
           else
             WriteLn('Zprava neodeslana z duvodu nepripravenosti zarizeni');
           { Cekani na odezvu }
           write('W3 ');
           i := 0;
           while (ChReceiveReady <> CHS_ReceiveReady ) AND OKSend do
           begin
             inc (i);
             if ChReceiveResult <> res_OK then WriteLn('Chyba pri cekani na zpravu');
             if i > 50 then
               begin
                 OKSend := False;
                 Delay (round(delay2));
                 Write('NODE 3 err ');
               end;
             delay(round(delay1));
           end;

       until OKSend;

       { Prijem zpravy }
       write('R3 ');
       ChReceive(LRMess2);
       if ChReceiveResult <> Res_Ok then WriteLn('Chyba pri prijmu zpravy ',res);

       with Chn2^ do
       begin
         ChDisconnect;
         ChClose
       end;

       { Zpracovani prijate zpravy }
       if LRMess2 > 1 then
         begin
           for i:= 1 to (LRMess2) do SMess2^[i] := RMess2^[i] + $60
         end;
       LSMess2 := LRMess2;
     end;



Until KeyPressed;


with Chn1^ do
     begin
       { zruseni instance Chn1 }
       Dispose(Chn1,Done);
     end;


with Chn2^ do
     begin
       { zruseni instance Chn2 }
       Dispose(Chn2,Done);
     end;

      Dispose(SMess1);
      Dispose(RMess1);
      Dispose(SMess2);
      Dispose(RMess2);



end.
