{$A+,B-,D+,E+,F+,G+,I+,L+,N-,O+,P-,Q-,R-,S+,T-,V+,X+,Y+}
{$M 16384,0,655360}
Program Test_Lokalni_Editace_NETTerm06;

uses
    Strings,
    uString,
    ChnVirt,
    ChnCom,
    ChnPrt,
    Crt;
const
     BaudRate = 9600;

     delay1 = (1/BaudRate)*11*1000;

     delay2 = (1/BaudRate)*11*20*1000;

     ParamStr1 : tParamStr = 'NAM=PRT LSB=500 NOD=1 DNO=2'+
                            ' NAM=COM COM=3 ADD=$0110 IRQ=5 BD=9600 BIT=8 PAR=N STO=1 LRB=1000';

type
   tmess = array [0..65500] of Byte;
   tdword = $00000000 .. $7FFFFFF;
   tdwrec = record
              B0,
              B1,
              B2,
              B3   : byte;
            end;

   tMessPtr = ^tmess;

var
   Chn1,Chn2       : pChnVirt;
   SMess1,RMess1   : tMessPtr;
   SMess0,RMess0   : tMessPtr;
   LRMess0,LSMess0 : Word;
   LRMess1,LSMess1 : Word;
   ML,MH,INum      : tdword;
   l               : byte;

procedure AddByteToMess(WrByte:Byte;WrMess:tMessPtr;var l:byte);
begin
  WrMess^[l] := WrByte;
  inc (l);
end;

procedure AddDWordToMess(WrWord:tdword;WrMess:tMessPtr;var l:byte);
var DW:tdwrec;
begin
  DW:=tdwrec(WrWord);
  WrMess^[l] := DW.B0;
  inc(l);
  WrMess^[l] := DW.B1;
  inc(l);
  WrMess^[l] := DW.B2;
  inc(l);
  WrMess^[l] := DW.B3;
  inc(l);
end;

begin

     New(SMess0);
     New(RMess0);
     New(SMess1);
     New(RMess1);

     l:=0;

     AddByteToMess($C1,SMess0,l);    { identifikator C1 }
     AddByteToMess($1E,SMess0,l);    { smaz display }
     AddByteToMess(88,SMess0,l);     { vypis X= }
     AddByteToMess(61,SMess0,l);
     AddByteToMess($1B,SMess0,l);    { zacatek ESC sekvence }
     AddByteToMess(Byte('Y'),SMess0,l); {kurzor na }
     AddByteToMess(0,SMess0,l);         {radek}
     AddByteToMess(10,SMess0,l);        {sloupec}
     AddByteToMess(Byte('('),SMess0,l);
     AddByteToMess(Byte('m'),SMess0,l);
     AddByteToMess(Byte('m'),SMess0,l);
     AddByteToMess(Byte(')'),SMess0,l);

     LSMess0 := l;

     WriteLn;
     Write('Zadej dolni hranici pro editovane cislo: '); ReadLn(ML);
     Write('Zadej horni hranici pro editovane cislo: '); ReadLn(MH);
     Write('Zadej inicializacni hodnotu: ');             ReadLn(INum);

     l:=0;

     AddByteToMess($C7,SMess1,l);    { identifikator C7 - lokalni editace   }
     AddByteToMess($02,SMess1,l);    { umisteni cisla na displeji }
     AddByteToMess($03,SMess1,l);    { editace cisla }

     AddDWordToMess(INum,SMess1,l);
     AddDWordToMess(ML,SMess1,l);
     AddDWordToMess(MH,SMess1,l);

     LSMess1 := l;

     { vytvoreni instance komunikacniho objektu Chn1 }
     Chn1:=ChnCollection^.ChNewInit(ChnPrt.cName);


     with Chn1^ do
     begin
       { nastavni parametru komunikace }
       ChSetParam(ParamStr1);
       if ChResult <> res_OK then halt;
       {otevreni komunikacniho kanalu}
       ChOpen;
       repeat
         if ChResult <> res_Ok then Writeln('Chyba otevreni kanalu');
       until ChReady = CHS_Open;
       if ChResult <> res_Ok then WriteLn('Chyba otevreni kanalu');

       { definice prijimaciho bufferu }
       ChReceiveBuffer(RMess1,SizeOf(tmess));
       if ChReceiveResult <> res_OK then WriteLn('Chyba bufferu');

       { Pripojeni kanalu }
       ChConnect;
       repeat
         if ChResult <> res_Ok then WriteLn ('Chyba pripojeni kanalu')
       until ChReady = CHS_Connect;
       if ChResult <> res_Ok then WriteLn('Chyba pripojeni kanalu');

       { vyslani zpravy 0 do terminalu }
       if ChSendReady = CHS_SendReady then
         begin
           ChSend(SMess0,LSMess0);
           { cekani na odvysilani zpravy }
           repeat
             if ChSendResult <> res_Ok then WriteLn('Chyba pri odesilani zpravy');
           until ChSendReady = CHS_SendReady;
           if ChSendResult <> res_Ok then WriteLn('Zprava neodeslana');
         end
           else
             WriteLn('Zprava neodeslana z duvodu nepripravenosti zarizeni');
           { Cekani na odezvu }
         while (ChReceiveReady <> CHS_ReceiveReady) do
         if ChReceiveResult <> res_OK then WriteLn('Chyba pri cekani na zpravu');

       { Prijem zpravy }
       ChReceive(LRMess0);
       if ChReceiveResult <> Res_Ok then WriteLn('Chyba pri prijmu zpravy ');

       delay (round(Delay2));

       { vyslani zpravy 1 do terminalu }
       if ChSendReady = CHS_SendReady then
         begin
           ChSend(SMess1,LSMess1);
           { cekani na odvysilani zpravy }
           repeat
             if ChSendResult <> res_Ok then WriteLn('Chyba pri odesilani zpravy');
           until ChSendReady = CHS_SendReady;
           if ChSendResult <> res_Ok then WriteLn('Zprava neodeslana');
         end
           else
             WriteLn('Zprava neodeslana z duvodu nepripravenosti zarizeni');
           { Cekani na odezvu }
         while (ChReceiveReady <> CHS_ReceiveReady) do
         if ChReceiveResult <> res_OK then WriteLn('Chyba pri cekani na zpravu');

       { Prijem zpravy }
       ChReceive(LRMess1);
       if ChReceiveResult <> Res_Ok then WriteLn('Chyba pri prijmu zpravy ');


       ChDisconnect;
       ChClose

     end;

       { Zpracovani prijate zpravy, testovani ukonceni editace ... }


with Chn1^ do
     begin
       { zruseni instance Chn1 }
       Dispose(Chn1,Done);
     end;

      Dispose(SMess1);
      Dispose(RMess1);

end.
